(ns fastmath.protocols.matrix)

(defprotocol MatrixProto
  (entry [m row col])
  (->seq [m])
  (fmap [m f])
  (cols [m])
  (rows [m])
  (to-float-array2d [m])
  (to-double-array2d [m])
  (to-float-array [m])
  (to-double-array [m])
  (to-real-matrix [m])
  (nrow [m])
  (ncol [m])
  (column [m id])
  (row [m id])
  (symmetric? [m] [m tol])
  (transpose [m])
  (inverse [m])
  (diag [m])
  (det [m])
  (add [m1 m2])
  (adds [m v])
  (sub [m] [m1 m2])
  (emulm [m1 m2])
  (mulm [m1 m2] [m1 t1? m2 t2?])
  (mulv [m v])
  (vtmul [m v])
  (muls [m v])
  (trace [m])
  (cholesky [m])
  (norm [m t])
  (singular? [m])
  (solve [m v]))

(defprotocol MatrixDecompositionProto
  (component [m c]))
