package fastmath.java;

import org.apache.commons.math3.random.RandomVectorGenerator;

public class R2 implements RandomVectorGenerator {

    private final static double[][] phi_t = {
        {0.61803398874989484820458683436564},{0.75487766624669276004950889635853,0.56984029099805326591139995811957},{0.81917251339616443969957118834243,0.67104360670378920841681565403620,0.54970047790197026694486969507263},{0.85667488385450287485232481531243,0.73389185662712599040473317000244,0.62870672103780863377482325737802,0.53859725722361005048122264247683},{0.88127146163356959440764916284137,0.77663938908976812561902324558316,0.68443012958534251896211696272270,0.60316874068572824547292523683016,0.53155539771579124713252081767632},{0.89865371262869929326087572204681,0.80757849522134485163658790532281,0.72573341296975984175365000591610,0.65218302594397170937034143837762,0.58608669757796948813635690539840,0.52668898670073598249334711517269},{0.91159235348205491862867367249405,0.83100061892695176432824927733010,0.75753380995266422969869941478074,0.69056202865697690288517058202999,0.62951106492875582730003595736803,0.57385747322139920715098251459727,0.52312408457716061075729645257027},{0.92159931963398300629943031520197,0.84934530594982037512818982943264,0.78275605609767159634284082376754,0.72138744873899397831909235456339,0.66483018195035164262219986161302,0.61270704335758120308263195482829,0.56467039429329616357682903743585,0.52039985119815466476006682666147},{0.92957012823202286420441303691446,0.86410062330129943120868029929251,0.80324212720755979641416620208373,0.74666988718969418152471392649965,0.69408202278191406644172237431419,0.64519791492092567374588473527398,0.59975670850807865662111668639540,0.55751592043587063520321515291797,0.51825014565096652285638437124731},{0.93606911107775837839719148757030,0.87622538071390475328416764674435,0.82020751322863523246016011753742,0.76777091780722732797011208526628,0.71868664054316597581710164088285,0.67274036475670183985292367269642,0.62973147522393282236900687897467,0.58947218223055222129776136761711,0.55178670162561941582977224538936,0.51651048729522186053965734293451},{0.94146961732163520437804678885564,0.88636504033974623446248207171930,0.83448575533593663813981516361485,0.78564298473647996951380210382896,0.73965900019128108479022737170871,0.69636647585858870333338432958385,0.65560787954220122647260533090089,0.61723489946564489835250777357037,0.58110790459747868014883528415860,0.54709543656396555182629802845991,0.51507373130028959663264624768321},{0.94602852828561361563553816888134,0.89496997633024404083446705422566,0.84666712956751122265633577326923,0.80097125853255757870859312549293,0.75774166090863118343056566768596,0.71684522829008883644550811346859,0.67815603632783745643479183780390,0.64155495699522919183492927691241,0.60692929178053680627053737266054,0.57417242467657100334649327504517,0.54318349389895880459346524842396,0.51386708132226958028822147938080},{0.94992839996361988303140513130890,0.90236396505744298739374316518276,0.85718115751184461850912378612183,0.81426072543419018873542589425265,0.77348938806491669084691239318148,0.73475953679334577385773359758501,0.69796895114411344371510619963924,0.66302052898461366092371056366997,0.62982203024138691514236300839917,0.59828583344903928695254111413363,0.56832870448914666279043893884597,0.53987157690877204200393605324428,0.51283934323878618070957088130898},{0.95330253740166415910798263623441,0.90878572781645129296055710486034,0.86634774028184114308896022261003,0.82589149908287709333309245550801,0.78732446169417092082717786419990,0.75055840709145247478770904555389,0.71550923394843284667586673936408,0.68209676825736197469812988136954,0.65024457993321806425942282539420,0.61987980798201601364613623948669,0.59093299383331221800460250241039,0.56333792245565849659410468396563,0.53703147089156116772555585325127,0.51195346386547320725363688523889},{0.95625055763798906682549601260394,0.91441512898296505043061161709646,0.87440997700257402781676289397419,0.83615502811293260978428864429915,0.79957371190480023311690592582302,0.76459280788164204020811263028805,0.73114229890281604302551865658233,0.69915523103853912300534366502077,0.66856757955612011825659303415667,0.63931812076922048203256259774481,0.61134830949363832567363121259131,0.58460216186433357436114808739050,0.55902614327914292662864252712442,0.53456906124489479755296597397522,0.51118196291144698010383780729402}
    };
    
    private int dimensions;
    private double[] current, phis;
    
    public R2(int dimensions) {
        this.dimensions = dimensions;
        current = new double[dimensions];

        for(int i=0;i<dimensions;i++) {
            current[i] = 0.5; // seed
        } 
        
        phis = phi_t[dimensions-1];
    }

    synchronized public double[] nextVector() {
        for(int i=0;i<dimensions;i++) {
            current[i] = (current[i] + phis[i])%1.0;
        }
        return current;
    }
}
