(ns leiningen.new.gcm-project
  (:use [leiningen.new.templates :only [renderer name-to-path sanitize-ns ->files]]))

(def render (renderer "gcm-project"))

(defn gcm-project
  [name]
  (let [data {:name name
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (->files data ["project.clj" (render "project.clj" data)]
             ["src/{{sanitized}}/core.clj" (render "core.clj" data)]
             ["test/{{sanitized}}/core_test.clj" (render "core_test.clj" data)]
             ["resources/json-simple-1.1.1.jar" (render "json-simple-1.1.1.jar")]
             ["resources/gcm-server-1.0.2.jar" (render "gcm-server-1.0.2.jar")])))
