/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.UUID;

public class RedisServer {
    private static final String REDIS_READY_PATTERN = ".*The server is now ready to accept connections on port.*";
    private final String LATEST_REDIS_VERSION = "2.8.5";
    private final File command;
    private final int port;
    private final String version;
    private volatile boolean active = false;
    private Process redisProcess;

    public RedisServer() throws IOException, URISyntaxException {
        this(RedisServer.findFreePort());
    }

    public RedisServer(String version) throws IOException, URISyntaxException {
        this(version, RedisServer.findFreePort());
    }

    public RedisServer(int port) throws IOException, URISyntaxException {
        this(null, port);
    }

    public RedisServer(String version, int port) throws IOException, URISyntaxException {
        this.version = version != null ? version : "2.8.5";
        this.port = port;
        this.command = this.extractExecutableFromJar(RedisServerEnum.getOsDependentRedisServerEnum());
    }

    private File extractExecutableFromJar(RedisServerEnum redisServerEnum) throws IOException, URISyntaxException {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
        tmpDir.deleteOnExit();
        tmpDir.mkdirs();
        String redisExecutablePath = "redis" + File.separator + this.version + File.separator + redisServerEnum.name().toLowerCase() + File.separator + redisServerEnum.executableName;
        URL redisExecutableUrl = RedisServer.class.getClassLoader().getResource(redisExecutablePath);
        File redisExecutableFile = new File(tmpDir, redisServerEnum.executableName);
        redisExecutableFile.createNewFile();
        RedisServer.copyFile(new File(redisExecutableUrl.toURI()), redisExecutableFile);
        redisExecutableFile.setExecutable(true);
        redisExecutableFile.deleteOnExit();
        return redisExecutableFile;
    }

    public int getPort() {
        return this.port;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isActive() {
        return this.active;
    }

    public synchronized void start() throws IOException {
        if (this.active) {
            throw new RuntimeException("This redis server instance is already running...");
        }
        this.redisProcess = this.createRedisProcessBuilder().start();
        this.awaitRedisServerReady();
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitRedisServerReady() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.redisProcess.getInputStream()));
        try {
            String outputLine;
            while ((outputLine = reader.readLine()) != null && !outputLine.matches(REDIS_READY_PATTERN)) {
            }
        }
        finally {
            reader.close();
        }
    }

    private ProcessBuilder createRedisProcessBuilder() {
        ProcessBuilder pb = new ProcessBuilder(this.command.getAbsolutePath(), "--port", Integer.toString(this.port));
        pb.directory(this.command.getParentFile());
        return pb;
    }

    public synchronized void stop() {
        if (this.active) {
            this.redisProcess.destroy();
            this.active = false;
        }
    }

    private static int findFreePort() throws IOException {
        ServerSocket server = new ServerSocket(0);
        int port = server.getLocalPort();
        server.close();
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File sourceFile, File destFile) throws IOException {
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    private static enum RedisServerEnum {
        WINDOWS("redis-server.exe"),
        LINUX("redis-server"),
        MACOSX("redis-server");

        private final String executableName;

        private RedisServerEnum(String executableName) {
            this.executableName = executableName;
        }

        public static RedisServerEnum getOsDependentRedisServerEnum() {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.contains("win")) {
                return WINDOWS;
            }
            if (osName.equals("linux")) {
                return LINUX;
            }
            if ("mac os x".equals(osName)) {
                return MACOSX;
            }
            throw new RuntimeException("Unsupported os/architecture...: " + osName);
        }
    }
}

