/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.JaasConfig;
import org.apache.kafka.common.security.JaasUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasContext {
    private static final Logger LOG = LoggerFactory.getLogger(JaasUtils.class);
    private static final String GLOBAL_CONTEXT_NAME_SERVER = "KafkaServer";
    private static final String GLOBAL_CONTEXT_NAME_CLIENT = "KafkaClient";
    private final String name;
    private final Type type;
    private final Configuration configuration;
    private final List<AppConfigurationEntry> configurationEntries;

    public static JaasContext load(Type contextType, ListenerName listenerName, Map<String, ?> configs) {
        String listenerContextName;
        String globalContextName;
        switch (contextType) {
            case CLIENT: {
                if (listenerName != null) {
                    throw new IllegalArgumentException("listenerName should be null for CLIENT");
                }
                globalContextName = GLOBAL_CONTEXT_NAME_CLIENT;
                listenerContextName = null;
                break;
            }
            case SERVER: {
                if (listenerName == null) {
                    throw new IllegalArgumentException("listenerName should not be null for SERVER");
                }
                globalContextName = GLOBAL_CONTEXT_NAME_SERVER;
                listenerContextName = listenerName.value().toLowerCase(Locale.ROOT) + "." + GLOBAL_CONTEXT_NAME_SERVER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected context type " + (Object)((Object)contextType));
            }
        }
        return JaasContext.load(contextType, listenerContextName, globalContextName, configs);
    }

    static JaasContext load(Type contextType, String listenerContextName, String globalContextName, Map<String, ?> configs) {
        Password jaasConfigArgs = (Password)configs.get("sasl.jaas.config");
        if (jaasConfigArgs != null) {
            int numModules;
            if (contextType == Type.SERVER) {
                throw new IllegalArgumentException("JAAS config property not supported for server");
            }
            JaasConfig jaasConfig = new JaasConfig(globalContextName, jaasConfigArgs.value());
            AppConfigurationEntry[] clientModules = jaasConfig.getAppConfigurationEntry(globalContextName);
            int n = numModules = clientModules == null ? 0 : clientModules.length;
            if (numModules != 1) {
                throw new IllegalArgumentException("JAAS config property contains " + numModules + " login modules, should be 1 module");
            }
            return new JaasContext(globalContextName, contextType, jaasConfig);
        }
        return JaasContext.defaultContext(contextType, listenerContextName, globalContextName);
    }

    private static JaasContext defaultContext(Type contextType, String listenerContextName, String globalContextName) {
        String jaasConfigFile = System.getProperty("java.security.auth.login.config");
        if (jaasConfigFile == null) {
            if (contextType == Type.CLIENT) {
                LOG.debug("System property 'java.security.auth.login.config' and Kafka SASL property 'sasl.jaas.config' are not set, using default JAAS configuration.");
            } else {
                LOG.debug("System property 'java.security.auth.login.config' is not set, using default JAAS configuration.");
            }
        }
        Configuration jaasConfig = Configuration.getConfiguration();
        AppConfigurationEntry[] configEntries = null;
        String contextName = globalContextName;
        if (listenerContextName != null && (configEntries = jaasConfig.getAppConfigurationEntry(listenerContextName)) != null) {
            contextName = listenerContextName;
        }
        if (configEntries == null) {
            configEntries = jaasConfig.getAppConfigurationEntry(globalContextName);
        }
        if (configEntries == null) {
            String listenerNameText = listenerContextName == null ? "" : " or '" + listenerContextName + "'";
            String errorMessage = "Could not find a '" + globalContextName + "'" + listenerNameText + " entry in the JAAS configuration. System property '" + "java.security.auth.login.config" + "' is " + (jaasConfigFile == null ? "not set" : jaasConfigFile);
            throw new IllegalArgumentException(errorMessage);
        }
        return new JaasContext(contextName, contextType, jaasConfig);
    }

    public JaasContext(String name, Type type, Configuration configuration) {
        this.name = name;
        this.type = type;
        this.configuration = configuration;
        AppConfigurationEntry[] entries = configuration.getAppConfigurationEntry(name);
        if (entries == null) {
            throw new IllegalArgumentException("Could not find a '" + name + "' entry in this JAAS configuration.");
        }
        this.configurationEntries = Collections.unmodifiableList(new ArrayList<AppConfigurationEntry>(Arrays.asList(entries)));
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public List<AppConfigurationEntry> configurationEntries() {
        return this.configurationEntries;
    }

    public String configEntryOption(String key, String loginModuleName) {
        for (AppConfigurationEntry entry : this.configurationEntries) {
            Object val;
            if (loginModuleName != null && !loginModuleName.equals(entry.getLoginModuleName()) || (val = entry.getOptions().get(key)) == null) continue;
            return (String)val;
        }
        return null;
    }

    public static enum Type {
        CLIENT,
        SERVER;

    }
}

