/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.record.InvalidRecordException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.CollectionUtils;
import org.apache.kafka.common.utils.Utils;

public class ProduceRequest
extends AbstractRequest {
    private static final String TRANSACTIONAL_ID_KEY_NAME = "transactional_id";
    private static final String ACKS_KEY_NAME = "acks";
    private static final String TIMEOUT_KEY_NAME = "timeout";
    private static final String TOPIC_DATA_KEY_NAME = "topic_data";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITION_DATA_KEY_NAME = "data";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String RECORD_SET_KEY_NAME = "record_set";
    private final short acks;
    private final int timeout;
    private final String transactionalId;
    private final Map<TopicPartition, Integer> partitionSizes;
    private volatile Map<TopicPartition, MemoryRecords> partitionRecords;
    private boolean transactional = false;
    private boolean idempotent = false;

    private ProduceRequest(short version, short acks, int timeout, Map<TopicPartition, MemoryRecords> partitionRecords, String transactionalId) {
        super(version);
        this.acks = acks;
        this.timeout = timeout;
        this.transactionalId = transactionalId;
        this.partitionRecords = partitionRecords;
        this.partitionSizes = ProduceRequest.createPartitionSizes(partitionRecords);
        for (MemoryRecords records : partitionRecords.values()) {
            this.validateRecords(version, records);
        }
    }

    private static Map<TopicPartition, Integer> createPartitionSizes(Map<TopicPartition, MemoryRecords> partitionRecords) {
        HashMap<TopicPartition, Integer> result = new HashMap<TopicPartition, Integer>(partitionRecords.size());
        for (Map.Entry<TopicPartition, MemoryRecords> entry : partitionRecords.entrySet()) {
            result.put(entry.getKey(), entry.getValue().sizeInBytes());
        }
        return result;
    }

    public ProduceRequest(Struct struct, short version) {
        super(version);
        this.partitionRecords = new HashMap<TopicPartition, MemoryRecords>();
        for (Object topicDataObj : struct.getArray(TOPIC_DATA_KEY_NAME)) {
            Struct topicData = (Struct)topicDataObj;
            String topic = topicData.getString(TOPIC_KEY_NAME);
            for (Object partitionResponseObj : topicData.getArray(PARTITION_DATA_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition = partitionResponse.getInt(PARTITION_KEY_NAME);
                MemoryRecords records = (MemoryRecords)partitionResponse.getRecords(RECORD_SET_KEY_NAME);
                this.validateRecords(version, records);
                this.partitionRecords.put(new TopicPartition(topic, partition), records);
            }
        }
        this.partitionSizes = ProduceRequest.createPartitionSizes(this.partitionRecords);
        this.acks = struct.getShort(ACKS_KEY_NAME);
        this.timeout = struct.getInt(TIMEOUT_KEY_NAME);
        this.transactionalId = struct.hasField(TRANSACTIONAL_ID_KEY_NAME) ? struct.getString(TRANSACTIONAL_ID_KEY_NAME) : null;
    }

    private void validateRecords(short version, MemoryRecords records) {
        if (version >= 3) {
            Iterator<MutableRecordBatch> iterator = records.batches().iterator();
            if (!iterator.hasNext()) {
                throw new InvalidRecordException("Produce requests with version " + version + " must have at least one record batch");
            }
            MutableRecordBatch entry = iterator.next();
            if (entry.magic() != 2) {
                throw new InvalidRecordException("Produce requests with version " + version + " are only allowed to contain record batches with magic version 2");
            }
            if (iterator.hasNext()) {
                throw new InvalidRecordException("Produce requests with version " + version + " are only allowed to contain exactly one record batch");
            }
            this.idempotent = entry.hasProducerId();
            this.transactional = entry.isTransactional();
        }
    }

    @Override
    public Struct toStruct() {
        Map<TopicPartition, MemoryRecords> partitionRecords = this.partitionRecordsOrFail();
        short version = this.version();
        Struct struct = new Struct(ApiKeys.PRODUCE.requestSchema(version));
        Map<String, Map<Integer, MemoryRecords>> recordsByTopic = CollectionUtils.groupDataByTopic(partitionRecords);
        struct.set(ACKS_KEY_NAME, (Object)this.acks);
        struct.set(TIMEOUT_KEY_NAME, (Object)this.timeout);
        if (struct.hasField(TRANSACTIONAL_ID_KEY_NAME)) {
            struct.set(TRANSACTIONAL_ID_KEY_NAME, (Object)this.transactionalId);
        }
        ArrayList<Struct> topicDatas = new ArrayList<Struct>(recordsByTopic.size());
        for (Map.Entry<String, Map<Integer, MemoryRecords>> topicEntry : recordsByTopic.entrySet()) {
            Struct topicData = struct.instance(TOPIC_DATA_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)topicEntry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, MemoryRecords> partitionEntry : topicEntry.getValue().entrySet()) {
                MemoryRecords records = partitionEntry.getValue();
                Struct part = topicData.instance(PARTITION_DATA_KEY_NAME).set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey()).set(RECORD_SET_KEY_NAME, (Object)records);
                partitionArray.add(part);
            }
            topicData.set(PARTITION_DATA_KEY_NAME, (Object)partitionArray.toArray());
            topicDatas.add(topicData);
        }
        struct.set(TOPIC_DATA_KEY_NAME, (Object)topicDatas.toArray());
        return struct;
    }

    @Override
    public String toString(boolean verbose) {
        StringBuilder bld = new StringBuilder();
        bld.append("{acks=").append(this.acks).append(",timeout=").append(this.timeout);
        if (verbose) {
            bld.append(",partitionSizes=").append(Utils.mkString(this.partitionSizes, "[", "]", "=", ","));
        } else {
            bld.append(",numPartitions=").append(this.partitionSizes.size());
        }
        bld.append("}");
        return bld.toString();
    }

    @Override
    public ProduceResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        if (this.acks == 0) {
            return null;
        }
        Errors error = Errors.forException(e);
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseMap = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        ProduceResponse.PartitionResponse partitionResponse = new ProduceResponse.PartitionResponse(error);
        for (TopicPartition tp : this.partitions()) {
            responseMap.put(tp, partitionResponse);
        }
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return new ProduceResponse(responseMap, throttleTimeMs);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.PRODUCE.latestVersion()));
    }

    private Collection<TopicPartition> partitions() {
        return this.partitionSizes.keySet();
    }

    public short acks() {
        return this.acks;
    }

    public int timeout() {
        return this.timeout;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public boolean isIdempotent() {
        return this.idempotent;
    }

    public Map<TopicPartition, MemoryRecords> partitionRecordsOrFail() {
        Map<TopicPartition, MemoryRecords> partitionRecords = this.partitionRecords;
        if (partitionRecords == null) {
            throw new IllegalStateException("The partition records are no longer available because clearPartitionRecords() has been invoked.");
        }
        return partitionRecords;
    }

    public void clearPartitionRecords() {
        this.partitionRecords = null;
    }

    public static ProduceRequest parse(ByteBuffer buffer, short version) {
        return new ProduceRequest(ApiKeys.PRODUCE.parseRequest(version, buffer), version);
    }

    public static byte requiredMagicForVersion(short produceRequestVersion) {
        switch (produceRequestVersion) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Magic value to use for produce request version " + produceRequestVersion + " is not known");
    }

    public static class Builder
    extends AbstractRequest.Builder<ProduceRequest> {
        private final byte magic;
        private final short acks;
        private final int timeout;
        private final Map<TopicPartition, MemoryRecords> partitionRecords;
        private final String transactionalId;

        public Builder(byte magic, short acks, int timeout, Map<TopicPartition, MemoryRecords> partitionRecords, String transactionalId) {
            super(ApiKeys.PRODUCE, (short)(magic == 2 ? 3 : 2));
            this.magic = magic;
            this.acks = acks;
            this.timeout = timeout;
            this.partitionRecords = partitionRecords;
            this.transactionalId = transactionalId;
        }

        public Builder(byte magic, short acks, int timeout, Map<TopicPartition, MemoryRecords> partitionRecords) {
            this(magic, acks, timeout, partitionRecords, null);
        }

        @Override
        public ProduceRequest build(short version) {
            if (version < 2) {
                throw new UnsupportedVersionException("ProduceRequest versions older than 2 are not supported.");
            }
            return new ProduceRequest(version, this.acks, this.timeout, this.partitionRecords, this.transactionalId);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=ProduceRequest").append(", magic=").append(this.magic).append(", acks=").append(this.acks).append(", timeout=").append(this.timeout).append(", partitionRecords=(").append(this.partitionRecords).append("), transactionalId='").append(this.transactionalId != null ? this.transactionalId : "").append("'");
            return bld.toString();
        }
    }
}

