/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.devtools.j2objc.J2ObjC;
import com.google.devtools.j2objc.translate.ASTFactory;
import com.google.devtools.j2objc.types.GeneratedMethodBinding;
import com.google.devtools.j2objc.types.GeneratedVariableBinding;
import com.google.devtools.j2objc.types.IOSMethod;
import com.google.devtools.j2objc.types.IOSMethodBinding;
import com.google.devtools.j2objc.types.IOSParameter;
import com.google.devtools.j2objc.types.JavaMethod;
import com.google.devtools.j2objc.types.NodeCopier;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import com.google.devtools.j2objc.util.NameTable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class JavaToIOSMethodTranslator
extends ErrorReportingASTVisitor {
    private AST ast;
    private Map<IMethodBinding, JavaMethod> descriptions = Maps.newLinkedHashMap();
    private List<IMethodBinding> overridableMethods = Lists.newArrayList();
    private List<IMethodBinding> mappedMethods = Lists.newArrayList();
    private final ITypeBinding javaLangCloneable;
    private final Map<String, IOSMethod> methodMappings;
    private static final Function<String, IOSMethod> IOS_METHOD_FROM_STRING = new Function<String, IOSMethod>(){

        public IOSMethod apply(String string) {
            return IOSMethod.create(string);
        }
    };

    public JavaToIOSMethodTranslator(AST aST, Map<String, String> map) {
        this.ast = aST;
        this.methodMappings = ImmutableMap.copyOf((Map)Maps.transformValues(map, IOS_METHOD_FROM_STRING));
        this.loadTargetMethods(aST.resolveWellKnownType("java.lang.Object"));
        this.loadTargetMethods(aST.resolveWellKnownType("java.lang.Class"));
        this.loadTargetMethods(aST.resolveWellKnownType("java.lang.String"));
        this.loadTargetMethods(Types.resolveJavaType("java.lang.Number"));
        this.loadCharSequenceMethods();
        this.javaLangCloneable = aST.resolveWellKnownType("java.lang.Cloneable");
    }

    private void loadTargetMethods(ITypeBinding iTypeBinding) {
        for (IMethodBinding iMethodBinding : iTypeBinding.getDeclaredMethods()) {
            int n;
            if (iMethodBinding.isConstructor() && Types.isJavaObjectType(iMethodBinding.getDeclaringClass()) || iMethodBinding.getName().equals("clone") || Modifier.isPrivate((int)(n = iMethodBinding.getModifiers()))) continue;
            if (!Modifier.isFinal((int)n)) {
                this.overridableMethods.add(iMethodBinding);
            }
            this.mappedMethods.add(iMethodBinding);
            this.addDescription(iMethodBinding);
        }
    }

    private void loadCharSequenceMethods() {
        ITypeBinding iTypeBinding = Types.resolveJavaType("java.lang.CharSequence");
        for (IMethodBinding iMethodBinding : iTypeBinding.getDeclaredMethods()) {
            if (iMethodBinding.getName().equals("length")) {
                this.overridableMethods.add(0, iMethodBinding);
                NameTable.rename((IBinding)iMethodBinding, "sequenceLength");
                this.mappedMethods.add(iMethodBinding);
                this.addDescription(iMethodBinding);
                continue;
            }
            if (iMethodBinding.getName().equals("toString")) {
                this.overridableMethods.add(0, iMethodBinding);
                NameTable.rename((IBinding)iMethodBinding, "sequenceDescription");
                this.mappedMethods.add(iMethodBinding);
                this.addDescription(iMethodBinding);
                continue;
            }
            if (!iMethodBinding.getName().equals("subSequence")) continue;
            this.overridableMethods.add(0, iMethodBinding);
            NameTable.rename((IBinding)iMethodBinding, "subSequenceFrom");
            this.mappedMethods.add(iMethodBinding);
            this.addDescription(iMethodBinding);
        }
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        IMethodBinding iMethodBinding = Types.getMethodBinding(methodDeclaration);
        JavaMethod javaMethod = this.getDescription(iMethodBinding);
        if (javaMethod != null) {
            this.mapMethod(methodDeclaration, iMethodBinding, this.methodMappings.get(javaMethod.getKey()));
            return true;
        }
        for (IMethodBinding iMethodBinding2 : this.overridableMethods) {
            JavaMethod javaMethod2;
            if (iMethodBinding.isConstructor() || !iMethodBinding.isEqualTo((IBinding)iMethodBinding2) && !iMethodBinding.overrides(iMethodBinding2) || (javaMethod2 = this.getDescription(iMethodBinding2)) == null) continue;
            String string = javaMethod2.getKey();
            IOSMethod iOSMethod = this.methodMappings.get(string);
            if (iOSMethod != null) {
                this.mapMethod(methodDeclaration, iMethodBinding, iOSMethod);
            }
            return true;
        }
        return true;
    }

    private void mapMethod(MethodDeclaration methodDeclaration, IMethodBinding iMethodBinding, IOSMethod iOSMethod) {
        IOSMethodBinding iOSMethodBinding = IOSMethodBinding.newMappedMethod(iOSMethod, iMethodBinding);
        methodDeclaration.setName(ASTFactory.newSimpleName(this.ast, iOSMethodBinding));
        Types.addBinding(methodDeclaration, iOSMethodBinding);
        List<SingleVariableDeclaration> list = ASTUtil.getParameters(methodDeclaration);
        int n = list.size();
        if (n > 0) {
            List<IOSParameter> list2 = iOSMethod.getParameters();
            assert (n == list2.size() || iOSMethod.isVarArgs());
            for (int i = 0; i < n; ++i) {
                ITypeBinding iTypeBinding = Types.resolveIOSType(list2.get(i).getType());
                if (iTypeBinding == null) continue;
                list.get(i).setType(ASTFactory.newType(this.ast, iTypeBinding));
            }
        }
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        Object object;
        if (classInstanceCreation.getExpression() != null) {
            classInstanceCreation.getExpression().accept((ASTVisitor)this);
        }
        IMethodBinding iMethodBinding = ASTUtil.getArguments(classInstanceCreation).iterator();
        while (iMethodBinding.hasNext()) {
            object = iMethodBinding.next();
            object.accept((ASTVisitor)this);
        }
        if (classInstanceCreation.getAnonymousClassDeclaration() != null) {
            classInstanceCreation.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        if ((object = this.descriptions.get(iMethodBinding = Types.getMethodBinding(classInstanceCreation))) != null) {
            String string = ((JavaMethod)object).getKey();
            IOSMethod iOSMethod = this.methodMappings.get(string);
            if (iOSMethod != null) {
                IOSMethodBinding iOSMethodBinding = IOSMethodBinding.newMappedMethod(iOSMethod, iMethodBinding);
                MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(this.ast, iOSMethodBinding, (Expression)ASTFactory.newSimpleName(this.ast, (IBinding)Types.resolveIOSType(iOSMethod.getDeclaringClass())));
                this.copyInvocationArguments(null, ASTUtil.getArguments(classInstanceCreation), ASTUtil.getArguments(methodInvocation));
                ASTUtil.setProperty((ASTNode)classInstanceCreation, (ASTNode)methodInvocation);
            } else {
                J2ObjC.error((ASTNode)classInstanceCreation, this.createMissingMethodMessage(iMethodBinding));
            }
        }
        return true;
    }

    public void endVisit(TypeDeclaration typeDeclaration) {
        ITypeBinding iTypeBinding;
        ITypeBinding iTypeBinding2 = Types.getTypeBinding(typeDeclaration);
        if (iTypeBinding2.isAssignmentCompatible(this.javaLangCloneable) && ((iTypeBinding = iTypeBinding2.getSuperclass()) == null || !iTypeBinding.isAssignmentCompatible(this.javaLangCloneable))) {
            this.addCopyWithZoneMethod(typeDeclaration);
        }
    }

    public void endVisit(MethodInvocation methodInvocation) {
        block6: {
            IOSMethod iOSMethod;
            Iterator<IMethodBinding> iterator;
            IMethodBinding iMethodBinding;
            block5: {
                Object object;
                iMethodBinding = Types.getMethodBinding(methodInvocation);
                JavaMethod javaMethod = this.getDescription(iMethodBinding);
                if (javaMethod == null && !iMethodBinding.getName().equals("clone")) {
                    ITypeBinding iOSMethod2;
                    object = methodInvocation.getExpression() != null ? Types.getVariableBinding(methodInvocation.getExpression()) : null;
                    ITypeBinding iTypeBinding = iOSMethod2 = object != null ? object.getType() : iMethodBinding.getDeclaringClass();
                    if (iOSMethod2 != null && !iOSMethod2.isArray()) {
                        iterator = this.descriptions.keySet().iterator();
                        while (iterator.hasNext()) {
                            iOSMethod = iterator.next();
                            if (!iMethodBinding.isSubsignature((IMethodBinding)iOSMethod) || !iOSMethod2.isAssignmentCompatible(iOSMethod.getDeclaringClass())) continue;
                            javaMethod = this.descriptions.get(iOSMethod);
                            break;
                        }
                    }
                }
                if (javaMethod == null) break block5;
                object = javaMethod.getKey();
                IOSMethod iOSMethod2 = this.methodMappings.get(object);
                if (iOSMethod2 == null) {
                    J2ObjC.error((ASTNode)methodInvocation, this.createMissingMethodMessage(iMethodBinding));
                    return;
                }
                iterator = IOSMethodBinding.newMappedMethod(iOSMethod2, iMethodBinding);
                Types.addBinding(methodInvocation, (IBinding)iterator);
                NameTable.rename((IBinding)iMethodBinding, iOSMethod2.getName());
                if (!(methodInvocation.getExpression() instanceof SimpleName) || !(iOSMethod = (SimpleName)methodInvocation.getExpression()).getIdentifier().equals(iMethodBinding.getDeclaringClass().getName()) && !iOSMethod.getIdentifier().equals(iMethodBinding.getDeclaringClass().getQualifiedName())) break block6;
                NameTable.rename((IBinding)iMethodBinding.getDeclaringClass(), iOSMethod2.getDeclaringClass());
                break block6;
            }
            for (IMethodBinding iMethodBinding2 : this.mappedMethods) {
                if (!iMethodBinding.overrides(iMethodBinding2) || (iterator = this.getDescription(iMethodBinding2)) == null || (iOSMethod = this.methodMappings.get(((JavaMethod)((Object)iterator)).getKey())) == null) continue;
                IOSMethodBinding iOSMethodBinding = IOSMethodBinding.newMappedMethod(iOSMethod, iMethodBinding);
                Types.addBinding(methodInvocation, iOSMethodBinding);
                break;
            }
        }
    }

    private void copyInvocationArguments(Expression expression, List<Expression> list, List<Expression> list2) {
        if (expression != null) {
            Expression expression2 = NodeCopier.copySubtree(this.ast, expression);
            expression2.accept((ASTVisitor)this);
            list2.add(expression2);
        }
        for (Expression expression3 : list) {
            list2.add(NodeCopier.copySubtree(this.ast, expression3));
        }
    }

    public boolean visit(SuperMethodInvocation superMethodInvocation) {
        for (Expression object2 : ASTUtil.getArguments(superMethodInvocation)) {
            object2.accept((ASTVisitor)this);
        }
        IMethodBinding iMethodBinding = Types.getMethodBinding(superMethodInvocation);
        JavaMethod javaMethod = this.getDescription(iMethodBinding);
        if (javaMethod != null) {
            String string = javaMethod.getKey();
            IOSMethod iMethodBinding2 = this.methodMappings.get(string);
            if (iMethodBinding2 == null) {
                return super.visit(superMethodInvocation);
            }
            IOSMethodBinding javaMethod2 = IOSMethodBinding.newMappedMethod(iMethodBinding2, iMethodBinding);
            Types.addBinding(superMethodInvocation, javaMethod2);
        } else {
            for (IMethodBinding iMethodBinding2 : this.mappedMethods) {
                IOSMethod iOSMethod;
                JavaMethod javaMethod3;
                if (!iMethodBinding.overrides(iMethodBinding2) || (javaMethod3 = this.getDescription(iMethodBinding2)) == null || (iOSMethod = this.methodMappings.get(javaMethod3.getKey())) == null) continue;
                IOSMethodBinding iOSMethodBinding = IOSMethodBinding.newMappedMethod(iOSMethod, iMethodBinding);
                Types.addBinding(superMethodInvocation, iOSMethodBinding);
            }
        }
        return true;
    }

    private JavaMethod getDescription(IMethodBinding iMethodBinding) {
        if (this.descriptions.containsKey(iMethodBinding)) {
            return this.descriptions.get(iMethodBinding);
        }
        return this.addDescription(iMethodBinding);
    }

    private JavaMethod addDescription(IMethodBinding iMethodBinding) {
        JavaMethod javaMethod = JavaMethod.getJavaMethod(iMethodBinding);
        if (javaMethod != null && this.methodMappings.containsKey(javaMethod.getKey())) {
            this.descriptions.put(iMethodBinding, javaMethod);
            return javaMethod;
        }
        return null;
    }

    public boolean visit(Block block) {
        for (Statement statement : ASTUtil.getStatements(block)) {
            statement.accept((ASTVisitor)this);
        }
        return false;
    }

    private String createMissingMethodMessage(IMethodBinding iMethodBinding) {
        StringBuilder stringBuilder = new StringBuilder("Internal error: ");
        stringBuilder.append(iMethodBinding.getDeclaringClass().getName());
        if (!iMethodBinding.isConstructor()) {
            stringBuilder.append('.');
            stringBuilder.append(iMethodBinding.getName());
        }
        stringBuilder.append('(');
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
        int n = iTypeBindingArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(iTypeBindingArray[i].getName());
            if (i + 1 >= n) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(") not mapped");
        return stringBuilder.toString();
    }

    private SingleVariableDeclaration makeZoneParameter(GeneratedVariableBinding generatedVariableBinding) {
        SimpleName simpleName = this.ast.newSimpleName("zone");
        Types.addBinding(simpleName, generatedVariableBinding);
        SingleVariableDeclaration singleVariableDeclaration = this.ast.newSingleVariableDeclaration();
        singleVariableDeclaration.setName(simpleName);
        singleVariableDeclaration.setType(ASTFactory.newType(this.ast, generatedVariableBinding.getType()));
        Types.addBinding(singleVariableDeclaration, generatedVariableBinding);
        return singleVariableDeclaration;
    }

    private MethodInvocation makeCloneInvocation(ITypeBinding iTypeBinding, GeneratedVariableBinding generatedVariableBinding) {
        GeneratedMethodBinding generatedMethodBinding = GeneratedMethodBinding.newMethod("clone", 0, Types.resolveIOSType("NSObject"), iTypeBinding);
        return ASTFactory.newMethodInvocation(this.ast, generatedMethodBinding, null);
    }

    private void addCopyWithZoneMethod(TypeDeclaration typeDeclaration) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(typeDeclaration).getTypeDeclaration();
        IOSMethod iOSMethod = IOSMethod.create("id copyWithZone:(NSZone *)zone");
        IOSMethodBinding iOSMethodBinding = IOSMethodBinding.newMethod(iOSMethod, 1, Types.resolveIOSType("id"), iTypeBinding);
        MethodDeclaration methodDeclaration = ASTFactory.newMethodDeclaration(this.ast, iOSMethodBinding);
        GeneratedVariableBinding generatedVariableBinding = new GeneratedVariableBinding("zone", 0, Types.resolveIOSType("NSZone"), false, true, iOSMethodBinding.getDeclaringClass(), iOSMethodBinding);
        iOSMethodBinding.addParameter(generatedVariableBinding.getType());
        ASTUtil.getParameters(methodDeclaration).add(this.makeZoneParameter(generatedVariableBinding));
        Block block = this.ast.newBlock();
        methodDeclaration.setBody(block);
        MethodInvocation methodInvocation = this.makeCloneInvocation(iTypeBinding, generatedVariableBinding);
        ReturnStatement returnStatement = this.ast.newReturnStatement();
        returnStatement.setExpression((Expression)methodInvocation);
        ASTUtil.getStatements(block).add((Statement)returnStatement);
        ASTUtil.getBodyDeclarations((AbstractTypeDeclaration)typeDeclaration).add((BodyDeclaration)methodDeclaration);
    }
}

