/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.util;

import com.google.common.collect.Lists;
import com.google.devtools.j2objc.util.BindingUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;

public final class ASTUtil {
    public static List<Statement> getStatements(Block block) {
        return block.statements();
    }

    public static List<Statement> getStatements(SwitchStatement switchStatement) {
        return switchStatement.statements();
    }

    public static List<SingleVariableDeclaration> getParameters(MethodDeclaration methodDeclaration) {
        return methodDeclaration.parameters();
    }

    public static List<Expression> getArguments(MethodInvocation methodInvocation) {
        return methodInvocation.arguments();
    }

    public static List<Expression> getArguments(SuperMethodInvocation superMethodInvocation) {
        return superMethodInvocation.arguments();
    }

    public static List<Expression> getArguments(ConstructorInvocation constructorInvocation) {
        return constructorInvocation.arguments();
    }

    public static List<Expression> getArguments(SuperConstructorInvocation superConstructorInvocation) {
        return superConstructorInvocation.arguments();
    }

    public static List<Expression> getArguments(ClassInstanceCreation classInstanceCreation) {
        return classInstanceCreation.arguments();
    }

    public static List<Expression> getArguments(EnumConstantDeclaration enumConstantDeclaration) {
        return enumConstantDeclaration.arguments();
    }

    public static List<Expression> getExtendedOperands(InfixExpression infixExpression) {
        return infixExpression.extendedOperands();
    }

    public static List<VariableDeclarationFragment> getFragments(VariableDeclarationStatement variableDeclarationStatement) {
        return variableDeclarationStatement.fragments();
    }

    public static List<VariableDeclarationFragment> getFragments(VariableDeclarationExpression variableDeclarationExpression) {
        return variableDeclarationExpression.fragments();
    }

    public static List<VariableDeclarationFragment> getFragments(FieldDeclaration fieldDeclaration) {
        return fieldDeclaration.fragments();
    }

    public static List<BodyDeclaration> getBodyDeclarations(AbstractTypeDeclaration abstractTypeDeclaration) {
        return abstractTypeDeclaration.bodyDeclarations();
    }

    public static List<BodyDeclaration> getBodyDeclarations(AnonymousClassDeclaration anonymousClassDeclaration) {
        return anonymousClassDeclaration.bodyDeclarations();
    }

    public static List<BodyDeclaration> getBodyDeclarations(ASTNode aSTNode) {
        if (aSTNode instanceof AbstractTypeDeclaration) {
            return ASTUtil.getBodyDeclarations((AbstractTypeDeclaration)aSTNode);
        }
        if (aSTNode instanceof AnonymousClassDeclaration) {
            return ASTUtil.getBodyDeclarations((AnonymousClassDeclaration)aSTNode);
        }
        throw new AssertionError((Object)("node type does not contains body declarations: " + aSTNode.getClass().getSimpleName()));
    }

    public static List<IExtendedModifier> getModifiers(BodyDeclaration bodyDeclaration) {
        return bodyDeclaration.modifiers();
    }

    public static List<IExtendedModifier> getModifiers(VariableDeclarationStatement variableDeclarationStatement) {
        return variableDeclarationStatement.modifiers();
    }

    public static List<IExtendedModifier> getModifiers(VariableDeclarationExpression variableDeclarationExpression) {
        return variableDeclarationExpression.modifiers();
    }

    public static List<IExtendedModifier> getModifiers(SingleVariableDeclaration singleVariableDeclaration) {
        return singleVariableDeclaration.modifiers();
    }

    public static List<Expression> getExpressions(ArrayInitializer arrayInitializer) {
        return arrayInitializer.expressions();
    }

    public static List<Expression> getDimensions(ArrayCreation arrayCreation) {
        return arrayCreation.dimensions();
    }

    public static List<Expression> getInitializers(ForStatement forStatement) {
        return forStatement.initializers();
    }

    public static List<Expression> getUpdaters(ForStatement forStatement) {
        return forStatement.updaters();
    }

    public static List<Type> getSuperInterfaceTypes(TypeDeclaration typeDeclaration) {
        return typeDeclaration.superInterfaceTypes();
    }

    public static List<Type> getTypeBounds(TypeParameter typeParameter) {
        return typeParameter.typeBounds();
    }

    public static List<TypeParameter> getTypeParameters(MethodDeclaration methodDeclaration) {
        return methodDeclaration.typeParameters();
    }

    public static List<Type> getTypeArguments(ParameterizedType parameterizedType) {
        return parameterizedType.typeArguments();
    }

    public static List<EnumConstantDeclaration> getEnumConstants(EnumDeclaration enumDeclaration) {
        return enumDeclaration.enumConstants();
    }

    public static List<AbstractTypeDeclaration> getTypes(CompilationUnit compilationUnit) {
        return compilationUnit.types();
    }

    public static List<Comment> getCommentList(CompilationUnit compilationUnit) {
        return compilationUnit.getCommentList();
    }

    public static List<Type> getTypes(UnionType unionType) {
        return unionType.types();
    }

    public static List<VariableDeclarationExpression> getResources(TryStatement tryStatement) {
        return tryStatement.resources();
    }

    public static List<CatchClause> getCatchClauses(TryStatement tryStatement) {
        return tryStatement.catchClauses();
    }

    public static void setProperty(ASTNode aSTNode, ASTNode aSTNode2) {
        ASTNode aSTNode3 = aSTNode.getParent();
        StructuralPropertyDescriptor structuralPropertyDescriptor = aSTNode.getLocationInParent();
        if (structuralPropertyDescriptor instanceof ChildPropertyDescriptor) {
            aSTNode3.setStructuralProperty(structuralPropertyDescriptor, (Object)aSTNode2);
        } else {
            List list;
            if (aSTNode3 instanceof ArrayCreation) {
                list = ((ArrayCreation)aSTNode3).dimensions();
            } else if (aSTNode3 instanceof ArrayInitializer) {
                list = ((ArrayInitializer)aSTNode3).expressions();
            } else if (aSTNode3 instanceof Block) {
                list = ((Block)aSTNode3).statements();
            } else if (aSTNode3 instanceof ClassInstanceCreation) {
                list = ((ClassInstanceCreation)aSTNode3).arguments();
            } else if (aSTNode3 instanceof ConstructorInvocation) {
                list = ((ConstructorInvocation)aSTNode3).arguments();
            } else if (aSTNode3 instanceof EnumConstantDeclaration) {
                list = ((EnumConstantDeclaration)aSTNode3).arguments();
            } else if (aSTNode3 instanceof InfixExpression) {
                list = ((InfixExpression)aSTNode3).extendedOperands();
            } else if (aSTNode3 instanceof MethodInvocation) {
                list = ((MethodInvocation)aSTNode3).arguments();
            } else if (aSTNode3 instanceof SuperConstructorInvocation) {
                list = ((SuperConstructorInvocation)aSTNode3).arguments();
            } else if (aSTNode3 instanceof SuperMethodInvocation) {
                list = ((SuperMethodInvocation)aSTNode3).arguments();
            } else if (aSTNode3 instanceof SwitchStatement) {
                list = ((SwitchStatement)aSTNode3).statements();
            } else if (aSTNode3 instanceof TypeDeclaration) {
                list = ((TypeDeclaration)aSTNode3).superInterfaceTypes();
            } else {
                throw new AssertionError((Object)("unknown parent node type: " + aSTNode3.getClass().getSimpleName()));
            }
            for (int i = 0; i < list.size(); ++i) {
                if (!aSTNode.equals(list.get(i))) continue;
                list.set(i, aSTNode2);
            }
        }
    }

    public static List<Statement> asStatementList(Statement statement) {
        Block block;
        if (statement instanceof Block) {
            return ASTUtil.getStatements((Block)statement);
        }
        ASTNode aSTNode = statement.getParent();
        if (aSTNode instanceof Block) {
            block = ASTUtil.getStatements((Block)aSTNode);
            for (int i = 0; i < block.size(); ++i) {
                if (block.get(i) != statement) continue;
                return block.subList(i, i + 1);
            }
        }
        block = statement.getAST().newBlock();
        ASTUtil.setProperty((ASTNode)statement, (ASTNode)block);
        ASTUtil.getStatements(block).add(statement);
        return ASTUtil.getStatements(block);
    }

    public static void insertAfter(Statement statement, Statement statement2) {
        ASTUtil.asStatementList(statement).add(statement2);
    }

    public static void insertBefore(Statement statement, Statement statement2) {
        ASTUtil.asStatementList(statement).add(0, statement2);
    }

    public static Map<String, Object> getProperties(ASTNode aSTNode) {
        return aSTNode.properties();
    }

    public static List<Annotation> getRuntimeAnnotations(List<IExtendedModifier> list) {
        ArrayList arrayList = Lists.newArrayList();
        for (IExtendedModifier iExtendedModifier : list) {
            if (!BindingUtil.isRuntimeAnnotation(iExtendedModifier)) continue;
            arrayList.add((Annotation)iExtendedModifier);
        }
        return arrayList;
    }

    public static AbstractTypeDeclaration getOwningType(ASTNode aSTNode) {
        for (ASTNode aSTNode2 = aSTNode; aSTNode2 != null; aSTNode2 = aSTNode2.getParent()) {
            if (!(aSTNode2 instanceof AbstractTypeDeclaration)) continue;
            return (AbstractTypeDeclaration)aSTNode2;
        }
        return null;
    }

    public static MethodDeclaration getOwningMethod(ASTNode aSTNode) {
        for (ASTNode aSTNode2 = aSTNode; aSTNode2 != null; aSTNode2 = aSTNode2.getParent()) {
            if (!(aSTNode2 instanceof MethodDeclaration)) continue;
            return (MethodDeclaration)aSTNode2;
        }
        return null;
    }

    public static Statement getOwningStatement(ASTNode aSTNode) {
        for (ASTNode aSTNode2 = aSTNode; aSTNode2 != null; aSTNode2 = aSTNode2.getParent()) {
            if (!(aSTNode2 instanceof Statement)) continue;
            return (Statement)aSTNode2;
        }
        return null;
    }

    public static List<MethodDeclaration> getMethodDeclarations(AbstractTypeDeclaration abstractTypeDeclaration) {
        ArrayList arrayList = Lists.newArrayList();
        for (BodyDeclaration bodyDeclaration : ASTUtil.getBodyDeclarations(abstractTypeDeclaration)) {
            if (!(bodyDeclaration instanceof MethodDeclaration)) continue;
            arrayList.add((MethodDeclaration)bodyDeclaration);
        }
        return arrayList;
    }

    public static List<FieldDeclaration> getFieldDeclarations(AbstractTypeDeclaration abstractTypeDeclaration) {
        ArrayList arrayList = Lists.newArrayList();
        for (BodyDeclaration bodyDeclaration : ASTUtil.getBodyDeclarations(abstractTypeDeclaration)) {
            if (!(bodyDeclaration instanceof FieldDeclaration)) continue;
            arrayList.add((FieldDeclaration)bodyDeclaration);
        }
        return arrayList;
    }
}

