/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.devtools.j2objc.translate.ASTFactory;
import com.google.devtools.j2objc.types.GeneratedVariableBinding;
import com.google.devtools.j2objc.types.NodeCopier;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;

public class ComplexExpressionExtractor
extends ErrorReportingASTVisitor {
    private static final int DEFAULT_MAX_DEPTH = 50;
    private static int maxDepth = 50;
    private Map<Expression, Integer> depths = Maps.newHashMap();
    private IMethodBinding currentMethod;
    private Statement currentStatement;
    private int count = 1;

    @VisibleForTesting
    static void setMaxDepth(int n) {
        maxDepth = n;
    }

    @VisibleForTesting
    static void resetMaxDepth() {
        maxDepth = 50;
    }

    private void handleNode(Expression expression, Collection<Expression> collection) {
        Object object;
        if (expression.getParent() instanceof Statement) {
            return;
        }
        int n = 0;
        for (Expression expression2 : collection) {
            object = this.depths.get(expression2);
            n = Math.max(n, object != null ? (Integer)object : 1);
        }
        if (n >= maxDepth) {
            Expression expression2;
            AST aST = expression.getAST();
            expression2 = Types.getTypeBinding(expression);
            assert (this.currentMethod != null);
            object = new GeneratedVariableBinding("complex$" + this.count++, 0, (ITypeBinding)expression2, false, false, null, this.currentMethod);
            VariableDeclarationStatement variableDeclarationStatement = ASTFactory.newVariableDeclarationStatement(aST, (IVariableBinding)object, NodeCopier.copySubtree(aST, expression));
            assert (this.currentStatement != null);
            ASTUtil.insertBefore(this.currentStatement, (Statement)variableDeclarationStatement);
            ASTUtil.setProperty((ASTNode)expression, (ASTNode)ASTFactory.newSimpleName(aST, (IBinding)object));
        } else {
            this.depths.put(expression, n + 1);
        }
    }

    @Override
    public void preVisit(ASTNode aSTNode) {
        super.preVisit(aSTNode);
        if (aSTNode instanceof Statement) {
            this.currentStatement = (Statement)aSTNode;
        }
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        this.currentMethod = Types.getMethodBinding(methodDeclaration);
        return true;
    }

    public void endVisit(MethodDeclaration methodDeclaration) {
        this.currentMethod = null;
    }

    public void endVisit(InfixExpression infixExpression) {
        this.handleNode((Expression)infixExpression, (Collection<Expression>)ImmutableList.of((Object)infixExpression.getLeftOperand(), (Object)infixExpression.getRightOperand()));
    }

    public void endVisit(MethodInvocation methodInvocation) {
        Expression expression = methodInvocation.getExpression();
        List<Expression> list = ASTUtil.getArguments(methodInvocation);
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)(list.size() + 1));
        if (expression != null) {
            arrayList.add(expression);
        }
        this.handleNode((Expression)methodInvocation, arrayList);
    }
}

