/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.devtools.j2objc.types.AbstractBinding;
import com.google.devtools.j2objc.types.Types;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;

public class GeneratedMethodBinding
extends AbstractBinding
implements IMethodBinding {
    private final IMethodBinding delegate;
    private final String name;
    private final int modifiers;
    private final List<ITypeBinding> parameters = Lists.newArrayList();
    private final ITypeBinding returnType;
    private final IMethodBinding methodDeclaration;
    private ITypeBinding declaringClass;
    private final boolean varargs;
    private final boolean isConstructor;
    private final boolean isSynthetic;

    public GeneratedMethodBinding(IMethodBinding iMethodBinding, String string, int n, ITypeBinding iTypeBinding, IMethodBinding iMethodBinding2, ITypeBinding iTypeBinding2, boolean bl, boolean bl2, boolean bl3) {
        this.delegate = iMethodBinding;
        this.name = (String)Preconditions.checkNotNull((Object)string);
        this.modifiers = n;
        this.returnType = iTypeBinding;
        this.methodDeclaration = iMethodBinding2;
        this.declaringClass = iTypeBinding2;
        this.isConstructor = bl;
        this.varargs = bl2;
        this.isSynthetic = bl3;
    }

    public GeneratedMethodBinding(IMethodBinding iMethodBinding) {
        this(null, iMethodBinding.getName(), iMethodBinding.getModifiers(), iMethodBinding.getReturnType(), null, iMethodBinding.getDeclaringClass(), iMethodBinding.isConstructor(), iMethodBinding.isVarargs(), iMethodBinding.isSynthetic());
        this.addParameters(iMethodBinding);
    }

    public static GeneratedMethodBinding newMethod(String string, int n, ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2) {
        return new GeneratedMethodBinding(null, string, n, iTypeBinding, null, iTypeBinding2, false, false, true);
    }

    public static GeneratedMethodBinding newConstructor(ITypeBinding iTypeBinding, int n) {
        return new GeneratedMethodBinding(null, "init", n, Types.mapTypeName("void"), null, iTypeBinding, true, false, false);
    }

    public static GeneratedMethodBinding newOverridingMethod(IMethodBinding iMethodBinding, ITypeBinding iTypeBinding, int n) {
        return new GeneratedMethodBinding(iMethodBinding, iMethodBinding.getName(), n, iMethodBinding.getReturnType(), null, iTypeBinding, iMethodBinding.isConstructor(), iMethodBinding.isVarargs(), iMethodBinding.isSynthetic());
    }

    public int getKind() {
        return 4;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public boolean isSynthetic() {
        return this.isSynthetic || (this.modifiers & 0x1000) > 0;
    }

    public String getKey() {
        throw new AssertionError((Object)"not implemented");
    }

    public boolean isEqualTo(IBinding iBinding) {
        return this.equals(iBinding);
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public boolean isDefaultConstructor() {
        return this.isConstructor && this.parameters.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public String getJavaName() {
        return this.delegate != null ? this.delegate.getName() : this.name;
    }

    public ITypeBinding getDeclaringClass() {
        return this.declaringClass;
    }

    public void setDeclaringClass(ITypeBinding iTypeBinding) {
        this.declaringClass = iTypeBinding;
    }

    public Object getDefaultValue() {
        return null;
    }

    public IAnnotationBinding[] getParameterAnnotations(int n) {
        return new IAnnotationBinding[0];
    }

    public ITypeBinding[] getParameterTypes() {
        return this.parameters.toArray(new ITypeBinding[this.parameters.size()]);
    }

    public void addParameter(ITypeBinding iTypeBinding) {
        this.parameters.add(iTypeBinding);
    }

    public void addParameter(int n, ITypeBinding iTypeBinding) {
        this.parameters.add(n, iTypeBinding);
    }

    public void addParameters(IMethodBinding iMethodBinding) {
        this.parameters.addAll(Arrays.asList(iMethodBinding.getParameterTypes()));
    }

    public ITypeBinding getReturnType() {
        return this.returnType;
    }

    public ITypeBinding[] getExceptionTypes() {
        return new ITypeBinding[0];
    }

    public ITypeBinding[] getTypeParameters() {
        throw new AssertionError((Object)"not implemented");
    }

    public boolean isAnnotationMember() {
        return false;
    }

    public boolean isGenericMethod() {
        return false;
    }

    public boolean isParameterizedMethod() {
        return false;
    }

    public ITypeBinding[] getTypeArguments() {
        return new ITypeBinding[0];
    }

    public IMethodBinding getMethodDeclaration() {
        return this.methodDeclaration != null ? this.methodDeclaration : this;
    }

    public boolean isRawMethod() {
        return false;
    }

    public boolean isSubsignature(IMethodBinding iMethodBinding) {
        return this.delegate != null && this.delegate.isSubsignature(iMethodBinding);
    }

    public boolean isVarargs() {
        return this.varargs;
    }

    public boolean overrides(IMethodBinding iMethodBinding) {
        return this.delegate != null && (this.delegate.equals(iMethodBinding) || this.delegate.overrides(iMethodBinding));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
        n = 31 * n + this.modifiers;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.parameters == null ? 0 : this.parameters.hashCode());
        n = 31 * n + (this.returnType == null ? 0 : this.returnType.hashCode());
        n = 31 * n + (this.varargs ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof GeneratedMethodBinding)) {
            return false;
        }
        GeneratedMethodBinding generatedMethodBinding = (GeneratedMethodBinding)object;
        return this.name.equals(generatedMethodBinding.name) && this.modifiers == generatedMethodBinding.modifiers && this.varargs == generatedMethodBinding.varargs && (this.returnType == null ? generatedMethodBinding.returnType == null : this.returnType.equals(generatedMethodBinding.returnType)) && this.declaringClass.equals(generatedMethodBinding.declaringClass) && this.parameters.equals(generatedMethodBinding.parameters);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        ASTNode.printModifiers((int)this.modifiers, (StringBuffer)stringBuffer);
        stringBuffer.append(this.returnType != null ? this.returnType.getName() : "<no type>");
        stringBuffer.append(' ');
        stringBuffer.append(this.name != null ? this.name : "<no name>");
        stringBuffer.append('(');
        ITypeBinding[] iTypeBindingArray = this.getParameterTypes();
        for (int i = 0; i < iTypeBindingArray.length; ++i) {
            stringBuffer.append(iTypeBindingArray[i].getName());
            if (i + 1 >= iTypeBindingArray.length) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

