/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class TypeSorter {
    private static Multimap<String, String> findSuperTypes(Map<String, ITypeBinding> map) {
        HashMultimap hashMultimap = HashMultimap.create();
        for (Map.Entry<String, ITypeBinding> entry : map.entrySet()) {
            Object object;
            String string = entry.getKey();
            ITypeBinding iTypeBinding = entry.getValue();
            ITypeBinding iTypeBinding2 = iTypeBinding.getSuperclass();
            if (iTypeBinding2 != null && map.containsKey(object = iTypeBinding2.getTypeDeclaration().getKey())) {
                hashMultimap.put((Object)string, object);
            }
            object = iTypeBinding.getInterfaces();
            int n = ((ITypeBinding[])object).length;
            for (int i = 0; i < n; ++i) {
                ITypeBinding iTypeBinding3 = object[i];
                String string2 = iTypeBinding3.getTypeDeclaration().getKey();
                if (!map.containsKey(string2)) continue;
                hashMultimap.put((Object)string, (Object)string2);
            }
        }
        return hashMultimap;
    }

    public static void sortTypes(CompilationUnit compilationUnit) {
        Object object;
        List<AbstractTypeDeclaration> list = ASTUtil.getTypes(compilationUnit);
        HashMap hashMap = Maps.newHashMap();
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        for (AbstractTypeDeclaration object22 : list) {
            object = Types.getTypeBinding(object22);
            Object object2 = object.getKey();
            hashMap.put(object2, object22);
            linkedHashMap.put(object2, object);
        }
        Iterator<AbstractTypeDeclaration> iterator = TypeSorter.findSuperTypes(linkedHashMap);
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        for (Object object2 : linkedHashMap.keySet()) {
            if (iterator.containsValue(object2)) continue;
            arrayList.add(object2);
        }
        list.clear();
        while (!arrayList.isEmpty()) {
            object = (String)arrayList.remove(arrayList.size() - 1);
            list.add(0, (AbstractTypeDeclaration)hashMap.get(object));
            for (String string : iterator.removeAll(object)) {
                if (iterator.containsValue(string)) continue;
                arrayList.add(string);
            }
        }
    }
}

