/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.gen;

import com.google.common.io.LineReader;
import com.google.devtools.j2objc.gen.SourcePosition;
import java.io.IOException;
import java.io.StringReader;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class SourceBuilder {
    private final StringBuilder buffer = new StringBuilder();
    private final CompilationUnit unit;
    private int indention = 0;
    private String filename = null;
    private String source = null;
    private int currentLine = -1;
    private final boolean emitLineDirectives;
    public static final int DEFAULT_INDENTION = 2;
    public static final int BEGINNING_OF_FILE = -1;

    public SourceBuilder(CompilationUnit compilationUnit, String string, String string2, boolean bl) {
        this(compilationUnit, bl, new SourcePosition(string, -1, string2));
    }

    public SourceBuilder(CompilationUnit compilationUnit, boolean bl, SourcePosition sourcePosition) {
        this.unit = compilationUnit;
        this.emitLineDirectives = bl;
        this.source = sourcePosition.getSource();
        this.filename = sourcePosition.getFilename();
        this.currentLine = sourcePosition.getLineNumber();
    }

    public SourceBuilder() {
        this(null, null, null, false);
    }

    public SourceBuilder(SourceBuilder sourceBuilder) {
        this(sourceBuilder.unit, sourceBuilder.emitLineDirectives, sourceBuilder.getSourcePosition());
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void print(String string) {
        this.buffer.append(string);
    }

    public void print(char c) {
        this.buffer.append(c);
        if (c == '\n') {
            ++this.currentLine;
        }
    }

    public void print(int n) {
        this.buffer.append(n);
    }

    public void printf(String string, Object ... objectArray) {
        this.print(String.format(string, objectArray));
        this.currentLine += this.countNewLines(string);
    }

    public void println(String string) {
        this.print(string);
        this.newline();
    }

    public void newline() {
        this.buffer.append('\n');
        ++this.currentLine;
    }

    public void indent() {
        ++this.indention;
    }

    public void unindent() {
        --this.indention;
        if (this.indention < 0) {
            throw new AssertionError((Object)"unbalanced indents");
        }
    }

    public void printIndent() {
        this.buffer.append(this.pad(this.indention * 2));
    }

    public SourceBuilder append(char c) {
        this.print(c);
        return this;
    }

    public SourceBuilder append(int n) {
        this.print(n);
        return this;
    }

    public SourceBuilder append(String string) {
        this.print(string);
        return this;
    }

    public char charAt(int n) {
        return this.buffer.charAt(n);
    }

    public int length() {
        return this.buffer.length();
    }

    public String substring(int n, int n2) {
        return this.buffer.substring(n, n2);
    }

    public void replace(int n, int n2, String string) {
        this.buffer.replace(n, n2, string);
    }

    public char[] pad(int n) {
        if (n < 0) {
            n = 0;
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 32;
        }
        return cArray;
    }

    public void reset() {
        this.buffer.setLength(0);
    }

    public void syncLineNumbers(ASTNode aSTNode) {
        int n;
        int n2;
        if (this.emitLineDirectives && (n2 = aSTNode.getStartPosition()) != -1 && this.currentLine != (n = this.unit.getLineNumber(n2))) {
            this.buffer.append(String.format("#line %d\n", n));
            this.currentLine = n;
        }
    }

    public void printStart(String string) {
        if (this.emitLineDirectives) {
            this.buffer.append(String.format("#line 1 \"%s\"\n\n", string));
        }
    }

    private int countNewLines(String string) {
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(10, n2 + 1)) != -1) {
            ++n;
        }
        return n;
    }

    public String reindent(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            LineReader lineReader = new LineReader((Readable)new StringReader(string));
            String string2 = lineReader.readLine();
            while (string2 != null) {
                stringBuffer.append(string2.trim());
                string2 = lineReader.readLine();
                if (string2 == null) continue;
                stringBuffer.append('\n');
            }
            String string3 = stringBuffer.toString();
            int n = this.indention * 2;
            stringBuffer.setLength(0);
            lineReader = new LineReader((Readable)new StringReader(string3));
            string2 = lineReader.readLine();
            while (string2 != null) {
                if (string2.startsWith("}")) {
                    n -= 2;
                }
                if (!string2.startsWith("#line")) {
                    stringBuffer.append(this.pad(n));
                }
                stringBuffer.append(string2);
                if (string2.endsWith("{")) {
                    n += 2;
                }
                if ((string2 = lineReader.readLine()) == null) continue;
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public int getLineNumber(ASTNode aSTNode) {
        int n = aSTNode.getStartPosition();
        if (n == -1) {
            return -1;
        }
        return this.getLineNumber(n);
    }

    public int getLineNumber(int n) {
        return this.unit.getLineNumber(n);
    }

    public SourcePosition getSourcePosition() {
        return new SourcePosition(this.filename, this.currentLine, this.source);
    }
}

