/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.gen;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTNodeException;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import com.google.devtools.j2objc.util.NameTable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class HiddenFieldDetector
extends ErrorReportingASTVisitor {
    private final Set<IVariableBinding> fieldNameConflicts = Sets.newLinkedHashSet();
    Map<String, Set<String>> fieldNameMap = Maps.newHashMap();
    private static final Set<String> NO_FIELDS = Sets.newLinkedHashSet();

    public static Set<IVariableBinding> getFieldNameConflicts(ASTNode aSTNode) throws ASTNodeException {
        HiddenFieldDetector hiddenFieldDetector = new HiddenFieldDetector();
        hiddenFieldDetector.run(aSTNode);
        return hiddenFieldDetector.fieldNameConflicts;
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        if (!typeDeclaration.isInterface()) {
            LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
            ITypeBinding iTypeBinding = Types.getTypeBinding(typeDeclaration);
            this.addFields(iTypeBinding, true, linkedHashSet);
            this.fieldNameMap.put(iTypeBinding.getBinaryName(), linkedHashSet);
        }
        return super.visit(typeDeclaration);
    }

    private void addFields(ITypeBinding iTypeBinding, boolean bl, Set<String> set) {
        for (IVariableBinding iVariableBinding : iTypeBinding.getDeclaredFields()) {
            if (!bl && (iVariableBinding.getModifiers() & 2) != 0) continue;
            set.add(NameTable.javaFieldToObjC(iVariableBinding.getName()));
        }
        ITypeBinding iTypeBinding2 = iTypeBinding.getSuperclass();
        if (iTypeBinding2 != null) {
            this.addFields(iTypeBinding2, false, set);
        }
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        IMethodBinding iMethodBinding = Types.getMethodBinding(methodDeclaration);
        if (iMethodBinding != null) {
            Set<String> set = this.fieldNameMap.get(iMethodBinding.getDeclaringClass().getBinaryName());
            if (set == null) {
                set = NO_FIELDS;
            }
            for (SingleVariableDeclaration singleVariableDeclaration : ASTUtil.getParameters(methodDeclaration)) {
                IVariableBinding iVariableBinding = Types.getVariableBinding(singleVariableDeclaration);
                if (iVariableBinding == null || !set.contains(iVariableBinding.getName())) continue;
                this.fieldNameConflicts.add(iVariableBinding);
            }
        }
        return super.visit(methodDeclaration);
    }
}

