/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.types;

import com.google.common.base.Preconditions;
import com.google.devtools.j2objc.util.BindingUtil;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class JavaMethod {
    private final String clazz;
    private final String name;
    private final String signature;
    private final boolean varargs;

    public static JavaMethod getJavaMethod(IMethodBinding iMethodBinding) {
        Preconditions.checkNotNull((Object)iMethodBinding);
        ITypeBinding iTypeBinding = iMethodBinding.getDeclaringClass();
        if (iTypeBinding == null) {
            return null;
        }
        String string = iTypeBinding.getBinaryName();
        if (string == null) {
            return null;
        }
        return new JavaMethod(iMethodBinding, iTypeBinding);
    }

    private JavaMethod(IMethodBinding iMethodBinding, ITypeBinding iTypeBinding) {
        this.name = iMethodBinding.getName();
        this.signature = BindingUtil.getSignature((IBinding)iMethodBinding);
        this.clazz = iTypeBinding.getBinaryName();
        this.varargs = iMethodBinding.isVarargs();
    }

    public String getClazz() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getKey() {
        return this.clazz + '.' + this.name + this.signature;
    }

    public boolean isVarArgs() {
        return this.varargs;
    }

    public int hashCode() {
        int n = 1;
        n += this.clazz.hashCode() * 31;
        n += this.name.hashCode() * 31;
        return n += this.signature.hashCode() * 31;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JavaMethod)) {
            return false;
        }
        JavaMethod javaMethod = (JavaMethod)object;
        return this.clazz.equals(javaMethod.clazz) && this.name.equals(javaMethod.name) && this.signature.equals(javaMethod.signature);
    }

    public String toString() {
        return "[clazz=" + this.clazz + ", name=" + this.name + ", signature=" + this.signature + "]";
    }
}

