/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.common.collect.Lists;
import com.google.devtools.j2objc.translate.ASTFactory;
import com.google.devtools.j2objc.translate.OuterReferenceResolver;
import com.google.devtools.j2objc.types.GeneratedMethodBinding;
import com.google.devtools.j2objc.types.NodeCopier;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;

public class OuterReferenceFixer
extends ErrorReportingASTVisitor {
    private IVariableBinding outerParam = null;

    public boolean visit(MethodDeclaration methodDeclaration) {
        IVariableBinding iVariableBinding;
        List<SingleVariableDeclaration> list;
        IMethodBinding iMethodBinding = Types.getMethodBinding(methodDeclaration);
        if (iMethodBinding.isConstructor() && (list = ASTUtil.getParameters(methodDeclaration)).size() > 0 && (iVariableBinding = Types.getVariableBinding(list.get(0))).getName().equals("outer$")) {
            this.outerParam = iVariableBinding;
        }
        return true;
    }

    public void endVisit(MethodDeclaration methodDeclaration) {
        this.outerParam = null;
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(classInstanceCreation).getTypeDeclaration();
        ITypeBinding iTypeBinding2 = iTypeBinding.getDeclaringClass();
        if (Modifier.isStatic((int)iTypeBinding.getModifiers()) || iTypeBinding2 == null) {
            return true;
        }
        AST aST = classInstanceCreation.getAST();
        GeneratedMethodBinding generatedMethodBinding = Types.getGeneratedMethodBinding(classInstanceCreation);
        this.addOuterArg(classInstanceCreation, generatedMethodBinding, iTypeBinding2);
        for (IVariableBinding iVariableBinding : this.getCapturedVariables(classInstanceCreation)) {
            ASTUtil.getArguments(classInstanceCreation).add((Expression)ASTFactory.newSimpleName(aST, (IBinding)iVariableBinding));
            generatedMethodBinding.addParameter(iVariableBinding.getType());
        }
        assert (generatedMethodBinding.isVarargs() || classInstanceCreation.arguments().size() == generatedMethodBinding.getParameterTypes().length);
        return true;
    }

    private List<IVariableBinding> getCapturedVariables(ClassInstanceCreation classInstanceCreation) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(classInstanceCreation).getTypeDeclaration();
        ITypeBinding iTypeBinding2 = Types.getTypeBinding(ASTUtil.getOwningType((ASTNode)classInstanceCreation)).getTypeDeclaration();
        if (iTypeBinding2.isEqualTo((IBinding)iTypeBinding)) {
            return OuterReferenceResolver.getInnerFields(iTypeBinding);
        }
        return OuterReferenceResolver.getCapturedVars(iTypeBinding);
    }

    private void addOuterArg(ClassInstanceCreation classInstanceCreation, GeneratedMethodBinding generatedMethodBinding, ITypeBinding iTypeBinding) {
        ITypeBinding iTypeBinding2 = Types.getTypeBinding(classInstanceCreation);
        if (!OuterReferenceResolver.needsOuterParam(iTypeBinding2)) {
            return;
        }
        AST aST = classInstanceCreation.getAST();
        Expression expression = classInstanceCreation.getExpression();
        List<IVariableBinding> list = OuterReferenceResolver.getPath((ASTNode)classInstanceCreation);
        ThisExpression thisExpression = null;
        if (expression != null) {
            classInstanceCreation.setExpression(null);
            thisExpression = NodeCopier.copySubtree(aST, expression);
        } else if (list != null) {
            thisExpression = ASTFactory.newName(aST, this.fixPath(list));
        } else {
            thisExpression = aST.newThisExpression();
            Types.addBinding(thisExpression, (IBinding)iTypeBinding);
        }
        ASTUtil.getArguments(classInstanceCreation).add(0, (Expression)thisExpression);
        generatedMethodBinding.addParameter(0, iTypeBinding);
    }

    public boolean visit(MethodInvocation methodInvocation) {
        List<IVariableBinding> list = OuterReferenceResolver.getPath((ASTNode)methodInvocation);
        if (list != null) {
            methodInvocation.setExpression((Expression)ASTFactory.newName(methodInvocation.getAST(), this.fixPath(list)));
        }
        return true;
    }

    public void endVisit(SuperMethodInvocation superMethodInvocation) {
        List<IVariableBinding> list = OuterReferenceResolver.getPath((ASTNode)superMethodInvocation);
        if (list != null) {
            superMethodInvocation.setQualifier(ASTFactory.newName(superMethodInvocation.getAST(), this.fixPath(list)));
        } else {
            superMethodInvocation.setQualifier(null);
        }
    }

    public boolean visit(SimpleName simpleName) {
        List<IVariableBinding> list = OuterReferenceResolver.getPath((ASTNode)simpleName);
        if (list != null) {
            AST aST = simpleName.getAST();
            if (list.size() == 1 && list.get(0).getConstantValue() != null) {
                IVariableBinding iVariableBinding = list.get(0);
                ASTUtil.setProperty((ASTNode)simpleName, (ASTNode)ASTFactory.makeLiteral(aST, iVariableBinding.getConstantValue(), iVariableBinding.getType()));
            } else {
                ASTUtil.setProperty((ASTNode)simpleName, (ASTNode)ASTFactory.newName(aST, this.fixPath(list)));
            }
        }
        return true;
    }

    public boolean visit(ThisExpression thisExpression) {
        List<IVariableBinding> list = OuterReferenceResolver.getPath((ASTNode)thisExpression);
        if (list != null) {
            ASTUtil.setProperty((ASTNode)thisExpression, (ASTNode)ASTFactory.newName(thisExpression.getAST(), this.fixPath(list)));
        } else {
            thisExpression.setQualifier(null);
        }
        return true;
    }

    public void endVisit(SuperConstructorInvocation superConstructorInvocation) {
        Expression expression = superConstructorInvocation.getExpression();
        if (expression == null) {
            return;
        }
        superConstructorInvocation.setExpression(null);
        ITypeBinding iTypeBinding = Types.getTypeBinding(expression);
        GeneratedMethodBinding generatedMethodBinding = Types.getGeneratedMethodBinding(superConstructorInvocation);
        ASTUtil.getArguments(superConstructorInvocation).add(0, expression);
        generatedMethodBinding.addParameter(0, iTypeBinding);
    }

    private List<IVariableBinding> fixPath(List<IVariableBinding> arrayList) {
        if (arrayList.get(0) == OuterReferenceResolver.OUTER_PARAMETER) {
            assert (this.outerParam != null);
            arrayList = Lists.newArrayList(arrayList);
            arrayList.set(0, this.outerParam);
        }
        return arrayList;
    }
}

