/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.gen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.devtools.j2objc.J2ObjC;
import com.google.devtools.j2objc.Options;
import com.google.devtools.j2objc.gen.ObjectiveCSourceFileGenerator;
import com.google.devtools.j2objc.types.HeaderImportCollector;
import com.google.devtools.j2objc.types.IOSMethod;
import com.google.devtools.j2objc.types.Import;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.BindingUtil;
import com.google.devtools.j2objc.util.NameTable;
import com.google.devtools.j2objc.util.UnicodeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class ObjectiveCHeaderGenerator
extends ObjectiveCSourceFileGenerator {
    private static final String DEPRECATED_ATTRIBUTE = "__attribute__((deprecated))";
    protected final String mainTypeName;
    private static final Set<String> NEEDS_INC_AND_DEC = ImmutableSet.of((Object)"int", (Object)"long", (Object)"double", (Object)"float", (Object)"short", (Object)"byte", (Object[])new String[]{"char"});

    public static void generate(String string, String string2, CompilationUnit compilationUnit) {
        ObjectiveCHeaderGenerator objectiveCHeaderGenerator = new ObjectiveCHeaderGenerator(string, string2, compilationUnit);
        objectiveCHeaderGenerator.generate(compilationUnit);
    }

    protected ObjectiveCHeaderGenerator(String string, String string2, CompilationUnit compilationUnit) {
        super(string, string2, compilationUnit, false);
        this.mainTypeName = NameTable.getMainTypeName(compilationUnit, string);
    }

    @Override
    protected String getSuffix() {
        return ".h";
    }

    public void generate(CompilationUnit compilationUnit) {
        this.println(J2ObjC.getFileHeader(this.getSourceFileName()));
        this.generateFileHeader();
        for (AbstractTypeDeclaration abstractTypeDeclaration : ASTUtil.getTypes(compilationUnit)) {
            this.newline();
            this.generate(abstractTypeDeclaration);
        }
        this.generateFileFooter();
        this.save(compilationUnit);
    }

    private String getSuperTypeName(TypeDeclaration typeDeclaration) {
        Type type = typeDeclaration.getSuperclassType();
        if (type == null) {
            return "NSObject";
        }
        return NameTable.getFullName(Types.getTypeBinding(type));
    }

    @Override
    public void generate(TypeDeclaration typeDeclaration) {
        Object object;
        ITypeBinding iTypeBinding = Types.getTypeBinding(typeDeclaration);
        String string = NameTable.getFullName(iTypeBinding);
        String string2 = this.getSuperTypeName(typeDeclaration);
        ArrayList arrayList = Lists.newArrayList((Object[])typeDeclaration.getFields());
        ArrayList arrayList2 = Lists.newArrayList((Object[])typeDeclaration.getMethods());
        boolean bl = typeDeclaration.isInterface();
        this.printConstantDefines((AbstractTypeDeclaration)typeDeclaration);
        if (this.needsDeprecatedAttribute(ASTUtil.getModifiers((BodyDeclaration)typeDeclaration))) {
            this.println(DEPRECATED_ATTRIBUTE);
        }
        if (bl) {
            this.printf("@protocol %s", string);
        } else {
            this.printf("@interface %s : %s", string, string2);
        }
        List<Type> list = ASTUtil.getSuperInterfaceTypes(typeDeclaration);
        if (!list.isEmpty()) {
            this.print(" < ");
            object = list.iterator();
            while (object.hasNext()) {
                this.print(NameTable.getFullName(Types.getTypeBinding(object.next())));
                if (!object.hasNext()) continue;
                this.print(", ");
            }
            this.print(bl ? ", NSObject, JavaObject >" : " >");
        } else if (bl) {
            this.print(" < NSObject, JavaObject >");
        }
        if (bl) {
            this.newline();
        } else {
            this.println(" {");
            this.printInstanceVariables(arrayList);
            this.println("}\n");
            this.printStaticFieldAccessors(arrayList, arrayList2, bl);
        }
        this.printMethods(arrayList2);
        this.println("@end");
        if (!bl) {
            this.printFieldSetters(iTypeBinding, arrayList);
        }
        if (bl) {
            this.printStaticInterface(string, arrayList, arrayList2);
        }
        this.printIncrementAndDecrementFunctions(iTypeBinding);
        object = iTypeBinding.getPackage().getName();
        if (NameTable.hasPrefix((String)object) && iTypeBinding.isTopLevel()) {
            String string3 = NameTable.camelCaseQualifiedName(iTypeBinding.getQualifiedName());
            if (iTypeBinding.isInterface()) {
                this.printf("\n#define %s %s\n", string3, string);
            } else {
                this.printf("\ntypedef %s %s;\n", string, string3);
            }
        }
        this.printExternalNativeMethodCategory(typeDeclaration, string);
    }

    private void printIncrementAndDecrementFunctions(ITypeBinding iTypeBinding) {
        ITypeBinding iTypeBinding2 = Types.getPrimitiveType(iTypeBinding);
        if (iTypeBinding2 == null || !NEEDS_INC_AND_DEC.contains(iTypeBinding2.getName())) {
            return;
        }
        String string = iTypeBinding2.getName();
        String string2 = string + "Value";
        if (string.equals("long")) {
            string2 = "longLongValue";
        } else if (string.equals("byte")) {
            string2 = "charValue";
        }
        this.newline();
        this.printf("BOXED_INC_AND_DEC(%s, %s, %s)\n", NameTable.capitalize(string), string2, NameTable.getFullName(iTypeBinding));
    }

    @Override
    protected void generate(AnnotationTypeDeclaration annotationTypeDeclaration) {
        String string = NameTable.getFullName((AbstractTypeDeclaration)annotationTypeDeclaration);
        ArrayList arrayList = Lists.newArrayList();
        for (BodyDeclaration object2 : ASTUtil.getBodyDeclarations((AbstractTypeDeclaration)annotationTypeDeclaration)) {
            if (!(object2 instanceof AnnotationTypeMemberDeclaration)) continue;
            arrayList.add((AnnotationTypeMemberDeclaration)object2);
        }
        this.printConstantDefines((AbstractTypeDeclaration)annotationTypeDeclaration);
        boolean bl = BindingUtil.isRuntimeAnnotation(Types.getTypeBinding(annotationTypeDeclaration));
        this.printf("@protocol %s < JavaLangAnnotationAnnotation >\n", string);
        if (!arrayList.isEmpty() && bl) {
            this.newline();
            this.printAnnotationProperties(arrayList);
        }
        this.println("@end\n");
        List<IVariableBinding> list = this.getStaticFieldsNeedingAccessors(ASTUtil.getFieldDeclarations((AbstractTypeDeclaration)annotationTypeDeclaration), true);
        if (bl || !list.isEmpty()) {
            this.printf("@interface %s : NSObject < %s >", string, string);
            if (bl) {
                if (arrayList.isEmpty()) {
                    this.newline();
                } else {
                    this.println(" {\n @private");
                    this.printAnnotationVariables(arrayList);
                    this.println("}\n");
                }
                this.printAnnotationConstructor(Types.getTypeBinding(annotationTypeDeclaration));
                this.printAnnotationAccessors(arrayList);
            } else {
                this.newline();
                this.newline();
            }
            this.printStaticFieldAccessors(list, Collections.<MethodDeclaration>emptyList());
            this.println("@end");
        }
    }

    private void printExternalNativeMethodCategory(TypeDeclaration typeDeclaration, String string) {
        final ArrayList arrayList = Lists.newArrayList();
        typeDeclaration.accept(new ASTVisitor(){

            public void endVisit(MethodDeclaration methodDeclaration) {
                if ((methodDeclaration.getModifiers() & 0x100) > 0 && !ObjectiveCHeaderGenerator.this.hasNativeCode(methodDeclaration)) {
                    arrayList.add(methodDeclaration);
                }
            }
        });
        if (!arrayList.isEmpty()) {
            this.printf("\n@interface %s (NativeMethods)\n", string);
            for (MethodDeclaration methodDeclaration : arrayList) {
                this.print(super.methodDeclaration(methodDeclaration));
                this.println(";");
            }
            this.println("@end");
        }
    }

    private void printStaticInterface(String string, List<FieldDeclaration> list, List<MethodDeclaration> list2) {
        List<IVariableBinding> list3 = this.getStaticFieldsNeedingAccessors(list, true);
        if (list3.isEmpty()) {
            return;
        }
        this.printf("\n@interface %s : NSObject {\n}\n", string);
        this.printStaticFieldAccessors(list3, list2);
        this.println("@end");
    }

    @Override
    protected void generate(EnumDeclaration enumDeclaration) {
        Object object;
        this.printConstantDefines((AbstractTypeDeclaration)enumDeclaration);
        String string = NameTable.getFullName((AbstractTypeDeclaration)enumDeclaration);
        List<EnumConstantDeclaration> list = ASTUtil.getEnumConstants(enumDeclaration);
        if (!list.isEmpty()) {
            this.println("typedef enum {");
            object = string.endsWith("Enum") ? string.substring(0, string.length() - 4) : string;
            this.indent();
            int n = 0;
            for (EnumConstantDeclaration object2 : list) {
                this.printIndent();
                this.printf("%s_%s = %d,\n", object, object2.getName().getIdentifier(), n++);
            }
            this.unindent();
            this.printf("} %s;\n\n", object);
        }
        object = Lists.newArrayList();
        ArrayList arrayList = Lists.newArrayList();
        for (Object e : enumDeclaration.bodyDeclarations()) {
            if (e instanceof FieldDeclaration) {
                object.add((FieldDeclaration)e);
                continue;
            }
            if (!(e instanceof MethodDeclaration)) continue;
            arrayList.add((MethodDeclaration)e);
        }
        if (this.needsDeprecatedAttribute(ASTUtil.getModifiers((BodyDeclaration)enumDeclaration))) {
            this.println(DEPRECATED_ATTRIBUTE);
        }
        this.printf("@interface %s : JavaLangEnum < NSCopying", string);
        Iterator<Object> iterator = Types.getTypeBinding(enumDeclaration);
        for (ITypeBinding iTypeBinding : iterator.getInterfaces()) {
            if (iTypeBinding.getName().equals("Cloneable")) continue;
            this.printf(", %s", NameTable.getFullName(iTypeBinding));
        }
        this.println(" > {");
        this.printInstanceVariables((List<FieldDeclaration>)object);
        this.println("}");
        for (EnumConstantDeclaration enumConstantDeclaration : list) {
            this.printf("+ (%s *)%s;\n", string, NameTable.getName(enumConstantDeclaration.getName()));
        }
        this.println("+ (IOSObjectArray *)values;");
        this.printf("+ (%s *)valueOfWithNSString:(NSString *)name;\n", string);
        this.println("- (id)copyWithZone:(NSZone *)zone;");
        this.printStaticFieldAccessors((List<FieldDeclaration>)object, arrayList, false);
        this.printMethods(arrayList);
        this.println("@end");
        this.printFieldSetters((ITypeBinding)iterator, (List<FieldDeclaration>)object);
    }

    @Override
    protected void printStaticFieldGetter(IVariableBinding iVariableBinding) {
        if (!BindingUtil.isPrivate((IBinding)iVariableBinding)) {
            this.printf(this.staticFieldGetterSignature(iVariableBinding) + ";\n", new Object[0]);
        }
    }

    @Override
    protected void printStaticFieldReferenceGetter(IVariableBinding iVariableBinding) {
        this.printf(this.staticFieldReferenceGetterSignature(iVariableBinding) + ";\n", new Object[0]);
    }

    @Override
    protected void printStaticFieldSetter(IVariableBinding iVariableBinding) {
        if (!BindingUtil.isPrivate((IBinding)iVariableBinding)) {
            this.printf(this.staticFieldSetterSignature(iVariableBinding) + ";\n", new Object[0]);
        }
    }

    @Override
    protected String methodDeclaration(MethodDeclaration methodDeclaration) {
        if ((methodDeclaration.getModifiers() & 0x100) > 0 && !this.hasNativeCode(methodDeclaration)) {
            return "";
        }
        String string = super.methodDeclaration(methodDeclaration);
        String string2 = NameTable.getName((IBinding)Types.getMethodBinding(methodDeclaration));
        if (string2.startsWith("new") || string2.startsWith("copy") || string2.startsWith("alloc") || string2.startsWith("init")) {
            string = string + " OBJC_METHOD_FAMILY_NONE";
        }
        if (this.needsDeprecatedAttribute(ASTUtil.getModifiers((BodyDeclaration)methodDeclaration))) {
            string = string + " __attribute__((deprecated))";
        }
        return string + ";\n";
    }

    @Override
    protected String mappedMethodDeclaration(MethodDeclaration methodDeclaration, IOSMethod iOSMethod) {
        return super.mappedMethodDeclaration(methodDeclaration, iOSMethod) + ";\n";
    }

    @Override
    protected String constructorDeclaration(MethodDeclaration methodDeclaration) {
        return super.constructorDeclaration(methodDeclaration) + ";\n";
    }

    @Override
    protected void printStaticConstructorDeclaration(MethodDeclaration methodDeclaration) {
    }

    @Override
    protected void printNormalMethod(MethodDeclaration methodDeclaration) {
        IMethodBinding iMethodBinding = Types.getMethodBinding(methodDeclaration);
        if (!iMethodBinding.isSynthetic()) {
            super.printNormalMethod(methodDeclaration);
        }
    }

    protected void printForwardDeclarations(Set<Import> set) {
        TreeSet treeSet = Sets.newTreeSet();
        for (Import object : set) {
            treeSet.add(this.createForwardDeclaration(object.getTypeName(), object.isInterface()));
        }
        if (!treeSet.isEmpty()) {
            for (String string : treeSet) {
                this.println(string);
            }
            this.newline();
        }
    }

    protected void generateFileHeader() {
        this.printf("#ifndef _%s_H_\n", this.mainTypeName);
        this.printf("#define _%s_H_\n", this.mainTypeName);
        this.pushIgnoreDeprecatedDeclarationsPragma();
        this.newline();
        HeaderImportCollector headerImportCollector = new HeaderImportCollector();
        headerImportCollector.collect((ASTNode)this.getUnit());
        this.printForwardDeclarations(headerImportCollector.getForwardDeclarations());
        this.println("#import \"JreEmulation.h\"");
        Set<Import> set = headerImportCollector.getSuperTypes();
        if (!set.isEmpty()) {
            TreeSet treeSet = Sets.newTreeSet();
            for (Import object : set) {
                treeSet.add(String.format("#include \"%s.h\"", object.getImportFileName()));
            }
            for (String string : treeSet) {
                this.println(string);
            }
        }
    }

    protected String createForwardDeclaration(String string, boolean bl) {
        return String.format("@%s %s;", bl ? "protocol" : "class", string);
    }

    protected void generateFileFooter() {
        this.newline();
        this.popIgnoreDeprecatedDeclarationsPragma();
        this.printf("#endif // _%s_H_\n", this.mainTypeName);
    }

    private void printInstanceVariables(List<FieldDeclaration> list) {
        this.indent();
        boolean bl = true;
        for (FieldDeclaration fieldDeclaration : list) {
            boolean bl2;
            if ((fieldDeclaration.getModifiers() & 8) != 0) continue;
            List<VariableDeclarationFragment> list2 = ASTUtil.getFragments(fieldDeclaration);
            assert (!list2.isEmpty());
            VariableDeclarationFragment variableDeclarationFragment = list2.get(0);
            if (bl) {
                this.println(" @public");
                bl = false;
            }
            this.printIndent();
            if (BindingUtil.isWeakReference(Types.getVariableBinding(variableDeclarationFragment))) {
                this.print("__weak ");
            }
            ITypeBinding iTypeBinding = Types.getTypeBinding(list2.get(0));
            String string = NameTable.getSpecificObjCType(iTypeBinding);
            boolean bl3 = bl2 = !iTypeBinding.isPrimitive() && !string.matches("id|id<.*>|Class");
            if (bl2 && string.endsWith(" *")) {
                string = string.substring(0, string.length() - 2);
            }
            this.print(string);
            this.print(' ');
            Iterator iterator = fieldDeclaration.fragments().iterator();
            while (iterator.hasNext()) {
                VariableDeclarationFragment variableDeclarationFragment2 = (VariableDeclarationFragment)iterator.next();
                if (bl2) {
                    this.print('*');
                }
                String string2 = NameTable.getName(variableDeclarationFragment2.getName());
                this.print(NameTable.javaFieldToObjC(string2));
                if (!iterator.hasNext()) continue;
                this.print(", ");
            }
            this.println(";");
        }
        this.unindent();
    }

    private void printAnnotationVariables(List<AnnotationTypeMemberDeclaration> list) {
        this.indent();
        for (AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration : list) {
            this.printIndent();
            ITypeBinding iTypeBinding = Types.getTypeBinding(annotationTypeMemberDeclaration);
            this.print(NameTable.getObjCType(iTypeBinding));
            if (iTypeBinding.isPrimitive() || iTypeBinding.isInterface()) {
                this.print(' ');
            }
            this.print(annotationTypeMemberDeclaration.getName().getIdentifier());
            this.println(";");
        }
        this.unindent();
    }

    private void printAnnotationConstructor(ITypeBinding iTypeBinding) {
        if (iTypeBinding.getDeclaredMethods().length > 0) {
            this.print(this.annotationConstructorDeclaration(iTypeBinding));
            this.println(";\n");
        }
    }

    private void printFieldSetters(ITypeBinding iTypeBinding, List<FieldDeclaration> list) {
        boolean bl = false;
        for (FieldDeclaration fieldDeclaration : list) {
            ITypeBinding iTypeBinding2 = Types.getTypeBinding(fieldDeclaration.getType());
            int n = fieldDeclaration.getModifiers();
            if (Modifier.isStatic((int)n) || iTypeBinding2.isPrimitive()) continue;
            String string = NameTable.getObjCType(iTypeBinding2);
            String string2 = NameTable.getFullName(iTypeBinding);
            for (VariableDeclarationFragment variableDeclarationFragment : ASTUtil.getFragments(fieldDeclaration)) {
                IVariableBinding iVariableBinding = Types.getVariableBinding(variableDeclarationFragment);
                if (BindingUtil.isWeakReference(iVariableBinding)) continue;
                String string3 = NameTable.javaFieldToObjC(NameTable.getName(variableDeclarationFragment.getName()));
                if (!bl) {
                    bl = true;
                    this.newline();
                }
                this.println(String.format("J2OBJC_FIELD_SETTER(%s, %s, %s)", string2, string3, string));
            }
        }
    }

    private void printAnnotationProperties(List<AnnotationTypeMemberDeclaration> list) {
        int n = 0;
        for (AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration : list) {
            ITypeBinding iTypeBinding = Types.getTypeBinding(annotationTypeMemberDeclaration.getType());
            this.print("@property (readonly) ");
            String string = NameTable.getSpecificObjCType(iTypeBinding);
            String string2 = NameTable.getName(annotationTypeMemberDeclaration.getName());
            this.println(String.format("%s%s%s;", string, string.endsWith("*") ? "" : " ", string2));
            if (string2.startsWith("new") || string2.startsWith("copy") || string2.startsWith("alloc") || string2.startsWith("init")) {
                this.println(String.format("- (%s)%s OBJC_METHOD_FAMILY_NONE;", string, string2));
            }
            ++n;
        }
        if (n > 0) {
            this.newline();
        }
    }

    private void printAnnotationAccessors(List<AnnotationTypeMemberDeclaration> list) {
        int n = 0;
        for (AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration : list) {
            if (annotationTypeMemberDeclaration.getDefault() == null) continue;
            ITypeBinding iTypeBinding = Types.getTypeBinding(annotationTypeMemberDeclaration.getType());
            String string = NameTable.getSpecificObjCType(iTypeBinding);
            String string2 = NameTable.getName(annotationTypeMemberDeclaration.getName());
            this.printf("+ (%s)%sDefault;\n", string, string2);
            ++n;
        }
        if (n > 0) {
            this.newline();
        }
    }

    private void printConstantDefines(AbstractTypeDeclaration abstractTypeDeclaration) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(abstractTypeDeclaration);
        boolean bl = false;
        for (IVariableBinding iVariableBinding : iTypeBinding.getDeclaredFields()) {
            if (!BindingUtil.isPrimitiveConstant(iVariableBinding)) continue;
            this.printf("#define %s ", NameTable.getPrimitiveConstantName(iVariableBinding));
            Object object = iVariableBinding.getConstantValue();
            assert (object != null);
            if (object instanceof Boolean) {
                this.println((Boolean)object != false ? "TRUE" : "FALSE");
            } else if (object instanceof Character) {
                this.println(UnicodeUtils.escapeCharLiteral(((Character)object).charValue()));
            } else if (object instanceof Long) {
                long l = (Long)object;
                if (l == Long.MIN_VALUE) {
                    this.println("((long long) 0x8000000000000000LL)");
                } else {
                    this.println(object.toString() + "LL");
                }
            } else if (object instanceof Integer) {
                long l = ((Integer)object).intValue();
                if (l == Integer.MIN_VALUE) {
                    this.println("((int) 0x80000000)");
                } else {
                    this.println(object.toString());
                }
            } else if (object instanceof Float) {
                float f = ((Float)object).floatValue();
                if (Float.isNaN(f)) {
                    this.println("NAN");
                } else if (f == Float.POSITIVE_INFINITY) {
                    this.println("INFINITY");
                } else if (f == Float.NEGATIVE_INFINITY) {
                    this.println("-INFINITY");
                } else if (f == Float.MAX_VALUE) {
                    this.println("__FLT_MAX__");
                } else if (f == Float.MIN_VALUE) {
                    this.println("__FLT_MIN__");
                } else {
                    this.println(object.toString());
                }
            } else if (object instanceof Double) {
                double d = (Double)object;
                if (Double.isNaN(d)) {
                    this.println("NAN");
                } else if (d == Double.POSITIVE_INFINITY) {
                    this.println("INFINITY");
                } else if (d == Double.NEGATIVE_INFINITY) {
                    this.println("-INFINITY");
                } else if (d == Double.MAX_VALUE) {
                    this.println("__DBL_MAX__");
                } else if (d == Double.MIN_VALUE) {
                    this.println("__DBL_MIN__");
                } else {
                    this.println(object.toString());
                }
            } else {
                this.println(object.toString());
            }
            bl = true;
        }
        if (bl) {
            this.newline();
        }
    }

    private boolean needsDeprecatedAttribute(List<IExtendedModifier> list) {
        return Options.generateDeprecatedDeclarations() && this.hasDeprecated(list);
    }

    boolean hasDeprecated(List<IExtendedModifier> list) {
        for (IExtendedModifier iExtendedModifier : list) {
            Annotation annotation;
            Name name;
            String string;
            if (!iExtendedModifier.isAnnotation() || !(string = (name = (annotation = (Annotation)iExtendedModifier).getTypeName()).isQualifiedName() ? "java.lang.Deprecated" : "Deprecated").equals(name.getFullyQualifiedName())) continue;
            return true;
        }
        return false;
    }
}

