/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.types;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.devtools.j2objc.J2ObjC;
import com.google.devtools.j2objc.Options;
import com.google.devtools.j2objc.types.BindingMapBuilder;
import com.google.devtools.j2objc.types.BindingMapVerifier;
import com.google.devtools.j2objc.types.GeneratedMethodBinding;
import com.google.devtools.j2objc.types.IOSTypeBinding;
import com.google.devtools.j2objc.types.RenamedTypeBinding;
import com.google.devtools.j2objc.util.BindingUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;

public class Types {
    private final AST ast;
    private final Map<Object, IBinding> bindingMap;
    private final Map<ITypeBinding, ITypeBinding> typeMap = Maps.newHashMap();
    private final Map<ITypeBinding, ITypeBinding> renamedTypeMap = Maps.newHashMap();
    private final Map<ITypeBinding, ITypeBinding> primitiveToWrapperTypes = new HashMap<ITypeBinding, ITypeBinding>();
    private final Map<ITypeBinding, ITypeBinding> wrapperToPrimitiveTypes = new HashMap<ITypeBinding, ITypeBinding>();
    private final List<IVariableBinding> releaseableFields = Lists.newArrayList();
    private final ITypeBinding javaObjectType;
    private final ITypeBinding javaClassType;
    private final ITypeBinding javaCloneableType;
    private final ITypeBinding javaNumberType;
    private final ITypeBinding javaStringType;
    private final ITypeBinding javaVoidType;
    private final ITypeBinding voidType;
    private final ITypeBinding booleanType;
    private static Types instance;
    private final IOSTypeBinding NSCopying;
    private final IOSTypeBinding NSObject;
    private final IOSTypeBinding NSNumber;
    private final IOSTypeBinding NSString;
    private final IOSTypeBinding IOSClass;
    private IOSTypeBinding IOSObjectArray;
    private final Map<String, ITypeBinding> javaBindingMap = Maps.newHashMap();
    private final Map<String, ITypeBinding> iosBindingMap = Maps.newHashMap();
    private final Map<ITypeBinding, IOSTypeBinding> arrayBindingMap = Maps.newHashMap();
    private final Set<Block> autoreleasePoolBlocks = Sets.newHashSet();
    private final Set<Expression> nilChecks = Sets.newHashSet();
    private final Set<Expression> deferredFieldSetters = Sets.newHashSet();
    public static final String EMPTY_PARAMETER_NAME = "__empty_parameter__";

    private Types(CompilationUnit compilationUnit) {
        this.ast = compilationUnit.getAST();
        this.javaObjectType = this.ast.resolveWellKnownType("java.lang.Object");
        this.javaClassType = this.ast.resolveWellKnownType("java.lang.Class");
        this.javaCloneableType = this.ast.resolveWellKnownType("java.lang.Cloneable");
        this.javaStringType = this.ast.resolveWellKnownType("java.lang.String");
        this.javaVoidType = this.ast.resolveWellKnownType("java.lang.Void");
        this.voidType = this.ast.resolveWellKnownType("void");
        this.booleanType = this.ast.resolveWellKnownType("boolean");
        ITypeBinding iTypeBinding = this.ast.resolveWellKnownType("java.lang.Integer");
        this.javaNumberType = iTypeBinding.getSuperclass();
        this.NSCopying = this.mapIOSType(IOSTypeBinding.newInterface("NSCopying", this.javaCloneableType));
        this.NSObject = this.mapIOSType(IOSTypeBinding.newClass("NSObject", this.javaObjectType));
        this.NSNumber = this.mapIOSType(IOSTypeBinding.newClass("NSNumber", this.javaNumberType, this.NSObject));
        this.NSString = this.mapIOSType(IOSTypeBinding.newClass("NSString", this.javaStringType, this.NSObject));
        this.IOSClass = this.mapIOSType(IOSTypeBinding.newUnmappedClass("IOSClass"));
        this.mapIOSType(IOSTypeBinding.newUnmappedClass("id"));
        this.mapIOSType(IOSTypeBinding.newUnmappedClass("NSZone"));
        this.initializeArrayTypes();
        this.initializeTypeMap();
        this.initializeCommonJavaTypes();
        this.populatePrimitiveAndWrapperTypeMaps();
        this.bindingMap = BindingMapBuilder.buildBindingMap(compilationUnit);
    }

    private IOSTypeBinding mapIOSType(IOSTypeBinding iOSTypeBinding) {
        this.iosBindingMap.put(iOSTypeBinding.getName(), iOSTypeBinding);
        return iOSTypeBinding;
    }

    private void initializeArrayTypes() {
        this.initializePrimitiveArray("boolean", "IOSBooleanArray");
        this.initializePrimitiveArray("byte", "IOSByteArray");
        this.initializePrimitiveArray("char", "IOSCharArray");
        this.initializePrimitiveArray("double", "IOSDoubleArray");
        this.initializePrimitiveArray("float", "IOSFloatArray");
        this.initializePrimitiveArray("int", "IOSIntArray");
        this.initializePrimitiveArray("long", "IOSLongArray");
        this.initializePrimitiveArray("short", "IOSShortArray");
        this.IOSObjectArray = this.mapIOSType(IOSTypeBinding.newUnmappedClass("IOSObjectArray"));
    }

    private void initializeTypeMap() {
        this.typeMap.put(this.javaObjectType, this.NSObject);
        this.typeMap.put(this.javaClassType, this.IOSClass);
        this.typeMap.put(this.javaCloneableType, this.NSCopying);
        this.typeMap.put(this.javaStringType, this.NSString);
        this.typeMap.put(this.javaNumberType, this.NSNumber);
    }

    private void initializeCommonJavaTypes() {
        ITypeBinding iTypeBinding = BindingUtil.findInterface(this.javaStringType, "java.lang.CharSequence");
        this.javaBindingMap.put("java.lang.CharSequence", iTypeBinding);
        this.iosBindingMap.put("JavaLangCharSequence", iTypeBinding);
        this.javaBindingMap.put("java.lang.Number", this.javaNumberType);
    }

    private void initializePrimitiveArray(String string, String string2) {
        ITypeBinding iTypeBinding = this.ast.resolveWellKnownType(string);
        IOSTypeBinding iOSTypeBinding = this.mapIOSType(IOSTypeBinding.newUnmappedClass(string2));
        this.arrayBindingMap.put(iTypeBinding, iOSTypeBinding);
    }

    private void populatePrimitiveAndWrapperTypeMaps() {
        this.loadPrimitiveAndWrapperTypes("boolean", "java.lang.Boolean");
        this.loadPrimitiveAndWrapperTypes("byte", "java.lang.Byte");
        this.loadPrimitiveAndWrapperTypes("char", "java.lang.Character");
        this.loadPrimitiveAndWrapperTypes("short", "java.lang.Short");
        this.loadPrimitiveAndWrapperTypes("int", "java.lang.Integer");
        this.loadPrimitiveAndWrapperTypes("long", "java.lang.Long");
        this.loadPrimitiveAndWrapperTypes("float", "java.lang.Float");
        this.loadPrimitiveAndWrapperTypes("double", "java.lang.Double");
        this.loadPrimitiveAndWrapperTypes("void", "java.lang.Void");
    }

    private void loadPrimitiveAndWrapperTypes(String string, String string2) {
        ITypeBinding iTypeBinding = this.ast.resolveWellKnownType(string);
        ITypeBinding iTypeBinding2 = this.ast.resolveWellKnownType(string2);
        this.primitiveToWrapperTypes.put(iTypeBinding, iTypeBinding2);
        this.wrapperToPrimitiveTypes.put(iTypeBinding2, iTypeBinding);
    }

    public static void initialize(CompilationUnit compilationUnit) {
        instance = new Types(compilationUnit);
    }

    public static void cleanup() {
        instance = null;
    }

    public static ITypeBinding mapType(ITypeBinding iTypeBinding) {
        if (iTypeBinding == null) {
            return null;
        }
        if (iTypeBinding.isArray()) {
            return Types.resolveArrayType(iTypeBinding.getComponentType());
        }
        ITypeBinding iTypeBinding2 = Types.instance.typeMap.get(iTypeBinding);
        if (iTypeBinding2 == null && iTypeBinding.isAssignmentCompatible(Types.instance.javaClassType)) {
            iTypeBinding2 = Types.instance.typeMap.get(Types.instance.javaClassType);
        }
        return iTypeBinding2 != null ? iTypeBinding2 : iTypeBinding;
    }

    public static ITypeBinding mapTypeName(String string) {
        ITypeBinding iTypeBinding = Types.instance.ast.resolveWellKnownType(string);
        return Types.mapType(iTypeBinding);
    }

    public static boolean hasIOSEquivalent(ITypeBinding iTypeBinding) {
        return iTypeBinding.isArray() || Types.instance.typeMap.containsKey(iTypeBinding.getTypeDeclaration());
    }

    public static ITypeBinding resolveJavaType(String string) {
        ITypeBinding iTypeBinding = Types.instance.javaBindingMap.get(string);
        if (iTypeBinding == null) {
            iTypeBinding = Types.instance.ast.resolveWellKnownType(string);
        }
        return iTypeBinding;
    }

    public static ITypeBinding resolveIOSType(String string) {
        return Types.instance.iosBindingMap.get(string);
    }

    public static boolean isJavaObjectType(ITypeBinding iTypeBinding) {
        return Types.instance.javaObjectType.equals(iTypeBinding);
    }

    public static boolean isJavaStringType(ITypeBinding iTypeBinding) {
        return Types.instance.javaStringType.equals(iTypeBinding);
    }

    public static boolean isFloatingPointType(ITypeBinding iTypeBinding) {
        return iTypeBinding.isEqualTo((IBinding)Types.instance.ast.resolveWellKnownType("double")) || iTypeBinding.isEqualTo((IBinding)Types.instance.ast.resolveWellKnownType("float")) || iTypeBinding == Types.instance.ast.resolveWellKnownType("java.lang.Double") || iTypeBinding == Types.instance.ast.resolveWellKnownType("java.lang.Float");
    }

    public static boolean isBooleanType(ITypeBinding iTypeBinding) {
        return iTypeBinding.isEqualTo((IBinding)Types.instance.booleanType) || iTypeBinding == Types.instance.ast.resolveWellKnownType("java.lang.Boolean");
    }

    public static boolean isLongType(ITypeBinding iTypeBinding) {
        return iTypeBinding.isEqualTo((IBinding)Types.instance.ast.resolveWellKnownType("long")) || iTypeBinding == Types.instance.ast.resolveWellKnownType("java.lang.Long");
    }

    public static ITypeBinding resolveIOSType(Type type) {
        if (type instanceof SimpleType) {
            String string = ((SimpleType)type).getName().getFullyQualifiedName();
            return Types.resolveIOSType(string);
        }
        return null;
    }

    public static IOSTypeBinding resolveArrayType(ITypeBinding iTypeBinding) {
        IOSTypeBinding iOSTypeBinding = Types.instance.arrayBindingMap.get(iTypeBinding);
        return iOSTypeBinding != null ? iOSTypeBinding : Types.instance.IOSObjectArray;
    }

    public static IBinding getBinding(Object object) {
        IBinding iBinding = Types.instance.bindingMap.get(object);
        assert (iBinding != null);
        return iBinding;
    }

    public static void addBinding(Object object, IBinding iBinding) {
        assert (iBinding != null);
        Types.instance.bindingMap.put(object, iBinding);
    }

    public static ITypeBinding getTypeBinding(Object object) {
        IBinding iBinding = Types.getBinding(object);
        if (iBinding instanceof ITypeBinding) {
            return (ITypeBinding)iBinding;
        }
        if (iBinding instanceof IMethodBinding) {
            IMethodBinding iMethodBinding = (IMethodBinding)iBinding;
            return iMethodBinding.isConstructor() ? iMethodBinding.getDeclaringClass() : iMethodBinding.getReturnType();
        }
        if (iBinding instanceof IVariableBinding) {
            return ((IVariableBinding)iBinding).getType();
        }
        if (iBinding instanceof IAnnotationBinding) {
            return ((IAnnotationBinding)iBinding).getAnnotationType();
        }
        return null;
    }

    public static IAnnotationBinding getAnnotationBinding(Object object) {
        IBinding iBinding = Types.getBinding(object);
        if (iBinding instanceof IAnnotationBinding) {
            return (IAnnotationBinding)iBinding;
        }
        return null;
    }

    public static IMethodBinding getMethodBinding(Object object) {
        IBinding iBinding = Types.getBinding(object);
        return iBinding instanceof IMethodBinding ? (IMethodBinding)iBinding : null;
    }

    public static GeneratedMethodBinding getGeneratedMethodBinding(Object object) {
        IMethodBinding iMethodBinding = Types.getMethodBinding(object);
        if (iMethodBinding == null) {
            return null;
        }
        GeneratedMethodBinding generatedMethodBinding = new GeneratedMethodBinding(iMethodBinding.getMethodDeclaration());
        Types.addBinding(object, generatedMethodBinding);
        return generatedMethodBinding;
    }

    public static IVariableBinding getVariableBinding(Object object) {
        IBinding iBinding = Types.getBinding(object);
        return iBinding instanceof IVariableBinding ? (IVariableBinding)iBinding : null;
    }

    public static void verifyNode(ASTNode aSTNode) {
        BindingMapVerifier.verify(aSTNode, Types.instance.bindingMap);
    }

    public static void verifyNodes(List<? extends ASTNode> list) {
        for (ASTNode aSTNode : list) {
            BindingMapVerifier.verify(aSTNode, Types.instance.bindingMap);
        }
    }

    public static ITypeBinding renameTypeBinding(String string, ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2) {
        ITypeBinding iTypeBinding3 = RenamedTypeBinding.rename(string, iTypeBinding, iTypeBinding2);
        Types.instance.renamedTypeMap.put(iTypeBinding2, iTypeBinding3);
        return iTypeBinding3;
    }

    public static ITypeBinding getRenamedBinding(ITypeBinding iTypeBinding) {
        return iTypeBinding != null && Types.instance.renamedTypeMap.containsKey(iTypeBinding) ? Types.instance.renamedTypeMap.get(iTypeBinding) : iTypeBinding;
    }

    public static boolean isVoidType(Type type) {
        return Types.isVoidType(Types.getTypeBinding(type));
    }

    public static boolean isVoidType(ITypeBinding iTypeBinding) {
        return iTypeBinding.isEqualTo((IBinding)Types.instance.voidType);
    }

    public static boolean isJavaVoidType(ITypeBinding iTypeBinding) {
        return iTypeBinding.isEqualTo((IBinding)Types.instance.javaVoidType);
    }

    public static void addReleaseableFields(Collection<IVariableBinding> collection) {
        for (IVariableBinding iVariableBinding : collection) {
            Types.instance.releaseableFields.add(iVariableBinding.getVariableDeclaration());
        }
    }

    public static boolean isReleaseableField(IVariableBinding iVariableBinding) {
        return iVariableBinding != null ? Types.instance.releaseableFields.contains(iVariableBinding.getVariableDeclaration()) : false;
    }

    public static ITypeBinding getWrapperType(ITypeBinding iTypeBinding) {
        return Types.instance.primitiveToWrapperTypes.get(iTypeBinding);
    }

    public static ITypeBinding getPrimitiveType(ITypeBinding iTypeBinding) {
        return Types.instance.wrapperToPrimitiveTypes.get(iTypeBinding);
    }

    public static boolean isBoxedPrimitive(ITypeBinding iTypeBinding) {
        return Types.instance.wrapperToPrimitiveTypes.containsKey(iTypeBinding);
    }

    public static ITypeBinding getNSNumber() {
        return Types.instance.NSNumber;
    }

    public static ITypeBinding getNSObject() {
        return Types.instance.NSObject;
    }

    public static ITypeBinding getNSString() {
        return Types.instance.NSString;
    }

    public static ITypeBinding getIOSClass() {
        return Types.instance.IOSClass;
    }

    public static void addAutoreleasePool(Block block) {
        if (Options.useGC()) {
            J2ObjC.warning((ASTNode)block, "@AutoreleasePool ignored in GC mode");
        }
        Types.instance.autoreleasePoolBlocks.add(block);
    }

    public static boolean hasAutoreleasePool(Block block) {
        return Types.instance.autoreleasePoolBlocks.contains(block);
    }

    public static void addNilCheck(Expression expression) {
        Types.instance.nilChecks.add(expression);
    }

    public static boolean hasNilCheck(Expression expression) {
        return Types.instance.nilChecks.contains(expression);
    }

    public static void addDeferredFieldSetter(Expression expression) {
        Types.instance.deferredFieldSetters.add(expression);
    }

    public static boolean hasDeferredFieldSetter(Expression expression) {
        return Types.instance.deferredFieldSetters.contains(expression);
    }
}

