/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.types;

import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class ModifiedTypeBinding
implements InvocationHandler {
    ITypeBinding original;
    ITypeBinding superclass;
    ITypeBinding[] interfaces;

    public static ITypeBinding bind(TypeDeclaration typeDeclaration) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(typeDeclaration);
        Type type = typeDeclaration.getSuperclassType();
        ITypeBinding iTypeBinding2 = type != null ? Types.getTypeBinding(type) : null;
        List<Type> list = ASTUtil.getSuperInterfaceTypes(typeDeclaration);
        ITypeBinding[] iTypeBindingArray = new ITypeBinding[list.size()];
        for (int i = 0; i < iTypeBindingArray.length; ++i) {
            iTypeBindingArray[i] = Types.getTypeBinding(list.get(i));
        }
        Class<?> clazz = iTypeBinding.getClass();
        return (ITypeBinding)Proxy.newProxyInstance(clazz.getClassLoader(), clazz.getInterfaces(), (InvocationHandler)new ModifiedTypeBinding(iTypeBinding, iTypeBinding2, iTypeBindingArray));
    }

    private ModifiedTypeBinding(ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2, ITypeBinding[] iTypeBindingArray) {
        this.original = iTypeBinding;
        this.superclass = iTypeBinding2;
        this.interfaces = iTypeBindingArray;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string = method.getName();
        if (string.equals("getSuperclass")) {
            return this.superclass;
        }
        if (string.equals("getInterfaces")) {
            return this.interfaces;
        }
        return method.invoke((Object)this.original, objectArray);
    }
}

