/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.types;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class IOSParameter {
    private final String name;
    private final String type;
    private final int index;
    private final boolean isVarArgs;
    static final Splitter IOS_PARAMETER_SPLITTER = Splitter.on((Pattern)Pattern.compile("(:|\\(|\\)|\\{|\\})")).omitEmptyStrings().trimResults();

    public IOSParameter(String string, int n) {
        if (string.equals("...")) {
            this.name = "values";
            this.type = null;
            this.index = 1;
            this.isVarArgs = true;
        } else {
            ArrayList arrayList = Lists.newArrayList((Iterable)IOS_PARAMETER_SPLITTER.split((CharSequence)string));
            assert (arrayList.size() == 3) : "bad iOS method description: " + string;
            this.name = (String)arrayList.get(0);
            this.type = (String)arrayList.get(1);
            this.index = n;
            this.isVarArgs = false;
        }
    }

    public String getParameterName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isVarArgs() {
        return this.isVarArgs;
    }
}

