/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.devtools.j2objc.J2ObjC;
import com.google.devtools.j2objc.translate.ASTFactory;
import com.google.devtools.j2objc.types.GeneratedMethodBinding;
import com.google.devtools.j2objc.types.GeneratedTypeBinding;
import com.google.devtools.j2objc.types.GeneratedVariableBinding;
import com.google.devtools.j2objc.types.IOSTypeBinding;
import com.google.devtools.j2objc.types.NodeCopier;
import com.google.devtools.j2objc.types.PointerTypeBinding;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.BindingUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import com.google.devtools.j2objc.util.NameTable;
import com.google.j2objc.annotations.AutoreleasePool;
import com.google.j2objc.annotations.LoopTranslation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;

public class Rewriter
extends ErrorReportingASTVisitor {
    private static final List<String> typeQualifierKeywords = Lists.newArrayList((Object[])new String[]{"in", "out", "inout", "oneway", "bycopy", "byref"});

    public boolean visit(TypeDeclaration typeDeclaration) {
        return this.visitType(typeDeclaration.getAST(), Types.getTypeBinding(typeDeclaration), ASTUtil.getBodyDeclarations((AbstractTypeDeclaration)typeDeclaration), typeDeclaration.getModifiers());
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        return this.visitType(enumDeclaration.getAST(), Types.getTypeBinding(enumDeclaration), ASTUtil.getBodyDeclarations((AbstractTypeDeclaration)enumDeclaration), enumDeclaration.getModifiers());
    }

    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
        return this.visitType(anonymousClassDeclaration.getAST(), Types.getTypeBinding(anonymousClassDeclaration), ASTUtil.getBodyDeclarations(anonymousClassDeclaration), 0);
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        return this.visitType(annotationTypeDeclaration.getAST(), Types.getTypeBinding(annotationTypeDeclaration), ASTUtil.getBodyDeclarations((AbstractTypeDeclaration)annotationTypeDeclaration), annotationTypeDeclaration.getModifiers());
    }

    private boolean visitType(AST aST, ITypeBinding iTypeBinding, List<BodyDeclaration> list, int n) {
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getInterfaces();
        if (iTypeBindingArray.length > 0) {
            if (Modifier.isAbstract((int)n) || iTypeBinding.isEnum()) {
                for (ITypeBinding iTypeBinding2 : iTypeBindingArray) {
                    LinkedList<ITypeBinding> linkedList = new LinkedList<ITypeBinding>();
                    LinkedHashSet<IMethodBinding> linkedHashSet = new LinkedHashSet<IMethodBinding>();
                    linkedList.add(iTypeBinding2);
                    while ((iTypeBinding2 = (ITypeBinding)linkedList.poll()) != null) {
                        linkedHashSet.addAll(Arrays.asList(iTypeBinding2.getDeclaredMethods()));
                        linkedList.addAll(Arrays.asList(iTypeBinding2.getInterfaces()));
                    }
                    this.addMissingMethods(aST, iTypeBinding, linkedHashSet, list);
                }
            } else if (!iTypeBinding.isInterface()) {
                LinkedHashSet<IMethodBinding> linkedHashSet = new LinkedHashSet<IMethodBinding>();
                for (ITypeBinding iTypeBinding3 : iTypeBindingArray) {
                    linkedHashSet.addAll(Arrays.asList(iTypeBinding3.getDeclaredMethods()));
                }
                this.addForwardingMethods(aST, iTypeBinding, linkedHashSet, list);
            }
        }
        this.renameDuplicateMembers(iTypeBinding);
        return true;
    }

    private void addMissingMethods(AST aST, ITypeBinding iTypeBinding, Set<IMethodBinding> set, List<BodyDeclaration> list) {
        for (IMethodBinding iMethodBinding : set) {
            if (this.isMethodImplemented(iTypeBinding, iMethodBinding, list)) continue;
            this.addAbstractMethod(aST, iTypeBinding, iMethodBinding, list);
        }
    }

    private void addForwardingMethods(AST aST, ITypeBinding iTypeBinding, Set<IMethodBinding> set, List<BodyDeclaration> list) {
        for (IMethodBinding iMethodBinding : set) {
            String string = iMethodBinding.getName();
            if (!string.matches("equals|hashCode|toString") || this.isMethodImplemented(iTypeBinding, iMethodBinding, list)) continue;
            this.addForwardingMethod(aST, iTypeBinding, iMethodBinding, list);
        }
    }

    private boolean isMethodImplemented(ITypeBinding iTypeBinding, IMethodBinding iMethodBinding, List<BodyDeclaration> list) {
        for (BodyDeclaration bodyDeclaration : list) {
            if (!(bodyDeclaration instanceof MethodDeclaration) || !Types.getMethodBinding(bodyDeclaration).isSubsignature(iMethodBinding)) continue;
            return true;
        }
        return this.isMethodImplemented(iTypeBinding.getSuperclass(), iMethodBinding);
    }

    private boolean isMethodImplemented(ITypeBinding iTypeBinding, IMethodBinding iMethodBinding) {
        if (iTypeBinding == null || iTypeBinding.getQualifiedName().equals("java.lang.Object")) {
            return false;
        }
        for (IMethodBinding iMethodBinding2 : iTypeBinding.getDeclaredMethods()) {
            if (!iMethodBinding.isSubsignature(iMethodBinding2) && (!iMethodBinding.getName().equals(iMethodBinding2.getName()) || !iMethodBinding.getReturnType().getErasure().isEqualTo((IBinding)iMethodBinding2.getReturnType().getErasure()) || !Arrays.equals(iMethodBinding.getParameterTypes(), iMethodBinding2.getParameterTypes()))) continue;
            return true;
        }
        return this.isMethodImplemented(iTypeBinding.getSuperclass(), iMethodBinding);
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        SingleVariableDeclaration singleVariableDeclaration;
        IMethodBinding iMethodBinding = Types.getMethodBinding(methodDeclaration);
        if (BindingUtil.hasAnnotation((IBinding)iMethodBinding, AutoreleasePool.class)) {
            if (!Types.isVoidType(iMethodBinding.getReturnType())) {
                J2ObjC.warning("Warning: Ignoring AutoreleasePool annotation on method with non-void return type");
            } else if (methodDeclaration.getBody() != null) {
                Types.addAutoreleasePool(methodDeclaration.getBody());
            }
        }
        String string = iMethodBinding.getName();
        this.renameReservedNames(string, iMethodBinding);
        this.handleCompareToMethod(methodDeclaration, iMethodBinding);
        List<SingleVariableDeclaration> list = ASTUtil.getParameters(methodDeclaration);
        for (int i = 0; i < list.size(); ++i) {
            singleVariableDeclaration = list.get(i);
            string = singleVariableDeclaration.getName().getIdentifier();
            if (!typeQualifierKeywords.contains(string)) continue;
            IVariableBinding iVariableBinding = Types.getVariableBinding(singleVariableDeclaration);
            NameTable.rename((IBinding)iVariableBinding, string + "Arg");
        }
        final HashMap hashMap = Maps.newHashMap();
        singleVariableDeclaration = methodDeclaration.getAST();
        methodDeclaration.accept(new ASTVisitor((AST)singleVariableDeclaration){
            final /* synthetic */ AST val$ast;
            {
                this.val$ast = aST;
            }

            public void endVisit(LabeledStatement labeledStatement) {
                final String string = labeledStatement.getLabel().getIdentifier();
                int n = hashMap.containsKey(string) ? (Integer)hashMap.get(string) + 1 : 1;
                hashMap.put(string, n);
                if (n > 1) {
                    final String string2 = string + '_' + n;
                    labeledStatement.setLabel(ASTFactory.newLabel(this.val$ast, string2));
                    labeledStatement.accept(new ASTVisitor(){

                        public void endVisit(ContinueStatement continueStatement) {
                            if (continueStatement.getLabel() != null && continueStatement.getLabel().getIdentifier().equals(string)) {
                                continueStatement.setLabel(ASTFactory.newLabel(val$ast, string2));
                            }
                        }

                        public void endVisit(BreakStatement breakStatement) {
                            if (breakStatement.getLabel() != null && breakStatement.getLabel().getIdentifier().equals(string)) {
                                breakStatement.setLabel(ASTFactory.newLabel(val$ast, string2));
                            }
                        }
                    });
                }
            }
        });
        return true;
    }

    private void handleCompareToMethod(MethodDeclaration methodDeclaration, IMethodBinding iMethodBinding) {
        if (!iMethodBinding.getName().equals("compareTo") || methodDeclaration.getBody() == null) {
            return;
        }
        ITypeBinding iTypeBinding = BindingUtil.findInterface(iMethodBinding.getDeclaringClass(), "java.lang.Comparable");
        if (iTypeBinding == null) {
            return;
        }
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeArguments();
        ITypeBinding[] iTypeBindingArray2 = iMethodBinding.getParameterTypes();
        if (iTypeBindingArray.length != 1 || iTypeBindingArray2.length != 1 || !iTypeBindingArray[0].isEqualTo((IBinding)iTypeBindingArray2[0])) {
            return;
        }
        AST aST = methodDeclaration.getAST();
        IVariableBinding iVariableBinding = Types.getVariableBinding(ASTUtil.getParameters(methodDeclaration).get(0));
        InfixExpression infixExpression = ASTFactory.newInfixExpression(aST, (Expression)ASTFactory.newSimpleName(aST, (IBinding)iVariableBinding), InfixExpression.Operator.NOT_EQUALS, (Expression)ASTFactory.newNullLiteral(aST), aST.resolveWellKnownType("boolean"));
        InstanceofExpression instanceofExpression = ASTFactory.newInstanceofExpression(aST, (Expression)ASTFactory.newSimpleName(aST, (IBinding)iVariableBinding), iTypeBindingArray[0]);
        instanceofExpression = ASTFactory.newPrefixExpression(aST, PrefixExpression.Operator.NOT, (Expression)instanceofExpression, "boolean");
        GeneratedTypeBinding generatedTypeBinding = GeneratedTypeBinding.newTypeBinding("java.lang.ClassCastException", aST.resolveWellKnownType("java.lang.RuntimeException"), false);
        ClassInstanceCreation classInstanceCreation = aST.newClassInstanceCreation();
        classInstanceCreation.setType(ASTFactory.newType(aST, generatedTypeBinding));
        Types.addBinding(classInstanceCreation, GeneratedMethodBinding.newConstructor(generatedTypeBinding, 0));
        ThrowStatement throwStatement = aST.newThrowStatement();
        throwStatement.setExpression((Expression)classInstanceCreation);
        Block block = aST.newBlock();
        ASTUtil.getStatements(block).add((Statement)throwStatement);
        IfStatement ifStatement = aST.newIfStatement();
        ifStatement.setExpression((Expression)ASTFactory.newInfixExpression(aST, (Expression)infixExpression, InfixExpression.Operator.CONDITIONAL_AND, (Expression)instanceofExpression, aST.resolveWellKnownType("boolean")));
        ifStatement.setThenStatement((Statement)block);
        ASTUtil.getStatements(methodDeclaration.getBody()).add(0, (Statement)ifStatement);
    }

    public boolean visit(MethodInvocation methodInvocation) {
        IMethodBinding iMethodBinding = Types.getMethodBinding(methodInvocation);
        String string = iMethodBinding.getName();
        this.renameReservedNames(string, iMethodBinding);
        return true;
    }

    public boolean visit(SuperMethodInvocation superMethodInvocation) {
        this.renameReservedNames(superMethodInvocation.getName().getIdentifier(), Types.getMethodBinding(superMethodInvocation));
        return true;
    }

    private void renameReservedNames(String string, IMethodBinding iMethodBinding) {
        if (NameTable.isReservedName(string)) {
            NameTable.rename((IBinding)iMethodBinding, string + "__");
        }
    }

    private static Statement getLoopBody(Statement statement) {
        if (statement instanceof DoStatement) {
            return ((DoStatement)statement).getBody();
        }
        if (statement instanceof EnhancedForStatement) {
            return ((EnhancedForStatement)statement).getBody();
        }
        if (statement instanceof ForStatement) {
            return ((ForStatement)statement).getBody();
        }
        if (statement instanceof WhileStatement) {
            return ((WhileStatement)statement).getBody();
        }
        return null;
    }

    public void endVisit(LabeledStatement labeledStatement) {
        LabeledStatement labeledStatement2;
        Statement statement = Rewriter.getLoopBody(labeledStatement.getBody());
        if (statement == null) {
            return;
        }
        final AST aST = labeledStatement.getAST();
        final String string = labeledStatement.getLabel().getIdentifier();
        final boolean[] blArray = new boolean[1];
        final boolean[] blArray2 = new boolean[1];
        labeledStatement.accept(new ASTVisitor(){

            public void endVisit(ContinueStatement continueStatement) {
                if (continueStatement.getLabel() != null && continueStatement.getLabel().getIdentifier().equals(string)) {
                    blArray[0] = true;
                    continueStatement.setLabel(ASTFactory.newLabel(aST, "continue_" + string));
                }
            }

            public void endVisit(BreakStatement breakStatement) {
                if (breakStatement.getLabel() != null && breakStatement.getLabel().getIdentifier().equals(string)) {
                    blArray2[0] = true;
                    breakStatement.setLabel(ASTFactory.newLabel(aST, "break_" + string));
                }
            }
        });
        if (blArray[0]) {
            labeledStatement2 = aST.newLabeledStatement();
            labeledStatement2.setLabel(ASTFactory.newLabel(aST, "continue_" + string));
            labeledStatement2.setBody((Statement)aST.newEmptyStatement());
            Block block = aST.newBlock();
            ASTUtil.setProperty((ASTNode)statement, (ASTNode)block);
            ASTUtil.getStatements(block).add(statement);
            ASTUtil.getStatements(block).add((Statement)labeledStatement2);
        }
        if (blArray2[0]) {
            labeledStatement2 = aST.newLabeledStatement();
            labeledStatement2.setLabel(ASTFactory.newLabel(aST, "break_" + string));
            labeledStatement2.setBody((Statement)aST.newEmptyStatement());
            ASTUtil.insertAfter((Statement)labeledStatement, (Statement)labeledStatement2);
        }
        if (blArray[0] || blArray2[0]) {
            ASTUtil.setProperty((ASTNode)labeledStatement, (ASTNode)NodeCopier.copySubtree(aST, labeledStatement.getBody()));
        }
    }

    public void endVisit(ForStatement forStatement) {
        Object e;
        if (forStatement.initializers().size() == 1 && (e = forStatement.initializers().get(0)) instanceof VariableDeclarationExpression) {
            List<VariableDeclarationFragment> list = ASTUtil.getFragments((VariableDeclarationExpression)e);
            for (VariableDeclarationFragment variableDeclarationFragment : list) {
                if (!BindingUtil.hasAnnotation(Types.getBinding(variableDeclarationFragment), AutoreleasePool.class)) continue;
                Statement statement = forStatement.getBody();
                if (!(statement instanceof Block)) {
                    AST aST = forStatement.getAST();
                    Block block = aST.newBlock();
                    ASTUtil.getStatements(block).add(NodeCopier.copySubtree(aST, statement));
                    forStatement.setBody((Statement)block);
                }
                Types.addAutoreleasePool((Block)forStatement.getBody());
            }
        }
    }

    private Block makeBlock(Statement statement) {
        if (statement instanceof Block) {
            return (Block)statement;
        }
        Block block = statement.getAST().newBlock();
        if (statement.getParent() != null) {
            ASTUtil.setProperty((ASTNode)statement, (ASTNode)block);
        }
        ASTUtil.getStatements(block).add(statement);
        return block;
    }

    private boolean emitJavaIteratorLoop(IVariableBinding iVariableBinding) {
        IAnnotationBinding iAnnotationBinding = BindingUtil.getAnnotation((IBinding)iVariableBinding, LoopTranslation.class);
        if (iAnnotationBinding == null) {
            return false;
        }
        Object object = BindingUtil.getAnnotationValue(iAnnotationBinding, "value");
        return object instanceof IVariableBinding && ((IVariableBinding)object).getName().equals(LoopTranslation.LoopStyle.JAVA_ITERATOR.name());
    }

    public void endVisit(EnhancedForStatement enhancedForStatement) {
        AST aST = enhancedForStatement.getAST();
        Expression expression = enhancedForStatement.getExpression();
        ITypeBinding iTypeBinding = Types.getTypeBinding(expression);
        IVariableBinding iVariableBinding = Types.getVariableBinding(enhancedForStatement.getParameter());
        if (BindingUtil.hasAnnotation((IBinding)iVariableBinding, AutoreleasePool.class)) {
            Types.addAutoreleasePool(this.makeBlock(enhancedForStatement.getBody()));
        }
        if (iTypeBinding.isArray()) {
            ASTUtil.setProperty((ASTNode)enhancedForStatement, (ASTNode)this.makeArrayIterationBlock(aST, expression, iTypeBinding, iVariableBinding, enhancedForStatement.getBody()));
        } else if (this.emitJavaIteratorLoop(iVariableBinding)) {
            ASTUtil.setProperty((ASTNode)enhancedForStatement, (ASTNode)this.makeIterableBlock(aST, expression, iTypeBinding, iVariableBinding, enhancedForStatement.getBody()));
        } else if (iVariableBinding.getType().isPrimitive()) {
            this.boxLoopVariable(aST, enhancedForStatement, iTypeBinding, iVariableBinding);
        } else {
            GeneratedVariableBinding generatedVariableBinding = new GeneratedVariableBinding(iVariableBinding);
            generatedVariableBinding.setTypeQualifiers("__strong");
            Types.addBinding(enhancedForStatement.getParameter(), generatedVariableBinding);
        }
    }

    private Block makeArrayIterationBlock(AST aST, Expression expression, ITypeBinding iTypeBinding, IVariableBinding iVariableBinding, Statement statement) {
        ITypeBinding iTypeBinding2 = iTypeBinding.getComponentType();
        if (!iTypeBinding2.isPrimitive()) {
            iTypeBinding2 = Types.resolveIOSType("id");
        }
        IOSTypeBinding iOSTypeBinding = Types.resolveArrayType(iTypeBinding2);
        PointerTypeBinding pointerTypeBinding = new PointerTypeBinding(iTypeBinding2);
        GeneratedVariableBinding generatedVariableBinding = new GeneratedVariableBinding("a__", 0, iTypeBinding, false, false, null, null);
        GeneratedVariableBinding generatedVariableBinding2 = new GeneratedVariableBinding("b__", 0, pointerTypeBinding, false, false, null, null);
        generatedVariableBinding2.setTypeQualifiers("const*");
        GeneratedVariableBinding generatedVariableBinding3 = new GeneratedVariableBinding("e__", 0, pointerTypeBinding, false, false, null, null);
        generatedVariableBinding3.setTypeQualifiers("const*");
        GeneratedVariableBinding generatedVariableBinding4 = new GeneratedVariableBinding("buffer", 1, pointerTypeBinding, true, false, iOSTypeBinding, null);
        GeneratedVariableBinding generatedVariableBinding5 = new GeneratedVariableBinding("size", 1, Types.resolveJavaType("int"), true, false, iOSTypeBinding, null);
        VariableDeclarationStatement variableDeclarationStatement = ASTFactory.newVariableDeclarationStatement(aST, generatedVariableBinding, NodeCopier.copySubtree(aST, expression));
        FieldAccess fieldAccess = ASTFactory.newFieldAccess(aST, generatedVariableBinding4, (Expression)ASTFactory.newSimpleName(aST, generatedVariableBinding));
        VariableDeclarationStatement variableDeclarationStatement2 = ASTFactory.newVariableDeclarationStatement(aST, generatedVariableBinding2, (Expression)fieldAccess);
        InfixExpression infixExpression = ASTFactory.newInfixExpression(aST, (Expression)ASTFactory.newSimpleName(aST, generatedVariableBinding2), InfixExpression.Operator.PLUS, (Expression)ASTFactory.newFieldAccess(aST, generatedVariableBinding5, (Expression)ASTFactory.newSimpleName(aST, generatedVariableBinding)), (ITypeBinding)pointerTypeBinding);
        VariableDeclarationStatement variableDeclarationStatement3 = ASTFactory.newVariableDeclarationStatement(aST, generatedVariableBinding3, (Expression)infixExpression);
        WhileStatement whileStatement = aST.newWhileStatement();
        whileStatement.setExpression((Expression)ASTFactory.newInfixExpression(aST, (Expression)ASTFactory.newSimpleName(aST, generatedVariableBinding2), InfixExpression.Operator.LESS, (Expression)ASTFactory.newSimpleName(aST, generatedVariableBinding3), Types.resolveJavaType("boolean")));
        Block block = this.makeBlock(NodeCopier.copySubtree(aST, statement));
        whileStatement.setBody((Statement)block);
        ASTUtil.getStatements(block).add(0, (Statement)ASTFactory.newVariableDeclarationStatement(aST, iVariableBinding, (Expression)ASTFactory.newDereference(aST, (Expression)ASTFactory.newPostfixExpression(aST, generatedVariableBinding2, PostfixExpression.Operator.INCREMENT))));
        Block block2 = aST.newBlock();
        List<Statement> list = ASTUtil.getStatements(block2);
        list.add((Statement)variableDeclarationStatement);
        list.add((Statement)variableDeclarationStatement2);
        list.add((Statement)variableDeclarationStatement3);
        list.add((Statement)whileStatement);
        return block2;
    }

    private void boxLoopVariable(AST aST, EnhancedForStatement enhancedForStatement, ITypeBinding iTypeBinding, IVariableBinding iVariableBinding) {
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeArguments();
        assert (iTypeBindingArray.length == 1 && Types.isBoxedPrimitive(iTypeBindingArray[0]));
        GeneratedVariableBinding generatedVariableBinding = new GeneratedVariableBinding("boxed__", 0, iTypeBindingArray[0], false, false, null, null);
        enhancedForStatement.setParameter(ASTFactory.newSingleVariableDeclaration(aST, generatedVariableBinding));
        ASTUtil.getStatements(this.makeBlock(enhancedForStatement.getBody())).add(0, (Statement)ASTFactory.newVariableDeclarationStatement(aST, iVariableBinding, (Expression)ASTFactory.newSimpleName(aST, generatedVariableBinding)));
    }

    private Block makeIterableBlock(AST aST, Expression expression, ITypeBinding iTypeBinding, IVariableBinding iVariableBinding, Statement statement) {
        ITypeBinding iTypeBinding2 = BindingUtil.findInterface(iTypeBinding, "java.lang.Iterable");
        IMethodBinding iMethodBinding = BindingUtil.findDeclaredMethod(iTypeBinding2, "iterator", new String[0]);
        ITypeBinding iTypeBinding3 = iMethodBinding.getReturnType();
        IMethodBinding iMethodBinding2 = BindingUtil.findDeclaredMethod(iTypeBinding3, "hasNext", new String[0]);
        IMethodBinding iMethodBinding3 = BindingUtil.findDeclaredMethod(iTypeBinding3, "next", new String[0]);
        assert (iMethodBinding2 != null && iMethodBinding3 != null);
        GeneratedVariableBinding generatedVariableBinding = new GeneratedVariableBinding("iter__", 0, iTypeBinding3, false, false, null, null);
        MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(aST, iMethodBinding, NodeCopier.copySubtree(aST, expression));
        VariableDeclarationStatement variableDeclarationStatement = ASTFactory.newVariableDeclarationStatement(aST, generatedVariableBinding, (Expression)methodInvocation);
        MethodInvocation methodInvocation2 = ASTFactory.newMethodInvocation(aST, iMethodBinding2, (Expression)ASTFactory.newSimpleName(aST, generatedVariableBinding));
        MethodInvocation methodInvocation3 = ASTFactory.newMethodInvocation(aST, iMethodBinding3, (Expression)ASTFactory.newSimpleName(aST, generatedVariableBinding));
        Block block = this.makeBlock(NodeCopier.copySubtree(aST, statement));
        ASTUtil.getStatements(block).add(0, (Statement)ASTFactory.newVariableDeclarationStatement(aST, iVariableBinding, (Expression)methodInvocation3));
        WhileStatement whileStatement = aST.newWhileStatement();
        whileStatement.setExpression((Expression)methodInvocation2);
        whileStatement.setBody((Statement)block);
        Block block2 = aST.newBlock();
        List<Statement> list = ASTUtil.getStatements(block2);
        list.add((Statement)variableDeclarationStatement);
        list.add((Statement)whileStatement);
        return block2;
    }

    public void endVisit(InfixExpression infixExpression) {
        InfixExpression.Operator operator = infixExpression.getOperator();
        ITypeBinding iTypeBinding = Types.getTypeBinding(infixExpression);
        ITypeBinding iTypeBinding2 = Types.getTypeBinding(infixExpression.getLeftOperand());
        ITypeBinding iTypeBinding3 = Types.getTypeBinding(infixExpression.getRightOperand());
        if (Types.isJavaStringType(iTypeBinding) && operator == InfixExpression.Operator.PLUS && !Types.isJavaStringType(iTypeBinding2) && !Types.isJavaStringType(iTypeBinding3)) {
            AST aST = infixExpression.getAST();
            ITypeBinding iTypeBinding4 = this.getAdditionType(aST, iTypeBinding2, iTypeBinding3);
            InfixExpression infixExpression2 = aST.newInfixExpression();
            InfixExpression infixExpression3 = aST.newInfixExpression();
            infixExpression2.setOperator(InfixExpression.Operator.PLUS);
            infixExpression3.setOperator(InfixExpression.Operator.PLUS);
            infixExpression2.setLeftOperand(NodeCopier.copySubtree(aST, infixExpression.getLeftOperand()));
            infixExpression2.setRightOperand(NodeCopier.copySubtree(aST, infixExpression.getRightOperand()));
            List<Expression> list = ASTUtil.getExtendedOperands(infixExpression);
            List<Expression> list2 = ASTUtil.getExtendedOperands(infixExpression2);
            List<Expression> list3 = ASTUtil.getExtendedOperands(infixExpression3);
            boolean bl = false;
            for (Expression expression : list) {
                Expression expression2 = NodeCopier.copySubtree(aST, expression);
                ITypeBinding iTypeBinding5 = Types.getTypeBinding(expression);
                if (bl || Types.isJavaStringType(iTypeBinding5)) {
                    if (bl) {
                        list3.add(expression2);
                    } else {
                        infixExpression3.setRightOperand(expression2);
                    }
                    bl = true;
                    continue;
                }
                list2.add(expression2);
                iTypeBinding4 = this.getAdditionType(aST, iTypeBinding4, iTypeBinding5);
            }
            Types.addBinding(infixExpression2, (IBinding)iTypeBinding4);
            infixExpression3.setLeftOperand((Expression)infixExpression2);
            Types.addBinding(infixExpression3, (IBinding)aST.resolveWellKnownType("java.lang.String"));
            ASTUtil.setProperty((ASTNode)infixExpression, (ASTNode)infixExpression3);
        } else if (operator == InfixExpression.Operator.CONDITIONAL_AND) {
            InfixExpression infixExpression4;
            if (infixExpression.getParent() instanceof InfixExpression && (infixExpression4 = (InfixExpression)infixExpression.getParent()).getOperator() == InfixExpression.Operator.CONDITIONAL_OR) {
                AST aST = infixExpression.getAST();
                ParenthesizedExpression parenthesizedExpression = ASTFactory.newParenthesizedExpression(aST, (Expression)NodeCopier.copySubtree(aST, infixExpression));
                ASTUtil.setProperty((ASTNode)infixExpression, (ASTNode)parenthesizedExpression);
            }
        } else if (operator == InfixExpression.Operator.AND && infixExpression.getParent() instanceof InfixExpression && ((InfixExpression)infixExpression.getParent()).getOperator() == InfixExpression.Operator.OR) {
            AST aST = infixExpression.getAST();
            ParenthesizedExpression parenthesizedExpression = ASTFactory.newParenthesizedExpression(aST, (Expression)NodeCopier.copySubtree(aST, infixExpression));
            ASTUtil.setProperty((ASTNode)infixExpression, (ASTNode)parenthesizedExpression);
        }
    }

    private ITypeBinding getAdditionType(AST aST, ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2) {
        ITypeBinding iTypeBinding3 = aST.resolveWellKnownType("double");
        ITypeBinding iTypeBinding4 = aST.resolveWellKnownType("java.lang.Double");
        if (iTypeBinding == iTypeBinding3 || iTypeBinding2 == iTypeBinding3 || iTypeBinding == iTypeBinding4 || iTypeBinding2 == iTypeBinding4) {
            return iTypeBinding3;
        }
        ITypeBinding iTypeBinding5 = aST.resolveWellKnownType("float");
        ITypeBinding iTypeBinding6 = aST.resolveWellKnownType("java.lang.Float");
        if (iTypeBinding == iTypeBinding5 || iTypeBinding2 == iTypeBinding5 || iTypeBinding == iTypeBinding6 || iTypeBinding2 == iTypeBinding6) {
            return iTypeBinding5;
        }
        ITypeBinding iTypeBinding7 = aST.resolveWellKnownType("long");
        ITypeBinding iTypeBinding8 = aST.resolveWellKnownType("java.lang.Long");
        if (iTypeBinding == iTypeBinding7 || iTypeBinding2 == iTypeBinding7 || iTypeBinding == iTypeBinding8 || iTypeBinding2 == iTypeBinding8) {
            return iTypeBinding7;
        }
        return aST.resolveWellKnownType("int");
    }

    public void endVisit(SwitchStatement switchStatement) {
        AST aST = switchStatement.getAST();
        List<Statement> list = ASTUtil.getStatements(switchStatement);
        int n = 0;
        Block block = aST.newBlock();
        List<Statement> list2 = ASTUtil.getStatements(block);
        for (int i = 0; i < list.size(); ++i) {
            Statement statement = list.get(i);
            if (!(statement instanceof VariableDeclarationStatement)) continue;
            VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)statement;
            list.remove(i--);
            List<VariableDeclarationFragment> list3 = ASTUtil.getFragments(variableDeclarationStatement);
            for (VariableDeclarationFragment variableDeclarationFragment : list3) {
                Expression expression = variableDeclarationFragment.getInitializer();
                if (expression == null) continue;
                Assignment assignment = ASTFactory.newAssignment(aST, (Expression)NodeCopier.copySubtree(aST, variableDeclarationFragment.getName()), NodeCopier.copySubtree(aST, expression));
                list.add(++i, (Statement)aST.newExpressionStatement((Expression)assignment));
                variableDeclarationFragment.setInitializer(null);
            }
            list2.add(n++, (Statement)NodeCopier.copySubtree(aST, variableDeclarationStatement));
        }
        if (list2.size() > 0) {
            list2.add((Statement)NodeCopier.copySubtree(aST, switchStatement));
            ASTUtil.setProperty((ASTNode)switchStatement, (ASTNode)block);
        }
    }

    private void addAbstractMethod(AST aST, ITypeBinding iTypeBinding, IMethodBinding iMethodBinding, List<BodyDeclaration> list) {
        MethodDeclaration methodDeclaration = this.createInterfaceMethodBody(aST, iTypeBinding, iMethodBinding, iMethodBinding.getModifiers());
        ASTUtil.getModifiers((BodyDeclaration)methodDeclaration).add((IExtendedModifier)aST.newModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD));
        list.add((BodyDeclaration)methodDeclaration);
    }

    private void addForwardingMethod(AST aST, ITypeBinding iTypeBinding, IMethodBinding iMethodBinding, List<BodyDeclaration> list) {
        Logger.getAnonymousLogger().fine(String.format("adding %s to %s", iMethodBinding.getName(), iTypeBinding.getQualifiedName()));
        MethodDeclaration methodDeclaration = this.createInterfaceMethodBody(aST, iTypeBinding, iMethodBinding, 1);
        Block block = aST.newBlock();
        methodDeclaration.setBody(block);
        SuperMethodInvocation superMethodInvocation = ASTFactory.newSuperMethodInvocation(aST, Types.getMethodBinding(methodDeclaration));
        for (SingleVariableDeclaration singleVariableDeclaration : ASTUtil.getParameters(methodDeclaration)) {
            Expression expression = (Expression)NodeCopier.copySubtree(aST, singleVariableDeclaration.getName());
            ASTUtil.getArguments(superMethodInvocation).add(expression);
        }
        ReturnStatement returnStatement = aST.newReturnStatement();
        returnStatement.setExpression((Expression)superMethodInvocation);
        ASTUtil.getStatements(block).add((Statement)returnStatement);
        list.add((BodyDeclaration)methodDeclaration);
    }

    private MethodDeclaration createInterfaceMethodBody(AST aST, ITypeBinding iTypeBinding, IMethodBinding iMethodBinding, int n) {
        GeneratedMethodBinding generatedMethodBinding = GeneratedMethodBinding.newOverridingMethod(iMethodBinding, iTypeBinding, n);
        MethodDeclaration methodDeclaration = ASTFactory.newMethodDeclaration(aST, generatedMethodBinding);
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
        for (int i = 0; i < iTypeBindingArray.length; ++i) {
            ITypeBinding iTypeBinding2 = iTypeBindingArray[i];
            GeneratedVariableBinding generatedVariableBinding = new GeneratedVariableBinding("param" + i, 0, iTypeBinding2, false, true, iTypeBinding, generatedMethodBinding);
            ASTUtil.getParameters(methodDeclaration).add(ASTFactory.newSingleVariableDeclaration(aST, generatedVariableBinding));
            generatedMethodBinding.addParameter(iTypeBinding2);
        }
        return methodDeclaration;
    }

    private void renameDuplicateMembers(ITypeBinding iTypeBinding) {
        HashMap hashMap = Maps.newHashMap();
        ITypeBinding iTypeBinding2 = iTypeBinding.getSuperclass();
        if (iTypeBinding2 != null) {
            this.addFields(iTypeBinding2, true, true, hashMap);
            for (IVariableBinding iVariableBinding : iTypeBinding.getDeclaredFields()) {
                String string = iVariableBinding.getName();
                IVariableBinding iVariableBinding2 = (IVariableBinding)hashMap.get(string);
                if (iVariableBinding2 == null) continue;
                string = string + '_' + iTypeBinding.getName();
                NameTable.rename((IBinding)iVariableBinding, string);
                hashMap.put(string, iVariableBinding);
            }
        }
    }

    private void addFields(ITypeBinding iTypeBinding, boolean bl, boolean bl2, Map<String, IVariableBinding> map) {
        for (IVariableBinding iVariableBinding : iTypeBinding.getDeclaredFields()) {
            IPackageBinding iPackageBinding;
            int n;
            if (map.containsValue(iVariableBinding) || Modifier.isStatic((int)(n = iVariableBinding.getModifiers()))) continue;
            if (bl) {
                map.put(iVariableBinding.getName(), iVariableBinding);
                continue;
            }
            if (Modifier.isPublic((int)n) || Modifier.isProtected((int)n)) {
                map.put(iVariableBinding.getName(), iVariableBinding);
                continue;
            }
            IPackageBinding iPackageBinding2 = iTypeBinding.getPackage();
            if (!iPackageBinding2.isEqualTo((IBinding)(iPackageBinding = iVariableBinding.getDeclaringClass().getPackage()))) continue;
            map.put(iVariableBinding.getName(), iVariableBinding);
        }
        ITypeBinding iTypeBinding2 = iTypeBinding.getSuperclass();
        if (bl2 && iTypeBinding2 != null) {
            this.addFields(iTypeBinding2, false, true, map);
        }
    }

    public void endVisit(SingleVariableDeclaration singleVariableDeclaration) {
        if (singleVariableDeclaration.getExtraDimensions() > 0) {
            singleVariableDeclaration.setType(ASTFactory.newType(singleVariableDeclaration.getAST(), Types.getTypeBinding(singleVariableDeclaration)));
            singleVariableDeclaration.setExtraDimensions(0);
        }
    }

    public void endVisit(VariableDeclarationStatement variableDeclarationStatement) {
        AST aST = variableDeclarationStatement.getAST();
        LinkedListMultimap<Integer, VariableDeclarationFragment> linkedListMultimap = this.rewriteExtraDimensions(aST, variableDeclarationStatement.getType(), ASTUtil.getFragments(variableDeclarationStatement));
        if (linkedListMultimap != null) {
            int n;
            List<Statement> list = ASTUtil.getStatements((Block)variableDeclarationStatement.getParent());
            for (n = 0; n < list.size() && !variableDeclarationStatement.equals((Object)list.get(n)); ++n) {
            }
            for (Integer n2 : linkedListMultimap.keySet()) {
                List list2 = linkedListMultimap.get((Object)n2);
                VariableDeclarationStatement variableDeclarationStatement2 = ASTFactory.newVariableDeclarationStatement(aST, (VariableDeclarationFragment)list2.get(0));
                ASTUtil.getFragments(variableDeclarationStatement2).addAll(list2.subList(1, list2.size()));
                list.add(++n, (Statement)variableDeclarationStatement2);
            }
        }
    }

    public void endVisit(FieldDeclaration fieldDeclaration) {
        AST aST = fieldDeclaration.getAST();
        LinkedListMultimap<Integer, VariableDeclarationFragment> linkedListMultimap = this.rewriteExtraDimensions(aST, fieldDeclaration.getType(), ASTUtil.getFragments(fieldDeclaration));
        if (linkedListMultimap != null) {
            int n;
            List<BodyDeclaration> list = ASTUtil.getBodyDeclarations(fieldDeclaration.getParent());
            for (n = 0; n < list.size() && !fieldDeclaration.equals((Object)list.get(n)); ++n) {
            }
            for (Integer n2 : linkedListMultimap.keySet()) {
                List list2 = linkedListMultimap.get((Object)n2);
                FieldDeclaration fieldDeclaration2 = ASTFactory.newFieldDeclaration(aST, (VariableDeclarationFragment)list2.get(0));
                ASTUtil.getFragments(fieldDeclaration2).addAll(list2.subList(1, list2.size()));
                list.add(++n, (BodyDeclaration)fieldDeclaration2);
            }
        }
    }

    private LinkedListMultimap<Integer, VariableDeclarationFragment> rewriteExtraDimensions(AST aST, Type type, List<VariableDeclarationFragment> list) {
        LinkedListMultimap linkedListMultimap = null;
        int n = -1;
        Iterator<VariableDeclarationFragment> iterator = list.iterator();
        while (iterator.hasNext()) {
            VariableDeclarationFragment variableDeclarationFragment = iterator.next();
            int n2 = variableDeclarationFragment.getExtraDimensions();
            ITypeBinding iTypeBinding = Types.getTypeBinding(variableDeclarationFragment);
            if (n == -1) {
                n = n2;
                if (n2 == 0) continue;
                ASTUtil.setProperty((ASTNode)type, (ASTNode)ASTFactory.newType(aST, iTypeBinding));
                continue;
            }
            if (n2 != n) {
                if (linkedListMultimap == null) {
                    linkedListMultimap = LinkedListMultimap.create();
                }
                VariableDeclarationFragment variableDeclarationFragment2 = ASTFactory.newVariableDeclarationFragment(aST, Types.getVariableBinding(variableDeclarationFragment), NodeCopier.copySubtree(aST, variableDeclarationFragment.getInitializer()));
                linkedListMultimap.put((Object)n2, (Object)variableDeclarationFragment2);
                iterator.remove();
                continue;
            }
            variableDeclarationFragment.setExtraDimensions(0);
        }
        return linkedListMultimap;
    }

    public void endVisit(Assignment assignment) {
        AST aST = assignment.getAST();
        Assignment.Operator operator = assignment.getOperator();
        Expression expression = assignment.getLeftHandSide();
        Expression expression2 = assignment.getRightHandSide();
        ITypeBinding iTypeBinding = Types.getTypeBinding(expression);
        if (operator == Assignment.Operator.PLUS_ASSIGN && Types.isJavaStringType(iTypeBinding)) {
            assignment.setOperator(Assignment.Operator.ASSIGN);
            assignment.setRightHandSide((Expression)ASTFactory.newInfixExpression(aST, NodeCopier.copySubtree(aST, expression), InfixExpression.Operator.PLUS, NodeCopier.copySubtree(aST, expression2), iTypeBinding));
        }
    }
}

