/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.devtools.j2objc.types.GeneratedVariableBinding;
import com.google.devtools.j2objc.util.BindingUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class OuterReferenceResolver
extends ASTVisitor {
    public static final IVariableBinding OUTER_PARAMETER = GeneratedVariableBinding.newPlaceholder();
    private static OuterReferenceResolver instance;
    private Map<ITypeBinding, IVariableBinding> outerVars = Maps.newHashMap();
    private Set<ITypeBinding> usesOuterParam = Sets.newHashSet();
    private ListMultimap<ITypeBinding, Capture> captures = ArrayListMultimap.create();
    private Map<ASTNode, List<IVariableBinding>> outerPaths = Maps.newHashMap();
    private ArrayList<Scope> scopeStack = Lists.newArrayList();

    public static void cleanup() {
        instance = null;
    }

    public static void initialize() {
        if (instance == null) {
            instance = new OuterReferenceResolver();
        }
    }

    public static void resolve(ASTNode aSTNode) {
        OuterReferenceResolver.initialize();
        assert (OuterReferenceResolver.instance.scopeStack.size() == 0);
        aSTNode.accept((ASTVisitor)instance);
    }

    public static boolean needsOuterReference(ITypeBinding iTypeBinding) {
        assert (instance != null);
        return OuterReferenceResolver.instance.outerVars.containsKey(iTypeBinding);
    }

    public static boolean needsOuterParam(ITypeBinding iTypeBinding) {
        assert (instance != null);
        return !iTypeBinding.isLocal() || OuterReferenceResolver.instance.outerVars.containsKey(iTypeBinding) || OuterReferenceResolver.instance.usesOuterParam.contains(iTypeBinding);
    }

    public static IVariableBinding getOuterField(ITypeBinding iTypeBinding) {
        assert (instance != null);
        return OuterReferenceResolver.instance.outerVars.get(iTypeBinding);
    }

    public static List<IVariableBinding> getCapturedVars(ITypeBinding iTypeBinding) {
        assert (instance != null);
        List list = OuterReferenceResolver.instance.captures.get((Object)iTypeBinding);
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        for (Capture capture : list) {
            arrayList.add(capture.var);
        }
        return arrayList;
    }

    public static List<IVariableBinding> getInnerFields(ITypeBinding iTypeBinding) {
        assert (instance != null);
        List list = OuterReferenceResolver.instance.captures.get((Object)iTypeBinding);
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        for (Capture capture : list) {
            arrayList.add(capture.field);
        }
        return arrayList;
    }

    public static List<IVariableBinding> getPath(ASTNode aSTNode) {
        assert (instance != null);
        return OuterReferenceResolver.instance.outerPaths.get(aSTNode);
    }

    public static void copyNode(ASTNode aSTNode, ASTNode aSTNode2) {
        assert (instance != null);
        List<IVariableBinding> list = OuterReferenceResolver.instance.outerPaths.get(aSTNode);
        if (list != null) {
            List<IVariableBinding> list2 = OuterReferenceResolver.instance.outerPaths.put(aSTNode2, list);
            assert (list2 == null);
        }
    }

    private Scope peekScope() {
        assert (this.scopeStack.size() > 0);
        return this.scopeStack.get(this.scopeStack.size() - 1);
    }

    private String getOuterFieldName(ITypeBinding iTypeBinding) {
        int n = 0;
        for (iTypeBinding = iTypeBinding.getSuperclass(); iTypeBinding != null; iTypeBinding = iTypeBinding.getSuperclass()) {
            if (iTypeBinding.getDeclaringClass() == null || Modifier.isStatic((int)iTypeBinding.getModifiers())) continue;
            ++n;
        }
        return "this$" + n;
    }

    private IVariableBinding getOrCreateOuterField(Scope scope) {
        if (scope.initializingContext && scope == this.peekScope()) {
            this.usesOuterParam.add(scope.type);
            return OUTER_PARAMETER;
        }
        ITypeBinding iTypeBinding = scope.type;
        IVariableBinding iVariableBinding = this.outerVars.get(iTypeBinding);
        if (iVariableBinding == null) {
            iVariableBinding = new GeneratedVariableBinding(this.getOuterFieldName(iTypeBinding), 18, iTypeBinding.getDeclaringClass(), true, false, iTypeBinding, null);
            this.outerVars.put(iTypeBinding, iVariableBinding);
        }
        return iVariableBinding;
    }

    private IVariableBinding getOrCreateInnerField(IVariableBinding iVariableBinding, ITypeBinding iTypeBinding) {
        List list = this.captures.get((Object)iTypeBinding);
        Object object = null;
        for (Capture capture : list) {
            if (!iVariableBinding.equals(capture.var)) continue;
            object = capture.field;
            break;
        }
        if (object == null) {
            GeneratedVariableBinding generatedVariableBinding = new GeneratedVariableBinding("val$" + iVariableBinding.getName(), 18, iVariableBinding.getType(), true, false, iTypeBinding, null);
            generatedVariableBinding.addAnnotations((IBinding)iVariableBinding);
            object = generatedVariableBinding;
            this.captures.put((Object)iTypeBinding, (Object)new Capture(iVariableBinding, (IVariableBinding)object));
        }
        return object;
    }

    private List<IVariableBinding> getOuterPath(ITypeBinding iTypeBinding) {
        Scope scope;
        iTypeBinding = iTypeBinding.getTypeDeclaration();
        ArrayList arrayList = Lists.newArrayList();
        for (int i = this.scopeStack.size() - 1; i >= 0 && !iTypeBinding.equals((scope = this.scopeStack.get(i)).type); --i) {
            arrayList.add(this.getOrCreateOuterField(scope));
        }
        return arrayList;
    }

    private List<IVariableBinding> getOuterPathInherited(ITypeBinding iTypeBinding) {
        Scope scope;
        iTypeBinding = iTypeBinding.getTypeDeclaration();
        ArrayList arrayList = Lists.newArrayList();
        for (int i = this.scopeStack.size() - 1; i >= 0 && !(scope = this.scopeStack.get(i)).inheritedScope.contains(iTypeBinding); --i) {
            arrayList.add(this.getOrCreateOuterField(scope));
        }
        return arrayList;
    }

    private List<IVariableBinding> getPathForField(IVariableBinding iVariableBinding) {
        List<IVariableBinding> list = this.getOuterPathInherited(iVariableBinding.getDeclaringClass());
        if (!list.isEmpty()) {
            list.add(iVariableBinding);
        }
        return list;
    }

    private List<IVariableBinding> getPathForLocalVar(IVariableBinding iVariableBinding) {
        Scope scope;
        boolean bl = iVariableBinding.getConstantValue() != null;
        ArrayList arrayList = Lists.newArrayList();
        Scope scope2 = null;
        for (int i = this.scopeStack.size() - 1; i >= 0 && !(scope = this.scopeStack.get(i)).declaredVars.contains(iVariableBinding); --i) {
            if (scope2 != null && !bl) {
                arrayList.add(this.getOrCreateOuterField(scope2));
            }
            scope2 = scope;
        }
        if (scope2 != null) {
            if (bl) {
                arrayList.add(iVariableBinding);
            } else {
                arrayList.add(this.getOrCreateInnerField(iVariableBinding, scope2.type));
            }
        }
        return arrayList;
    }

    private void addPath(ASTNode aSTNode, List<IVariableBinding> list) {
        if (!list.isEmpty()) {
            this.outerPaths.put(aSTNode, list);
        }
    }

    private void pushType(ASTNode aSTNode, ITypeBinding iTypeBinding) {
        ITypeBinding iTypeBinding2;
        this.scopeStack.add(new Scope(iTypeBinding));
        ITypeBinding iTypeBinding3 = iTypeBinding.getSuperclass();
        if (iTypeBinding3 != null && !Modifier.isStatic((int)iTypeBinding3.getModifiers()) && (iTypeBinding2 = iTypeBinding3.getDeclaringClass()) != null) {
            this.addPath(aSTNode, this.getOuterPathInherited(iTypeBinding2));
        }
    }

    private void popType(ITypeBinding iTypeBinding) {
        this.scopeStack.remove(this.scopeStack.size() - 1);
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        this.pushType((ASTNode)typeDeclaration, typeDeclaration.resolveBinding());
        return true;
    }

    public void endVisit(TypeDeclaration typeDeclaration) {
        this.popType(typeDeclaration.resolveBinding());
    }

    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
        this.pushType((ASTNode)anonymousClassDeclaration, anonymousClassDeclaration.resolveBinding());
        return true;
    }

    public void endVisit(AnonymousClassDeclaration anonymousClassDeclaration) {
        this.popType(anonymousClassDeclaration.resolveBinding());
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        this.pushType((ASTNode)enumDeclaration, enumDeclaration.resolveBinding());
        return true;
    }

    public void endVisit(EnumDeclaration enumDeclaration) {
        this.popType(enumDeclaration.resolveBinding());
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        this.pushType((ASTNode)annotationTypeDeclaration, annotationTypeDeclaration.resolveBinding());
        return true;
    }

    public void endVisit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        this.popType(annotationTypeDeclaration.resolveBinding());
    }

    public boolean visit(SimpleName simpleName) {
        ASTNode aSTNode = simpleName.getParent();
        if (aSTNode instanceof FieldAccess || aSTNode instanceof QualifiedName && simpleName == ((QualifiedName)aSTNode).getName()) {
            return false;
        }
        IBinding iBinding = simpleName.resolveBinding();
        if (iBinding instanceof IVariableBinding) {
            IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
            if (iVariableBinding.isField() && !Modifier.isStatic((int)iVariableBinding.getModifiers())) {
                this.addPath((ASTNode)simpleName, this.getPathForField(iVariableBinding));
            } else if (!iVariableBinding.isField()) {
                this.addPath((ASTNode)simpleName, this.getPathForLocalVar(iVariableBinding));
            }
        }
        return true;
    }

    public boolean visit(ThisExpression thisExpression) {
        Name name = thisExpression.getQualifier();
        if (name != null) {
            this.addPath((ASTNode)thisExpression, this.getOuterPath(name.resolveTypeBinding()));
        }
        return true;
    }

    public void endVisit(MethodInvocation methodInvocation) {
        IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
        if (methodInvocation.getExpression() == null && !Modifier.isStatic((int)iMethodBinding.getModifiers())) {
            this.addPath((ASTNode)methodInvocation, this.getOuterPathInherited(iMethodBinding.getDeclaringClass()));
        }
    }

    public void endVisit(SuperMethodInvocation superMethodInvocation) {
        Name name = superMethodInvocation.getQualifier();
        if (name != null) {
            this.addPath((ASTNode)superMethodInvocation, this.getOuterPath(name.resolveTypeBinding()));
        }
    }

    public void endVisit(ClassInstanceCreation classInstanceCreation) {
        ITypeBinding iTypeBinding;
        ITypeBinding iTypeBinding2 = classInstanceCreation.resolveTypeBinding();
        if (classInstanceCreation.getExpression() == null && !Modifier.isStatic((int)iTypeBinding2.getModifiers()) && (iTypeBinding = iTypeBinding2.getDeclaringClass()) != null) {
            this.addPath((ASTNode)classInstanceCreation, this.getOuterPathInherited(iTypeBinding));
        }
    }

    private boolean visitVariableDeclaration(VariableDeclaration variableDeclaration) {
        assert (this.scopeStack.size() > 0);
        Scope scope = this.scopeStack.get(this.scopeStack.size() - 1);
        scope.declaredVars.add(variableDeclaration.resolveBinding());
        return true;
    }

    public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
        return this.visitVariableDeclaration((VariableDeclaration)variableDeclarationFragment);
    }

    public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
        return this.visitVariableDeclaration((VariableDeclaration)singleVariableDeclaration);
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        IMethodBinding iMethodBinding = methodDeclaration.resolveBinding();
        if (!iMethodBinding.isConstructor()) {
            this.peekScope().initializingContext = false;
        }
        return true;
    }

    public void endVisit(MethodDeclaration methodDeclaration) {
        IMethodBinding iMethodBinding = methodDeclaration.resolveBinding();
        if (!iMethodBinding.isConstructor()) {
            this.peekScope().initializingContext = true;
        }
    }

    private static class Scope {
        private final ITypeBinding type;
        private final Set<ITypeBinding> inheritedScope;
        private boolean initializingContext = true;
        private Set<IVariableBinding> declaredVars = Sets.newHashSet();

        private Scope(ITypeBinding iTypeBinding) {
            this.type = iTypeBinding;
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.add((Object)iTypeBinding.getTypeDeclaration());
            for (ITypeBinding iTypeBinding2 : BindingUtil.getAllInheritedTypes(iTypeBinding)) {
                builder.add((Object)iTypeBinding2.getTypeDeclaration());
            }
            this.inheritedScope = builder.build();
        }
    }

    private static class Capture {
        private final IVariableBinding var;
        private final IVariableBinding field;

        private Capture(IVariableBinding iVariableBinding, IVariableBinding iVariableBinding2) {
            this.var = iVariableBinding;
            this.field = iVariableBinding2;
        }
    }
}

