/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.BindingUtil;
import com.google.devtools.j2objc.util.DeadCodeMap;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WildcardType;

public class DeadCodeEliminator
extends ErrorReportingASTVisitor {
    private static final Joiner innerClassJoiner = Joiner.on((char)'$');
    private static int classCount = 0;
    private final Set<MethodDeclaration> generatedMethods = Sets.newHashSet();
    private final Map<Type, ITypeBinding> generatedTypes = Maps.newHashMap();
    private final DeadCodeMap deadCodeMap;

    private static String generateClassName() {
        return "J2OBJC_DUMMY_CLASS_" + classCount++;
    }

    public DeadCodeEliminator(DeadCodeMap deadCodeMap) {
        this.deadCodeMap = deadCodeMap;
    }

    public void endVisit(TypeDeclaration typeDeclaration) {
        Iterator<IMethodBinding> iterator;
        ITypeBinding iTypeBinding = typeDeclaration.resolveBinding();
        List<BodyDeclaration> list = ASTUtil.getBodyDeclarations((AbstractTypeDeclaration)typeDeclaration);
        this.eliminateDeadCode(typeDeclaration.resolveBinding(), list);
        if (!typeDeclaration.isInterface() && !Modifier.isAbstract((int)typeDeclaration.getModifiers())) {
            this.generateMissingMethods(typeDeclaration.getAST(), iTypeBinding, list);
        }
        ITypeBinding iTypeBinding2 = typeDeclaration.resolveBinding();
        ITypeBinding iTypeBinding3 = iTypeBinding2.getSuperclass();
        if (!(iTypeBinding2.isInterface() || iTypeBinding2.isAnonymous() || iTypeBinding3 == null || this.getConstructors(iTypeBinding2).hasNext() || !(iterator = this.getVisible(this.getConstructors(iTypeBinding3))).hasNext() || this.getWithArity(0, iterator).hasNext())) {
            this.generateConstructor(typeDeclaration);
        }
        this.finishElimination();
    }

    public void endVisit(EnumDeclaration enumDeclaration) {
        ITypeBinding iTypeBinding = enumDeclaration.resolveBinding();
        List<BodyDeclaration> list = ASTUtil.getBodyDeclarations((AbstractTypeDeclaration)enumDeclaration);
        this.eliminateDeadCode(iTypeBinding, list);
        this.generateMissingMethods(enumDeclaration.getAST(), iTypeBinding, list);
        if (this.deadCodeMap.isDeadClass(BindingUtil.getSignature((IBinding)enumDeclaration.resolveBinding()))) {
            enumDeclaration.enumConstants().clear();
        }
        this.finishElimination();
    }

    public void endVisit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        List<BodyDeclaration> list = ASTUtil.getBodyDeclarations((AbstractTypeDeclaration)annotationTypeDeclaration);
        this.eliminateDeadCode(annotationTypeDeclaration.resolveBinding(), list);
        this.finishElimination();
    }

    public void endVisit(ImportDeclaration importDeclaration) {
        String string;
        IVariableBinding iVariableBinding;
        String string2;
        IBinding iBinding = importDeclaration.resolveBinding();
        if (iBinding instanceof IMethodBinding) {
            IMethodBinding iMethodBinding = (IMethodBinding)iBinding;
            if (this.allMethodsDeadWithName(iMethodBinding.getDeclaringClass(), this.getProGuardName(iMethodBinding))) {
                importDeclaration.delete();
            }
        } else if (iBinding instanceof IVariableBinding && this.deadCodeMap.isDeadField(string2 = BindingUtil.getSignature((IBinding)(iVariableBinding = (IVariableBinding)iBinding).getDeclaringClass()), string = iVariableBinding.getName()) && iVariableBinding.getConstantValue() == null) {
            importDeclaration.delete();
        }
    }

    public void endVisit(AnonymousClassDeclaration anonymousClassDeclaration) {
        ITypeBinding iTypeBinding = anonymousClassDeclaration.resolveBinding();
        List<BodyDeclaration> list = ASTUtil.getBodyDeclarations(anonymousClassDeclaration);
        this.eliminateDeadCode(iTypeBinding, list);
        this.generateMissingMethods(anonymousClassDeclaration.getAST(), iTypeBinding, list);
        this.finishElimination();
    }

    private void eliminateDeadCode(ITypeBinding iTypeBinding, List<BodyDeclaration> list) {
        String string = BindingUtil.getSignature((IBinding)iTypeBinding);
        this.removeDeadMethods(string, list);
        this.removeDeadFields(string, list);
        if (this.deadCodeMap.isDeadClass(string)) {
            this.removeInitializerBlocks(list);
        }
        this.initializeFinalFields(list);
    }

    private void finishElimination() {
        this.generatedTypes.clear();
        this.generatedMethods.clear();
    }

    private void removeDeadMethods(String string, List<BodyDeclaration> list) {
        Iterator<BodyDeclaration> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2;
            IMethodBinding iMethodBinding;
            String string3;
            MethodDeclaration methodDeclaration;
            BodyDeclaration bodyDeclaration = iterator.next();
            if (!(bodyDeclaration instanceof MethodDeclaration) || this.generatedMethods.contains(methodDeclaration = (MethodDeclaration)bodyDeclaration) || !this.deadCodeMap.isDeadMethod(string, string3 = this.getProGuardName(iMethodBinding = methodDeclaration.resolveBinding()), string2 = BindingUtil.getSignature((IBinding)iMethodBinding))) continue;
            iterator.remove();
        }
    }

    private void generateMissingMethods(AST aST, ITypeBinding iTypeBinding, List<BodyDeclaration> list) {
        List<List<IMethodBinding>> list2 = this.groupOverrideEquivalentMethods(this.getVisibleMethods(iTypeBinding));
        for (List<IMethodBinding> list3 : list2) {
            assert (list3.size() > 0);
            if (list3.get(0).isConstructor() || this.getConcreteMethod(list3) != null) continue;
            IMethodBinding iMethodBinding = list3.get(0);
            this.generateMethodStub(aST, iTypeBinding, list, iMethodBinding, this.createReturnType(aST, iTypeBinding, list, list3));
        }
    }

    private IMethodBinding getConcreteMethod(List<IMethodBinding> list) {
        if (list.size() == 1 && !Modifier.isAbstract((int)list.get(0).getModifiers())) {
            return list.get(0);
        }
        IMethodBinding iMethodBinding = null;
        for (IMethodBinding iMethodBinding2 : list) {
            int n = iMethodBinding2.getModifiers();
            if (Modifier.isAbstract((int)n) || Modifier.isNative((int)n)) continue;
            if (iMethodBinding == null) {
                iMethodBinding = iMethodBinding2;
                continue;
            }
            throw new AssertionError((Object)"Can't inherit multiple concrete methods with same signature");
        }
        if (iMethodBinding == null) {
            return null;
        }
        for (IMethodBinding iMethodBinding2 : list) {
            if (DeadCodeEliminator.isSubstitutableBy(iMethodBinding.getReturnType()).apply((Object)iMethodBinding2.getReturnType()) && this.compatibleThrowsClauses(iMethodBinding, iMethodBinding2)) continue;
            return null;
        }
        return iMethodBinding;
    }

    private static final Predicate<ITypeBinding> isSubstitutableBy(final ITypeBinding iTypeBinding) {
        return new Predicate<ITypeBinding>(){

            public boolean apply(ITypeBinding iTypeBinding2) {
                return iTypeBinding.isPrimitive() && iTypeBinding.isEqualTo((IBinding)iTypeBinding2) || iTypeBinding.isSubTypeCompatible(iTypeBinding2) || iTypeBinding.isEqualTo((IBinding)iTypeBinding2.getErasure()) || iTypeBinding.getName().equals("void") && iTypeBinding2.getName().equals("void");
            }
        };
    }

    private boolean compatibleThrowsClauses(IMethodBinding iMethodBinding, IMethodBinding iMethodBinding2) {
        for (ITypeBinding iTypeBinding : iMethodBinding.getExceptionTypes()) {
            boolean bl = false;
            for (ITypeBinding iTypeBinding2 : iMethodBinding2.getExceptionTypes()) {
                if (!iTypeBinding.isSubTypeCompatible(iTypeBinding2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private Type createReturnType(AST aST, ITypeBinding iTypeBinding, List<BodyDeclaration> list, List<IMethodBinding> list2) {
        ArrayList arrayList = Lists.newArrayList();
        for (IMethodBinding iMethodBinding : list2) {
            arrayList.add(iMethodBinding.getReturnType());
        }
        return this.createType(aST, iTypeBinding, list, arrayList);
    }

    private List<List<IMethodBinding>> groupOverrideEquivalentMethods(List<IMethodBinding> list) {
        ArrayList arrayList = Lists.newArrayList();
        for (IMethodBinding iMethodBinding : list) {
            List list2 = null;
            for (List list3 : arrayList) {
                IMethodBinding iMethodBinding2 = (IMethodBinding)list3.get(0);
                if (!this.isSubsignature(iMethodBinding, iMethodBinding2) && !this.isSubsignature(iMethodBinding2, iMethodBinding)) continue;
                list2 = list3;
                break;
            }
            if (list2 != null) {
                list2.add(iMethodBinding);
                continue;
            }
            arrayList.add(Lists.newArrayList((Object[])new IMethodBinding[]{iMethodBinding}));
        }
        return arrayList;
    }

    private boolean isSubsignature(IMethodBinding iMethodBinding, IMethodBinding iMethodBinding2) {
        int n;
        if (iMethodBinding.isSubsignature(iMethodBinding2)) {
            return true;
        }
        if (!iMethodBinding.getName().equals(iMethodBinding2.getName()) || iMethodBinding.getParameterTypes().length != iMethodBinding2.getParameterTypes().length || iMethodBinding.getTypeParameters().length != iMethodBinding2.getTypeParameters().length) {
            return false;
        }
        for (n = 0; n < iMethodBinding.getParameterTypes().length; ++n) {
            if (iMethodBinding.getParameterTypes()[n].isEqualTo((IBinding)iMethodBinding2.getParameterTypes()[n])) continue;
            return false;
        }
        for (n = 0; n < iMethodBinding.getTypeParameters().length; ++n) {
            if (iMethodBinding.getTypeParameters()[n].isEqualTo((IBinding)iMethodBinding2.getParameterTypes()[n])) continue;
            return false;
        }
        return true;
    }

    private List<IMethodBinding> getVisibleMethods(ITypeBinding iTypeBinding) {
        ArrayList arrayList = Lists.newArrayList();
        String string = BindingUtil.getSignature((IBinding)iTypeBinding);
        for (IMethodBinding iMethodBinding : iTypeBinding.getDeclaredMethods()) {
            int iTypeBinding2 = iMethodBinding.getModifiers();
            if (this.deadCodeMap.isDeadMethod(string, this.getProGuardName(iMethodBinding), BindingUtil.getSignature((IBinding)iMethodBinding)) || Modifier.isPrivate((int)iTypeBinding2) || Modifier.isStatic((int)iTypeBinding2)) continue;
            arrayList.add(iMethodBinding);
        }
        ArrayList arrayList2 = Lists.newArrayList();
        if (iTypeBinding.getSuperclass() != null) {
            this.collectVisibleMethods(iTypeBinding.getSuperclass(), arrayList2, arrayList);
        }
        for (ITypeBinding iTypeBinding2 : iTypeBinding.getInterfaces()) {
            this.collectVisibleMethods(iTypeBinding2, arrayList2, arrayList);
        }
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    private void collectVisibleMethods(ITypeBinding iTypeBinding, List<IMethodBinding> list, List<IMethodBinding> list2) {
        for (IMethodBinding iMethodBinding : this.getVisibleMethods(iTypeBinding)) {
            if (this.hasOverride(list2, iMethodBinding)) continue;
            list.add(iMethodBinding);
        }
    }

    private boolean hasOverride(List<IMethodBinding> list, IMethodBinding iMethodBinding) {
        for (IMethodBinding iMethodBinding2 : list) {
            if (!iMethodBinding2.overrides(iMethodBinding)) continue;
            return true;
        }
        return false;
    }

    private void generateMethodStub(AST aST, ITypeBinding iTypeBinding, List<BodyDeclaration> list, IMethodBinding iMethodBinding, Type type) {
        MethodDeclaration methodDeclaration = aST.newMethodDeclaration();
        methodDeclaration.setName(aST.newSimpleName(iMethodBinding.getName()));
        methodDeclaration.setReturnType2(type);
        for (ITypeBinding iTypeBinding2 : iMethodBinding.getTypeParameters()) {
            TypeParameter typeParameter = aST.newTypeParameter();
            typeParameter.setName(aST.newSimpleName(iTypeBinding2.getName()));
            for (SingleVariableDeclaration singleVariableDeclaration : iTypeBinding2.getTypeBounds()) {
                ASTUtil.getTypeBounds(typeParameter).add(this.createType(aST, iTypeBinding, (ITypeBinding)singleVariableDeclaration));
            }
            ASTUtil.getTypeParameters(methodDeclaration).add(typeParameter);
        }
        int n = 0;
        for (ITypeBinding iTypeBinding2 : iMethodBinding.getParameterTypes()) {
            SingleVariableDeclaration singleVariableDeclaration = aST.newSingleVariableDeclaration();
            String string = "arg" + n++;
            singleVariableDeclaration.setName(aST.newSimpleName(string));
            singleVariableDeclaration.setType(this.createType(aST, iTypeBinding, iTypeBinding2));
            ASTUtil.getParameters(methodDeclaration).add(singleVariableDeclaration);
        }
        int n2 = iMethodBinding.getModifiers();
        List<IExtendedModifier> list2 = ASTUtil.getModifiers((BodyDeclaration)methodDeclaration);
        list2.add((IExtendedModifier)aST.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        if (Modifier.isStrictfp((int)n2)) {
            list2.add((IExtendedModifier)aST.newModifier(Modifier.ModifierKeyword.STRICTFP_KEYWORD));
        }
        if (Modifier.isSynchronized((int)n2)) {
            list2.add((IExtendedModifier)aST.newModifier(Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD));
        }
        Block block = aST.newBlock();
        methodDeclaration.setBody(block);
        this.addAssertionError(block);
        list.add((BodyDeclaration)methodDeclaration);
        this.generatedMethods.add(methodDeclaration);
    }

    private void addAssertionError(Block block) {
        AST aST = block.getAST();
        ThrowStatement throwStatement = aST.newThrowStatement();
        ASTUtil.getStatements(block).add((Statement)throwStatement);
        ClassInstanceCreation classInstanceCreation = aST.newClassInstanceCreation();
        throwStatement.setExpression((Expression)classInstanceCreation);
        SimpleType simpleType = aST.newSimpleType((Name)aST.newSimpleName("AssertionError"));
        classInstanceCreation.setType((Type)simpleType);
        StringLiteral stringLiteral = aST.newStringLiteral();
        stringLiteral.setLiteralValue("Cannot invoke dead method");
        ASTUtil.getArguments(classInstanceCreation).add((Expression)stringLiteral);
    }

    private void removeDeadFields(String string, List<BodyDeclaration> list) {
        Iterator<BodyDeclaration> iterator = list.iterator();
        while (iterator.hasNext()) {
            BodyDeclaration bodyDeclaration = iterator.next();
            if (!(bodyDeclaration instanceof FieldDeclaration)) continue;
            FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
            Iterator<VariableDeclarationFragment> iterator2 = ASTUtil.getFragments(fieldDeclaration).iterator();
            while (iterator2.hasNext()) {
                VariableDeclarationFragment variableDeclarationFragment = iterator2.next();
                if (variableDeclarationFragment.resolveBinding().getConstantValue() != null || !this.deadCodeMap.isDeadField(string, variableDeclarationFragment.getName().getIdentifier())) continue;
                iterator2.remove();
            }
            if (!fieldDeclaration.fragments().isEmpty()) continue;
            iterator.remove();
        }
    }

    private void initializeFinalFields(List<BodyDeclaration> list) {
        HashSet hashSet = Sets.newHashSet();
        for (BodyDeclaration bodyDeclaration : list) {
            int n;
            MethodDeclaration methodDeclaration;
            if (bodyDeclaration instanceof MethodDeclaration && !this.generatedMethods.contains(methodDeclaration = (MethodDeclaration)bodyDeclaration) && methodDeclaration.isConstructor()) {
                return;
            }
            if (!(bodyDeclaration instanceof FieldDeclaration) || Modifier.isStatic((int)(n = (methodDeclaration = (FieldDeclaration)bodyDeclaration).getModifiers())) || !Modifier.isFinal((int)n)) continue;
            for (VariableDeclarationFragment variableDeclarationFragment : ASTUtil.getFragments((FieldDeclaration)methodDeclaration)) {
                if (variableDeclarationFragment.getInitializer() != null) continue;
                hashSet.add(variableDeclarationFragment);
            }
        }
        for (BodyDeclaration bodyDeclaration : hashSet) {
            if (bodyDeclaration.getInitializer() != null) continue;
            this.addFieldInitializer((VariableDeclarationFragment)bodyDeclaration);
        }
    }

    private void addFieldInitializer(VariableDeclarationFragment variableDeclarationFragment) {
        AST aST = variableDeclarationFragment.getAST();
        ITypeBinding iTypeBinding = ((FieldDeclaration)variableDeclarationFragment.getParent()).getType().resolveBinding();
        variableDeclarationFragment.setInitializer(this.getDefaultValue(aST, iTypeBinding));
    }

    private boolean allMethodsDeadWithName(ITypeBinding iTypeBinding, String string) {
        String string2 = BindingUtil.getSignature((IBinding)iTypeBinding);
        for (IMethodBinding iMethodBinding : iTypeBinding.getDeclaredMethods()) {
            if (!iMethodBinding.getName().equals(string) || this.deadCodeMap.isDeadMethod(string2, string, BindingUtil.getSignature((IBinding)iMethodBinding))) continue;
            return false;
        }
        return true;
    }

    private void removeInitializerBlocks(List<BodyDeclaration> list) {
        Iterator<BodyDeclaration> iterator = list.iterator();
        while (iterator.hasNext()) {
            BodyDeclaration bodyDeclaration = iterator.next();
            if (!(bodyDeclaration instanceof Initializer)) continue;
            iterator.remove();
        }
    }

    private void generateConstructor(TypeDeclaration typeDeclaration) {
        ITypeBinding iTypeBinding = typeDeclaration.resolveBinding();
        IMethodBinding iMethodBinding = this.getVisible(this.getConstructors(iTypeBinding.getSuperclass())).next();
        AST aST = typeDeclaration.getAST();
        MethodDeclaration methodDeclaration = aST.newMethodDeclaration();
        methodDeclaration.setConstructor(true);
        methodDeclaration.setName(aST.newSimpleName(typeDeclaration.getName().getIdentifier()));
        ASTUtil.getModifiers((BodyDeclaration)methodDeclaration).add((IExtendedModifier)aST.newModifier(Modifier.ModifierKeyword.PROTECTED_KEYWORD));
        ASTUtil.getBodyDeclarations((AbstractTypeDeclaration)typeDeclaration).add((BodyDeclaration)methodDeclaration);
        Block block = aST.newBlock();
        methodDeclaration.setBody(block);
        SuperConstructorInvocation superConstructorInvocation = aST.newSuperConstructorInvocation();
        ASTUtil.getStatements(block).add((Statement)superConstructorInvocation);
        this.addAssertionError(block);
        for (ITypeBinding iTypeBinding2 : iMethodBinding.getParameterTypes()) {
            Expression expression = this.getDefaultValue(aST, iTypeBinding2);
            CastExpression castExpression = aST.newCastExpression();
            castExpression.setExpression(expression);
            castExpression.setType(this.createType(aST, iTypeBinding, iTypeBinding2));
            ASTUtil.getArguments(superConstructorInvocation).add((Expression)castExpression);
        }
    }

    private Iterator<IMethodBinding> getConstructors(ITypeBinding iTypeBinding) {
        final String string = BindingUtil.getSignature((IBinding)iTypeBinding);
        return Iterators.filter((Iterator)Iterators.forArray((Object[])iTypeBinding.getDeclaredMethods()), (Predicate)new Predicate<IMethodBinding>(){

            public boolean apply(IMethodBinding iMethodBinding) {
                return iMethodBinding.isConstructor() && !DeadCodeEliminator.this.deadCodeMap.isDeadMethod(string, DeadCodeEliminator.this.getProGuardName(iMethodBinding), BindingUtil.getSignature((IBinding)iMethodBinding));
            }
        });
    }

    private <T extends IBinding> Iterator<T> getVisible(Iterator<T> iterator) {
        return Iterators.filter(iterator, (Predicate)new Predicate<T>(){

            public boolean apply(T t) {
                return !Modifier.isPrivate((int)t.getModifiers());
            }
        });
    }

    private Iterator<IMethodBinding> getWithArity(final int n, Iterator<IMethodBinding> iterator) {
        return Iterators.filter(iterator, (Predicate)new Predicate<IMethodBinding>(){

            public boolean apply(IMethodBinding iMethodBinding) {
                return iMethodBinding.getParameterTypes().length == n;
            }
        });
    }

    private Expression getDefaultValue(AST aST, ITypeBinding iTypeBinding) {
        if (iTypeBinding.isPrimitive()) {
            if (iTypeBinding.getName().equals("boolean")) {
                return aST.newBooleanLiteral(false);
            }
            return aST.newNumberLiteral("0");
        }
        return aST.newNullLiteral();
    }

    private String getProGuardName(IMethodBinding iMethodBinding) {
        if (!iMethodBinding.isConstructor() || !iMethodBinding.getDeclaringClass().isMember()) {
            return iMethodBinding.getName();
        }
        ITypeBinding iTypeBinding = iMethodBinding.getDeclaringClass();
        assert (iTypeBinding != null);
        LinkedList linkedList = Lists.newLinkedList();
        do {
            linkedList.add(0, iTypeBinding.getName());
        } while ((iTypeBinding = iTypeBinding.getDeclaringClass()) != null);
        return innerClassJoiner.join((Iterable)linkedList);
    }

    private boolean inScope(ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2) {
        return iTypeBinding2.equals(iTypeBinding) || iTypeBinding2.getSuperclass() != null && this.inScope(iTypeBinding, iTypeBinding2.getSuperclass()) || Iterables.any(Arrays.asList(iTypeBinding2.getDeclaredTypes()), (Predicate)Predicates.equalTo((Object)iTypeBinding));
    }

    private Type createType(AST aST, ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2) {
        PrimitiveType primitiveType;
        if (iTypeBinding2.isArray()) {
            primitiveType = aST.newArrayType(this.createType(aST, iTypeBinding, iTypeBinding2.getElementType()), iTypeBinding2.getDimensions());
        } else if (iTypeBinding2.isPrimitive()) {
            primitiveType = aST.newPrimitiveType(PrimitiveType.toCode((String)iTypeBinding2.getName()));
        } else if (iTypeBinding2.isWildcardType()) {
            WildcardType wildcardType = aST.newWildcardType();
            ITypeBinding iTypeBinding3 = iTypeBinding2.getBound();
            if (iTypeBinding3 != null) {
                wildcardType.setBound(this.createType(aST, iTypeBinding, iTypeBinding3), iTypeBinding2.isUpperbound());
            }
            primitiveType = wildcardType;
        } else if (!iTypeBinding2.isParameterizedType()) {
            String string = this.inScope(iTypeBinding2, iTypeBinding) ? iTypeBinding2.getName() : iTypeBinding2.getQualifiedName();
            primitiveType = aST.newSimpleType(aST.newName(string));
        } else {
            ITypeBinding[] iTypeBindingArray;
            ITypeBinding iTypeBinding4 = iTypeBinding2.getErasure();
            String string = this.inScope(iTypeBinding2, iTypeBinding) ? iTypeBinding4.getName() : iTypeBinding4.getQualifiedName();
            SimpleType simpleType = aST.newSimpleType(aST.newName(string));
            ParameterizedType parameterizedType = aST.newParameterizedType((Type)simpleType);
            for (ITypeBinding iTypeBinding5 : iTypeBindingArray = iTypeBinding2.getTypeArguments()) {
                ASTUtil.getTypeArguments(parameterizedType).add(this.createType(aST, iTypeBinding, iTypeBinding5));
            }
            primitiveType = parameterizedType;
        }
        this.generatedTypes.put((Type)primitiveType, iTypeBinding2);
        return primitiveType;
    }

    private Type createType(AST aST, ITypeBinding iTypeBinding, List<BodyDeclaration> list, List<ITypeBinding> list2) {
        assert (list2.size() > 0);
        ITypeBinding iTypeBinding2 = null;
        for (ITypeBinding object2 : list2) {
            if (!object2.isPrimitive() && !object2.isArray() && !object2.isEnum()) continue;
            iTypeBinding2 = object2;
            break;
        }
        if (iTypeBinding2 != null) {
            return this.createType(aST, iTypeBinding, iTypeBinding2);
        }
        for (ITypeBinding iTypeBinding3 : list2) {
            if (!Iterables.all(list2, DeadCodeEliminator.isSubstitutableBy(iTypeBinding3))) continue;
            return this.createType(aST, iTypeBinding, iTypeBinding3);
        }
        ITypeBinding iTypeBinding3 = null;
        ArrayList arrayList = Lists.newArrayList();
        for (ITypeBinding iTypeBinding4 : list2) {
            if (iTypeBinding4.isClass()) {
                if (iTypeBinding3 == null) {
                    iTypeBinding3 = iTypeBinding4;
                    continue;
                }
                if (DeadCodeEliminator.isSubstitutableBy(iTypeBinding4).apply((Object)iTypeBinding3)) {
                    iTypeBinding3 = iTypeBinding4;
                    continue;
                }
                if (!DeadCodeEliminator.isSubstitutableBy(iTypeBinding3).apply((Object)iTypeBinding4)) {
                    throw new AssertionError((Object)"Impossible common type: unrelated classes");
                }
                continue;
            }
            assert (iTypeBinding4.isInterface());
            arrayList.add(iTypeBinding4);
        }
        TypeDeclaration typeDeclaration = this.createClass(aST, iTypeBinding, iTypeBinding3, arrayList);
        list.add((BodyDeclaration)typeDeclaration);
        return aST.newSimpleType(aST.newName(typeDeclaration.getName().getFullyQualifiedName()));
    }

    private TypeDeclaration createClass(AST aST, ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2, List<ITypeBinding> list) {
        TypeDeclaration typeDeclaration = aST.newTypeDeclaration();
        if (iTypeBinding2 != null) {
            typeDeclaration.setSuperclassType(this.createType(aST, iTypeBinding, iTypeBinding2));
        }
        for (ITypeBinding iTypeBinding3 : list) {
            ASTUtil.getSuperInterfaceTypes(typeDeclaration).add(this.createType(aST, iTypeBinding, iTypeBinding3));
        }
        ASTUtil.getModifiers((BodyDeclaration)typeDeclaration).add((IExtendedModifier)aST.newModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD));
        typeDeclaration.setName(aST.newSimpleName(DeadCodeEliminator.generateClassName()));
        return typeDeclaration;
    }
}

