/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.gen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.devtools.j2objc.gen.ObjectiveCHeaderGenerator;
import com.google.devtools.j2objc.types.HeaderImportCollector;
import com.google.devtools.j2objc.types.Import;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.NameTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class ObjectiveCSegmentedHeaderGenerator
extends ObjectiveCHeaderGenerator {
    private Map<AbstractTypeDeclaration, HeaderImportCollector> importCollectors = Maps.newHashMap();

    protected ObjectiveCSegmentedHeaderGenerator(String string, String string2, CompilationUnit compilationUnit) {
        super(string, string2, compilationUnit);
    }

    public static void generate(String string, String string2, CompilationUnit compilationUnit) {
        new ObjectiveCSegmentedHeaderGenerator(string, string2, compilationUnit).generate(compilationUnit);
    }

    @Override
    protected void generateFileHeader() {
        this.println("#import \"JreEmulation.h\"");
        this.newline();
        this.printf("#if !%s_RESTRICT\n", this.mainTypeName);
        this.printf("#define %s_INCLUDE_ALL 1\n", this.mainTypeName);
        this.println("#endif");
        this.printf("#undef %s_RESTRICT\n", this.mainTypeName);
        ArrayList arrayList = Lists.newArrayList(ASTUtil.getTypes(this.getUnit()));
        Collections.reverse(arrayList);
        for (AbstractTypeDeclaration abstractTypeDeclaration : arrayList) {
            HeaderImportCollector headerImportCollector = new HeaderImportCollector();
            headerImportCollector.collect((ASTNode)abstractTypeDeclaration);
            this.importCollectors.put(abstractTypeDeclaration, headerImportCollector);
            this.printLocalIncludes(abstractTypeDeclaration, headerImportCollector);
        }
    }

    private void printLocalIncludes(AbstractTypeDeclaration abstractTypeDeclaration, HeaderImportCollector headerImportCollector) {
        ArrayList arrayList = Lists.newArrayList();
        for (Import import_ : headerImportCollector.getSuperTypes()) {
            if (!this.mainTypeName.equals(import_.getMainTypeName())) continue;
            arrayList.add(import_);
        }
        if (!arrayList.isEmpty()) {
            this.printf("#if %s_INCLUDE\n", NameTable.getFullName(abstractTypeDeclaration));
            for (Import import_ : arrayList) {
                this.printf("#define %s_INCLUDE 1\n", import_.getTypeName());
            }
            this.println("#endif");
        }
    }

    @Override
    protected void generateFileFooter() {
    }

    @Override
    public void generate(AbstractTypeDeclaration abstractTypeDeclaration) {
        String string = NameTable.getFullName(abstractTypeDeclaration);
        this.printf("#if !defined (_%s_) && (%s_INCLUDE_ALL || %s_INCLUDE)\n", string, this.mainTypeName, string);
        this.printf("#define _%s_\n", string);
        HeaderImportCollector headerImportCollector = this.importCollectors.get(abstractTypeDeclaration);
        assert (headerImportCollector != null);
        this.newline();
        this.printForwardDeclarations(headerImportCollector.getForwardDeclarations());
        for (Import import_ : headerImportCollector.getSuperTypes()) {
            if (this.mainTypeName.equals(import_.getMainTypeName())) continue;
            this.printf("#define %s_RESTRICT 1\n", import_.getMainTypeName());
            this.printf("#define %s_INCLUDE 1\n", import_.getTypeName());
            this.printf("#include \"%s.h\"\n", import_.getImportFileName());
            this.newline();
        }
        super.generate(abstractTypeDeclaration);
        this.println("#endif");
    }
}

