/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.gen;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.devtools.j2objc.J2ObjC;
import com.google.devtools.j2objc.Options;
import com.google.devtools.j2objc.gen.HiddenFieldDetector;
import com.google.devtools.j2objc.gen.MetadataGenerator;
import com.google.devtools.j2objc.gen.ObjectiveCSourceFileGenerator;
import com.google.devtools.j2objc.gen.StatementGenerator;
import com.google.devtools.j2objc.types.IOSMethod;
import com.google.devtools.j2objc.types.ImplementationImportCollector;
import com.google.devtools.j2objc.types.Import;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.BindingUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import com.google.devtools.j2objc.util.NameTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class ObjectiveCImplementationGenerator
extends ObjectiveCSourceFileGenerator {
    private Set<IVariableBinding> fieldHiders;
    private final String suffix;
    private final Set<String> invokedConstructors = Sets.newHashSet();
    private final ListMultimap<AbstractTypeDeclaration, Comment> blockComments = ArrayListMultimap.create();
    private static final String TYPE_REGEX = "\\([\\w\\s\\*<>\\[\\]]+\\)";
    private static final String PARAM_REGEX = "\\s*:\\s*\\([\\w\\s\\*<>\\[\\]]+\\)\\s*\\w+";
    private static final String ADDITIONAL_PARAM_REGEX = "\\s+(\\w+)\\s*:\\s*\\([\\w\\s\\*<>\\[\\]]+\\)\\s*\\w+";
    private static final Pattern OBJC_METHOD_DECL_PATTERN = Pattern.compile("^\\+|-\\s*\\([\\w\\s\\*<>\\[\\]]+\\)\\s*(\\w+)(\\s*:\\s*\\([\\w\\s\\*<>\\[\\]]+\\)\\s*\\w+((?:\\s+(\\w+)\\s*:\\s*\\([\\w\\s\\*<>\\[\\]]+\\)\\s*\\w+)*))?\\s*\\{");
    private static final Pattern ADDITIONAL_PARAM_PATTERN = Pattern.compile("\\s+(\\w+)\\s*:\\s*\\([\\w\\s\\*<>\\[\\]]+\\)\\s*\\w+");

    public static void generate(String string, J2ObjC.Language language, CompilationUnit compilationUnit, String string2) {
        ObjectiveCImplementationGenerator objectiveCImplementationGenerator = new ObjectiveCImplementationGenerator(string, language, compilationUnit, string2);
        objectiveCImplementationGenerator.generate(compilationUnit);
    }

    private ObjectiveCImplementationGenerator(String string, J2ObjC.Language language, CompilationUnit compilationUnit, String string2) {
        super(string, string2, compilationUnit, Options.emitLineDirectives());
        this.fieldHiders = HiddenFieldDetector.getFieldNameConflicts((ASTNode)compilationUnit);
        this.suffix = language.getSuffix();
    }

    @Override
    protected String getSuffix() {
        return this.suffix;
    }

    public void generate(CompilationUnit compilationUnit) {
        this.println(J2ObjC.getFileHeader(this.getSourceFileName()));
        List<AbstractTypeDeclaration> list = this.collectTypes(compilationUnit);
        if (!list.isEmpty()) {
            this.findBlockComments(compilationUnit, list);
            this.findInvokedConstructors(compilationUnit);
            this.printStart(this.getSourceFileName());
            this.printImports(compilationUnit);
            this.pushIgnoreDeprecatedDeclarationsPragma();
            for (AbstractTypeDeclaration abstractTypeDeclaration : list) {
                this.generate(abstractTypeDeclaration);
            }
            this.popIgnoreDeprecatedDeclarationsPragma();
        } else {
            List<AbstractTypeDeclaration> list2 = ASTUtil.getTypes(compilationUnit);
            if (!list2.isEmpty()) {
                this.printf("void %s_unused() {}\n", NameTable.getFullName(list2.get(0)));
            }
        }
        this.save(compilationUnit);
    }

    private List<AbstractTypeDeclaration> collectTypes(CompilationUnit compilationUnit) {
        final ArrayList arrayList = Lists.newArrayList();
        compilationUnit.accept((ASTVisitor)new ErrorReportingASTVisitor(){

            public boolean visit(TypeDeclaration typeDeclaration) {
                if (!(typeDeclaration.isInterface() && ObjectiveCImplementationGenerator.this.getStaticFieldsNeedingAccessors(Arrays.asList(typeDeclaration.getFields()), true).isEmpty() && Options.stripReflection())) {
                    arrayList.add(typeDeclaration);
                }
                return false;
            }

            public boolean visit(EnumDeclaration enumDeclaration) {
                arrayList.add(enumDeclaration);
                return false;
            }

            public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
                if (BindingUtil.isRuntimeAnnotation(Types.getTypeBinding(annotationTypeDeclaration)) || !ObjectiveCImplementationGenerator.this.getStaticFieldsNeedingAccessors(ASTUtil.getFieldDeclarations((AbstractTypeDeclaration)annotationTypeDeclaration), true).isEmpty()) {
                    arrayList.add(annotationTypeDeclaration);
                }
                return false;
            }
        });
        return arrayList;
    }

    private String parameterKey(IMethodBinding iMethodBinding) {
        StringBuilder stringBuilder = new StringBuilder();
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
        for (int i = 0; i < iTypeBindingArray.length; ++i) {
            if (i == 0) {
                stringBuilder.append(NameTable.capitalize(NameTable.parameterKeyword(iTypeBindingArray[i])));
            } else {
                stringBuilder.append(NameTable.parameterKeyword(iTypeBindingArray[i]));
            }
            stringBuilder.append('_');
        }
        return stringBuilder.toString();
    }

    private String methodKey(IMethodBinding iMethodBinding) {
        StringBuilder stringBuilder = new StringBuilder();
        if (iMethodBinding.isConstructor()) {
            stringBuilder.append(NameTable.getFullName(iMethodBinding.getDeclaringClass()));
        } else {
            stringBuilder.append(NameTable.getName((IBinding)iMethodBinding));
        }
        stringBuilder.append(this.parameterKey(iMethodBinding));
        return stringBuilder.toString();
    }

    private void findInvokedConstructors(CompilationUnit compilationUnit) {
        compilationUnit.accept((ASTVisitor)new ErrorReportingASTVisitor(){

            public boolean visit(ConstructorInvocation constructorInvocation) {
                ObjectiveCImplementationGenerator.this.invokedConstructors.add(ObjectiveCImplementationGenerator.this.methodKey(Types.getMethodBinding(constructorInvocation)));
                return false;
            }
        });
    }

    private void findBlockComments(CompilationUnit compilationUnit, List<AbstractTypeDeclaration> list) {
        List<Comment> list2 = ASTUtil.getCommentList(compilationUnit);
        for (Comment comment : list2) {
            if (!comment.isBlockComment()) continue;
            int n = comment.getStartPosition();
            AbstractTypeDeclaration abstractTypeDeclaration = null;
            int n2 = -1;
            for (AbstractTypeDeclaration abstractTypeDeclaration2 : list) {
                int n3 = abstractTypeDeclaration2.getStartPosition();
                if (n3 < 0) continue;
                int n4 = n3 + abstractTypeDeclaration2.getLength();
                if (n <= n3 || n >= n4 || n3 <= n2) continue;
                abstractTypeDeclaration = abstractTypeDeclaration2;
                n2 = n3;
            }
            if (abstractTypeDeclaration == null) continue;
            this.blockComments.put(abstractTypeDeclaration, (Object)comment);
        }
    }

    @Override
    public void generate(TypeDeclaration typeDeclaration) {
        this.syncLineNumbers((ASTNode)typeDeclaration.getName());
        String string = NameTable.getFullName((AbstractTypeDeclaration)typeDeclaration);
        ArrayList arrayList = Lists.newArrayList((Object[])typeDeclaration.getFields());
        ArrayList arrayList2 = Lists.newArrayList((Object[])typeDeclaration.getMethods());
        this.fieldHiders = HiddenFieldDetector.getFieldNameConflicts((ASTNode)typeDeclaration);
        if (typeDeclaration.isInterface()) {
            this.printStaticInterface((AbstractTypeDeclaration)typeDeclaration, string, arrayList, arrayList2);
        } else {
            this.printf("@implementation %s\n\n", string);
            this.printStaticReferencesMethod(arrayList);
            this.printStaticVars(arrayList, false);
            this.printStaticFieldAccessors(arrayList, arrayList2, false);
            this.printMethods(typeDeclaration);
            if (!Options.stripReflection()) {
                this.printTypeAnnotationsMethod((AbstractTypeDeclaration)typeDeclaration);
                this.printMethodAnnotationMethods(Lists.newArrayList((Object[])typeDeclaration.getMethods()));
                this.printFieldAnnotationMethods(Lists.newArrayList((Object[])typeDeclaration.getFields()));
                this.printMetadata((AbstractTypeDeclaration)typeDeclaration);
            }
            this.println("@end");
        }
    }

    @Override
    protected void generate(AnnotationTypeDeclaration annotationTypeDeclaration) {
        List<Object> list;
        this.syncLineNumbers((ASTNode)annotationTypeDeclaration.getName());
        String string = NameTable.getFullName((AbstractTypeDeclaration)annotationTypeDeclaration);
        this.printf("@implementation %s\n", string);
        if (BindingUtil.isRuntimeAnnotation(Types.getTypeBinding(annotationTypeDeclaration))) {
            list = Lists.newArrayList();
            for (BodyDeclaration bodyDeclaration : ASTUtil.getBodyDeclarations((AbstractTypeDeclaration)annotationTypeDeclaration)) {
                if (!(bodyDeclaration instanceof AnnotationTypeMemberDeclaration)) continue;
                list.add((AnnotationTypeMemberDeclaration)bodyDeclaration);
            }
            this.printAnnotationProperties((List<AnnotationTypeMemberDeclaration>)list);
            if (!list.isEmpty()) {
                this.printAnnotationConstructor(Types.getTypeBinding(annotationTypeDeclaration));
            }
            this.printAnnotationAccessors(list);
        }
        list = ASTUtil.getFieldDeclarations((AbstractTypeDeclaration)annotationTypeDeclaration);
        List<IVariableBinding> list2 = this.getStaticFieldsNeedingAccessors((List<FieldDeclaration>)list, true);
        this.printStaticVars((List<FieldDeclaration>)list, true);
        this.printStaticFieldAccessors(list2, Collections.<MethodDeclaration>emptyList());
        this.println("- (IOSClass *)annotationType {");
        this.printf("  return [IOSClass classWithProtocol:@protocol(%s)];\n", string);
        this.println("}\n");
        if (!Options.stripReflection()) {
            this.printTypeAnnotationsMethod((AbstractTypeDeclaration)annotationTypeDeclaration);
            this.printMetadata((AbstractTypeDeclaration)annotationTypeDeclaration);
        }
        this.println("@end\n");
    }

    private void printAnnotationConstructor(ITypeBinding iTypeBinding) {
        this.print(this.annotationConstructorDeclaration(iTypeBinding));
        this.println(" {");
        this.println("  if ((self = [super init])) {");
        for (IMethodBinding iMethodBinding : iTypeBinding.getDeclaredMethods()) {
            boolean bl;
            String string = iMethodBinding.getName();
            this.printf("    %s = ", string);
            ITypeBinding iTypeBinding2 = iMethodBinding.getReturnType();
            boolean bl2 = bl = !iTypeBinding2.isPrimitive();
            if (bl) {
                this.print("RETAIN_(");
            }
            this.printf("%s_", string);
            if (bl) {
                this.print(')');
            }
            this.println(";");
        }
        this.println("  }");
        this.println("  return self;");
        this.println("}\n");
    }

    private void printAnnotationAccessors(List<AnnotationTypeMemberDeclaration> list) {
        int n = 0;
        for (AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration : list) {
            Expression expression = annotationTypeMemberDeclaration.getDefault();
            if (expression == null) continue;
            ITypeBinding iTypeBinding = Types.getTypeBinding(annotationTypeMemberDeclaration.getType());
            String string = NameTable.getSpecificObjCType(iTypeBinding);
            String string2 = NameTable.getName(annotationTypeMemberDeclaration.getName());
            this.printf("+ (%s)%sDefault {\n", string, string2);
            this.printf("  return %s;\n", this.generateExpression(expression));
            this.println("}\n");
            ++n;
        }
        if (n > 0) {
            this.newline();
        }
    }

    private void findMethodSignatures(String string, Set<String> set) {
        Matcher matcher = OBJC_METHOD_DECL_PATTERN.matcher(string);
        while (matcher.find()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(matcher.group(1));
            if (matcher.group(2) != null) {
                stringBuilder.append(':');
                String string2 = matcher.group(3);
                if (string2 != null) {
                    Matcher matcher2 = ADDITIONAL_PARAM_PATTERN.matcher(string2);
                    while (matcher2.find()) {
                        stringBuilder.append(matcher2.group(1)).append(':');
                    }
                }
            }
            set.add(stringBuilder.toString());
        }
    }

    private void printMethodsAndOcni(AbstractTypeDeclaration abstractTypeDeclaration, Iterable<MethodDeclaration> iterable, Iterable<Comment> iterable2) {
        HashSet hashSet = Sets.newHashSet();
        Iterator<MethodDeclaration> iterator = iterable.iterator();
        Iterator<Comment> iterator2 = iterable2.iterator();
        MethodDeclaration methodDeclaration = iterator.hasNext() ? iterator.next() : null;
        Comment comment = iterator2.hasNext() ? iterator2.next() : null;
        int n = 0;
        while (methodDeclaration != null || comment != null) {
            String string;
            int n2;
            int n3;
            int n4 = n3 = methodDeclaration != null ? methodDeclaration.getStartPosition() : Integer.MAX_VALUE;
            if (n3 < 0) {
                n3 = n;
            }
            int n5 = n2 = comment != null ? comment.getStartPosition() : Integer.MAX_VALUE;
            if (n3 < n2) {
                assert (methodDeclaration != null);
                this.printMethod(methodDeclaration);
                n = n3 + methodDeclaration.getLength();
                methodDeclaration = iterator.hasNext() ? iterator.next() : null;
                continue;
            }
            assert (comment != null);
            if (n2 > n && (string = this.extractNativeCode(n2, comment.getLength())) != null) {
                string = this.reindent(string.trim());
                this.findMethodSignatures(string, hashSet);
                this.print(string + "\n\n");
            }
            comment = iterator2.hasNext() ? iterator2.next() : null;
        }
        if (BindingUtil.findInterface(Types.getTypeBinding(abstractTypeDeclaration), "java.lang.Iterable") != null && !hashSet.contains("countByEnumeratingWithState:objects:count:")) {
            this.print("- (NSUInteger)countByEnumeratingWithState:(NSFastEnumerationState *)state objects:(__unsafe_unretained id *)stackbuf count:(NSUInteger)len {\n  return JreDefaultFastEnumeration(self, state, stackbuf, len);\n}\n\n");
        }
    }

    private void printMethods(TypeDeclaration typeDeclaration) {
        this.printMethodsAndOcni((AbstractTypeDeclaration)typeDeclaration, Arrays.asList(typeDeclaration.getMethods()), this.blockComments.get((Object)typeDeclaration));
        ITypeBinding iTypeBinding = Types.getTypeBinding(typeDeclaration);
        for (ITypeBinding iTypeBinding2 : iTypeBinding.getInterfaces()) {
            if (!iTypeBinding2.getQualifiedName().equals("java.lang.CharSequence")) continue;
            this.println("- (NSString *)description {\n  return [self sequenceDescription];\n}\n");
        }
        List<VariableDeclarationFragment> list = this.getProperties(typeDeclaration.getFields());
        if (list.size() > 0) {
            this.printStrongReferencesMethod(list);
        }
    }

    private List<VariableDeclarationFragment> getProperties(FieldDeclaration[] fieldDeclarationArray) {
        ArrayList arrayList = Lists.newArrayList();
        for (FieldDeclaration fieldDeclaration : fieldDeclarationArray) {
            if (Modifier.isStatic((int)fieldDeclaration.getModifiers())) continue;
            arrayList.addAll(ASTUtil.getFragments(fieldDeclaration));
        }
        return arrayList;
    }

    private boolean isStrongReferenceProperty(VariableDeclarationFragment variableDeclarationFragment) {
        IVariableBinding iVariableBinding = Types.getVariableBinding(variableDeclarationFragment);
        ITypeBinding iTypeBinding = Types.getTypeBinding(variableDeclarationFragment);
        return !iTypeBinding.isPrimitive() && !BindingUtil.isWeakReference(iVariableBinding);
    }

    private void printStrongReferencesMethod(List<VariableDeclarationFragment> list) {
        if (Options.memoryDebug()) {
            if (!Options.useReferenceCounting()) {
                this.println("- (NSArray *)memDebugStrongReferences {");
                this.println("  return nil;");
                this.println("}");
                return;
            }
            this.println("- (NSArray *)memDebugStrongReferences {");
            this.println("  NSMutableArray *result =");
            this.println("      [[[super memDebugStrongReferences] mutableCopy] autorelease];");
            for (VariableDeclarationFragment variableDeclarationFragment : list) {
                String string = NameTable.getName(variableDeclarationFragment.getName());
                String string2 = NameTable.javaFieldToObjC(string);
                if (!this.isStrongReferenceProperty(variableDeclarationFragment)) continue;
                this.println(String.format("  [result addObject:[JreMemDebugStrongReference strongReferenceWithObject:%s name:@\"%s\"]];", string2, string));
            }
            this.println("  return result;");
            this.println("}\n");
        }
    }

    private void printStaticReferencesMethod(List<FieldDeclaration> list) {
        this.printStaticReferencesMethod(list, null);
    }

    private void printStaticReferencesMethod(List<FieldDeclaration> list, String string) {
        if (Options.memoryDebug()) {
            if (!Options.useReferenceCounting()) {
                this.println("+ (NSArray *)memDebugStaticReferences {");
                this.println("  return nil;");
                this.println("}");
                return;
            }
            this.println("+ (NSArray *)memDebugStaticReferences {");
            this.println("  NSMutableArray *result = [NSMutableArray array];");
            for (FieldDeclaration fieldDeclaration : list) {
                if (!Modifier.isStatic((int)fieldDeclaration.getModifiers())) continue;
                for (VariableDeclarationFragment variableDeclarationFragment : ASTUtil.getFragments(fieldDeclaration)) {
                    IVariableBinding iVariableBinding = Types.getVariableBinding(variableDeclarationFragment);
                    if (iVariableBinding.getType().isPrimitive()) continue;
                    String string2 = NameTable.getStaticVarQualifiedName(iVariableBinding);
                    this.println(String.format("  [result addObject:[JreMemDebugStrongReference strongReferenceWithObject:%s name:@\"%s\"]];", string2, string2));
                }
            }
            if (string != null) {
                this.println(String.format("  [result addObject:[JreMemDebugStrongReference strongReferenceWithObject:%s name:@\"enumValues\"]];", string));
            }
            this.println("  return result;");
            this.println("}\n");
        }
    }

    private void printStaticInterface(AbstractTypeDeclaration abstractTypeDeclaration, String string, List<FieldDeclaration> list, List<MethodDeclaration> list2) {
        List<IVariableBinding> list3 = this.getStaticFieldsNeedingAccessors(list, true);
        if (list3.isEmpty()) {
            if (!Options.stripReflection()) {
                this.printf("\n@interface %s : NSObject\n@end\n", string);
            } else {
                return;
            }
        }
        this.printf("\n@implementation %s\n\n", string);
        this.printStaticVars(list, true);
        this.printStaticFieldAccessors(list3, list2);
        for (MethodDeclaration methodDeclaration : list2) {
            if (methodDeclaration.getBody() == null) continue;
            this.printNormalMethod(methodDeclaration);
        }
        if (!Options.stripReflection()) {
            this.printMetadata(abstractTypeDeclaration);
        }
        this.println("@end");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void generate(EnumDeclaration enumDeclaration) {
        void var8_17;
        List<EnumConstantDeclaration> list = ASTUtil.getEnumConstants(enumDeclaration);
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        MethodDeclaration methodDeclaration = null;
        for (BodyDeclaration object22 : ASTUtil.getBodyDeclarations((AbstractTypeDeclaration)enumDeclaration)) {
            if (object22 instanceof FieldDeclaration) {
                arrayList2.add((FieldDeclaration)object22);
                continue;
            }
            if (!(object22 instanceof MethodDeclaration)) continue;
            MethodDeclaration methodDeclaration2 = (MethodDeclaration)object22;
            if (methodDeclaration2.getName().getIdentifier().equals("initialize")) {
                methodDeclaration = methodDeclaration2;
                continue;
            }
            arrayList.add(methodDeclaration2);
        }
        this.syncLineNumbers((ASTNode)enumDeclaration.getName());
        String string = NameTable.getFullName((AbstractTypeDeclaration)enumDeclaration);
        this.newline();
        for (EnumConstantDeclaration enumConstantDeclaration : list) {
            IVariableBinding iVariableBinding = Types.getVariableBinding(enumConstantDeclaration.getName());
            this.printf("static %s *%s;\n", string, NameTable.getStaticVarQualifiedName(iVariableBinding));
        }
        this.printf("IOSObjectArray *%s_values;\n", string);
        this.newline();
        this.printf("@implementation %s\n\n", string);
        this.printStaticVars(arrayList2, false);
        this.printStaticReferencesMethod(arrayList2, (String)string + "_values");
        for (EnumConstantDeclaration enumConstantDeclaration : list) {
            String string2 = NameTable.getName(enumConstantDeclaration.getName());
            this.printf("+ (%s *)%s {\n", string, string2);
            this.printf("  return %s_%s;\n", string, string2);
            this.println("}");
        }
        this.newline();
        String string3 = Options.useReferenceCounting() ? "[self retain]" : "self";
        this.printf("- (id)copyWithZone:(NSZone *)zone {\n  return %s;\n}\n\n", string3);
        this.printStaticFieldAccessors(arrayList2, arrayList, false);
        this.printMethodsAndOcni((AbstractTypeDeclaration)enumDeclaration, arrayList, this.blockComments.get((Object)enumDeclaration));
        this.printf("+ (void)initialize {\n  if (self == [%s class]) {\n", string);
        boolean bl = false;
        while (var8_17 < list.size()) {
            EnumConstantDeclaration enumConstantDeclaration = list.get((int)var8_17);
            List<Expression> list2 = ASTUtil.getArguments(enumConstantDeclaration);
            String string4 = NameTable.getName(enumConstantDeclaration.getName());
            String string5 = NameTable.getFullName(Types.getMethodBinding(enumConstantDeclaration).getDeclaringClass());
            this.printf("    %s_%s = [[%s alloc] init", string, string4, string5);
            if (list2.isEmpty()) {
                this.print("With");
            } else {
                this.print(StatementGenerator.generateArguments(Types.getMethodBinding(enumConstantDeclaration), list2, this.fieldHiders, this.getBuilder().getSourcePosition()));
                this.print(" with");
            }
            this.printf("NSString:@\"%s\" withInt:%d];\n", string4, (int)var8_17);
            ++var8_17;
        }
        this.printf("    %s_values = [[IOSObjectArray alloc] initWithObjects:(id[]){ ", string);
        for (EnumConstantDeclaration enumConstantDeclaration : list) {
            this.printf("%s_%s, ", string, NameTable.getName(enumConstantDeclaration.getName()));
        }
        this.printf("nil } count:%d type:[IOSClass classWithClass:[%s class]]];\n", list.size(), string);
        if (methodDeclaration != null) {
            for (Statement statement : ASTUtil.getStatements(methodDeclaration.getBody())) {
                this.printf("    %s", StatementGenerator.generate((ASTNode)statement, this.fieldHiders, false, this.getBuilder().getSourcePosition()));
            }
        }
        this.println("  }\n}\n");
        this.println("+ (IOSObjectArray *)values {");
        this.printf("  return [IOSObjectArray arrayWithArray:%s_values];\n", string);
        this.println("}\n");
        this.printf("+ (%s *)valueOfWithNSString:(NSString *)name {\n", string);
        this.printf("  for (int i = 0; i < [%s_values count]; i++) {\n", string);
        this.printf("    %s *e = %s_values->buffer_[i];\n", string, string);
        this.printf("    if ([name isEqual:[e name]]) {\n", new Object[0]);
        this.printf("      return e;\n", new Object[0]);
        this.printf("    }\n", new Object[0]);
        this.printf("  }\n", new Object[0]);
        if (Options.useReferenceCounting()) {
            this.printf("  @throw [[[JavaLangIllegalArgumentException alloc] initWithNSString:name] autorelease];\n", new Object[0]);
        } else {
            this.printf("  @throw [[JavaLangIllegalArgumentException alloc] initWithNSString:name];\n", new Object[0]);
        }
        this.printf("  return nil;\n", new Object[0]);
        this.println("}\n");
        if (!Options.stripReflection()) {
            this.printTypeAnnotationsMethod((AbstractTypeDeclaration)enumDeclaration);
            this.printMetadata((AbstractTypeDeclaration)enumDeclaration);
        }
        this.println("@end");
    }

    @Override
    protected void printStaticFieldGetter(IVariableBinding iVariableBinding) {
        if (!BindingUtil.isPrivate((IBinding)iVariableBinding)) {
            String string = BindingUtil.isPrimitiveConstant(iVariableBinding) ? NameTable.getPrimitiveConstantName(iVariableBinding) : NameTable.getStaticVarQualifiedName(iVariableBinding);
            this.printf("%s {\n  return %s;\n}\n\n", this.staticFieldGetterSignature(iVariableBinding), string);
        }
    }

    @Override
    protected void printStaticFieldReferenceGetter(IVariableBinding iVariableBinding) {
        this.printf("%s {\n  return &%s;\n}\n\n", this.staticFieldReferenceGetterSignature(iVariableBinding), NameTable.getStaticVarQualifiedName(iVariableBinding));
    }

    @Override
    protected void printStaticFieldSetter(IVariableBinding iVariableBinding) {
        String string = NameTable.getStaticVarQualifiedName(iVariableBinding);
        String string2 = NameTable.getName((IBinding)iVariableBinding);
        String string3 = this.staticFieldSetterSignature(iVariableBinding);
        if (Options.useReferenceCounting()) {
            this.printf("%s {\n  JreOperatorRetainedAssign(&%s, nil, %s);\n}\n\n", string3, string, string2);
        } else {
            this.printf("%s {\n  %s = %s;\n}\n\n", string3, string, string2);
        }
    }

    @Override
    protected String methodDeclaration(MethodDeclaration methodDeclaration) {
        String string = this.generateMethodBody(methodDeclaration);
        if (string == null) {
            return "";
        }
        return super.methodDeclaration(methodDeclaration) + " " + this.reindent(string) + "\n\n";
    }

    private String generateNativeStub(MethodDeclaration methodDeclaration) {
        IMethodBinding iMethodBinding = Types.getMethodBinding(methodDeclaration);
        String string = NameTable.getName((IBinding)iMethodBinding);
        return String.format("{\n  @throw \"%s method not implemented\";\n}", string);
    }

    @Override
    protected String mappedMethodDeclaration(MethodDeclaration methodDeclaration, IOSMethod iOSMethod) {
        String string = this.generateMethodBody(methodDeclaration);
        if (string == null) {
            return "";
        }
        return super.mappedMethodDeclaration(methodDeclaration, iOSMethod) + " " + this.reindent(string) + "\n\n";
    }

    /*
     * Enabled aggressive block sorting
     */
    private String generateMethodBody(MethodDeclaration methodDeclaration) {
        boolean bl;
        String string;
        if (Modifier.isNative((int)methodDeclaration.getModifiers())) {
            if (!this.hasNativeCode(methodDeclaration, true)) {
                if (!Options.generateNativeStubs()) return null;
                return this.generateNativeStub(methodDeclaration);
            }
            string = this.extractNativeMethodBody(methodDeclaration);
        } else {
            if (Modifier.isAbstract((int)methodDeclaration.getModifiers())) {
                String string2 = "{\n // can't call an abstract method\n [self doesNotRecognizeSelector:_cmd];\n ";
                if (Types.isVoidType(methodDeclaration.getReturnType2())) return string2 + "}";
                string2 = string2 + "return 0;\n";
                return string2 + "}";
            }
            string = this.generateStatement((Statement)methodDeclaration.getBody(), false);
        }
        boolean bl2 = (methodDeclaration.getModifiers() & 8) != 0;
        boolean bl3 = bl = (methodDeclaration.getModifiers() & 0x20) != 0;
        if (bl2 && bl) {
            return "{\n@synchronized([self class]) {\n" + string + "}\n}\n";
        }
        if (!bl) return string;
        return "{\n@synchronized(self) {\n" + string + "}\n}\n";
    }

    @Override
    protected String getParameterName(SingleVariableDeclaration singleVariableDeclaration) {
        String string = super.getParameterName(singleVariableDeclaration);
        IVariableBinding iVariableBinding = Types.getVariableBinding(singleVariableDeclaration);
        return iVariableBinding != null && this.fieldHiders.contains(iVariableBinding) ? string + "Arg" : string;
    }

    private static int findConstructorInvocation(List<Statement> list) {
        for (int i = 0; i < list.size(); ++i) {
            Statement statement = list.get(i);
            if (!(statement instanceof ConstructorInvocation) && !(statement instanceof SuperConstructorInvocation)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected String constructorDeclaration(MethodDeclaration methodDeclaration) {
        String string;
        IMethodBinding iMethodBinding = Types.getMethodBinding(methodDeclaration);
        boolean bl = Options.memoryDebug();
        List<Statement> list = ASTUtil.getStatements(methodDeclaration.getBody());
        if (iMethodBinding.getDeclaringClass().isEnum()) {
            return this.enumConstructorDeclaration(methodDeclaration, list, iMethodBinding);
        }
        StringBuffer stringBuffer = new StringBuffer("{\n");
        int n = ObjectiveCImplementationGenerator.findConstructorInvocation(list);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.generateStatement(list.get(n2++), false));
        }
        String string2 = string = n2 == n ? this.generateStatement(list.get(n2++), false) : "[super init]";
        if (n2 >= list.size()) {
            stringBuffer.append("return ");
            if (bl) {
                stringBuffer.append("JreMemDebugAdd(");
            }
            stringBuffer.append(string).append(bl ? ");\n}" : ";\n}");
        } else {
            stringBuffer.append("if (self = ").append(string).append(") {\n");
            while (n2 < list.size()) {
                stringBuffer.append(this.generateStatement(list.get(n2++), false));
            }
            if (bl) {
                stringBuffer.append("JreMemDebugAdd(self);\n");
            }
            stringBuffer.append("}\nreturn self;\n}");
        }
        String string3 = stringBuffer.toString();
        if (this.invokedConstructors.contains(this.methodKey(iMethodBinding))) {
            return super.constructorDeclaration(methodDeclaration, true) + " " + this.reindent(string3) + "\n\n" + super.constructorDeclaration(methodDeclaration, false) + " {\n  return " + this.generateStatement(this.createInnerConstructorInvocation(methodDeclaration), false) + ";\n}\n\n";
        }
        return super.constructorDeclaration(methodDeclaration, false) + " " + this.reindent(string3) + "\n\n";
    }

    private Statement createInnerConstructorInvocation(MethodDeclaration methodDeclaration) {
        ConstructorInvocation constructorInvocation = methodDeclaration.getAST().newConstructorInvocation();
        Types.addBinding(constructorInvocation, Types.getBinding(methodDeclaration));
        for (SingleVariableDeclaration singleVariableDeclaration : ASTUtil.getParameters(methodDeclaration)) {
            SimpleName simpleName = singleVariableDeclaration.getName();
            IVariableBinding iVariableBinding = Types.getVariableBinding(simpleName);
            SimpleName simpleName2 = methodDeclaration.getAST().newSimpleName(simpleName.getIdentifier());
            Types.addBinding(simpleName2, (IBinding)iVariableBinding);
            ASTUtil.getArguments(constructorInvocation).add((Expression)simpleName2);
        }
        return constructorInvocation;
    }

    private String enumConstructorDeclaration(MethodDeclaration methodDeclaration, List<Statement> list, IMethodBinding iMethodBinding) {
        assert (!list.isEmpty());
        Statement statement = list.get(0);
        assert (statement instanceof ConstructorInvocation || statement instanceof SuperConstructorInvocation);
        String string = this.generateStatement(list.get(0), false);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = Options.memoryDebug();
        if (list.size() == 1) {
            stringBuffer.append("{\nreturn ");
            if (bl) {
                stringBuffer.append("JreMemDebugAdd(" + string + ")");
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(";\n}");
        } else {
            stringBuffer.append("{\nif ((self = ");
            stringBuffer.append(string);
            stringBuffer.append(")) {\n");
            for (int i = 1; i < list.size(); ++i) {
                stringBuffer.append(this.generateStatement(list.get(i), false));
            }
            if (bl) {
                stringBuffer.append("JreMemDebugAdd(self);\n");
            }
            stringBuffer.append("}\nreturn self;\n}");
        }
        if (this.invokedConstructors.contains(this.methodKey(iMethodBinding))) {
            return super.constructorDeclaration(methodDeclaration, true) + " " + this.reindent(stringBuffer.toString()) + "\n\n" + super.constructorDeclaration(methodDeclaration, false) + " {\n  return " + this.generateStatement(this.createInnerConstructorInvocation(methodDeclaration), false) + ";\n}\n\n";
        }
        return super.constructorDeclaration(methodDeclaration, false) + " " + this.reindent(stringBuffer.toString()) + "\n\n";
    }

    @Override
    protected void printStaticConstructorDeclaration(MethodDeclaration methodDeclaration) {
        String string = NameTable.getFullName(Types.getMethodBinding(methodDeclaration).getDeclaringClass());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{\nif (self == [" + string + " class]) {\n");
        for (Statement statement : ASTUtil.getStatements(methodDeclaration.getBody())) {
            stringBuffer.append(this.generateStatement(statement, false));
        }
        stringBuffer.append("}\n}");
        this.print("+ (void)initialize " + this.reindent(stringBuffer.toString()) + "\n\n");
    }

    private String generateStatement(Statement statement, boolean bl) {
        return StatementGenerator.generate((ASTNode)statement, this.fieldHiders, bl, this.getBuilder().getSourcePosition());
    }

    private String generateExpression(Expression expression) {
        return StatementGenerator.generate((ASTNode)expression, this.fieldHiders, false, this.getBuilder().getSourcePosition());
    }

    private String extractNativeMethodBody(MethodDeclaration methodDeclaration) {
        assert ((methodDeclaration.getModifiers() & 0x100) > 0);
        String string = this.extractNativeCode(methodDeclaration.getStartPosition(), methodDeclaration.getLength());
        if (string == null) {
            J2ObjC.warning((ASTNode)methodDeclaration, "no native code found");
            return "";
        }
        return '{' + string + '}';
    }

    private void printImports(CompilationUnit compilationUnit) {
        ImplementationImportCollector implementationImportCollector = new ImplementationImportCollector();
        implementationImportCollector.collect(compilationUnit, this.getSourceFileName());
        Set<Import> set = implementationImportCollector.getImports();
        if (!set.isEmpty()) {
            Comment comment;
            int n;
            TreeSet treeSet = Sets.newTreeSet();
            for (Import iterator2 : set) {
                treeSet.add(String.format("#include \"%s.h\"", iterator2.getImportFileName()));
            }
            for (String string : treeSet) {
                this.println(string);
            }
            int n2 = compilationUnit.types().isEmpty() ? compilationUnit.getLength() : ((ASTNode)compilationUnit.types().get(0)).getStartPosition();
            Iterator<Comment> iterator = ASTUtil.getCommentList(compilationUnit).iterator();
            while (iterator.hasNext() && (n = (comment = iterator.next()).getStartPosition()) < n2) {
                String string;
                if (!(comment instanceof BlockComment) || (string = this.extractNativeCode(n, comment.getLength(), true)) == null) continue;
                this.println(string.trim());
            }
            this.newline();
        }
    }

    private void printStaticVars(List<FieldDeclaration> list, boolean bl) {
        boolean bl2 = false;
        for (FieldDeclaration fieldDeclaration : list) {
            if (!Modifier.isStatic((int)fieldDeclaration.getModifiers()) && !bl) continue;
            for (VariableDeclarationFragment variableDeclarationFragment : ASTUtil.getFragments(fieldDeclaration)) {
                IVariableBinding iVariableBinding = Types.getVariableBinding(variableDeclarationFragment);
                if (BindingUtil.isPrimitiveConstant(iVariableBinding)) continue;
                String string = NameTable.getStaticVarQualifiedName(iVariableBinding);
                String string2 = NameTable.getObjCType(iVariableBinding.getType());
                Expression expression = variableDeclarationFragment.getInitializer();
                if (expression != null) {
                    this.printf("static %s %s = %s;\n", string2, string, this.generateExpression(expression));
                } else {
                    this.printf("static %s %s;\n", string2, string);
                }
                bl2 = true;
            }
        }
        if (bl2) {
            this.newline();
        }
    }

    private void printAnnotationProperties(List<AnnotationTypeMemberDeclaration> list) {
        int n = 0;
        for (AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration : list) {
            this.println(String.format("@synthesize %s;", NameTable.getName(annotationTypeMemberDeclaration.getName())));
            ++n;
        }
        if (n > 0) {
            this.newline();
        }
    }

    private void printTypeAnnotationsMethod(AbstractTypeDeclaration abstractTypeDeclaration) {
        List<Annotation> list = ASTUtil.getRuntimeAnnotations(ASTUtil.getModifiers((BodyDeclaration)abstractTypeDeclaration));
        if (list.size() > 0) {
            this.println("+ (IOSObjectArray *)__annotations {");
            this.printAnnotationCreate(list);
        }
    }

    private void printMethodAnnotationMethods(List<MethodDeclaration> list) {
        for (MethodDeclaration methodDeclaration : list) {
            List<Annotation> list2 = ASTUtil.getRuntimeAnnotations(ASTUtil.getModifiers((BodyDeclaration)methodDeclaration));
            if (list2.size() > 0) {
                this.printf("+ (IOSObjectArray *)__annotations_%s {\n", this.methodKey(Types.getMethodBinding(methodDeclaration)));
                this.printAnnotationCreate(list2);
            }
            this.printParameterAnnotationMethods(methodDeclaration);
        }
    }

    private void printParameterAnnotationMethods(MethodDeclaration methodDeclaration) {
        List<Annotation> list;
        List<SingleVariableDeclaration> list2 = ASTUtil.getParameters(methodDeclaration);
        boolean bl = false;
        for (SingleVariableDeclaration singleVariableDeclaration : list2) {
            list = ASTUtil.getRuntimeAnnotations(ASTUtil.getModifiers(singleVariableDeclaration));
            if (list.size() <= 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.printf("+ (IOSObjectArray *)__annotations_%s_params {\n", this.methodKey(Types.getMethodBinding(methodDeclaration)));
            this.print("  return [IOSObjectArray arrayWithObjects:(id[]) { ");
            for (int i = 0; i < list2.size(); ++i) {
                SingleVariableDeclaration singleVariableDeclaration;
                if (i > 0) {
                    this.print(", ");
                }
                if ((list = ASTUtil.getRuntimeAnnotations(ASTUtil.getModifiers(singleVariableDeclaration = list2.get(i)))).size() > 0) {
                    this.print("[IOSObjectArray arrayWithObjects:(id[]) { ");
                    this.printAnnotations(list);
                    this.printf(" } count:%d type:[IOSClass classWithProtocol:@protocol(JavaLangAnnotationAnnotation)]]", list.size());
                    continue;
                }
                this.print("[IOSObjectArray arrayWithLength:0 type:[IOSClass classWithProtocol:@protocol(JavaLangAnnotationAnnotation)]]");
            }
            this.printf(" } count:%d type:[IOSClass classWithProtocol:@protocol(JavaLangAnnotationAnnotation)]];\n}\n", list2.size());
        }
    }

    private void printFieldAnnotationMethods(List<FieldDeclaration> list) {
        for (FieldDeclaration fieldDeclaration : list) {
            List<Annotation> list2 = ASTUtil.getRuntimeAnnotations(ASTUtil.getModifiers((BodyDeclaration)fieldDeclaration));
            if (list2.size() <= 0) continue;
            for (VariableDeclarationFragment variableDeclarationFragment : ASTUtil.getFragments(fieldDeclaration)) {
                this.printf("+ (IOSObjectArray *)__annotations_%s_ {\n", variableDeclarationFragment.getName().getIdentifier());
                this.printAnnotationCreate(list2);
            }
        }
    }

    private void printAnnotationCreate(List<Annotation> list) {
        this.print("  return [IOSObjectArray arrayWithObjects:(id[]) { ");
        this.printAnnotations(list);
        this.printf(" } count:%d type:[IOSClass classWithProtocol:@protocol(JavaLangAnnotationAnnotation)]];\n}\n\n", list.size());
    }

    private void printAnnotations(List<Annotation> list) {
        boolean bl = true;
        for (Annotation annotation : list) {
            if (bl) {
                bl = false;
            } else {
                this.print(", ");
            }
            if (Options.useReferenceCounting()) {
                this.print('[');
            }
            this.printf("[[%s alloc] init", NameTable.getFullName(Types.getTypeBinding(annotation)));
            this.printAnnotationParameters(annotation);
            this.print(']');
            if (!Options.useReferenceCounting()) continue;
            this.print(" autorelease]");
        }
    }

    private void printAnnotationParameters(Annotation annotation) {
        IAnnotationBinding iAnnotationBinding = Types.getAnnotationBinding(annotation);
        IMemberValuePairBinding[] iMemberValuePairBindingArray = BindingUtil.getSortedMemberValuePairs(iAnnotationBinding);
        for (int i = 0; i < iMemberValuePairBindingArray.length; ++i) {
            if (i > 0) {
                this.print(' ');
            }
            IMemberValuePairBinding iMemberValuePairBinding = iMemberValuePairBindingArray[i];
            this.print(i == 0 ? "With" : "with");
            this.printf("%s:", NameTable.capitalize(iMemberValuePairBinding.getName()));
            Object object = iMemberValuePairBinding.getValue();
            this.printAnnotationValue(annotation.getAST(), object);
        }
    }

    private void printAnnotationValue(AST aST, Object object) {
        if (object == null) {
            this.print("nil");
        } else if (object instanceof IVariableBinding) {
            IVariableBinding iVariableBinding = (IVariableBinding)object;
            ITypeBinding iTypeBinding = iVariableBinding.getDeclaringClass();
            this.printf("[%s %s]", NameTable.getFullName(iTypeBinding), iVariableBinding.getName());
        } else if (object instanceof ITypeBinding) {
            ITypeBinding iTypeBinding = (ITypeBinding)object;
            this.printf("[[%s class] getClass]", NameTable.getFullName(iTypeBinding));
        } else if (object instanceof String) {
            StringLiteral stringLiteral = aST.newStringLiteral();
            stringLiteral.setLiteralValue((String)object);
            this.print(StatementGenerator.generateStringLiteral(stringLiteral));
        } else if (object instanceof Number || object instanceof Character || object instanceof Boolean) {
            this.print(object.toString());
        } else if (object.getClass().isArray()) {
            this.print("[IOSObjectArray arrayWithObjects:(id[]) { ");
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    this.print(", ");
                }
                this.printAnnotationValue(aST, objectArray[i]);
            }
            this.printf(" } count:%d type:[[NSObject class] getClass]]", objectArray.length);
        } else assert (false) : "unknown annotation value type";
    }

    private void printMetadata(AbstractTypeDeclaration abstractTypeDeclaration) {
        this.print(new MetadataGenerator(abstractTypeDeclaration).getMetadataSource());
    }
}

