/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.Compiler;
import clojure.lang.URLClassLoader;
import clojure.lang.Util;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class DynamicClassLoader
extends URLClassLoader {
    HashMap<Integer, Object[]> constantVals = new HashMap();
    static ConcurrentHashMap<String, Reference<Class>> classCache = new ConcurrentHashMap();
    static final URL[] EMPTY_URLS = new URL[0];
    static final ReferenceQueue rq = new ReferenceQueue();

    public DynamicClassLoader() {
        super(EMPTY_URLS, Thread.currentThread().getContextClassLoader() == null || Thread.currentThread().getContextClassLoader() == ClassLoader.getSystemClassLoader() ? Compiler.class.getClassLoader() : Thread.currentThread().getContextClassLoader());
    }

    public DynamicClassLoader(ClassLoader parent) {
        super(EMPTY_URLS, parent);
    }

    public Class defineClass(String name, byte[] bytes, Object srcForm) {
        Util.clearCache(rq, classCache);
        Class<?> c = this.defineClass(name, bytes, 0, bytes.length);
        classCache.put(name, new SoftReference(c, rq));
        return c;
    }

    static Class<?> findInMemoryClass(String name) {
        Reference<Class> cr = classCache.get(name);
        if (cr != null) {
            Class c = cr.get();
            if (c != null) {
                return c;
            }
            classCache.remove(name, cr);
        }
        return null;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> c = DynamicClassLoader.findInMemoryClass(name);
        if (c != null) {
            return c;
        }
        return super.findClass(name);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null && (c = DynamicClassLoader.findInMemoryClass(name)) == null) {
            c = super.loadClass(name, false);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public void registerConstants(int id, Object[] val) {
        this.constantVals.put(id, val);
    }

    public Object[] getConstants(int id) {
        return this.constantVals.get(id);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }
}

