/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AReference;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.ObjC;
import clojure.lang.PersistentHashSet;
import clojure.lang.RT;
import clojure.lang.Sequential;
import clojure.lang.Symbol;
import clojure.lang.Var;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class Namespace
extends AReference
implements Serializable {
    public final Symbol name;
    final transient AtomicReference<IPersistentMap> mappings = new AtomicReference();
    final transient AtomicReference<IPersistentMap> aliases = new AtomicReference();
    final transient AtomicReference<IPersistentMap> refers = new AtomicReference();
    static final ConcurrentHashMap<Symbol, Namespace> namespaces = new ConcurrentHashMap();
    static Keyword only = Keyword.intern("only");
    static Keyword onlyAndRefer = Keyword.intern("onlyAndRefer");
    static Keyword refer = Keyword.intern("refer");
    static Keyword exclude = Keyword.intern("exclude");
    static Keyword allkeyword = Keyword.intern("all");
    static Keyword rename = Keyword.intern("rename");

    public String toString() {
        return this.name.toString();
    }

    Namespace(Symbol name) {
        super(name.meta());
        this.name = name;
        this.mappings.set(RT.DEFAULT_IMPORTS);
        this.aliases.set(RT.map(new Object[0]));
        this.refers.set(RT.map(new Object[0]));
        if (!name.name.equals("clojure.core")) {
            this.referNs(RT.CLOJURE_NS, RT.map(new Object[0]));
        }
    }

    public static ISeq all() {
        return RT.seq(namespaces.values());
    }

    public Symbol getName() {
        return this.name;
    }

    public IPersistentMap getMappings() {
        return this.mappings.get();
    }

    public Var intern(Symbol sym) {
        Object o;
        if (sym.ns != null) {
            throw new IllegalArgumentException("Can't intern namespace-qualified symbol");
        }
        IPersistentMap map = this.getMappings();
        Var v = null;
        while ((o = map.valAt(sym)) == null) {
            if (v == null) {
                v = new Var(this, sym);
            }
            IPersistentMap newMap = map.assoc(sym, v);
            this.mappings.compareAndSet(map, newMap);
            map = this.getMappings();
        }
        if (o instanceof Var && ((Var)o).ns == this) {
            return (Var)o;
        }
        if (v == null) {
            v = new Var(this, sym);
        }
        while (!this.mappings.compareAndSet(map, map.assoc(sym, v))) {
            map = this.getMappings();
        }
        return v;
    }

    private void warnOrFailOnReplace(Symbol sym, Object o, Object v) {
        if (o instanceof Var) {
            Namespace ns = ((Var)o).ns;
            if (ns == this || v instanceof Var && ((Var)v).ns == RT.CLOJURE_NS) {
                return;
            }
            if (ns != RT.CLOJURE_NS) {
                throw new IllegalStateException(sym + " already refers to: " + o + " in namespace: " + this.name);
            }
        }
        RT.errPrintWriter().println("WARNING: " + sym + " already refers to: " + o + " in namespace: " + this.name + ", being replaced by: " + v);
    }

    Object reference(Symbol sym, Object val) {
        Object o;
        if (sym.ns != null) {
            throw new IllegalArgumentException("Can't intern namespace-qualified symbol");
        }
        IPersistentMap map = this.getMappings();
        while ((o = map.valAt(sym)) == null) {
            IPersistentMap newMap = map.assoc(sym, val);
            this.mappings.compareAndSet(map, newMap);
            map = this.getMappings();
        }
        if (o == val) {
            return o;
        }
        this.warnOrFailOnReplace(sym, o, val);
        while (!this.mappings.compareAndSet(map, map.assoc(sym, val))) {
            map = this.getMappings();
        }
        return val;
    }

    public static boolean areDifferentInstancesOfSameClassName(Class cls1, Class cls2) {
        return cls1 != cls2 && cls1.getName().equals(cls2.getName());
    }

    Class referenceClass(Symbol sym, Class val) {
        if (sym.ns != null) {
            throw new IllegalArgumentException("Can't intern namespace-qualified symbol");
        }
        IPersistentMap map = this.getMappings();
        Class c = (Class)map.valAt(sym);
        while (c == null || Namespace.areDifferentInstancesOfSameClassName(c, val)) {
            IPersistentMap newMap = map.assoc(sym, val);
            this.mappings.compareAndSet(map, newMap);
            map = this.getMappings();
            c = (Class)map.valAt(sym);
        }
        if (c == val) {
            return c;
        }
        throw new IllegalStateException(sym + " already refers to: " + c + " in namespace: " + this.name);
    }

    public void unmap(Symbol sym) {
        if (sym.ns != null) {
            throw new IllegalArgumentException("Can't unintern namespace-qualified symbol");
        }
        IPersistentMap map = this.getMappings();
        while (map.containsKey(sym)) {
            IPersistentMap newMap = map.without(sym);
            this.mappings.compareAndSet(map, newMap);
            map = this.getMappings();
        }
    }

    public Class importClass(Symbol sym, Class c) {
        return this.referenceClass(sym, c);
    }

    public Class importClass(Class c) {
        String n = c.getName();
        return this.importClass(Symbol.intern(n.substring(n.lastIndexOf(46) + 1)), c);
    }

    public Var refer(Symbol sym, Var var) {
        return (Var)this.reference(sym, var);
    }

    public Namespace referNs(Object ns, IPersistentMap filters) {
        Object refer = filters.valAt(Namespace.refer);
        Object exclude = filters.valAt(Namespace.exclude);
        Object only = filters.valAt(Namespace.only);
        only = only == null ? RT.set(new Object[0]) : PersistentHashSet.create(RT.seq(only));
        Object rename = filters.valAt(Namespace.rename);
        IPersistentSet onlyAndRefer = (IPersistentSet)only;
        if (refer != null && refer instanceof Sequential) {
            for (ISeq e = RT.seq(refer); e != null; e = e.next()) {
                onlyAndRefer = (IPersistentSet)onlyAndRefer.cons(e.first());
            }
        }
        filters = filters.assoc(Namespace.onlyAndRefer, onlyAndRefer).assoc(Namespace.refer, refer == null && refer instanceof Sequential ? PersistentHashSet.create(RT.seq(refer)) : refer).assoc(Namespace.exclude, exclude == null ? RT.set(new Object[0]) : PersistentHashSet.create(RT.seq(exclude))).assoc(Namespace.only, only).assoc(Namespace.rename, rename == null ? RT.map(new Object[0]) : this.invert(rename));
        boolean successful = false;
        while (!successful) {
            IPersistentMap expects = this.refers.get();
            successful = this.refers.compareAndSet(expects, expects.assoc(ns, filters));
        }
        return this;
    }

    private IPersistentMap invert(Object m) {
        IPersistentMap r = RT.map(new Object[0]);
        ISeq s = RT.seq(RT.keys(m));
        while (s != null) {
            Object k = RT.first(s);
            r = r.assoc(RT.get(m, k), k);
            s = RT.next(s);
        }
        return r;
    }

    public static Namespace findOrCreate(Symbol name) {
        Namespace ns = namespaces.get(name);
        if (ns != null) {
            return ns;
        }
        Namespace newns = new Namespace(name);
        ns = namespaces.putIfAbsent(name, newns);
        return ns == null ? newns : ns;
    }

    public static Namespace remove(Symbol name) {
        if (name.equals(RT.CLOJURE_NS.name)) {
            throw new IllegalArgumentException("Cannot remove clojure namespace");
        }
        return namespaces.remove(name);
    }

    public static Namespace find(Symbol name) {
        return namespaces.get(name);
    }

    public Object getMapping(Symbol name) {
        Object val = this.mappings.get().valAt(name);
        if (val == null && !ObjC.objc) {
            val = Var.maybeLoadFromClass(this.name.toString(), name.toString());
            if (val == null && this != RT.CLOJURE_NS && (val = this.searchMapping(name)) != null && val instanceof Var) {
                this.refer(name, (Var)val);
            }
            return val;
        }
        return val;
    }

    private Object searchMapping(Symbol name) {
        IPersistentMap m = this.refers.get();
        for (ISeq s = m.seq(); s != null; s = s.next()) {
            Object i = s.first();
            Object o = null;
            Namespace ns = (Namespace)RT.first(i);
            IPersistentMap filters = (IPersistentMap)RT.second(i);
            Object refer = filters.valAt(Namespace.refer);
            IPersistentSet exclude = (IPersistentSet)filters.valAt(Namespace.exclude);
            IPersistentMap rename = (IPersistentMap)filters.valAt(Namespace.rename);
            if (exclude.contains(name)) continue;
            if (rename.containsKey(name)) {
                o = ns.getMapping((Symbol)rename.valAt(name));
            } else if (allkeyword.equals(refer)) {
                o = ns.getMapping(name);
            } else {
                IPersistentSet onlyAndRefer = (IPersistentSet)filters.valAt(Namespace.onlyAndRefer);
                if (onlyAndRefer.count() > 0 && !onlyAndRefer.contains(name)) continue;
                o = ns.getMapping(name);
            }
            if (o == null || !(o instanceof Var)) continue;
            return o;
        }
        return null;
    }

    public Var findInternedVar(Symbol symbol) {
        Object o = this.getMapping(symbol);
        if (o != null && o instanceof Var && ((Var)o).ns == this) {
            return (Var)o;
        }
        if (!ObjC.objc) {
            return Var.maybeLoadFromClass(this.name.toString(), symbol.toString());
        }
        return null;
    }

    public IPersistentMap getAliases() {
        return this.aliases.get();
    }

    public Namespace lookupAlias(Symbol alias) {
        IPersistentMap map = this.getAliases();
        return (Namespace)map.valAt(alias);
    }

    public void addAlias(Symbol alias, Namespace ns) {
        if (alias == null || ns == null) {
            throw new NullPointerException("Expecting Symbol + Namespace");
        }
        IPersistentMap map = this.getAliases();
        while (!map.containsKey(alias)) {
            IPersistentMap newMap = map.assoc(alias, ns);
            this.aliases.compareAndSet(map, newMap);
            map = this.getAliases();
        }
        if (!map.valAt(alias).equals(ns)) {
            throw new IllegalStateException("Alias " + alias + " already exists in namespace " + this.name + ", aliasing " + map.valAt(alias));
        }
    }

    public void removeAlias(Symbol alias) {
        IPersistentMap map = this.getAliases();
        while (map.containsKey(alias)) {
            IPersistentMap newMap = map.without(alias);
            this.aliases.compareAndSet(map, newMap);
            map = this.getAliases();
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return Namespace.findOrCreate(this.name);
    }
}

