/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.APersistentMap;
import clojure.lang.ASeq;
import clojure.lang.ATransientMap;
import clojure.lang.Counted;
import clojure.lang.IDeref;
import clojure.lang.IEditableCollection;
import clojure.lang.IFn;
import clojure.lang.IMapEntry;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.ITransientMap;
import clojure.lang.IllegalAccessError;
import clojure.lang.Keyword;
import clojure.lang.MapEntry;
import clojure.lang.Obj;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;
import clojure.lang.Util;
import java.util.Iterator;
import java.util.Map;

public class PersistentArrayMap
extends APersistentMap
implements IObj,
IEditableCollection {
    final Object[] array;
    static final int HASHTABLE_THRESHOLD = 16;
    public static final PersistentArrayMap EMPTY = new PersistentArrayMap();
    private final IPersistentMap _meta;

    public static IPersistentMap create(Map other) {
        ITransientMap ret = EMPTY.asTransient();
        Iterator iterator = other.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = iterator.next();
            ret = ret.assoc(e.getKey(), e.getValue());
        }
        return ret.persistent();
    }

    protected PersistentArrayMap() {
        this.array = new Object[0];
        this._meta = null;
    }

    @Override
    public PersistentArrayMap withMeta(IPersistentMap meta) {
        return new PersistentArrayMap(meta, this.array);
    }

    PersistentArrayMap create(Object ... init) {
        return new PersistentArrayMap(this.meta(), init);
    }

    IPersistentMap createHT(Object[] init) {
        return PersistentHashMap.create(this.meta(), init);
    }

    public static PersistentArrayMap createWithCheck(Object[] init) {
        int i = 0;
        while (i < init.length) {
            int j = i + 2;
            while (j < init.length) {
                if (PersistentArrayMap.equalKey(init[i], init[j])) {
                    throw new IllegalArgumentException("Duplicate key: " + init[i]);
                }
                j += 2;
            }
            i += 2;
        }
        return new PersistentArrayMap(init);
    }

    public static PersistentArrayMap createAsIfByAssoc(Object[] init) {
        int n = 0;
        int i = 0;
        while (i < init.length) {
            boolean duplicateKey = false;
            int j = 0;
            while (j < i) {
                if (PersistentArrayMap.equalKey(init[i], init[j])) {
                    duplicateKey = true;
                    break;
                }
                j += 2;
            }
            if (!duplicateKey) {
                n += 2;
            }
            i += 2;
        }
        if (n < init.length) {
            Object[] nodups = new Object[n];
            int m = 0;
            int i2 = 0;
            while (i2 < init.length) {
                boolean duplicateKey = false;
                int j = 0;
                while (j < m) {
                    if (PersistentArrayMap.equalKey(init[i2], nodups[j])) {
                        duplicateKey = true;
                        break;
                    }
                    j += 2;
                }
                if (!duplicateKey) {
                    j = init.length - 2;
                    while (j >= i2) {
                        if (PersistentArrayMap.equalKey(init[i2], init[j])) break;
                        j -= 2;
                    }
                    nodups[m] = init[i2];
                    nodups[m + 1] = init[j + 1];
                    m += 2;
                }
                i2 += 2;
            }
            if (m != n) {
                throw new IllegalArgumentException("Internal error: m=" + m);
            }
            init = nodups;
        }
        return new PersistentArrayMap(init);
    }

    public PersistentArrayMap(Object[] init) {
        this.array = init;
        this._meta = null;
    }

    public PersistentArrayMap(IPersistentMap meta, Object[] init) {
        this._meta = meta;
        this.array = init;
    }

    @Override
    public int count() {
        return this.array.length / 2;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indexOf(key) >= 0;
    }

    @Override
    public IMapEntry entryAt(Object key) {
        int i = this.indexOf(key);
        if (i >= 0) {
            return new MapEntry(this.array[i], this.array[i + 1]);
        }
        return null;
    }

    @Override
    public IPersistentMap assocEx(Object key, Object val) {
        int i = this.indexOf(key);
        if (i >= 0) {
            throw Util.runtimeException("Key already present");
        }
        if (this.array.length > 16) {
            return this.createHT(this.array).assocEx(key, val);
        }
        Object[] newArray = new Object[this.array.length + 2];
        if (this.array.length > 0) {
            System.arraycopy(this.array, 0, newArray, 2, this.array.length);
        }
        newArray[0] = key;
        newArray[1] = val;
        return this.create(newArray);
    }

    @Override
    public IPersistentMap assoc(Object key, Object val) {
        Object[] newArray;
        int i = this.indexOf(key);
        if (i >= 0) {
            if (this.array[i + 1] == val) {
                return this;
            }
            newArray = (Object[])this.array.clone();
            newArray[i + 1] = val;
        } else {
            if (this.array.length > 16) {
                return this.createHT(this.array).assoc(key, val);
            }
            newArray = new Object[this.array.length + 2];
            if (this.array.length > 0) {
                System.arraycopy(this.array, 0, newArray, 2, this.array.length);
            }
            newArray[0] = key;
            newArray[1] = val;
        }
        return this.create(newArray);
    }

    @Override
    public IPersistentMap without(Object key) {
        int i = this.indexOf(key);
        if (i >= 0) {
            int newlen = this.array.length - 2;
            if (newlen == 0) {
                return this.empty();
            }
            Object[] newArray = new Object[newlen];
            int s = 0;
            int d = 0;
            while (s < this.array.length) {
                if (!PersistentArrayMap.equalKey(this.array[s], key)) {
                    newArray[d] = this.array[s];
                    newArray[d + 1] = this.array[s + 1];
                    d += 2;
                }
                s += 2;
            }
            return this.create(newArray);
        }
        return this;
    }

    @Override
    public IPersistentMap empty() {
        return EMPTY.withMeta(this.meta());
    }

    @Override
    public final Object valAt(Object key, Object notFound) {
        int i = this.indexOf(key);
        if (i >= 0) {
            return this.array[i + 1];
        }
        return notFound;
    }

    @Override
    public Object valAt(Object key) {
        return this.valAt(key, null);
    }

    public int capacity() {
        return this.count();
    }

    private int indexOfObject(Object key) {
        Util.EquivPred ep = Util.equivPred(key);
        int i = 0;
        while (i < this.array.length) {
            if (ep.equiv(key, this.array[i])) {
                return i;
            }
            i += 2;
        }
        return -1;
    }

    private int indexOf(Object key) {
        if (key instanceof Keyword) {
            int i = 0;
            while (i < this.array.length) {
                if (key == this.array[i]) {
                    return i;
                }
                i += 2;
            }
            return -1;
        }
        return this.indexOfObject(key);
    }

    static boolean equalKey(Object k1, Object k2) {
        if (k1 instanceof Keyword) {
            return k1 == k2;
        }
        return Util.equiv(k1, k2);
    }

    public Iterator iterator() {
        return new Iter(this.array);
    }

    @Override
    public ISeq seq() {
        if (this.array.length > 0) {
            return new Seq(this.array, 0);
        }
        return null;
    }

    @Override
    public IPersistentMap meta() {
        return this._meta;
    }

    public Object kvreduce(IFn f, Object init) {
        int i = 0;
        while (i < this.array.length) {
            if (RT.isReduced(init = f.invoke(init, this.array[i], this.array[i + 1]))) {
                return ((IDeref)init).deref();
            }
            i += 2;
        }
        return init;
    }

    @Override
    public ITransientMap asTransient() {
        return new TransientArrayMap(this.array);
    }

    static class Iter
    implements Iterator {
        Object[] array;
        int i;

        Iter(Object[] array) {
            this(array, -2);
        }

        Iter(Object[] array, int i) {
            this.array = array;
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.array.length - 2;
        }

        public Object next() {
            this.i += 2;
            return new MapEntry(this.array[this.i], this.array[this.i + 1]);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class Seq
    extends ASeq
    implements Counted {
        final Object[] array;
        final int i;

        Seq(Object[] array, int i) {
            this.array = array;
            this.i = i;
        }

        public Seq(IPersistentMap meta, Object[] array, int i) {
            super(meta);
            this.array = array;
            this.i = i;
        }

        @Override
        public Object first() {
            return new MapEntry(this.array[this.i], this.array[this.i + 1]);
        }

        @Override
        public ISeq next() {
            if (this.i + 2 < this.array.length) {
                return new Seq(this.array, this.i + 2);
            }
            return null;
        }

        @Override
        public int count() {
            return (this.array.length - this.i) / 2;
        }

        @Override
        public Obj withMeta(IPersistentMap meta) {
            return new Seq(meta, this.array, this.i);
        }
    }

    static final class TransientArrayMap
    extends ATransientMap {
        int len;
        final Object[] array;
        Thread owner = Thread.currentThread();

        public TransientArrayMap(Object[] array) {
            this.array = new Object[Math.max(16, array.length)];
            System.arraycopy(array, 0, this.array, 0, array.length);
            this.len = array.length;
        }

        private int indexOf(Object key) {
            int i = 0;
            while (i < this.len) {
                if (PersistentArrayMap.equalKey(this.array[i], key)) {
                    return i;
                }
                i += 2;
            }
            return -1;
        }

        @Override
        ITransientMap doAssoc(Object key, Object val) {
            int i = this.indexOf(key);
            if (i >= 0) {
                if (this.array[i + 1] != val) {
                    this.array[i + 1] = val;
                }
            } else {
                if (this.len >= this.array.length) {
                    return PersistentHashMap.create(this.array).asTransient().assoc(key, val);
                }
                this.array[this.len++] = key;
                this.array[this.len++] = val;
            }
            return this;
        }

        @Override
        ITransientMap doWithout(Object key) {
            int i = this.indexOf(key);
            if (i >= 0) {
                if (this.len >= 2) {
                    this.array[i] = this.array[this.len - 2];
                    this.array[i + 1] = this.array[this.len - 1];
                }
                this.len -= 2;
            }
            return this;
        }

        @Override
        Object doValAt(Object key, Object notFound) {
            int i = this.indexOf(key);
            if (i >= 0) {
                return this.array[i + 1];
            }
            return notFound;
        }

        @Override
        int doCount() {
            return this.len / 2;
        }

        @Override
        IPersistentMap doPersistent() {
            this.ensureEditable();
            this.owner = null;
            Object[] a = new Object[this.len];
            System.arraycopy(this.array, 0, a, 0, this.len);
            return new PersistentArrayMap(a);
        }

        @Override
        void ensureEditable() {
            if (this.owner == Thread.currentThread()) {
                return;
            }
            if (this.owner != null) {
                throw new IllegalAccessError("Transient used by non-owner thread");
            }
            throw new IllegalAccessError("Transient used after persistent! call");
        }
    }
}

