/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.Util;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ExecutorService
implements Executor {
    public ExecutorService() {
    }

    public ExecutorService(int i) {
    }

    public void shutdown() {
    }

    public Future submit(Callable callable) {
        return new CallableFuture(callable);
    }

    @Override
    public void execute(Runnable arg0) {
        new Thread(arg0).start();
    }

    public static class CallableFuture
    implements Future {
        Object r = null;
        boolean done = false;
        boolean cancelled = false;
        private Callable callable;

        public CallableFuture(final Callable callable) {
            this.callable = callable;
            new Thread(){

                @Override
                public void run() {
                    try {
                        CallableFuture.this.r = callable.call();
                        CallableFuture.this.done = true;
                    }
                    catch (Exception e) {
                        throw Util.sneakyThrow(e);
                    }
                }
            }.start();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cancelled = true;
            return true;
        }

        public Object get() throws InterruptedException, ExecutionException {
            if (this.done) {
                return this.r;
            }
            throw new InterruptedException();
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long millis = unit.toMillis(timeout);
            long start = System.currentTimeMillis();
            do {
                Thread.sleep(50L);
                if (!this.done) continue;
                return this.r;
            } while (System.currentTimeMillis() - start <= millis);
            throw new TimeoutException();
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }
    }
}

