/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.asm.Attribute;
import clojure.asm.ByteVector;
import clojure.asm.ClassVisitor;
import clojure.asm.ClassWriter;
import clojure.asm.FieldVisitor;
import clojure.asm.Label;
import clojure.asm.MethodVisitor;
import clojure.asm.Opcodes;
import clojure.asm.Type;
import clojure.asm.commons.GeneratorAdapter;
import clojure.lang.AFn;
import clojure.lang.AFunction;
import clojure.lang.APersistentVector;
import clojure.lang.ArityException;
import clojure.lang.ArraySeq;
import clojure.lang.DynamicClassLoader;
import clojure.lang.IFn;
import clojure.lang.ILookup;
import clojure.lang.ILookupSite;
import clojure.lang.ILookupThunk;
import clojure.lang.IMapEntry;
import clojure.lang.IMeta;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentList;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IPersistentStack;
import clojure.lang.IPersistentVector;
import clojure.lang.IRecord;
import clojure.lang.ISeq;
import clojure.lang.IType;
import clojure.lang.IllegalAccessError;
import clojure.lang.Intrinsics;
import clojure.lang.Keyword;
import clojure.lang.KeywordLookupSite;
import clojure.lang.LazySeq;
import clojure.lang.LineNumberingPushbackReader;
import clojure.lang.LispReader;
import clojure.lang.Namespace;
import clojure.lang.Numbers;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentList;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Reflector;
import clojure.lang.RestFn;
import clojure.lang.SourceWriter;
import clojure.lang.StringEscapeUtils;
import clojure.lang.Symbol;
import clojure.lang.Util;
import clojure.lang.Var;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Compiler
implements Opcodes {
    private static final String DOLLAR = "_";
    static final Symbol DEF = Symbol.intern("def");
    static final Symbol LOOP = Symbol.intern("loop*");
    static final Symbol RECUR = Symbol.intern("recur");
    static final Symbol IF = Symbol.intern("if");
    static final Symbol LET = Symbol.intern("let*");
    static final Symbol LETFN = Symbol.intern("letfn*");
    static final Symbol DO = Symbol.intern("do");
    static final Symbol FN = Symbol.intern("fn*");
    static final Symbol FNONCE = (Symbol)Symbol.intern("fn*").withMeta(RT.map(Keyword.intern(null, "once"), RT.T));
    static final Symbol QUOTE = Symbol.intern("quote");
    static final Symbol THE_VAR = Symbol.intern("var");
    static final Symbol DOT = Symbol.intern(".");
    static final Symbol ASSIGN = Symbol.intern("set!");
    static final Symbol TRY = Symbol.intern("try");
    static final Symbol CATCH = Symbol.intern("catch");
    static final Symbol FINALLY = Symbol.intern("finally");
    static final Symbol THROW = Symbol.intern("throw");
    static final Symbol MONITOR_ENTER = Symbol.intern("monitor-enter");
    static final Symbol MONITOR_EXIT = Symbol.intern("monitor-exit");
    static final Symbol IMPORT = Symbol.intern("clojure.core", "import*");
    static final Symbol DEFTYPE = Symbol.intern("deftype*");
    static final Symbol CASE = Symbol.intern("case*");
    static final Symbol CLASS = Symbol.intern("Class");
    static final Symbol NEW = Symbol.intern("new");
    static final Symbol THIS = Symbol.intern("this");
    static final Symbol REIFY = Symbol.intern("reify*");
    static final Symbol LIST = Symbol.intern("clojure.core", "list");
    static final Symbol HASHMAP = Symbol.intern("clojure.core", "hash-map");
    static final Symbol VECTOR = Symbol.intern("clojure.core", "vector");
    static final Symbol IDENTITY = Symbol.intern("clojure.core", "identity");
    static final Symbol _AMP_ = Symbol.intern("&");
    static final Symbol ISEQ = Symbol.intern("clojure.lang.ISeq");
    static final Keyword inlineKey = Keyword.intern(null, "inline");
    static final Keyword inlineAritiesKey = Keyword.intern(null, "inline-arities");
    static final Keyword staticKey = Keyword.intern(null, "static");
    static final Keyword arglistsKey = Keyword.intern(null, "arglists");
    static final Symbol INVOKE_STATIC = Symbol.intern("invokeStatic");
    static final Keyword volatileKey = Keyword.intern(null, "volatile");
    static final Keyword implementsKey = Keyword.intern(null, "implements");
    static final String COMPILE_STUB_PREFIX = "compile__stub";
    static final Keyword protocolKey = Keyword.intern(null, "protocol");
    static final Keyword onKey = Keyword.intern(null, "on");
    static Keyword dynamicKey = Keyword.intern("dynamic");
    static final Symbol NS = Symbol.intern("ns");
    static final Symbol IN_NS = Symbol.intern("in-ns");
    public static final IPersistentMap specials = PersistentHashMap.create(DEF, new DefExpr.Parser(), LOOP, new LetExpr.Parser(), RECUR, new RecurExpr.Parser(), IF, new IfExpr.Parser(), CASE, new CaseExpr.Parser(), LET, new LetExpr.Parser(), LETFN, new LetFnExpr.Parser(), DO, new BodyExpr.Parser(), FN, null, QUOTE, new ConstantExpr.Parser(), THE_VAR, new TheVarExpr.Parser(), IMPORT, new ImportExpr.Parser(), DOT, new HostExpr.Parser(), ASSIGN, new AssignExpr.Parser(), DEFTYPE, new NewInstanceExpr.DeftypeParser(), REIFY, new NewInstanceExpr.ReifyParser(), TRY, new TryExpr.Parser(), THROW, new ThrowExpr.Parser(), MONITOR_ENTER, new MonitorEnterExpr.Parser(), MONITOR_EXIT, new MonitorExitExpr.Parser(), CATCH, null, FINALLY, null, NEW, new NewExpr.Parser(), _AMP_, null);
    private static final int MAX_POSITIONAL_ARITY = 20;
    private static final Type OBJECT_TYPE;
    private static final Type VAR_TYPE;
    private static final Type IFN_TYPE;
    private static final Type RT_TYPE;
    private static final Type NUMBERS_TYPE;
    static final Type CLASS_TYPE;
    static final Type NS_TYPE;
    static final Type UTIL_TYPE;
    static final Type REFLECTOR_TYPE;
    static final Type THROWABLE_TYPE;
    static final Type BOOLEAN_OBJECT_TYPE;
    static final Type IPERSISTENTMAP_TYPE;
    static final Type IOBJ_TYPE;
    private static final Type[][] ARG_TYPES;
    private static final Type[] EXCEPTION_TYPES;
    public static final Var STOP_EMIT_SOURCE;
    public static final Var LOCAL_ENV;
    public static final Var LOOP_LOCALS;
    public static final Var LOOP_LABEL;
    public static final Var RETURN_TYPE;
    public static final Var CONSTANTS;
    public static final Var CONSTANT_IDS;
    public static final Var KEYWORD_CALLSITES;
    public static final Var PROTOCOL_CALLSITES;
    public static final Var VAR_CALLSITES;
    public static final Var KEYWORDS;
    public static final Var VARS;
    public static final Var METHOD;
    public static final Var IN_CATCH_FINALLY;
    public static final Var NO_RECUR;
    public static final Var LOADER;
    public static final Var SOURCE;
    public static final Var SOURCE_PATH;
    public static final Var SOURCE_WRITER;
    public static final Var COMPILE_PATH;
    public static final Var SOURCE_GEN_PATH;
    public static final Var COMPILE_FILES;
    public static final Var INSTANCE;
    public static final Var ADD_ANNOTATIONS;
    public static final Keyword disableLocalsClearingKey;
    public static final Keyword elideMetaKey;
    public static final Var COMPILER_OPTIONS;
    public static final Var LINE;
    public static final Var COLUMN;
    public static final Var LINE_BEFORE;
    public static final Var COLUMN_BEFORE;
    public static final Var LINE_AFTER;
    public static final Var COLUMN_AFTER;
    public static final Var NEXT_LOCAL_NUM;
    public static final Var RET_LOCAL_NUM;
    public static final Var COMPILE_STUB_SYM;
    public static final Var COMPILE_STUB_CLASS;
    public static final Var CLEAR_PATH;
    public static final Var CLEAR_ROOT;
    public static final Var CLEAR_SITES;
    public static final Class RECUR_CLASS;
    static final NilExpr NIL_EXPR;
    static final BooleanExpr TRUE_EXPR;
    static final BooleanExpr FALSE_EXPR;
    public static final IPersistentMap CHAR_MAP;
    public static final IPersistentMap DEMUNGE_MAP;
    public static final Pattern DEMUNGE_PATTERN;
    static int temp;

    static {
        VAR_TYPE = Type.getType(Var.class);
        IFN_TYPE = Type.getType(IFn.class);
        RT_TYPE = Type.getType(RT.class);
        NUMBERS_TYPE = Type.getType(Numbers.class);
        CLASS_TYPE = Type.getType(Class.class);
        NS_TYPE = Type.getType(Namespace.class);
        UTIL_TYPE = Type.getType(Util.class);
        REFLECTOR_TYPE = Type.getType(Reflector.class);
        THROWABLE_TYPE = Type.getType(Throwable.class);
        BOOLEAN_OBJECT_TYPE = Type.getType(Boolean.class);
        IPERSISTENTMAP_TYPE = Type.getType(IPersistentMap.class);
        IOBJ_TYPE = Type.getType(IObj.class);
        EXCEPTION_TYPES = new Type[0];
        OBJECT_TYPE = Type.getType(Object.class);
        ARG_TYPES = new Type[22][];
        int i = 0;
        while (i <= 20) {
            Type[] a = new Type[i];
            int j = 0;
            while (j < i) {
                a[j] = OBJECT_TYPE;
                ++j;
            }
            Compiler.ARG_TYPES[i] = a;
            ++i;
        }
        Type[] a = new Type[21];
        int j = 0;
        while (j < 20) {
            a[j] = OBJECT_TYPE;
            ++j;
        }
        a[20] = Type.getType("[Ljava/lang/Object;");
        Compiler.ARG_TYPES[21] = a;
        STOP_EMIT_SOURCE = Var.create(false).setDynamic();
        LOCAL_ENV = Var.create(null).setDynamic();
        LOOP_LOCALS = Var.create().setDynamic();
        LOOP_LABEL = Var.create().setDynamic();
        RETURN_TYPE = Var.create().setDynamic();
        CONSTANTS = Var.create().setDynamic();
        CONSTANT_IDS = Var.create().setDynamic();
        KEYWORD_CALLSITES = Var.create().setDynamic();
        PROTOCOL_CALLSITES = Var.create().setDynamic();
        VAR_CALLSITES = Var.create().setDynamic();
        KEYWORDS = Var.create().setDynamic();
        VARS = Var.create().setDynamic();
        METHOD = Var.create(null).setDynamic();
        IN_CATCH_FINALLY = Var.create(null).setDynamic();
        NO_RECUR = Var.create(null).setDynamic();
        LOADER = Var.create().setDynamic();
        SOURCE = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("*source-path*"), "NO_SOURCE_FILE").setDynamic();
        SOURCE_PATH = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("*file*"), "NO_SOURCE_PATH").setDynamic();
        SOURCE_WRITER = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("*source-writer*"), null).setDynamic();
        COMPILE_PATH = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("*compile-path*"), null).setDynamic();
        SOURCE_GEN_PATH = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("*source-gen-path*"), null).setDynamic();
        COMPILE_FILES = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("*compile-files*"), Boolean.FALSE).setDynamic();
        INSTANCE = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("instance?"));
        ADD_ANNOTATIONS = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("add-annotations"));
        disableLocalsClearingKey = Keyword.intern("disable-locals-clearing");
        elideMetaKey = Keyword.intern("elide-meta");
        COMPILER_OPTIONS = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("*compiler-options*"), null).setDynamic();
        LINE = Var.create(0).setDynamic();
        COLUMN = Var.create(0).setDynamic();
        LINE_BEFORE = Var.create(0).setDynamic();
        COLUMN_BEFORE = Var.create(0).setDynamic();
        LINE_AFTER = Var.create(0).setDynamic();
        COLUMN_AFTER = Var.create(0).setDynamic();
        NEXT_LOCAL_NUM = Var.create(0).setDynamic();
        RET_LOCAL_NUM = Var.create().setDynamic();
        COMPILE_STUB_SYM = Var.create(null).setDynamic();
        COMPILE_STUB_CLASS = Var.create(null).setDynamic();
        CLEAR_PATH = Var.create(null).setDynamic();
        CLEAR_ROOT = Var.create(null).setDynamic();
        CLEAR_SITES = Var.create(null).setDynamic();
        RECUR_CLASS = Recur.class;
        NIL_EXPR = new NilExpr();
        TRUE_EXPR = new BooleanExpr(true);
        FALSE_EXPR = new BooleanExpr(false);
        CHAR_MAP = PersistentHashMap.create(Character.valueOf('-'), DOLLAR, Character.valueOf('\u00a9'), "_OBJC_", Character.valueOf(':'), "_COLON_", Character.valueOf('+'), "_PLUS_", Character.valueOf('>'), "_GT_", Character.valueOf('<'), "_LT_", Character.valueOf('='), "_EQ_", Character.valueOf('~'), "_TILDE_", Character.valueOf('!'), "_BANG_", Character.valueOf('@'), "_CIRCA_", Character.valueOf('#'), "_SHARP_", Character.valueOf('\''), "_SINGLEQUOTE_", Character.valueOf('\"'), "_DOUBLEQUOTE_", Character.valueOf('%'), "_PERCENT_", Character.valueOf('^'), "_CARET_", Character.valueOf('&'), "_AMPERSAND_", Character.valueOf('*'), "_STAR_", Character.valueOf('|'), "_BAR_", Character.valueOf('{'), "_LBRACE_", Character.valueOf('}'), "_RBRACE_", Character.valueOf('['), "_LBRACK_", Character.valueOf(']'), "_RBRACK_", Character.valueOf('/'), "_SLASH_", Character.valueOf('\\'), "_BSLASH_", Character.valueOf('?'), "_QMARK_");
        IPersistentMap m = RT.map(DOLLAR, Character.valueOf('/'));
        ISeq s = RT.seq(CHAR_MAP);
        while (s != null) {
            IMapEntry e = (IMapEntry)s.first();
            Character origCh = (Character)e.key();
            String escapeStr = (String)e.val();
            m = m.assoc(escapeStr, origCh);
            s = s.next();
        }
        DEMUNGE_MAP = m;
        Object[] mungeStrs = RT.toArray(RT.keys(m));
        Arrays.sort(mungeStrs, new Comparator(){

            public int compare(Object s1, Object s2) {
                return ((String)s2).length() - ((String)s1).length();
            }
        });
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Object[] objectArray = mungeStrs;
        int n = mungeStrs.length;
        int n2 = 0;
        while (n2 < n) {
            Object s2 = objectArray[n2];
            String escapeStr = (String)s2;
            if (!first) {
                sb.append("|");
            }
            first = false;
            sb.append("\\Q");
            sb.append(escapeStr);
            sb.append("\\E");
            ++n2;
        }
        DEMUNGE_PATTERN = Pattern.compile(sb.toString());
        temp = 0;
    }

    public static void emitSource(String source) {
        if (Boolean.TRUE.equals(STOP_EMIT_SOURCE.deref())) {
            return;
        }
        if (source != null && source.endsWith(";;")) {
            new RuntimeException(source).printStackTrace();
        }
        if (source == null) {
            new RuntimeException().printStackTrace();
            return;
        }
        if (source != null && (source.isEmpty() || "null;".equals(source))) {
            return;
        }
        SourceWriter sc = (SourceWriter)SOURCE_WRITER.deref();
        if (sc != null) {
            source = source.replaceAll("compile__stub.", "");
            sc.println(source);
        }
    }

    public static void emitSource() {
        SourceWriter sc = (SourceWriter)SOURCE_WRITER.deref();
        if (sc != null) {
            sc.println();
        }
    }

    public static void tab() {
        SourceWriter sc = (SourceWriter)SOURCE_WRITER.deref();
        if (sc != null) {
            sc.tab();
        }
    }

    public static void untab() {
        SourceWriter sc = (SourceWriter)SOURCE_WRITER.deref();
        if (sc != null) {
            sc.untab();
        }
    }

    public static Object getCompilerOption(Keyword k) {
        return RT.get(COMPILER_OPTIONS.deref(), k);
    }

    static Object elideMeta(Object m) {
        Collection elides = (Collection)Compiler.getCompilerOption(elideMetaKey);
        if (elides != null) {
            for (Object k : elides) {
                m = RT.dissoc(m, k);
            }
        }
        return m;
    }

    static int lineDeref() {
        return ((Number)LINE.deref()).intValue();
    }

    static int columnDeref() {
        return ((Number)COLUMN.deref()).intValue();
    }

    static boolean isSpecial(Object sym) {
        return specials.containsKey(sym);
    }

    public static String printClass(Object c) {
        if (c instanceof Class) {
            return ((Class)c).getCanonicalName().replaceAll("-", DOLLAR);
        }
        if (c instanceof Type) {
            return ((Type)c).getClassName().replaceAll("-", DOLLAR);
        }
        if (c instanceof String) {
            return c.toString().replaceAll("-", DOLLAR);
        }
        throw new RuntimeException("printClass doesn't support: " + c.getClass().getCanonicalName());
    }

    static Symbol resolveSymbol(Symbol sym) {
        if (sym.name.indexOf(46) > 0) {
            return sym;
        }
        if (sym.ns != null) {
            Namespace ns = Compiler.namespaceFor(sym);
            if (ns == null || ns.name.name == sym.ns) {
                return sym;
            }
            return Symbol.intern(ns.name.name, sym.name);
        }
        Object o = Compiler.currentNS().getMapping(sym);
        if (o == null) {
            return Symbol.intern(Compiler.currentNS().name.name, sym.name);
        }
        if (o instanceof Class) {
            return Symbol.intern(null, ((Class)o).getName());
        }
        if (o instanceof Var) {
            Var v = (Var)o;
            return Symbol.intern(v.ns.name.name, v.sym.name);
        }
        return null;
    }

    static Class maybePrimitiveType(Expr e) {
        try {
            Class c;
            if (e instanceof MaybePrimitiveExpr && e.hasJavaClass() && ((MaybePrimitiveExpr)e).canEmitPrimitive() && Util.isPrimitive(c = e.getJavaClass())) {
                return c;
            }
        }
        catch (Exception ex) {
            throw Util.sneakyThrow(ex);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Class maybeJavaClass(Collection<Expr> exprs) {
        Class match = null;
        try {
            Iterator<Expr> iterator = exprs.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return match;
                }
                Expr e = iterator.next();
                if (e instanceof ThrowExpr) continue;
                if (!e.hasJavaClass()) {
                    return null;
                }
                Class c = e.getJavaClass();
                if (match == null) {
                    match = c;
                    continue;
                }
                if (match != c) break;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean subsumes(Class[] c1, Class[] c2) {
        Boolean better = false;
        int i = 0;
        while (i < c1.length) {
            if (c1[i] != c2[i]) {
                if (!c1[i].isPrimitive() && c2[i].isPrimitive() || c2[i].isAssignableFrom(c1[i])) {
                    better = true;
                } else {
                    return false;
                }
            }
            ++i;
        }
        return better;
    }

    static int getMatchingParams(String methodName, ArrayList<Class[]> paramlists, IPersistentVector argexprs, List<Class> rets) {
        int matchIdx = -1;
        boolean tied = false;
        boolean foundExact = false;
        int i = 0;
        while (i < paramlists.size()) {
            boolean match = true;
            ISeq aseq = argexprs.seq();
            int exact = 0;
            int p = 0;
            while (match && p < argexprs.count() && aseq != null) {
                Expr arg = (Expr)aseq.first();
                Class aclass = arg.hasJavaClass() ? arg.getJavaClass() : Object.class;
                Class pclass = paramlists.get(i)[p];
                if (arg.hasJavaClass() && aclass == pclass) {
                    ++exact;
                } else {
                    match = Reflector.paramArgTypeMatch(pclass, aclass);
                }
                ++p;
                aseq = aseq.next();
            }
            if (exact == argexprs.count()) {
                if (!foundExact || matchIdx == -1 || rets.get(matchIdx).isAssignableFrom(rets.get(i))) {
                    matchIdx = i;
                }
                tied = false;
                foundExact = true;
            } else if (match && !foundExact) {
                if (matchIdx == -1) {
                    matchIdx = i;
                } else if (Compiler.subsumes(paramlists.get(i), paramlists.get(matchIdx))) {
                    matchIdx = i;
                    tied = false;
                } else if (Arrays.equals(paramlists.get(matchIdx), paramlists.get(i))) {
                    if (rets.get(matchIdx).isAssignableFrom(rets.get(i))) {
                        matchIdx = i;
                    }
                } else if (!Compiler.subsumes(paramlists.get(matchIdx), paramlists.get(i))) {
                    tied = true;
                }
            }
            ++i;
        }
        if (tied) {
            throw new IllegalArgumentException("More than one matching method found: " + methodName);
        }
        return matchIdx;
    }

    public static String munge(String name) {
        StringBuilder sb = new StringBuilder();
        char[] cArray = name.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            String sub = (String)CHAR_MAP.valAt(Character.valueOf(c));
            if (sub != null) {
                sb.append(sub);
            } else {
                sb.append(c);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String demunge(String mungedName) {
        StringBuilder sb = new StringBuilder();
        Matcher m = DEMUNGE_PATTERN.matcher(mungedName);
        int lastMatchEnd = 0;
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            sb.append(mungedName.substring(lastMatchEnd, start));
            lastMatchEnd = end;
            Character origCh = (Character)DEMUNGE_MAP.valAt(m.group());
            sb.append(origCh);
        }
        sb.append(mungedName.substring(lastMatchEnd));
        return sb.toString();
    }

    static PathNode clearPathRoot() {
        return (PathNode)CLEAR_ROOT.get();
    }

    public static String escapeString(String value) {
        return StringEscapeUtils.escapeJava(value);
    }

    private static LocalBinding registerLocal(Symbol sym, Symbol tag, Expr init, boolean isArg) {
        int num = Compiler.getAndIncLocalNum();
        LocalBinding b = new LocalBinding(num, sym, tag, init, isArg, Compiler.clearPathRoot());
        IPersistentMap localsMap = (IPersistentMap)LOCAL_ENV.deref();
        LOCAL_ENV.set(RT.assoc(localsMap, b.sym, b));
        ObjMethod method = (ObjMethod)METHOD.deref();
        method.locals = (IPersistentMap)RT.assoc(method.locals, b, b);
        method.indexlocals = (IPersistentMap)RT.assoc(method.indexlocals, num, b);
        return b;
    }

    private static String registerTemp() {
        return "__r" + temp++;
    }

    private static int getAndIncLocalNum() {
        int num = ((Number)NEXT_LOCAL_NUM.deref()).intValue();
        ObjMethod m = (ObjMethod)METHOD.deref();
        if (num > m.maxLocal) {
            m.maxLocal = num;
        }
        NEXT_LOCAL_NUM.set(num + 1);
        return num;
    }

    public static Expr analyze(C context, Object form) {
        return Compiler.analyze(context, form, null);
    }

    private static Expr analyze(C context, Object form, String name) {
        try {
            if (form instanceof LazySeq && (form = RT.seq(form)) == null) {
                form = PersistentList.EMPTY;
            }
            if (form == null) {
                return NIL_EXPR;
            }
            if (form == Boolean.TRUE) {
                return TRUE_EXPR;
            }
            if (form == Boolean.FALSE) {
                return FALSE_EXPR;
            }
            Class<?> fclass = form.getClass();
            if (fclass == Symbol.class) {
                return Compiler.analyzeSymbol((Symbol)form);
            }
            if (fclass == Keyword.class) {
                return Compiler.registerKeyword((Keyword)form);
            }
            if (form instanceof Number) {
                return NumberExpr.parse((Number)form);
            }
            if (fclass == String.class) {
                return new StringExpr(((String)form).intern());
            }
            if (form instanceof IPersistentCollection && ((IPersistentCollection)form).count() == 0) {
                Expr ret = new EmptyExpr(form);
                if (RT.meta(form) != null) {
                    ret = new MetaExpr(ret, MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)form).meta()));
                }
                return ret;
            }
            if (form instanceof ISeq) {
                return Compiler.analyzeSeq(context, (ISeq)form, name);
            }
            if (form instanceof IPersistentVector) {
                return VectorExpr.parse(context, (IPersistentVector)form);
            }
            if (form instanceof IRecord) {
                return new ConstantExpr(form);
            }
            if (form instanceof IType) {
                return new ConstantExpr(form);
            }
            if (form instanceof IPersistentMap) {
                return MapExpr.parse(context, (IPersistentMap)form);
            }
            if (form instanceof IPersistentSet) {
                return SetExpr.parse(context, (IPersistentSet)form);
            }
            return new ConstantExpr(form);
        }
        catch (Throwable e) {
            if (!(e instanceof CompilerException)) {
                throw new CompilerException((String)SOURCE_PATH.deref(), Compiler.lineDeref(), Compiler.columnDeref(), e);
            }
            throw (CompilerException)e;
        }
    }

    public static Var isMacro(Object op) {
        if (op instanceof Symbol && Compiler.referenceLocal((Symbol)op) != null) {
            return null;
        }
        if (op instanceof Symbol || op instanceof Var) {
            Var v;
            Var var = v = op instanceof Var ? (Var)op : Compiler.lookupVar((Symbol)op, false, false);
            if (v != null && v.isMacro()) {
                if (v.ns != Compiler.currentNS() && !v.isPublic()) {
                    throw new IllegalStateException("var: " + v + " is not public");
                }
                return v;
            }
        }
        return null;
    }

    public static IFn isInline(Object op, int arity) {
        if (op instanceof Symbol && Compiler.referenceLocal((Symbol)op) != null) {
            return null;
        }
        if (op instanceof Symbol || op instanceof Var) {
            Var v;
            Var var = v = op instanceof Var ? (Var)op : Compiler.lookupVar((Symbol)op, false);
            if (v != null) {
                IFn arityPred;
                if (v.ns != Compiler.currentNS() && !v.isPublic()) {
                    throw new IllegalStateException("var: " + v + " is not public");
                }
                IFn ret = (IFn)RT.get(v.meta(), inlineKey);
                if (ret != null && ((arityPred = (IFn)RT.get(v.meta(), inlineAritiesKey)) == null || RT.booleanCast(arityPred.invoke(arity)))) {
                    return ret;
                }
            }
        }
        return null;
    }

    public static boolean namesStaticMember(Symbol sym) {
        return sym.ns != null && Compiler.namespaceFor(sym) == null;
    }

    public static Object preserveTag(ISeq src, Object dst) {
        Symbol tag = Compiler.tagOf(src);
        if (tag != null && dst instanceof IObj) {
            IPersistentMap meta = RT.meta(dst);
            return ((IObj)dst).withMeta((IPersistentMap)RT.assoc(meta, RT.TAG_KEY, tag));
        }
        return dst;
    }

    public static Object macroexpand1(Object x) {
        if (x instanceof ISeq) {
            ISeq form = (ISeq)x;
            Object op = RT.first(form);
            if (Compiler.isSpecial(op)) {
                return x;
            }
            Var v = Compiler.isMacro(op);
            if (v != null) {
                try {
                    return v.applyTo(RT.cons(form, RT.cons(LOCAL_ENV.get(), form.next())));
                }
                catch (ArityException e) {
                    throw new ArityException(e.actual - 2, e.name);
                }
            }
            if (op instanceof Symbol) {
                Symbol sym = (Symbol)op;
                String sname = sym.name;
                if (sym.name.charAt(0) == '.') {
                    if (RT.length(form) < 2) {
                        throw new IllegalArgumentException("Malformed member expression, expecting (.member target ...)");
                    }
                    Symbol meth = Symbol.intern(sname.substring(1));
                    Object target = RT.second(form);
                    if (HostExpr.maybeClass(target, false) != null) {
                        target = ((IObj)((Object)RT.list(IDENTITY, target))).withMeta(RT.map(RT.TAG_KEY, CLASS));
                    }
                    return Compiler.preserveTag(form, RT.listStar(DOT, target, meth, form.next().next()));
                }
                if (Compiler.namesStaticMember(sym)) {
                    Symbol target = Symbol.intern(sym.ns);
                    Class c = HostExpr.maybeClass(target, false);
                    if (c != null) {
                        Symbol meth = Symbol.intern(sym.name);
                        return Compiler.preserveTag(form, RT.listStar(DOT, target, meth, form.next()));
                    }
                } else {
                    int idx = sname.lastIndexOf(46);
                    if (idx == sname.length() - 1) {
                        return RT.listStar(NEW, Symbol.intern(sname.substring(0, idx)), form.next());
                    }
                }
            }
        }
        return x;
    }

    static Object macroexpand(Object form) {
        Object exf = Compiler.macroexpand1(form);
        if (exf != form) {
            return Compiler.macroexpand(exf);
        }
        return form;
    }

    private static Expr analyzeSeq(C context, ISeq form, String name) {
        Object line = Compiler.lineDeref();
        Object column = Compiler.columnDeref();
        if (RT.meta(form) != null && RT.meta(form).containsKey(RT.LINE_KEY)) {
            line = RT.meta(form).valAt(RT.LINE_KEY);
        }
        if (RT.meta(form) != null && RT.meta(form).containsKey(RT.COLUMN_KEY)) {
            column = RT.meta(form).valAt(RT.COLUMN_KEY);
        }
        Var.pushThreadBindings(RT.map(LINE, line, COLUMN, column));
        try {
            Object me = Compiler.macroexpand1(form);
            if (me != form) {
                Expr expr = Compiler.analyze(context, me, name);
                return expr;
            }
            Object op = RT.first(form);
            if (op == null) {
                throw new IllegalArgumentException("Can't call nil");
            }
            IFn inline = Compiler.isInline(op, RT.count(RT.next(form)));
            if (inline != null) {
                Expr expr = Compiler.analyze(context, Compiler.preserveTag(form, inline.applyTo(RT.next(form))));
                return expr;
            }
            if (op.equals(FN)) {
                Expr expr = FnExpr.parse(context, form, name);
                return expr;
            }
            IParser p = (IParser)specials.valAt(op);
            if (p != null) {
                Expr expr = p.parse(context, form);
                return expr;
            }
            Expr expr = InvokeExpr.parse(context, form);
            return expr;
        }
        catch (Throwable e) {
            if (!(e instanceof CompilerException)) {
                throw new CompilerException((String)SOURCE_PATH.deref(), Compiler.lineDeref(), Compiler.columnDeref(), e);
            }
            throw (CompilerException)e;
        }
        finally {
            Var.popThreadBindings();
        }
    }

    static String errorMsg(String source, int line, int column, String s) {
        return String.format("%s, compiling:(%s:%d:%d)", s, source, line, column);
    }

    public static Object eval(Object form) {
        return Compiler.eval(form, true);
    }

    /*
     * Exception decompiling
     */
    public static Object eval(Object form, boolean freshLoader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 16[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int registerConstant(Object o) {
        if (!CONSTANTS.isBound()) {
            return -1;
        }
        PersistentVector v = (PersistentVector)CONSTANTS.deref();
        IdentityHashMap ids = (IdentityHashMap)CONSTANT_IDS.deref();
        Integer i = (Integer)ids.get(o);
        if (i != null) {
            return i;
        }
        CONSTANTS.set(RT.conj(v, o));
        ids.put(o, v.count());
        return v.count();
    }

    private static KeywordExpr registerKeyword(Keyword keyword) {
        if (!KEYWORDS.isBound()) {
            return new KeywordExpr(keyword);
        }
        IPersistentMap keywordsMap = (IPersistentMap)KEYWORDS.deref();
        Object id = RT.get(keywordsMap, keyword);
        if (id == null) {
            KEYWORDS.set(RT.assoc(keywordsMap, keyword, Compiler.registerConstant(keyword)));
        }
        return new KeywordExpr(keyword);
    }

    private static int registerKeywordCallsite(Keyword keyword) {
        if (!KEYWORD_CALLSITES.isBound()) {
            throw new IllegalAccessError("KEYWORD_CALLSITES is not bound");
        }
        IPersistentVector keywordCallsites = (IPersistentVector)KEYWORD_CALLSITES.deref();
        keywordCallsites = keywordCallsites.cons(keyword);
        KEYWORD_CALLSITES.set(keywordCallsites);
        return keywordCallsites.count() - 1;
    }

    private static int registerProtocolCallsite(Var v) {
        if (!PROTOCOL_CALLSITES.isBound()) {
            throw new IllegalAccessError("PROTOCOL_CALLSITES is not bound");
        }
        IPersistentVector protocolCallsites = (IPersistentVector)PROTOCOL_CALLSITES.deref();
        protocolCallsites = protocolCallsites.cons(v);
        PROTOCOL_CALLSITES.set(protocolCallsites);
        return protocolCallsites.count() - 1;
    }

    static ISeq fwdPath(PathNode p1) {
        ISeq ret = null;
        while (p1 != null) {
            ret = RT.cons(p1, ret);
            p1 = p1.parent;
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    static PathNode commonPath(PathNode n1, PathNode n2) {
        xp = Compiler.fwdPath(n1);
        yp = Compiler.fwdPath(n2);
        if (RT.first(xp) == RT.first(yp)) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            xp = xp.next();
            yp = yp.next();
lbl7:
            // 2 sources

            ** while (RT.second((Object)xp) != null && RT.second((Object)xp) == RT.second((Object)yp))
        }
lbl8:
        // 1 sources

        return (PathNode)RT.first(xp);
    }

    static void addAnnotation(Object visitor, IPersistentMap meta) {
        try {
            if (meta != null && ADD_ANNOTATIONS.isBound()) {
                ADD_ANNOTATIONS.invoke(visitor, meta);
            }
        }
        catch (Exception e) {
            throw Util.sneakyThrow(e);
        }
    }

    static void addParameterAnnotation(Object visitor, IPersistentMap meta, int i) {
        try {
            if (meta != null && ADD_ANNOTATIONS.isBound()) {
                ADD_ANNOTATIONS.invoke(visitor, meta, i);
            }
        }
        catch (Exception e) {
            throw Util.sneakyThrow(e);
        }
    }

    private static Expr analyzeSymbol(Symbol sym) {
        Object o;
        Symbol nsSym;
        Class c;
        Symbol tag = Compiler.tagOf(sym);
        if (sym.ns == null) {
            LocalBinding b = Compiler.referenceLocal(sym);
            if (b != null) {
                return new LocalBindingExpr(b, tag);
            }
        } else if (Compiler.namespaceFor(sym) == null && (c = HostExpr.maybeClass(nsSym = Symbol.intern(sym.ns), false)) != null) {
            if (Reflector.getField(c, sym.name, true) != null) {
                return new StaticFieldExpr(Compiler.lineDeref(), Compiler.columnDeref(), c, sym.name, tag);
            }
            throw Util.runtimeException("Unable to find static field: " + sym.name + " in " + c);
        }
        if ((o = Compiler.resolve(sym)) instanceof Var) {
            Var v = (Var)o;
            if (Compiler.isMacro(v) != null) {
                throw Util.runtimeException("Can't take value of a macro: " + v);
            }
            if (RT.booleanCast(RT.get(v.meta(), RT.CONST_KEY))) {
                return Compiler.analyze(C.EXPRESSION, RT.list(QUOTE, v.get()));
            }
            Compiler.registerVar(v);
            return new VarExpr(v, tag);
        }
        if (o instanceof Class) {
            return new ConstantExpr(o);
        }
        if (o instanceof Symbol) {
            return new UnresolvedVarExpr((Symbol)o);
        }
        throw Util.runtimeException("Unable to resolve symbol: " + sym + " in this context");
    }

    static String destubClassName(String className) {
        if (className.startsWith(COMPILE_STUB_PREFIX)) {
            return className.substring(COMPILE_STUB_PREFIX.length() + 1);
        }
        return className;
    }

    static Type getType(Class c) {
        String descriptor = Type.getType(c).getDescriptor();
        if (descriptor.startsWith("L")) {
            descriptor = "L" + Compiler.destubClassName(descriptor.substring(1));
        }
        return Type.getType(descriptor);
    }

    static Object resolve(Symbol sym, boolean allowPrivate) {
        return Compiler.resolveIn(Compiler.currentNS(), sym, allowPrivate);
    }

    static Object resolve(Symbol sym) {
        return Compiler.resolveIn(Compiler.currentNS(), sym, false);
    }

    static Namespace namespaceFor(Symbol sym) {
        return Compiler.namespaceFor(Compiler.currentNS(), sym);
    }

    static Namespace namespaceFor(Namespace inns, Symbol sym) {
        Symbol nsSym = Symbol.intern(sym.ns);
        Namespace ns = inns.lookupAlias(nsSym);
        if (ns == null) {
            ns = Namespace.find(nsSym);
        }
        return ns;
    }

    public static Object resolveIn(Namespace n, Symbol sym, boolean allowPrivate) {
        if (sym.ns != null) {
            Namespace ns = Compiler.namespaceFor(n, sym);
            if (ns == null) {
                throw Util.runtimeException("No such namespace: " + sym.ns);
            }
            Var v = ns.findInternedVar(Symbol.intern(sym.name));
            if (v == null) {
                throw Util.runtimeException("No such var: " + sym);
            }
            if (v.ns != Compiler.currentNS() && !v.isPublic() && !allowPrivate) {
                throw new IllegalStateException("var: " + sym + " is not public");
            }
            return v;
        }
        if (sym.name.indexOf(46) > 0 || sym.name.charAt(0) == '[') {
            return RT.classForName(sym.name);
        }
        if (sym.equals(NS)) {
            return RT.NS_VAR;
        }
        if (sym.equals(IN_NS)) {
            return RT.IN_NS_VAR;
        }
        if (Util.equals(sym, COMPILE_STUB_SYM.get())) {
            return COMPILE_STUB_CLASS.get();
        }
        Object o = n.getMapping(sym);
        if (o == null) {
            if (RT.booleanCast(RT.ALLOW_UNRESOLVED_VARS.deref())) {
                return sym;
            }
            throw Util.runtimeException("Unable to resolve symbol: " + sym + " in this context");
        }
        return o;
    }

    public static Object maybeResolveIn(Namespace n, Symbol sym) {
        if (sym.ns != null) {
            Namespace ns = Compiler.namespaceFor(n, sym);
            if (ns == null) {
                return null;
            }
            Var v = ns.findInternedVar(Symbol.intern(sym.name));
            if (v == null) {
                return null;
            }
            return v;
        }
        if (sym.name.indexOf(46) > 0 && !sym.name.endsWith(".") || sym.name.charAt(0) == '[') {
            return RT.classForName(sym.name);
        }
        if (sym.equals(NS)) {
            return RT.NS_VAR;
        }
        if (sym.equals(IN_NS)) {
            return RT.IN_NS_VAR;
        }
        Object o = n.getMapping(sym);
        return o;
    }

    static Var lookupVar(Symbol sym, boolean internNew, boolean registerMacro) {
        Var var = null;
        if (sym.ns != null) {
            Namespace ns = Compiler.namespaceFor(sym);
            if (ns == null) {
                return null;
            }
            Symbol name = Symbol.intern(sym.name);
            var = internNew && ns == Compiler.currentNS() ? Compiler.currentNS().intern(name) : ns.findInternedVar(name);
        } else if (sym.equals(NS)) {
            var = RT.NS_VAR;
        } else if (sym.equals(IN_NS)) {
            var = RT.IN_NS_VAR;
        } else {
            Object o = Compiler.currentNS().getMapping(sym);
            if (o == null) {
                if (internNew) {
                    var = Compiler.currentNS().intern(Symbol.intern(sym.name));
                }
            } else if (o instanceof Var) {
                var = (Var)o;
            } else {
                throw Util.runtimeException("Expecting var, but " + sym + " is mapped to " + o);
            }
        }
        if (var != null && (!var.isMacro() || registerMacro)) {
            Compiler.registerVar(var);
        }
        return var;
    }

    static Var lookupVar(Symbol sym, boolean internNew) {
        return Compiler.lookupVar(sym, internNew, true);
    }

    private static void registerVar(Var var) {
        if (!VARS.isBound()) {
            return;
        }
        IPersistentMap varsMap = (IPersistentMap)VARS.deref();
        Object id = RT.get(varsMap, var);
        if (id == null) {
            VARS.set(RT.assoc(varsMap, var, Compiler.registerConstant(var)));
        }
    }

    static Namespace currentNS() {
        return (Namespace)RT.CURRENT_NS.deref();
    }

    static void closeOver(LocalBinding b, ObjMethod method) {
        if (b != null && method != null) {
            if (RT.get(method.locals, b) == null) {
                method.objx.closes = (IPersistentMap)RT.assoc(method.objx.closes, b, b);
                Compiler.closeOver(b, method.parent);
            } else if (IN_CATCH_FINALLY.deref() != null) {
                method.localsUsedInCatchFinally = (PersistentHashSet)method.localsUsedInCatchFinally.cons(b.idx);
            }
        }
    }

    static LocalBinding referenceLocal(Symbol sym) {
        if (!LOCAL_ENV.isBound()) {
            return null;
        }
        LocalBinding b = (LocalBinding)RT.get(LOCAL_ENV.deref(), sym);
        if (b != null) {
            ObjMethod method = (ObjMethod)METHOD.deref();
            Compiler.closeOver(b, method);
        }
        return b;
    }

    private static Symbol tagOf(Object o) {
        Object tag = RT.get(RT.meta(o), RT.TAG_KEY);
        if (tag instanceof Symbol) {
            return (Symbol)tag;
        }
        if (tag instanceof String) {
            return Symbol.intern(null, (String)tag);
        }
        return null;
    }

    public static Object loadFile(String file) throws IOException {
        try (FileInputStream f = new FileInputStream(file);){
            Object object = Compiler.load(new InputStreamReader((InputStream)f, RT.UTF8), new File(file).getAbsolutePath(), new File(file).getName());
            return object;
        }
    }

    public static Object load(Reader rdr) {
        return Compiler.load(rdr, null, "NO_SOURCE_FILE");
    }

    public static Object load(Reader rdr, String sourcePath, String sourceName) {
        Object EOF = new Object();
        Object ret = null;
        LineNumberingPushbackReader pushbackReader = rdr instanceof LineNumberingPushbackReader ? (LineNumberingPushbackReader)rdr : new LineNumberingPushbackReader(rdr);
        Var.pushThreadBindings(RT.mapUniqueKeys(LOADER, RT.makeClassLoader(), SOURCE_PATH, sourcePath, SOURCE, sourceName, METHOD, null, LOCAL_ENV, null, LOOP_LOCALS, null, NEXT_LOCAL_NUM, 0, RT.READEVAL, RT.T, RT.CURRENT_NS, RT.CURRENT_NS.deref(), LINE_BEFORE, pushbackReader.getLineNumber(), COLUMN_BEFORE, pushbackReader.getColumnNumber(), LINE_AFTER, pushbackReader.getLineNumber(), COLUMN_AFTER, pushbackReader.getColumnNumber(), RT.UNCHECKED_MATH, RT.UNCHECKED_MATH.deref(), RT.WARN_ON_REFLECTION, RT.WARN_ON_REFLECTION.deref(), RT.DATA_READERS, RT.DATA_READERS.deref()));
        try {
            try {
                Object r = LispReader.read(pushbackReader, false, EOF, false);
                while (r != EOF) {
                    LINE_AFTER.set(pushbackReader.getLineNumber());
                    COLUMN_AFTER.set(pushbackReader.getColumnNumber());
                    ret = Compiler.eval(r, false);
                    LINE_BEFORE.set(pushbackReader.getLineNumber());
                    COLUMN_BEFORE.set(pushbackReader.getColumnNumber());
                    r = LispReader.read(pushbackReader, false, EOF, false);
                }
            }
            catch (LispReader.ReaderException e) {
                throw new CompilerException(sourcePath, e.line, e.column, e.getCause());
            }
        }
        finally {
            Var.popThreadBindings();
        }
        return ret;
    }

    public static void writeClassFile(String internalName, byte[] bytecode) throws IOException {
        String genPath = (String)COMPILE_PATH.deref();
        if (genPath == null) {
            throw Util.runtimeException("*compile-path* not set");
        }
        String[] dirs = internalName.split("/");
        String p = genPath;
        int i = 0;
        while (i < dirs.length - 1) {
            p = String.valueOf(p) + File.separator + dirs[i];
            new File(p).mkdir();
            ++i;
        }
        String path = String.valueOf(genPath) + File.separator + internalName + ".class";
        File cf = new File(path);
        cf.createNewFile();
        try (FileOutputStream cfs = new FileOutputStream(cf);){
            cfs.write(bytecode);
            cfs.flush();
            cfs.getFD().sync();
        }
    }

    public static void writeSourceFile(String internalName, String source) throws IOException {
        internalName = internalName.replaceAll("-", DOLLAR);
        String genPath = (String)SOURCE_GEN_PATH.deref();
        if (genPath == null) {
            genPath = "target/gen";
        }
        String[] dirs = internalName.split("/");
        String path = String.valueOf(genPath) + File.separator + internalName + ".java";
        File cf = new File(path);
        cf.getParentFile().mkdirs();
        cf.createNewFile();
        try (FileOutputStream cfs = new FileOutputStream(cf);){
            cfs.write(source.getBytes());
            cfs.flush();
            cfs.getFD().sync();
        }
    }

    public static void pushNS() {
        Var.pushThreadBindings(PersistentHashMap.create(Var.intern(Symbol.intern("clojure.core"), Symbol.intern("*ns*")).setDynamic(), null));
    }

    public static void pushNSandLoader(ClassLoader loader) {
        Var.pushThreadBindings(RT.map(Var.intern(Symbol.intern("clojure.core"), Symbol.intern("*ns*")).setDynamic(), null, RT.FN_LOADER_VAR, loader, RT.READEVAL, RT.T));
    }

    public static ILookupThunk getLookupThunk(Object target, Keyword k) {
        return null;
    }

    static void compile1(GeneratorAdapter gen, ObjExpr objx, Object form) {
        Object line = Compiler.lineDeref();
        Object column = Compiler.columnDeref();
        if (RT.meta(form) != null && RT.meta(form).containsKey(RT.LINE_KEY)) {
            line = RT.meta(form).valAt(RT.LINE_KEY);
        }
        if (RT.meta(form) != null && RT.meta(form).containsKey(RT.COLUMN_KEY)) {
            column = RT.meta(form).valAt(RT.COLUMN_KEY);
        }
        Var.pushThreadBindings(RT.map(LINE, line, COLUMN, column, LOADER, RT.makeClassLoader()));
        try {
            form = Compiler.macroexpand(form);
            if (form instanceof ISeq && Util.equals(RT.first(form), DO)) {
                ISeq s = RT.next(form);
                while (s != null) {
                    Compiler.compile1(gen, objx, RT.first(s));
                    s = RT.next(s);
                }
            } else {
                Expr expr = Compiler.analyze(C.EVAL, form);
                objx.keywords = (IPersistentMap)KEYWORDS.deref();
                objx.vars = (IPersistentMap)VARS.deref();
                objx.constants = (PersistentVector)CONSTANTS.deref();
                Compiler.emitSource(expr.emit(C.STATEMENT, objx, gen));
                expr.eval();
            }
        }
        finally {
            Var.popThreadBindings();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object compile(Reader rdr, String sourcePath, String sourceName) throws IOException {
        if (COMPILE_PATH.deref() == null) {
            throw Util.runtimeException("*compile-path* not set");
        }
        Object EOF = new Object();
        Object ret = null;
        LineNumberingPushbackReader pushbackReader = rdr instanceof LineNumberingPushbackReader ? (LineNumberingPushbackReader)rdr : new LineNumberingPushbackReader(rdr);
        Var.pushThreadBindings(RT.mapUniqueKeys(SOURCE_PATH, sourcePath, SOURCE, sourceName, METHOD, null, LOCAL_ENV, null, LOOP_LOCALS, null, NEXT_LOCAL_NUM, 0, RT.READEVAL, RT.T, RT.CURRENT_NS, RT.CURRENT_NS.deref(), LINE_BEFORE, pushbackReader.getLineNumber(), COLUMN_BEFORE, pushbackReader.getColumnNumber(), LINE_AFTER, pushbackReader.getLineNumber(), COLUMN_AFTER, pushbackReader.getColumnNumber(), CONSTANTS, PersistentVector.EMPTY, CONSTANT_IDS, new IdentityHashMap(), KEYWORDS, PersistentHashMap.EMPTY, VARS, PersistentHashMap.EMPTY, RT.UNCHECKED_MATH, RT.UNCHECKED_MATH.deref(), RT.WARN_ON_REFLECTION, RT.WARN_ON_REFLECTION.deref(), RT.DATA_READERS, RT.DATA_READERS.deref()));
        try {
            try {
                ClassWriter cw;
                ObjExpr objx = new ObjExpr(null);
                objx.internalName = String.valueOf(sourcePath.replace(File.separator, "/").substring(0, sourcePath.lastIndexOf(46))) + "__init";
                objx.objtype = Type.getObjectType(objx.internalName);
                ClassWriter cv = cw = new ClassWriter(1);
                int lastSlash = objx.internalName.lastIndexOf(47);
                String className = objx.internalName.substring(lastSlash + 1);
                String packageName = objx.internalName.substring(0, lastSlash).replaceAll("/", ".");
                SourceWriter source = cw.getSc();
                Var.pushThreadBindings(RT.mapUniqueKeys(SOURCE_WRITER, source));
                Compiler.emitSource("package " + packageName + ";");
                Compiler.emitSource();
                Compiler.emitSource("import clojure.lang.*;");
                Compiler.emitSource();
                Compiler.emitSource("public class " + className + " {");
                Compiler.tab();
                cv.visit(49, 33, objx.internalName, null, "java/lang/Object", null);
                Compiler.emitSource("public static void load() throws Exception {");
                GeneratorAdapter gen = new GeneratorAdapter(9, clojure.asm.commons.Method.getMethod("void load ()"), null, null, cv);
                Compiler.tab();
                gen.visitCode();
                Object r = LispReader.read(pushbackReader, false, EOF, false);
                while (r != EOF) {
                    LINE_AFTER.set(pushbackReader.getLineNumber());
                    COLUMN_AFTER.set(pushbackReader.getColumnNumber());
                    Compiler.compile1(gen, objx, r);
                    LINE_BEFORE.set(pushbackReader.getLineNumber());
                    COLUMN_BEFORE.set(pushbackReader.getColumnNumber());
                    r = LispReader.read(pushbackReader, false, EOF, false);
                }
                gen.returnValue();
                gen.endMethod();
                Compiler.untab();
                Compiler.emitSource("}");
                int i = 0;
                while (i < objx.constants.count()) {
                    cv.visitField(25, objx.constantName(i), objx.constantType(i).getDescriptor(), null, null);
                    Compiler.emitSource("private static " + Compiler.printClass(objx.constantRealType(i)) + " " + objx.constantName(i) + ";");
                    ++i;
                }
                int INITS_PER = 100;
                int numInits = objx.constants.count() / 100;
                if (objx.constants.count() % 100 != 0) {
                    ++numInits;
                }
                int n = 0;
                while (n < numInits) {
                    GeneratorAdapter clinitgen = new GeneratorAdapter(9, clojure.asm.commons.Method.getMethod("void __init" + n + "()"), null, null, cv);
                    Compiler.emitSource("static void __init" + n + "() {");
                    Compiler.tab();
                    clinitgen.visitCode();
                    try {
                        Var.pushThreadBindings(RT.map(RT.PRINT_DUP, RT.T));
                        int i2 = n * 100;
                        while (i2 < objx.constants.count() && i2 < (n + 1) * 100) {
                            String val = objx.emitValue(objx.constants.nth(i2), clinitgen);
                            clinitgen.checkCast(objx.constantType(i2));
                            clinitgen.putStatic(objx.objtype, objx.constantName(i2), objx.constantType(i2));
                            Compiler.emitSource(String.valueOf(objx.constantName(i2)) + " = (" + Compiler.printClass(objx.constantRealType(i2)) + ")" + val + ";");
                            ++i2;
                        }
                    }
                    finally {
                        Var.popThreadBindings();
                    }
                    Compiler.untab();
                    Compiler.emitSource("}");
                    clinitgen.returnValue();
                    clinitgen.endMethod();
                    ++n;
                }
                Compiler.emitSource("static {");
                Compiler.tab();
                GeneratorAdapter clinitgen = new GeneratorAdapter(9, clojure.asm.commons.Method.getMethod("void <clinit> ()"), null, null, cv);
                clinitgen.visitCode();
                Label startTry = clinitgen.newLabel();
                Label endTry = clinitgen.newLabel();
                Label end = clinitgen.newLabel();
                Label finallyLabel = clinitgen.newLabel();
                int n2 = 0;
                while (n2 < numInits) {
                    clinitgen.invokeStatic(objx.objtype, clojure.asm.commons.Method.getMethod("void __init" + n2 + "()"));
                    Compiler.emitSource("__init" + n2 + "();");
                    ++n2;
                }
                String iname = objx.internalName.replace('/', '.');
                clinitgen.push(iname);
                clinitgen.invokeStatic(CLASS_TYPE, clojure.asm.commons.Method.getMethod("Class forName(String)"));
                clinitgen.invokeVirtual(CLASS_TYPE, clojure.asm.commons.Method.getMethod("ClassLoader getClassLoader()"));
                clinitgen.invokeStatic(Type.getType(Compiler.class), clojure.asm.commons.Method.getMethod("void pushNSandLoader(ClassLoader)"));
                clinitgen.mark(startTry);
                clinitgen.invokeStatic(objx.objtype, clojure.asm.commons.Method.getMethod("void load()"));
                clinitgen.mark(endTry);
                clinitgen.invokeStatic(VAR_TYPE, clojure.asm.commons.Method.getMethod("void popThreadBindings()"));
                clinitgen.goTo(end);
                clinitgen.mark(finallyLabel);
                clinitgen.invokeStatic(VAR_TYPE, clojure.asm.commons.Method.getMethod("void popThreadBindings()"));
                clinitgen.throwException();
                clinitgen.mark(end);
                clinitgen.visitTryCatchBlock(startTry, endTry, finallyLabel, null);
                clinitgen.returnValue();
                clinitgen.endMethod();
                cv.visitEnd();
                Compiler.emitSource("clojure.lang.Compiler.pushNSandLoader(" + iname + ".class.getClassLoader());");
                Compiler.emitSource("try {");
                Compiler.tab();
                Compiler.emitSource("load();");
                Compiler.untab();
                Compiler.emitSource("} catch (Exception ___x) {");
                Compiler.emitSource("throw new RuntimeException(___x);");
                Compiler.emitSource("} finally {");
                Compiler.tab();
                Compiler.emitSource("Var.popThreadBindings();");
                Compiler.untab();
                Compiler.emitSource("}");
                Compiler.untab();
                Compiler.emitSource("}");
                Compiler.untab();
                Compiler.emitSource("}");
                Var.popThreadBindings();
                Compiler.writeClassFile(objx.internalName, cw.toByteArray());
                Compiler.writeSourceFile(objx.internalName, source.toString());
                return ret;
            }
            catch (LispReader.ReaderException e) {
                throw new CompilerException(sourcePath, e.line, e.column, e.getCause());
            }
        }
        finally {
            Var.popThreadBindings();
        }
    }

    static Class primClass(Symbol sym) {
        if (sym == null) {
            return null;
        }
        Class<Object> c = null;
        if (sym.name.equals("int")) {
            c = Integer.TYPE;
        } else if (sym.name.equals("long")) {
            c = Long.TYPE;
        } else if (sym.name.equals("float")) {
            c = Float.TYPE;
        } else if (sym.name.equals("double")) {
            c = Double.TYPE;
        } else if (sym.name.equals("char")) {
            c = Character.TYPE;
        } else if (sym.name.equals("short")) {
            c = Short.TYPE;
        } else if (sym.name.equals("byte")) {
            c = Byte.TYPE;
        } else if (sym.name.equals("boolean")) {
            c = Boolean.TYPE;
        } else if (sym.name.equals("void")) {
            c = Void.TYPE;
        }
        return c;
    }

    static Class tagClass(Object tag) {
        if (tag == null) {
            return Object.class;
        }
        Class c = null;
        if (tag instanceof Symbol) {
            c = Compiler.primClass((Symbol)tag);
        }
        if (c == null) {
            c = HostExpr.tagToClass(tag);
        }
        return c;
    }

    static Class primClass(Class c) {
        return c.isPrimitive() ? c : Object.class;
    }

    static Class boxClass(Class p) {
        if (!p.isPrimitive()) {
            return p;
        }
        Class c = null;
        if (p == Integer.TYPE) {
            c = Integer.class;
        } else if (p == Long.TYPE) {
            c = Long.class;
        } else if (p == Float.TYPE) {
            c = Float.class;
        } else if (p == Double.TYPE) {
            c = Double.class;
        } else if (p == Character.TYPE) {
            c = Character.class;
        } else if (p == Short.TYPE) {
            c = Short.class;
        } else if (p == Byte.TYPE) {
            c = Byte.class;
        } else if (p == Boolean.TYPE) {
            c = Boolean.class;
        }
        return c;
    }

    static IPersistentCollection emptyVarCallSites() {
        return PersistentHashSet.EMPTY;
    }

    private static String wrap(C context, String v) {
        if (C.RETURN == context) {
            Class retClass;
            Class clazz = retClass = RETURN_TYPE.isBound() ? (Class)RETURN_TYPE.deref() : Object.class;
            if (retClass != Void.TYPE) {
                v = "return " + Compiler.unboxVal(retClass, v);
            }
        }
        return String.valueOf(v) + (C.EXPRESSION != context ? ";" : "");
    }

    public static String unboxVal(Class c, String v) {
        switch (Type.getType(c).getSort()) {
            case 2: {
                v = "RT.charCast(" + v + ")";
                break;
            }
            case 1: {
                v = "RT.booleanCast(" + v + ")";
                break;
            }
            case 8: {
                v = "RT.doubleCast(" + v + ")";
                break;
            }
            case 6: {
                v = "RT.floatCast(" + v + ")";
                break;
            }
            case 7: {
                v = "RT.longCast(" + v + ")";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                v = "RT.intCast(" + v + ")";
                break;
            }
            default: {
                if (c == Object.class || c == Void.TYPE) break;
                v = "(" + Compiler.printClass(c) + ")" + v;
            }
        }
        return v;
    }

    private static void emitAssigRet(C context, String r, String body) {
        boolean ex;
        boolean bl = ex = context == C.EXPRESSION;
        if (body.equals("continue;")) {
            Compiler.emitSource(body);
        } else {
            Compiler.emitSource(String.valueOf(ex ? String.valueOf(r) + " = " : "") + body + (ex ? ";" : ""));
        }
    }

    public static class AssignExpr
    implements Expr {
        public final AssignableExpr target;
        public final Expr val;

        public AssignExpr(AssignableExpr target, Expr val) {
            this.target = target;
            this.val = val;
        }

        @Override
        public Object eval() {
            return this.target.evalAssign(this.val);
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            return this.target.emitAssign(context, objx, gen, this.val);
        }

        @Override
        public boolean hasJavaClass() {
            return this.val.hasJavaClass();
        }

        @Override
        public Class getJavaClass() {
            return this.val.getJavaClass();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object frm) {
                ISeq form = (ISeq)frm;
                if (RT.length(form) != 3) {
                    throw new IllegalArgumentException("Malformed assignment, expecting (set! target val)");
                }
                Expr target = Compiler.analyze(C.EXPRESSION, RT.second(form));
                if (!(target instanceof AssignableExpr)) {
                    throw new IllegalArgumentException("Invalid assignment target");
                }
                return new AssignExpr((AssignableExpr)((Object)target), Compiler.analyze(C.EXPRESSION, RT.third(form)));
            }
        }
    }

    static interface AssignableExpr {
        public Object evalAssign(Expr var1);

        public String emitAssign(C var1, ObjExpr var2, GeneratorAdapter var3, Expr var4);
    }

    public static class BindingInit {
        LocalBinding binding;
        Expr init;

        public final LocalBinding binding() {
            return this.binding;
        }

        public final Expr init() {
            return this.init;
        }

        public BindingInit(LocalBinding binding, Expr init) {
            this.binding = binding;
            this.init = init;
        }
    }

    public static class BodyExpr
    implements Expr,
    MaybePrimitiveExpr {
        PersistentVector exprs;

        public final PersistentVector exprs() {
            return this.exprs;
        }

        public BodyExpr(PersistentVector exprs) {
            this.exprs = exprs;
        }

        @Override
        public Object eval() {
            Object ret = null;
            for (Object o : this.exprs) {
                Expr e = (Expr)o;
                ret = e.eval();
            }
            return ret;
        }

        @Override
        public boolean canEmitPrimitive() {
            return this.lastExpr() instanceof MaybePrimitiveExpr && ((MaybePrimitiveExpr)this.lastExpr()).canEmitPrimitive();
        }

        @Override
        public String emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            int i = 0;
            while (i < this.exprs.count() - 1) {
                Expr e = (Expr)this.exprs.nth(i);
                String emit = e.emit(C.STATEMENT, objx, gen);
                if (emit == null) {
                    return null;
                }
                Compiler.emitSource(emit);
                ++i;
            }
            MaybePrimitiveExpr last = (MaybePrimitiveExpr)this.exprs.nth(this.exprs.count() - 1);
            return last.emitUnboxed(context, objx, gen);
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            int i = 0;
            while (i < this.exprs.count() - 1) {
                Expr e = (Expr)this.exprs.nth(i);
                String emit = e.emit(C.STATEMENT, objx, gen);
                if (emit == null) {
                    return null;
                }
                Compiler.emitSource(emit);
                ++i;
            }
            Expr last = (Expr)this.exprs.nth(this.exprs.count() - 1);
            return last.emit(context, objx, gen);
        }

        @Override
        public boolean hasJavaClass() {
            return this.lastExpr().hasJavaClass();
        }

        @Override
        public Class getJavaClass() {
            return this.lastExpr().getJavaClass();
        }

        private Expr lastExpr() {
            return (Expr)this.exprs.nth(this.exprs.count() - 1);
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object frms) {
                ISeq forms = (ISeq)frms;
                if (Util.equals(RT.first(forms), DO)) {
                    forms = RT.next(forms);
                }
                PersistentVector exprs = PersistentVector.EMPTY;
                while (forms != null) {
                    Expr e = context != C.EVAL && (context == C.STATEMENT || forms.next() != null) ? Compiler.analyze(C.STATEMENT, forms.first()) : Compiler.analyze(context, forms.first());
                    exprs = exprs.cons(e);
                    forms = forms.next();
                }
                if (exprs.count() == 0) {
                    exprs = exprs.cons(NIL_EXPR);
                }
                return new BodyExpr(exprs);
            }
        }
    }

    static class BooleanExpr
    extends LiteralExpr {
        public final boolean val;

        public BooleanExpr(boolean val) {
            this.val = val;
        }

        @Override
        Object val() {
            return this.val ? RT.T : RT.F;
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (this.val) {
                gen.getStatic(BOOLEAN_OBJECT_TYPE, "TRUE", BOOLEAN_OBJECT_TYPE);
            } else {
                gen.getStatic(BOOLEAN_OBJECT_TYPE, "FALSE", BOOLEAN_OBJECT_TYPE);
            }
            if (context == C.STATEMENT) {
                gen.pop();
                return "";
            }
            return Compiler.wrap(context, this.val ? "Boolean.TRUE" : "Boolean.FALSE");
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return Boolean.class;
        }
    }

    public static enum C {
        STATEMENT,
        EXPRESSION,
        RETURN,
        EVAL;

    }

    public static class CaseExpr
    implements Expr,
    MaybePrimitiveExpr {
        public final LocalBindingExpr expr;
        public final int shift;
        public final int mask;
        public final int low;
        public final int high;
        public final Expr defaultExpr;
        public final SortedMap<Integer, Expr> tests;
        public final HashMap<Integer, Expr> thens;
        public final Keyword switchType;
        public final Keyword testType;
        public final Set<Integer> skipCheck;
        public final Class returnType;
        public final int line;
        public final int column;
        static final Type NUMBER_TYPE = Type.getType(Number.class);
        static final clojure.asm.commons.Method intValueMethod = clojure.asm.commons.Method.getMethod("int intValue()");
        static final clojure.asm.commons.Method hashMethod = clojure.asm.commons.Method.getMethod("int hash(Object)");
        static final clojure.asm.commons.Method hashCodeMethod = clojure.asm.commons.Method.getMethod("int hashCode()");
        static final clojure.asm.commons.Method equivMethod = clojure.asm.commons.Method.getMethod("boolean equiv(Object, Object)");
        static final Keyword compactKey = Keyword.intern(null, "compact");
        static final Keyword sparseKey = Keyword.intern(null, "sparse");
        static final Keyword hashIdentityKey = Keyword.intern(null, "hash-identity");
        static final Keyword hashEquivKey = Keyword.intern(null, "hash-equiv");
        static final Keyword intKey = Keyword.intern(null, "int");

        public CaseExpr(int line, int column, LocalBindingExpr expr, int shift, int mask, int low, int high, Expr defaultExpr, SortedMap<Integer, Expr> tests, HashMap<Integer, Expr> thens, Keyword switchType, Keyword testType, Set<Integer> skipCheck) {
            this.expr = expr;
            this.shift = shift;
            this.mask = mask;
            this.low = low;
            this.high = high;
            this.defaultExpr = defaultExpr;
            this.tests = tests;
            this.thens = thens;
            this.line = line;
            this.column = column;
            if (switchType != compactKey && switchType != sparseKey) {
                throw new IllegalArgumentException("Unexpected switch type: " + switchType);
            }
            this.switchType = switchType;
            if (testType != intKey && testType != hashEquivKey && testType != hashIdentityKey) {
                throw new IllegalArgumentException("Unexpected test type: " + switchType);
            }
            this.testType = testType;
            this.skipCheck = skipCheck;
            ArrayList<Expr> returns = new ArrayList<Expr>(thens.values());
            returns.add(defaultExpr);
            this.returnType = Compiler.maybeJavaClass(returns);
            if (RT.count(skipCheck) > 0 && RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                RT.errPrintWriter().format("Performance warning, %s:%d:%d - hash collision of some case test constants; if selected, those entries will be tested sequentially.\n", SOURCE_PATH.deref(), line, column);
            }
        }

        @Override
        public boolean hasJavaClass() {
            return this.returnType != null;
        }

        @Override
        public boolean canEmitPrimitive() {
            return Util.isPrimitive(this.returnType);
        }

        @Override
        public Class getJavaClass() {
            return this.returnType;
        }

        @Override
        public Object eval() {
            throw new UnsupportedOperationException("Can't eval case");
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            return this.doEmit(context, objx, gen, false);
        }

        @Override
        public String emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            return this.doEmit(context, objx, gen, true);
        }

        public String doEmit(C context, ObjExpr objx, GeneratorAdapter gen, boolean emitUnboxed) {
            Label[] la;
            String r = Compiler.registerTemp();
            Label defaultLabel = gen.newLabel();
            Label endLabel = gen.newLabel();
            TreeMap<Integer, Label> labels = new TreeMap<Integer, Label>();
            if (context == C.EXPRESSION) {
                Compiler.emitSource("Object " + r + " = null;");
            }
            for (Integer i : this.tests.keySet()) {
                labels.put(i, gen.newLabel());
            }
            gen.visitLineNumber(this.line, gen.mark());
            Class primExprClass = Compiler.maybePrimitiveType(this.expr);
            Type primExprType = primExprClass == null ? null : Type.getType(primExprClass);
            String cond = this.testType == intKey ? this.emitExprForInts(objx, gen, primExprType, defaultLabel) : this.emitExprForHashes(objx, gen);
            Compiler.emitSource("switch (" + cond + ") {");
            Compiler.tab();
            if (this.switchType == sparseKey) {
                la = new Label[labels.size()];
                la = labels.values().toArray(la);
                int[] ints = Numbers.int_array(this.tests.keySet());
                gen.visitLookupSwitchInsn(defaultLabel, ints, la);
            } else {
                la = new Label[this.high - this.low + 1];
                int i = this.low;
                while (i <= this.high) {
                    la[i - this.low] = labels.containsKey(i) ? (Label)labels.get(i) : defaultLabel;
                    ++i;
                }
                gen.visitTableSwitchInsn(this.low, this.high, defaultLabel, la);
            }
            int pos = 0;
            for (Integer i : labels.keySet()) {
                Compiler.emitSource("case " + i + ":");
                ++pos;
                Compiler.tab();
                gen.mark((Label)labels.get(i));
                if (this.testType == intKey) {
                    this.emitThenForInts(context, r, objx, gen, primExprType, (Expr)this.tests.get(i), this.thens.get(i), defaultLabel, emitUnboxed);
                } else if (RT.contains(this.skipCheck, i) == RT.T) {
                    String e = CaseExpr.emitExpr(objx, gen, this.thens.get(i), emitUnboxed);
                    if (!(e == null || this.thens.get(i) instanceof LiteralExpr && context == C.STATEMENT)) {
                        Compiler.emitAssigRet(context, r, Compiler.wrap(context, e));
                    }
                    if (context != C.RETURN) {
                        Compiler.emitSource("break;");
                    }
                } else {
                    this.emitThenForHashes(context, r, objx, gen, (Expr)this.tests.get(i), this.thens.get(i), defaultLabel, emitUnboxed);
                }
                gen.goTo(endLabel);
                Compiler.untab();
            }
            gen.mark(defaultLabel);
            Compiler.emitSource("default:");
            Compiler.tab();
            String e = CaseExpr.emitExpr(objx, gen, this.defaultExpr, emitUnboxed);
            if (!(e == null || this.defaultExpr instanceof LiteralExpr && context == C.STATEMENT)) {
                Compiler.emitAssigRet(context, r, Compiler.wrap(context, e));
            }
            Compiler.untab();
            Compiler.untab();
            Compiler.emitSource("}");
            gen.mark(endLabel);
            if (context == C.STATEMENT) {
                gen.pop();
            }
            return context == C.EXPRESSION ? r : "";
        }

        private boolean isShiftMasked() {
            return this.mask != 0;
        }

        private String emitShiftMask(GeneratorAdapter gen, String v) {
            if (this.isShiftMasked()) {
                gen.push(this.shift);
                gen.visitInsn(122);
                gen.push(this.mask);
                gen.visitInsn(126);
                return String.valueOf(v) + " >> " + this.shift + " & " + this.mask;
            }
            return v;
        }

        private String emitExprForInts(ObjExpr objx, GeneratorAdapter gen, Type exprType, Label defaultLabel) {
            if (exprType == null) {
                if (RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                    RT.errPrintWriter().format("Performance warning, %s:%d:%d - case has int tests, but tested expression is not primitive.\n", SOURCE_PATH.deref(), this.line, this.column);
                }
                String val = this.expr.emit(C.EXPRESSION, objx, gen);
                gen.instanceOf(NUMBER_TYPE);
                gen.ifZCmp(153, defaultLabel);
                this.expr.emit(C.EXPRESSION, objx, gen);
                gen.checkCast(NUMBER_TYPE);
                gen.invokeVirtual(NUMBER_TYPE, intValueMethod);
                return this.emitShiftMask(gen, "RT.uncheckedIntCast(" + val + ")");
            }
            if (exprType == Type.LONG_TYPE || exprType == Type.INT_TYPE || exprType == Type.SHORT_TYPE || exprType == Type.BYTE_TYPE) {
                String val = this.expr.emitUnboxed(C.EXPRESSION, objx, gen);
                gen.cast(exprType, Type.INT_TYPE);
                return this.emitShiftMask(gen, "(int)" + val);
            }
            gen.goTo(defaultLabel);
            return "-666123";
        }

        private void emitThenForInts(C context, String r, ObjExpr objx, GeneratorAdapter gen, Type exprType, Expr test, Expr then, Label defaultLabel, boolean emitUnboxed) {
            if (exprType == null) {
                String val = this.expr.emit(C.EXPRESSION, objx, gen);
                String tval = test.emit(C.EXPRESSION, objx, gen);
                gen.invokeStatic(UTIL_TYPE, equivMethod);
                gen.ifZCmp(153, defaultLabel);
                Compiler.emitSource("if (Util.equiv(" + val + ", " + tval + ")) {");
                Compiler.tab();
                String body = CaseExpr.emitExpr(objx, gen, then, emitUnboxed);
                if (!(body == null || then instanceof LiteralExpr && context == C.STATEMENT)) {
                    Compiler.emitAssigRet(context, r, Compiler.wrap(context, body));
                }
                if (context != C.RETURN) {
                    Compiler.emitSource("break;");
                }
                Compiler.untab();
                Compiler.emitSource("}");
            } else if (exprType == Type.LONG_TYPE) {
                String val = ((NumberExpr)test).emitUnboxed(C.EXPRESSION, objx, gen);
                String tval = this.expr.emitUnboxed(C.EXPRESSION, objx, gen);
                gen.ifCmp(Type.LONG_TYPE, 154, defaultLabel);
                Compiler.emitSource("if (" + val + " == " + tval + ") {");
                Compiler.tab();
                String body = CaseExpr.emitExpr(objx, gen, then, emitUnboxed);
                if (!(body == null || then instanceof LiteralExpr && context == C.STATEMENT)) {
                    Compiler.emitAssigRet(context, r, Compiler.wrap(context, body));
                }
                if (context != C.RETURN) {
                    Compiler.emitSource("break;");
                }
                Compiler.untab();
                Compiler.emitSource("}");
            } else if (exprType == Type.INT_TYPE || exprType == Type.SHORT_TYPE || exprType == Type.BYTE_TYPE) {
                if (this.isShiftMasked()) {
                    ((NumberExpr)test).emitUnboxed(C.EXPRESSION, objx, gen);
                    this.expr.emitUnboxed(C.EXPRESSION, objx, gen);
                    gen.cast(exprType, Type.LONG_TYPE);
                    gen.ifCmp(Type.LONG_TYPE, 154, defaultLabel);
                }
                String val = ((NumberExpr)test).n.toString();
                String tval = this.expr.b.print();
                Compiler.emitSource("if (" + val + " == " + tval + ") {");
                Compiler.tab();
                String body = CaseExpr.emitExpr(objx, gen, then, emitUnboxed);
                if (!(body == null || then instanceof LiteralExpr && context == C.STATEMENT)) {
                    Compiler.emitAssigRet(context, r, Compiler.wrap(context, body));
                }
                if (context != C.RETURN) {
                    Compiler.emitSource("break;");
                }
                Compiler.untab();
                Compiler.emitSource("}");
            } else {
                gen.goTo(defaultLabel);
            }
        }

        private String emitExprForHashes(ObjExpr objx, GeneratorAdapter gen) {
            String val = this.expr.emit(C.EXPRESSION, objx, gen);
            gen.invokeStatic(UTIL_TYPE, hashMethod);
            return this.emitShiftMask(gen, "Util.hash(" + val + ")");
        }

        private void emitThenForHashes(C context, String r, ObjExpr objx, GeneratorAdapter gen, Expr test, Expr then, Label defaultLabel, boolean emitUnboxed) {
            String val = this.expr.emit(C.EXPRESSION, objx, gen);
            String tval = test.emit(C.EXPRESSION, objx, gen);
            if (this.testType == hashIdentityKey) {
                gen.visitJumpInsn(166, defaultLabel);
                Compiler.emitSource("if (" + val + " == " + tval + ") {");
            } else {
                Compiler.emitSource("if (Util.equiv(" + val + ", " + tval + ")) {");
                gen.invokeStatic(UTIL_TYPE, equivMethod);
                gen.ifZCmp(153, defaultLabel);
            }
            Compiler.tab();
            String e = CaseExpr.emitExpr(objx, gen, then, emitUnboxed);
            if (!(e == null || then instanceof LiteralExpr && context == C.STATEMENT)) {
                Compiler.emitAssigRet(context, r, Compiler.wrap(context, e));
            }
            if (context != C.RETURN) {
                Compiler.emitSource("break;");
            }
            Compiler.untab();
            Compiler.emitSource("}");
        }

        private static String emitExpr(ObjExpr objx, GeneratorAdapter gen, Expr expr, boolean emitUnboxed) {
            if (emitUnboxed && expr instanceof MaybePrimitiveExpr) {
                return ((MaybePrimitiveExpr)expr).emitUnboxed(C.EXPRESSION, objx, gen);
            }
            return expr.emit(C.EXPRESSION, objx, gen);
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object frm) {
                Expr defaultExpr;
                ISeq form = (ISeq)frm;
                if (context == C.EVAL) {
                    return Compiler.analyze(context, RT.list(RT.list(FNONCE, PersistentVector.EMPTY, form)));
                }
                PersistentVector args = PersistentVector.create(form.next());
                Object exprForm = args.nth(0);
                int shift = ((Number)args.nth(1)).intValue();
                int mask = ((Number)args.nth(2)).intValue();
                Object defaultForm = args.nth(3);
                Map caseMap = (Map)args.nth(4);
                Keyword switchType = (Keyword)args.nth(5);
                Keyword testType = (Keyword)args.nth(6);
                Set skipCheck = RT.count(args) < 8 ? null : (Set)args.nth(7);
                ISeq keys = RT.keys(caseMap);
                int low = ((Number)RT.first(keys)).intValue();
                int high = ((Number)RT.nth(keys, RT.count(keys) - 1)).intValue();
                LocalBindingExpr testexpr = (LocalBindingExpr)Compiler.analyze(C.EXPRESSION, exprForm);
                testexpr.shouldClear = false;
                TreeMap<Integer, Expr> tests = new TreeMap<Integer, Expr>();
                HashMap<Integer, Expr> thens = new HashMap<Integer, Expr>();
                PathNode branch = new PathNode(PATHTYPE.BRANCH, (PathNode)CLEAR_PATH.get());
                Iterator iterator = caseMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Expr thenExpr;
                    Map.Entry o;
                    Map.Entry e = o = iterator.next();
                    Integer minhash = ((Number)e.getKey()).intValue();
                    Object pair = e.getValue();
                    Expr testExpr = testType == intKey ? NumberExpr.parse(((Number)RT.first(pair)).intValue()) : new ConstantExpr(RT.first(pair));
                    tests.put(minhash, testExpr);
                    try {
                        Var.pushThreadBindings(RT.map(CLEAR_PATH, new PathNode(PATHTYPE.PATH, branch)));
                        thenExpr = Compiler.analyze(context, RT.second(pair));
                    }
                    finally {
                        Var.popThreadBindings();
                    }
                    thens.put(minhash, thenExpr);
                }
                try {
                    Var.pushThreadBindings(RT.map(CLEAR_PATH, new PathNode(PATHTYPE.PATH, branch)));
                    defaultExpr = Compiler.analyze(context, args.nth(3));
                }
                finally {
                    Var.popThreadBindings();
                }
                int line = ((Number)LINE.deref()).intValue();
                int column = ((Number)COLUMN.deref()).intValue();
                return new CaseExpr(line, column, testexpr, shift, mask, low, high, defaultExpr, tests, thens, switchType, testType, skipCheck);
            }
        }
    }

    public static class CompilerException
    extends RuntimeException {
        public final String source;
        public final int line;

        public CompilerException(String source, int line, int column, Throwable cause) {
            super(Compiler.errorMsg(source, line, column, cause.toString()), cause);
            this.source = source;
            this.line = line;
        }

        @Override
        public String toString() {
            return this.getMessage();
        }
    }

    static class ConstantExpr
    extends LiteralExpr {
        public final Object v;
        public final int id;

        public ConstantExpr(Object v) {
            this.v = v;
            this.id = Compiler.registerConstant(v);
        }

        @Override
        Object val() {
            return this.v;
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            String val = objx.emitConstant(gen, this.id);
            if (context == C.STATEMENT) {
                gen.pop();
                return "";
            }
            return Compiler.wrap(context, val);
        }

        @Override
        public boolean hasJavaClass() {
            return Modifier.isPublic(this.v.getClass().getModifiers());
        }

        @Override
        public Class getJavaClass() {
            return this.v.getClass();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object form) {
                Object v = RT.second(form);
                if (v == null) {
                    return NIL_EXPR;
                }
                if (v == Boolean.TRUE) {
                    return TRUE_EXPR;
                }
                if (v == Boolean.FALSE) {
                    return FALSE_EXPR;
                }
                if (v instanceof Number) {
                    return NumberExpr.parse((Number)v);
                }
                if (v instanceof String) {
                    return new StringExpr((String)v);
                }
                if (v instanceof IPersistentCollection && ((IPersistentCollection)v).count() == 0) {
                    return new EmptyExpr(v);
                }
                return new ConstantExpr(v);
            }
        }
    }

    static class DefExpr
    implements Expr {
        public final Var var;
        public final Expr init;
        public final Expr meta;
        public final boolean initProvided;
        public final boolean isDynamic;
        public final String source;
        public final int line;
        public final int column;
        static final clojure.asm.commons.Method bindRootMethod = clojure.asm.commons.Method.getMethod("void bindRoot(Object)");
        static final clojure.asm.commons.Method setTagMethod = clojure.asm.commons.Method.getMethod("void setTag(clojure.lang.Symbol)");
        static final clojure.asm.commons.Method setMetaMethod = clojure.asm.commons.Method.getMethod("void setMeta(clojure.lang.IPersistentMap)");
        static final clojure.asm.commons.Method setDynamicMethod = clojure.asm.commons.Method.getMethod("clojure.lang.Var setDynamic(boolean)");
        static final clojure.asm.commons.Method symintern = clojure.asm.commons.Method.getMethod("clojure.lang.Symbol intern(String, String)");

        public DefExpr(String source, int line, int column, Var var, Expr init, Expr meta, boolean initProvided, boolean isDynamic) {
            this.source = source;
            this.line = line;
            this.column = column;
            this.var = var;
            this.init = init;
            this.meta = meta;
            this.isDynamic = isDynamic;
            this.initProvided = initProvided;
        }

        @Override
        public Object eval() {
            try {
                if (this.initProvided) {
                    this.var.bindRoot(this.init.eval());
                }
                if (this.meta != null) {
                    IPersistentMap metaMap = (IPersistentMap)this.meta.eval();
                    this.var.setMeta((IPersistentMap)this.meta.eval());
                }
                return this.var.setDynamic(this.isDynamic);
            }
            catch (Throwable e) {
                if (!(e instanceof CompilerException)) {
                    throw new CompilerException(this.source, this.line, this.column, e);
                }
                throw (CompilerException)e;
            }
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            String val;
            String constant = objx.emitVar(gen, this.var);
            if (this.isDynamic) {
                gen.push(this.isDynamic);
                gen.invokeVirtual(VAR_TYPE, setDynamicMethod);
                Compiler.emitSource(String.valueOf(constant) + ".setDynamic(true);");
            }
            if (this.meta != null) {
                gen.dup();
                val = this.meta.emit(C.EXPRESSION, objx, gen);
                gen.checkCast(IPERSISTENTMAP_TYPE);
                gen.invokeVirtual(VAR_TYPE, setMetaMethod);
                Compiler.emitSource(String.valueOf(constant) + ".setMeta((IPersistentMap)" + val + ");");
            }
            if (this.initProvided) {
                gen.dup();
                val = this.init instanceof FnExpr ? ((FnExpr)this.init).emitForDefn(objx, gen) : this.init.emit(C.EXPRESSION, objx, gen);
                gen.invokeVirtual(VAR_TYPE, bindRootMethod);
                Compiler.emitSource(String.valueOf(constant) + ".bindRoot(" + val + ");");
            }
            if (context == C.STATEMENT) {
                gen.pop();
                return "";
            }
            return Compiler.wrap(context, constant);
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return Var.class;
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object form) {
                Object source_path;
                IPersistentMap mm;
                boolean isDynamic;
                String docstring = null;
                if (RT.count(form) == 4 && RT.third(form) instanceof String) {
                    docstring = (String)RT.third(form);
                    form = RT.list(RT.first(form), RT.second(form), RT.fourth(form));
                }
                if (RT.count(form) > 3) {
                    throw Util.runtimeException("Too many arguments to def");
                }
                if (RT.count(form) < 2) {
                    throw Util.runtimeException("Too few arguments to def");
                }
                if (!(RT.second(form) instanceof Symbol)) {
                    throw Util.runtimeException("First argument to def must be a Symbol");
                }
                Symbol sym = (Symbol)RT.second(form);
                Var v = Compiler.lookupVar(sym, true);
                if (v == null) {
                    throw Util.runtimeException("Can't refer to qualified var that doesn't exist");
                }
                if (!v.ns.equals(Compiler.currentNS())) {
                    if (sym.ns == null) {
                        v = Compiler.currentNS().intern(sym);
                    } else {
                        throw Util.runtimeException("Can't create defs outside of current ns");
                    }
                }
                if (isDynamic = RT.booleanCast(RT.get(mm = sym.meta(), dynamicKey))) {
                    v.setDynamic();
                }
                if (!isDynamic && sym.name.startsWith("*") && sym.name.endsWith("*") && sym.name.length() > 2) {
                    RT.errPrintWriter().format("Warning: %1$s not declared dynamic and thus is not dynamically rebindable, but its name suggests otherwise. Please either indicate ^:dynamic %1$s or change the name. (%2$s:%3$d)\n", sym, SOURCE_PATH.get(), LINE.get());
                }
                if (RT.booleanCast(RT.get(mm, arglistsKey))) {
                    IPersistentMap vm = v.meta();
                    vm = (IPersistentMap)RT.assoc(vm, arglistsKey, RT.second(mm.valAt(arglistsKey)));
                    v.setMeta(vm);
                }
                source_path = (source_path = SOURCE_PATH.get()) == null ? "NO_SOURCE_FILE" : source_path;
                mm = (IPersistentMap)RT.assoc(mm, RT.LINE_KEY, LINE.get()).assoc(RT.COLUMN_KEY, COLUMN.get()).assoc(RT.FILE_KEY, source_path);
                if (docstring != null) {
                    mm = (IPersistentMap)RT.assoc(mm, RT.DOC_KEY, docstring);
                }
                Expr meta = (mm = (IPersistentMap)Compiler.elideMeta(mm)).count() == 0 ? null : Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, mm);
                return new DefExpr((String)SOURCE.deref(), Compiler.lineDeref(), Compiler.columnDeref(), v, Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, RT.third(form), v.sym.name), meta, RT.count(form) == 3, isDynamic);
            }
        }
    }

    public static class EmptyExpr
    implements Expr {
        public final Object coll;
        static final Type HASHMAP_TYPE = Type.getType(PersistentArrayMap.class);
        static final Type HASHSET_TYPE = Type.getType(PersistentHashSet.class);
        static final Type VECTOR_TYPE = Type.getType(PersistentVector.class);
        static final Type LIST_TYPE = Type.getType(PersistentList.class);
        static final Type EMPTY_LIST_TYPE = Type.getType(PersistentList.EmptyList.class);

        public EmptyExpr(Object coll) {
            this.coll = coll;
        }

        @Override
        public Object eval() {
            return this.coll;
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            String ret;
            if (this.coll instanceof IPersistentList) {
                gen.getStatic(LIST_TYPE, "EMPTY", EMPTY_LIST_TYPE);
                ret = String.valueOf(LIST_TYPE.getClassName()) + ".EMPTY";
            } else if (this.coll instanceof IPersistentVector) {
                gen.getStatic(VECTOR_TYPE, "EMPTY", VECTOR_TYPE);
                ret = String.valueOf(VECTOR_TYPE.getClassName()) + ".EMPTY";
            } else if (this.coll instanceof IPersistentMap) {
                gen.getStatic(HASHMAP_TYPE, "EMPTY", HASHMAP_TYPE);
                ret = String.valueOf(HASHMAP_TYPE.getClassName()) + ".EMPTY";
            } else if (this.coll instanceof IPersistentSet) {
                gen.getStatic(HASHSET_TYPE, "EMPTY", HASHSET_TYPE);
                ret = String.valueOf(HASHSET_TYPE.getClassName()) + ".EMPTY";
            } else {
                throw new UnsupportedOperationException("Unknown Collection type");
            }
            if (context == C.STATEMENT) {
                gen.pop();
                return "";
            }
            return Compiler.wrap(context, ret);
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            if (this.coll instanceof IPersistentList) {
                return IPersistentList.class;
            }
            if (this.coll instanceof IPersistentVector) {
                return IPersistentVector.class;
            }
            if (this.coll instanceof IPersistentMap) {
                return IPersistentMap.class;
            }
            if (this.coll instanceof IPersistentSet) {
                return IPersistentSet.class;
            }
            throw new UnsupportedOperationException("Unknown Collection type");
        }
    }

    static interface Expr {
        public Object eval();

        public String emit(C var1, ObjExpr var2, GeneratorAdapter var3);

        public boolean hasJavaClass();

        public Class getJavaClass();
    }

    static abstract class FieldExpr
    extends HostExpr {
        FieldExpr() {
        }
    }

    public static class FnExpr
    extends ObjExpr {
        static final Type aFnType = Type.getType(AFunction.class);
        static final Type restFnType = Type.getType(RestFn.class);
        FnMethod variadicMethod = null;
        IPersistentCollection methods;
        private boolean hasMeta;

        public FnExpr(Object tag) {
            super(tag);
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        boolean supportsMeta() {
            return this.hasMeta;
        }

        @Override
        public Class getJavaClass() {
            return AFunction.class;
        }

        @Override
        protected void emitMethods(ClassVisitor cv) {
            ISeq s = RT.seq(this.methods);
            while (s != null) {
                ObjMethod method = (ObjMethod)s.first();
                method.emit(this, cv);
                s = s.next();
            }
            if (this.isVariadic()) {
                Compiler.emitSource("public int getRequiredArity() {");
                Compiler.tab();
                Compiler.emitSource("return " + this.variadicMethod.reqParms.count() + ";");
                Compiler.untab();
                Compiler.emitSource("}");
                GeneratorAdapter gen = new GeneratorAdapter(1, clojure.asm.commons.Method.getMethod("int getRequiredArity()"), null, null, cv);
                gen.visitCode();
                gen.push(this.variadicMethod.reqParms.count());
                gen.returnValue();
                gen.endMethod();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Expr parse(C context, ISeq form, String name) {
            String basename;
            ISeq origForm = form;
            FnExpr fn = new FnExpr(Compiler.tagOf(form));
            fn.src = form;
            ObjMethod enclosingMethod = (ObjMethod)METHOD.deref();
            if (((IMeta)form.first()).meta() != null) {
                fn.onceOnly = RT.booleanCast(RT.get(RT.meta(form.first()), Keyword.intern(null, "once")));
            }
            String string = basename = enclosingMethod != null ? String.valueOf(enclosingMethod.objx.name) + Compiler.DOLLAR : String.valueOf(Compiler.munge(Compiler.currentNS().name.name)) + Compiler.DOLLAR;
            if (RT.second(form) instanceof Symbol) {
                name = ((Symbol)RT.second((Object)form)).name;
            }
            String simpleName = name != null ? String.valueOf(Compiler.munge(name).replace(".", "_DOT_")) + (enclosingMethod != null ? "__" + RT.nextID() : "") : "fn__" + RT.nextID();
            fn.name = String.valueOf(basename) + simpleName;
            fn.internalName = fn.name.replace('.', '/');
            fn.objtype = Type.getObjectType(fn.internalName);
            ArrayList<String> prims = new ArrayList<String>();
            try {
                Var.pushThreadBindings(RT.mapUniqueKeys(CONSTANTS, PersistentVector.EMPTY, CONSTANT_IDS, new IdentityHashMap(), KEYWORDS, PersistentHashMap.EMPTY, VARS, PersistentHashMap.EMPTY, KEYWORD_CALLSITES, PersistentVector.EMPTY, PROTOCOL_CALLSITES, PersistentVector.EMPTY, VAR_CALLSITES, Compiler.emptyVarCallSites(), NO_RECUR, null));
                if (RT.second(form) instanceof Symbol) {
                    Symbol nm = (Symbol)RT.second(form);
                    fn.thisName = nm.name;
                    fn.isStatic = false;
                    form = RT.cons(FN, RT.next(RT.next(form)));
                }
                if (RT.second(form) instanceof IPersistentVector) {
                    form = RT.list(FN, RT.next(form));
                }
                fn.line = Compiler.lineDeref();
                fn.column = Compiler.columnDeref();
                FnMethod[] methodArray = new FnMethod[21];
                FnMethod variadicMethod = null;
                ISeq s = RT.next(form);
                while (s != null) {
                    FnMethod f = FnMethod.parse(fn, (ISeq)RT.first(s), fn.isStatic);
                    if (f.isVariadic()) {
                        if (variadicMethod != null) throw Util.runtimeException("Can't have more than 1 variadic overload");
                        variadicMethod = f;
                    } else {
                        if (methodArray[f.reqParms.count()] != null) throw Util.runtimeException("Can't have 2 overloads with same arity");
                        methodArray[f.reqParms.count()] = f;
                    }
                    if (f.prim != null) {
                        prims.add(f.prim);
                    }
                    s = RT.next(s);
                }
                if (variadicMethod != null) {
                    int i = variadicMethod.reqParms.count() + 1;
                    while (i <= 20) {
                        if (methodArray[i] != null) {
                            throw Util.runtimeException("Can't have fixed arity function with more params than variadic function");
                        }
                        ++i;
                    }
                }
                if (fn.isStatic && fn.closes.count() > 0) {
                    throw new IllegalArgumentException("static fns can't be closures");
                }
                IPersistentCollection methods = null;
                int i = 0;
                while (i < methodArray.length) {
                    if (methodArray[i] != null) {
                        methods = RT.conj(methods, methodArray[i]);
                    }
                    ++i;
                }
                if (variadicMethod != null) {
                    methods = RT.conj(methods, variadicMethod);
                }
                fn.methods = methods;
                fn.variadicMethod = variadicMethod;
                fn.keywords = (IPersistentMap)KEYWORDS.deref();
                fn.vars = (IPersistentMap)VARS.deref();
                fn.constants = (PersistentVector)CONSTANTS.deref();
                fn.keywordCallsites = (IPersistentVector)KEYWORD_CALLSITES.deref();
                fn.protocolCallsites = (IPersistentVector)PROTOCOL_CALLSITES.deref();
                fn.varCallsites = (IPersistentSet)VAR_CALLSITES.deref();
                fn.constantsID = RT.nextID();
            }
            finally {
                Var.popThreadBindings();
            }
            IPersistentMap fmeta = RT.meta(origForm);
            if (fmeta != null) {
                fmeta = fmeta.without(RT.LINE_KEY).without(RT.COLUMN_KEY).without(RT.FILE_KEY);
            }
            fn.hasMeta = RT.count(fmeta) > 0;
            try {
                fn.compile(fn.isVariadic() ? "clojure/lang/RestFn" : "clojure/lang/AFunction", prims.size() == 0 ? null : prims.toArray(new String[prims.size()]), fn.onceOnly);
            }
            catch (IOException e) {
                throw Util.sneakyThrow(e);
            }
            fn.getCompiledClass();
            if (!fn.supportsMeta()) return fn;
            return new MetaExpr(fn, MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, fmeta));
        }

        public final ObjMethod variadicMethod() {
            return this.variadicMethod;
        }

        boolean isVariadic() {
            return this.variadicMethod != null;
        }

        public final IPersistentCollection methods() {
            return this.methods;
        }

        public String emitForDefn(ObjExpr objx, GeneratorAdapter gen) {
            return this.emit(C.EXPRESSION, objx, gen);
        }
    }

    public static class FnMethod
    extends ObjMethod {
        PersistentVector reqParms = PersistentVector.EMPTY;
        LocalBinding restParm = null;
        Type[] argtypes;
        Class[] argclasses;
        Class retClass;
        String prim;
        private String thisName;

        public FnMethod(ObjExpr objx, ObjMethod parent) {
            super(objx, parent);
        }

        public static char classChar(Object x) {
            Class c = null;
            if (x instanceof Class) {
                c = (Class)x;
            } else if (x instanceof Symbol) {
                c = Compiler.primClass((Symbol)x);
            }
            if (c == null || !c.isPrimitive()) {
                return 'O';
            }
            if (c == Long.TYPE) {
                return 'L';
            }
            if (c == Double.TYPE) {
                return 'D';
            }
            throw new IllegalArgumentException("Only long and double primitives are supported");
        }

        public static String primInterface(IPersistentVector arglist) {
            boolean prim;
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < arglist.count()) {
                sb.append(FnMethod.classChar(Compiler.tagOf(arglist.nth(i))));
                ++i;
            }
            sb.append(FnMethod.classChar(Compiler.tagOf(arglist)));
            String ret = sb.toString();
            boolean bl = prim = ret.contains("L") || ret.contains("D");
            if (prim && arglist.count() > 4) {
                throw new IllegalArgumentException("fns taking primitives support only 4 or fewer args");
            }
            if (prim) {
                return "clojure.lang.IFn$" + ret;
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static FnMethod parse(ObjExpr objx, ISeq form, boolean isStatic) {
            IPersistentVector parms = (IPersistentVector)RT.first(form);
            ISeq body = RT.next(form);
            try {
                FnMethod method = new FnMethod(objx, (ObjMethod)METHOD.deref());
                method.line = Compiler.lineDeref();
                method.column = Compiler.columnDeref();
                PathNode pnode = (PathNode)CLEAR_PATH.get();
                if (pnode == null) {
                    pnode = new PathNode(PATHTYPE.PATH, null);
                }
                Var.pushThreadBindings(RT.mapUniqueKeys(METHOD, method, LOCAL_ENV, LOCAL_ENV.deref(), LOOP_LOCALS, null, NEXT_LOCAL_NUM, 0, CLEAR_PATH, pnode, CLEAR_ROOT, pnode, CLEAR_SITES, PersistentHashMap.EMPTY));
                method.prim = FnMethod.primInterface(parms);
                if (method.prim != null) {
                    method.prim = method.prim.replace('.', '/');
                }
                method.retClass = Compiler.tagClass(Compiler.tagOf(parms));
                if (method.retClass.isPrimitive() && method.retClass != Double.TYPE && method.retClass != Long.TYPE) {
                    throw new IllegalArgumentException("Only long and double primitives are supported");
                }
                if (!isStatic) {
                    method.thisName = objx.thisName;
                    if (objx.thisName != null) {
                        Compiler.registerLocal(Symbol.intern(objx.thisName), null, null, false);
                    } else {
                        Compiler.getAndIncLocalNum();
                    }
                }
                PSTATE state = PSTATE.REQ;
                PersistentVector argLocals = PersistentVector.EMPTY;
                ArrayList<Type> argtypes = new ArrayList<Type>();
                ArrayList<Class<ISeq>> argclasses = new ArrayList<Class<ISeq>>();
                int i = 0;
                while (i < parms.count()) {
                    if (!(parms.nth(i) instanceof Symbol)) {
                        throw new IllegalArgumentException("fn params must be Symbols: " + parms.nth(i));
                    }
                    Symbol p = (Symbol)parms.nth(i);
                    if (p.getNamespace() != null) {
                        throw Util.runtimeException("Can't use qualified name as parameter: " + p);
                    }
                    if (p.equals(_AMP_)) {
                        if (state != PSTATE.REQ) throw Util.runtimeException("Invalid parameter list");
                        state = PSTATE.REST;
                    } else {
                        Class<ISeq> pc = Compiler.primClass(Compiler.tagClass(Compiler.tagOf(p)));
                        if (pc.isPrimitive() && pc != Double.TYPE && pc != Long.TYPE) {
                            throw new IllegalArgumentException("Only long and double primitives are supported: " + p);
                        }
                        if (state == PSTATE.REST && Compiler.tagOf(p) != null) {
                            throw Util.runtimeException("& arg cannot have type hint");
                        }
                        if (state == PSTATE.REST && method.prim != null) {
                            throw Util.runtimeException("fns taking primitives cannot be variadic");
                        }
                        if (state == PSTATE.REST) {
                            pc = ISeq.class;
                        }
                        argtypes.add(Type.getType(pc));
                        argclasses.add(pc);
                        LocalBinding lb = pc.isPrimitive() ? Compiler.registerLocal(p, null, new MethodParamExpr(pc), true) : Compiler.registerLocal(p, state == PSTATE.REST ? ISEQ : Compiler.tagOf(p), null, true);
                        argLocals = argLocals.cons(lb);
                        switch (state) {
                            case REQ: {
                                method.reqParms = method.reqParms.cons(lb);
                                break;
                            }
                            case REST: {
                                method.restParm = lb;
                                state = PSTATE.DONE;
                                break;
                            }
                            default: {
                                throw Util.runtimeException("Unexpected parameter");
                            }
                        }
                    }
                    ++i;
                }
                if (method.reqParms.count() > 20) {
                    throw Util.runtimeException("Can't specify more than 20 params");
                }
                LOOP_LOCALS.set(argLocals);
                method.argLocals = argLocals;
                if (method.prim != null) {
                    method.argtypes = argtypes.toArray(new Type[argtypes.size()]);
                    method.argclasses = argclasses.toArray(new Class[argtypes.size()]);
                    i = 0;
                    while (i < method.argclasses.length) {
                        if (method.argclasses[i] == Long.TYPE || method.argclasses[i] == Double.TYPE) {
                            Compiler.getAndIncLocalNum();
                        }
                        ++i;
                    }
                }
                method.body = new BodyExpr.Parser().parse(C.RETURN, body);
                FnMethod fnMethod = method;
                return fnMethod;
            }
            finally {
                Var.popThreadBindings();
            }
        }

        @Override
        public void emit(ObjExpr fn, ClassVisitor cv) {
            if (this.prim != null) {
                this.doEmitPrim(fn, cv);
            } else if (fn.isStatic) {
                this.doEmitStatic(fn, cv);
            } else {
                this.doEmit(fn, cv);
            }
        }

        public void doEmitStatic(ObjExpr fn, ClassVisitor cv) {
            new RuntimeException().printStackTrace();
            clojure.asm.commons.Method ms = new clojure.asm.commons.Method("invokeStatic", this.getReturnType(), this.argtypes);
            GeneratorAdapter gen = new GeneratorAdapter(9, ms, null, EXCEPTION_TYPES, cv);
            gen.visitCode();
            Label loopLabel = gen.mark();
            gen.visitLineNumber(this.line, loopLabel);
            try {
                try {
                    Var.pushThreadBindings(RT.map(LOOP_LABEL, loopLabel, METHOD, this));
                    FnMethod.emitBody(this.objx, gen, this.retClass, this.body);
                    Label end = gen.mark();
                    ISeq lbs = this.argLocals.seq();
                    while (lbs != null) {
                        LocalBinding lb = (LocalBinding)lbs.first();
                        gen.visitLocalVariable(lb.name, this.argtypes[lb.idx].getDescriptor(), null, loopLabel, end, lb.idx);
                        lbs = lbs.next();
                    }
                }
                catch (Exception e) {
                    throw Util.sneakyThrow(e);
                }
            }
            finally {
                Var.popThreadBindings();
            }
            gen.returnValue();
            gen.endMethod();
            clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.getMethodName(), OBJECT_TYPE, this.getArgTypes());
            gen = new GeneratorAdapter(1, m, null, EXCEPTION_TYPES, cv);
            gen.visitCode();
            int i = 0;
            while (i < this.argtypes.length) {
                gen.loadArg(i);
                HostExpr.emitUnboxArg(fn, gen, this.argclasses[i], "");
                ++i;
            }
            gen.invokeStatic(this.objx.objtype, ms);
            gen.box(this.getReturnType(), "");
            gen.returnValue();
            gen.endMethod();
        }

        public void doEmitPrim(ObjExpr fn, ClassVisitor cv) {
            Type returnType = this.retClass == Double.TYPE || this.retClass == Long.TYPE ? this.getReturnType() : OBJECT_TYPE;
            clojure.asm.commons.Method ms = new clojure.asm.commons.Method("invokePrim", returnType, this.argtypes);
            GeneratorAdapter gen = new GeneratorAdapter(17, ms, null, EXCEPTION_TYPES, cv);
            gen.visitCode();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.argLocals.count()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(String.valueOf(Compiler.printClass(this.argclasses[i])) + " " + ((LocalBinding)this.argLocals.nth(i)).print());
                ++i;
            }
            Compiler.emitSource("public final " + Compiler.printClass(this.retClass) + " invokePrim(" + sb.toString() + ") {");
            Compiler.tab();
            Label loopLabel = gen.mark();
            gen.visitLineNumber(this.line, loopLabel);
            try {
                try {
                    Var.pushThreadBindings(RT.map(LOOP_LABEL, loopLabel, METHOD, this));
                    String b = FnMethod.emitBody(this.objx, gen, this.retClass, this.body);
                    if (b != null) {
                        Compiler.emitSource(b);
                    }
                    Label end = gen.mark();
                    gen.visitLocalVariable("this", "Ljava/lang/Object;", null, loopLabel, end, 0);
                    ISeq lbs = this.argLocals.seq();
                    while (lbs != null) {
                        LocalBinding lb = (LocalBinding)lbs.first();
                        gen.visitLocalVariable(lb.name, this.argtypes[lb.idx - 1].getDescriptor(), null, loopLabel, end, lb.idx);
                        lbs = lbs.next();
                    }
                }
                catch (Exception e) {
                    throw Util.sneakyThrow(e);
                }
            }
            finally {
                Var.popThreadBindings();
            }
            Compiler.untab();
            Compiler.emitSource("}");
            gen.returnValue();
            gen.endMethod();
            clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.getMethodName(), OBJECT_TYPE, this.getArgTypes());
            gen = new GeneratorAdapter(1, m, null, EXCEPTION_TYPES, cv);
            gen.visitCode();
            gen.loadThis();
            sb = new StringBuilder();
            StringBuilder args = new StringBuilder();
            int i2 = 0;
            while (i2 < this.argtypes.length) {
                if (sb.length() > 0) {
                    sb.append(", ");
                    args.append(", ");
                }
                gen.loadArg(i2);
                String argname = ((LocalBinding)this.argLocals.nth(i2)).print();
                sb.append("Object " + argname);
                args.append(HostExpr.emitUnboxArg(fn, gen, this.argclasses[i2], argname));
                ++i2;
            }
            Compiler.emitSource("public Object invoke(" + sb.toString() + ") {");
            Compiler.tab();
            gen.invokeInterface(Type.getType("L" + this.prim + ";"), ms);
            Compiler.emitSource("return " + gen.box(this.getReturnType(), "invokePrim(" + args + ")") + ";");
            Compiler.untab();
            Compiler.emitSource("}");
            gen.returnValue();
            gen.endMethod();
        }

        public void doEmit(ObjExpr fn, ClassVisitor cv) {
            clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.getMethodName(), this.getReturnType(), this.getArgTypes());
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.argLocals.count()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                LocalBinding b = (LocalBinding)this.argLocals.get(i);
                sb.append(String.valueOf(Compiler.printClass(this.getArgTypes()[i])) + " " + b.print());
                ++i;
            }
            Compiler.emitSource("public " + Compiler.printClass(this.getReturnType()) + " " + this.getMethodName() + "(" + sb.toString() + ") {");
            Compiler.tab();
            GeneratorAdapter gen = new GeneratorAdapter(1, m, null, EXCEPTION_TYPES, cv);
            gen.visitCode();
            if (this.hasException) {
                Compiler.emitSource("try {");
                Compiler.tab();
            }
            if (this.hasRecur) {
                Compiler.emitSource("while(true) {");
                Compiler.tab();
            }
            Label loopLabel = gen.mark();
            gen.visitLineNumber(this.line, loopLabel);
            try {
                Var.pushThreadBindings(RT.map(LOOP_LABEL, loopLabel, METHOD, this));
                String r = this.body.emit(C.RETURN, fn, gen);
                if (r != null) {
                    Compiler.emitSource(r);
                }
                Label end = gen.mark();
                gen.visitLocalVariable("this", "Ljava/lang/Object;", null, loopLabel, end, 0);
                ISeq lbs = this.argLocals.seq();
                while (lbs != null) {
                    LocalBinding lb = (LocalBinding)lbs.first();
                    gen.visitLocalVariable(lb.name, "Ljava/lang/Object;", null, loopLabel, end, lb.idx);
                    lbs = lbs.next();
                }
            }
            finally {
                Var.popThreadBindings();
            }
            gen.returnValue();
            gen.endMethod();
            if (this.hasRecur) {
                Compiler.untab();
                Compiler.emitSource("}");
            }
            if (this.hasException) {
                Compiler.untab();
                Compiler.emitSource("} catch (Exception ___e) {");
                Compiler.tab();
                Compiler.emitSource("throw Util.sneakyThrow(___e);");
                Compiler.untab();
                Compiler.emitSource("}");
            }
            Compiler.untab();
            Compiler.emitSource("}");
        }

        public final PersistentVector reqParms() {
            return this.reqParms;
        }

        public final LocalBinding restParm() {
            return this.restParm;
        }

        boolean isVariadic() {
            return this.restParm != null;
        }

        @Override
        int numParams() {
            return this.reqParms.count() + (this.isVariadic() ? 1 : 0);
        }

        @Override
        String getMethodName() {
            return this.isVariadic() ? "doInvoke" : "invoke";
        }

        @Override
        Type getReturnType() {
            if (this.prim != null) {
                return Type.getType(this.retClass);
            }
            return OBJECT_TYPE;
        }

        @Override
        Type[] getArgTypes() {
            if (this.isVariadic() && this.reqParms.count() == 20) {
                Type[] ret = new Type[21];
                int i = 0;
                while (i < 21) {
                    ret[i] = OBJECT_TYPE;
                    ++i;
                }
                return ret;
            }
            return ARG_TYPES[this.numParams()];
        }

        @Override
        void emitClearLocals(GeneratorAdapter gen) {
        }
    }

    public static abstract class HostExpr
    implements Expr,
    MaybePrimitiveExpr {
        static final Type BOOLEAN_TYPE = Type.getType(Boolean.class);
        static final Type CHAR_TYPE = Type.getType(Character.class);
        static final Type INTEGER_TYPE = Type.getType(Integer.class);
        static final Type LONG_TYPE = Type.getType(Long.class);
        static final Type FLOAT_TYPE = Type.getType(Float.class);
        static final Type DOUBLE_TYPE = Type.getType(Double.class);
        static final Type SHORT_TYPE = Type.getType(Short.class);
        static final Type BYTE_TYPE = Type.getType(Byte.class);
        static final Type NUMBER_TYPE = Type.getType(Number.class);
        static final clojure.asm.commons.Method charValueMethod = clojure.asm.commons.Method.getMethod("char charValue()");
        static final clojure.asm.commons.Method booleanValueMethod = clojure.asm.commons.Method.getMethod("boolean booleanValue()");
        static final clojure.asm.commons.Method charValueOfMethod = clojure.asm.commons.Method.getMethod("Character valueOf(char)");
        static final clojure.asm.commons.Method intValueOfMethod = clojure.asm.commons.Method.getMethod("Integer valueOf(int)");
        static final clojure.asm.commons.Method longValueOfMethod = clojure.asm.commons.Method.getMethod("Long valueOf(long)");
        static final clojure.asm.commons.Method floatValueOfMethod = clojure.asm.commons.Method.getMethod("Float valueOf(float)");
        static final clojure.asm.commons.Method doubleValueOfMethod = clojure.asm.commons.Method.getMethod("Double valueOf(double)");
        static final clojure.asm.commons.Method shortValueOfMethod = clojure.asm.commons.Method.getMethod("Short valueOf(short)");
        static final clojure.asm.commons.Method byteValueOfMethod = clojure.asm.commons.Method.getMethod("Byte valueOf(byte)");
        static final clojure.asm.commons.Method intValueMethod = clojure.asm.commons.Method.getMethod("int intValue()");
        static final clojure.asm.commons.Method longValueMethod = clojure.asm.commons.Method.getMethod("long longValue()");
        static final clojure.asm.commons.Method floatValueMethod = clojure.asm.commons.Method.getMethod("float floatValue()");
        static final clojure.asm.commons.Method doubleValueMethod = clojure.asm.commons.Method.getMethod("double doubleValue()");
        static final clojure.asm.commons.Method byteValueMethod = clojure.asm.commons.Method.getMethod("byte byteValue()");
        static final clojure.asm.commons.Method shortValueMethod = clojure.asm.commons.Method.getMethod("short shortValue()");
        static final clojure.asm.commons.Method fromIntMethod = clojure.asm.commons.Method.getMethod("clojure.lang.Num from(int)");
        static final clojure.asm.commons.Method fromLongMethod = clojure.asm.commons.Method.getMethod("clojure.lang.Num from(long)");
        static final clojure.asm.commons.Method fromDoubleMethod = clojure.asm.commons.Method.getMethod("clojure.lang.Num from(double)");

        public static String emitBoxReturn(ObjExpr objx, GeneratorAdapter gen, Class returnType, String val) {
            if (returnType.isPrimitive()) {
                if (returnType == Boolean.TYPE) {
                    Label falseLabel = gen.newLabel();
                    Label endLabel = gen.newLabel();
                    gen.ifZCmp(153, falseLabel);
                    gen.getStatic(BOOLEAN_OBJECT_TYPE, "TRUE", BOOLEAN_OBJECT_TYPE);
                    gen.goTo(endLabel);
                    gen.mark(falseLabel);
                    gen.getStatic(BOOLEAN_OBJECT_TYPE, "FALSE", BOOLEAN_OBJECT_TYPE);
                    gen.mark(endLabel);
                    return "(" + val + " ? Boolean.TRUE : Boolean.FALSE)";
                }
                if (returnType == Void.TYPE) {
                    NIL_EXPR.emit(C.EXPRESSION, objx, gen);
                    Compiler.emitSource(String.valueOf(val) + ";");
                    return "null";
                }
                if (returnType == Character.TYPE) {
                    gen.invokeStatic(CHAR_TYPE, charValueOfMethod);
                    return "Character.valueOf(" + val + ")";
                }
                if (returnType == Integer.TYPE) {
                    gen.invokeStatic(INTEGER_TYPE, intValueOfMethod);
                    return "Integer.valueOf(" + val + ")";
                }
                if (returnType == Float.TYPE) {
                    gen.invokeStatic(FLOAT_TYPE, floatValueOfMethod);
                    return "Float.valueOf(" + val + ")";
                }
                if (returnType == Double.TYPE) {
                    gen.invokeStatic(DOUBLE_TYPE, doubleValueOfMethod);
                    return "Double.valueOf(" + val + ")";
                }
                if (returnType == Long.TYPE) {
                    gen.invokeStatic(NUMBERS_TYPE, clojure.asm.commons.Method.getMethod("Number num(long)"));
                    return "Numbers.num(" + val + ")";
                }
                if (returnType == Byte.TYPE) {
                    gen.invokeStatic(BYTE_TYPE, byteValueOfMethod);
                    return "Byte.valueOf(" + val + ")";
                }
                if (returnType == Short.TYPE) {
                    gen.invokeStatic(SHORT_TYPE, shortValueOfMethod);
                    return "Short.valueOf(" + val + ")";
                }
            }
            return "((" + Compiler.printClass(returnType) + ")" + val + ")";
        }

        public static String emitUnboxArg(ObjExpr objx, GeneratorAdapter gen, Class paramType, String val) {
            if (paramType.isPrimitive()) {
                if (paramType == Boolean.TYPE) {
                    gen.checkCast(BOOLEAN_TYPE);
                    gen.invokeVirtual(BOOLEAN_TYPE, booleanValueMethod);
                    return "((Boolean)" + val + ").booleanValue()";
                }
                if (paramType == Character.TYPE) {
                    gen.checkCast(CHAR_TYPE);
                    gen.invokeVirtual(CHAR_TYPE, charValueMethod);
                    return "((Character)" + val + ").charValue()";
                }
                clojure.asm.commons.Method m = null;
                gen.checkCast(NUMBER_TYPE);
                if (RT.booleanCast(RT.UNCHECKED_MATH.deref())) {
                    if (paramType == Integer.TYPE) {
                        m = clojure.asm.commons.Method.getMethod("int uncheckedIntCast(Object)");
                    } else if (paramType == Float.TYPE) {
                        m = clojure.asm.commons.Method.getMethod("float uncheckedFloatCast(Object)");
                    } else if (paramType == Double.TYPE) {
                        m = clojure.asm.commons.Method.getMethod("double uncheckedDoubleCast(Object)");
                    } else if (paramType == Long.TYPE) {
                        m = clojure.asm.commons.Method.getMethod("long uncheckedLongCast(Object)");
                    } else if (paramType == Byte.TYPE) {
                        m = clojure.asm.commons.Method.getMethod("byte uncheckedByteCast(Object)");
                    } else if (paramType == Short.TYPE) {
                        m = clojure.asm.commons.Method.getMethod("short uncheckedShortCast(Object)");
                    }
                } else if (paramType == Integer.TYPE) {
                    m = clojure.asm.commons.Method.getMethod("int intCast(Object)");
                } else if (paramType == Float.TYPE) {
                    m = clojure.asm.commons.Method.getMethod("float floatCast(Object)");
                } else if (paramType == Double.TYPE) {
                    m = clojure.asm.commons.Method.getMethod("double doubleCast(Object)");
                } else if (paramType == Long.TYPE) {
                    m = clojure.asm.commons.Method.getMethod("long longCast(Object)");
                } else if (paramType == Byte.TYPE) {
                    m = clojure.asm.commons.Method.getMethod("byte byteCast(Object)");
                } else if (paramType == Short.TYPE) {
                    m = clojure.asm.commons.Method.getMethod("short shortCast(Object)");
                }
                gen.invokeStatic(RT_TYPE, m);
                return "RT." + m.getName() + "(" + val + ")";
            }
            gen.checkCast(Type.getType(paramType));
            return "((" + Compiler.printClass(paramType) + ")" + val + ")";
        }

        private static Class maybeClass(Object form, boolean stringOk) {
            if (form instanceof Class) {
                return (Class)form;
            }
            Class c = null;
            if (form instanceof Symbol) {
                Symbol sym = (Symbol)form;
                if (sym.ns == null) {
                    if (Util.equals(sym, COMPILE_STUB_SYM.get())) {
                        return (Class)COMPILE_STUB_CLASS.get();
                    }
                    if (sym.name.indexOf(46) > 0 || sym.name.charAt(0) == '[') {
                        c = RT.classForName(sym.name);
                    } else {
                        Object o = Compiler.currentNS().getMapping(sym);
                        if (o instanceof Class) {
                            c = (Class)o;
                        } else {
                            try {
                                c = RT.classForName(sym.name);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            } else if (stringOk && form instanceof String) {
                c = RT.classForName((String)form);
            }
            return c;
        }

        static Class tagToClass(Object tag) {
            Class c = HostExpr.maybeClass(tag, true);
            if (tag instanceof Symbol) {
                Symbol sym = (Symbol)tag;
                if (sym.ns == null) {
                    if (sym.name.equals("objects")) {
                        c = Object[].class;
                    } else if (sym.name.equals("ints")) {
                        c = int[].class;
                    } else if (sym.name.equals("longs")) {
                        c = long[].class;
                    } else if (sym.name.equals("floats")) {
                        c = float[].class;
                    } else if (sym.name.equals("doubles")) {
                        c = double[].class;
                    } else if (sym.name.equals("chars")) {
                        c = char[].class;
                    } else if (sym.name.equals("shorts")) {
                        c = short[].class;
                    } else if (sym.name.equals("bytes")) {
                        c = byte[].class;
                    } else if (sym.name.equals("booleans")) {
                        c = boolean[].class;
                    } else if (sym.name.equals("int")) {
                        c = Integer.TYPE;
                    } else if (sym.name.equals("long")) {
                        c = Long.TYPE;
                    } else if (sym.name.equals("float")) {
                        c = Float.TYPE;
                    } else if (sym.name.equals("double")) {
                        c = Double.TYPE;
                    } else if (sym.name.equals("char")) {
                        c = Character.TYPE;
                    } else if (sym.name.equals("short")) {
                        c = Short.TYPE;
                    } else if (sym.name.equals("byte")) {
                        c = Byte.TYPE;
                    } else if (sym.name.equals("boolean")) {
                        c = Boolean.TYPE;
                    }
                }
            }
            if (c != null) {
                return c;
            }
            throw new IllegalArgumentException("Unable to resolve classname: " + tag);
        }

        public static String tagToCanonical(Object tag) {
            try {
                return Compiler.printClass(HostExpr.tagToClass(tag));
            }
            catch (Exception e) {
                return Compiler.printClass(String.valueOf(tag));
            }
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object frm) {
                Symbol sym;
                boolean maybeField;
                ISeq form = (ISeq)frm;
                if (RT.length(form) < 3) {
                    throw new IllegalArgumentException("Malformed member expression, expecting (. target member ...)");
                }
                int line = Compiler.lineDeref();
                int column = Compiler.columnDeref();
                String source = (String)SOURCE.deref();
                Class c = HostExpr.maybeClass(RT.second(form), false);
                Expr instance = null;
                if (c == null) {
                    instance = Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, RT.second(form));
                }
                boolean bl = maybeField = RT.length(form) == 3 && RT.third(form) instanceof Symbol;
                if (maybeField && ((Symbol)RT.third((Object)form)).name.charAt(0) != '-') {
                    sym = (Symbol)RT.third(form);
                    if (c != null) {
                        maybeField = Reflector.getMethods(c, 0, Compiler.munge(sym.name), true).size() == 0;
                    } else if (instance != null && instance.hasJavaClass() && instance.getJavaClass() != null) {
                        boolean bl2 = maybeField = Reflector.getMethods(instance.getJavaClass(), 0, Compiler.munge(sym.name), false).size() == 0;
                    }
                }
                if (maybeField) {
                    sym = ((Symbol)RT.third((Object)form)).name.charAt(0) == '-' ? Symbol.intern(((Symbol)RT.third((Object)form)).name.substring(1)) : (Symbol)RT.third(form);
                    Symbol tag = Compiler.tagOf(form);
                    if (c != null) {
                        return new StaticFieldExpr(line, column, c, Compiler.munge(sym.name), tag);
                    }
                    return new InstanceFieldExpr(line, column, instance, Compiler.munge(sym.name), tag);
                }
                ISeq call = (ISeq)(RT.third(form) instanceof ISeq ? RT.third(form) : RT.next(RT.next(form)));
                if (!(RT.first(call) instanceof Symbol)) {
                    throw new IllegalArgumentException("Malformed member expression");
                }
                Symbol sym2 = (Symbol)RT.first(call);
                Symbol tag = Compiler.tagOf(form);
                PersistentVector args = PersistentVector.EMPTY;
                ISeq s = RT.next(call);
                while (s != null) {
                    args = args.cons(Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, s.first()));
                    s = s.next();
                }
                if (c != null) {
                    return new StaticMethodExpr(source, line, column, tag, c, Compiler.munge(sym2.name), args);
                }
                return new InstanceMethodExpr(source, line, column, tag, instance, Compiler.munge(sym2.name), args);
            }
        }
    }

    static interface IParser {
        public Expr parse(C var1, Object var2);
    }

    public static class IfExpr
    implements Expr,
    MaybePrimitiveExpr {
        public final Expr testExpr;
        public final Expr thenExpr;
        public final Expr elseExpr;
        public final int line;
        public final int column;

        public IfExpr(int line, int column, Expr testExpr, Expr thenExpr, Expr elseExpr) {
            this.testExpr = testExpr;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.line = line;
            this.column = column;
        }

        @Override
        public Object eval() {
            Object t = this.testExpr.eval();
            if (t != null && t != Boolean.FALSE) {
                return this.thenExpr.eval();
            }
            return this.elseExpr.eval();
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            return this.doEmit(context, objx, gen, false);
        }

        @Override
        public String emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            return this.doEmit(context, objx, gen, true);
        }

        public String doEmit(C context, ObjExpr objx, GeneratorAdapter gen, boolean emitUnboxed) {
            Class cast;
            if (this.testExpr instanceof NilExpr) {
                return this.elseExpr.emit(context, objx, gen);
            }
            Label nullLabel = gen.newLabel();
            Label falseLabel = gen.newLabel();
            Label endLabel = gen.newLabel();
            gen.visitLineNumber(this.line, gen.mark());
            StringBuilder sb = new StringBuilder();
            String ret = Compiler.registerTemp();
            if (C.EXPRESSION == context) {
                Compiler.emitSource("Object " + ret + ";");
            }
            sb.append("if (");
            try {
                if (this.testExpr instanceof StaticMethodExpr && ((StaticMethodExpr)this.testExpr).canEmitIntrinsicPredicate()) {
                    sb.append(((StaticMethodExpr)this.testExpr).emitIntrinsicPredicate(C.EXPRESSION, objx, gen, falseLabel));
                } else if (Compiler.maybePrimitiveType(this.testExpr) == Boolean.TYPE) {
                    sb.append(((MaybePrimitiveExpr)this.testExpr).emitUnboxed(C.EXPRESSION, objx, gen));
                    gen.ifZCmp(153, falseLabel);
                } else {
                    String val = this.testExpr.emit(C.EXPRESSION, objx, gen);
                    gen.dup();
                    gen.ifNull(nullLabel);
                    gen.getStatic(BOOLEAN_OBJECT_TYPE, "FALSE", BOOLEAN_OBJECT_TYPE);
                    gen.visitJumpInsn(165, falseLabel);
                    String temp = Compiler.registerTemp();
                    Compiler.emitSource("Object " + temp + " = " + val + ";");
                    sb.append(String.valueOf(temp) + " != null && !(" + temp + " == Boolean.FALSE)");
                }
            }
            catch (Exception e) {
                throw Util.sneakyThrow(e);
            }
            sb.append(") {");
            Compiler.emitSource(sb.toString());
            Compiler.tab();
            String e = emitUnboxed ? ((MaybePrimitiveExpr)this.thenExpr).emitUnboxed(context, objx, gen) : this.thenExpr.emit(context, objx, gen);
            if (e != null) {
                Compiler.emitAssigRet(context, ret, e);
            }
            Compiler.untab();
            Compiler.emitSource("} else {");
            Compiler.tab();
            gen.goTo(endLabel);
            gen.mark(nullLabel);
            gen.pop();
            gen.mark(falseLabel);
            e = emitUnboxed ? ((MaybePrimitiveExpr)this.elseExpr).emitUnboxed(context, objx, gen) : this.elseExpr.emit(context, objx, gen);
            if (e != null) {
                Compiler.emitAssigRet(context, ret, e);
            }
            Compiler.untab();
            Compiler.emitSource("}");
            gen.mark(endLabel);
            try {
                Class thenClass = this.thenExpr.getJavaClass();
                Class elseClass = this.elseExpr.getJavaClass();
                cast = thenClass.isPrimitive() && thenClass == elseClass ? thenClass : null;
            }
            catch (Exception e2) {
                cast = null;
            }
            return C.EXPRESSION == context ? String.valueOf(cast != null ? "(" + Compiler.printClass(this.asBoxClass(cast)) + ")" : "") + ret : "";
        }

        private Class asBoxClass(Class cast) {
            switch (Type.getType(cast).getSort()) {
                case 2: {
                    return Character.class;
                }
                case 1: {
                    return Boolean.class;
                }
                case 8: {
                    return Double.class;
                }
                case 6: {
                    return Float.class;
                }
                case 7: {
                    return Long.class;
                }
                case 5: {
                    return Integer.class;
                }
                case 4: {
                    return Short.class;
                }
                case 3: {
                    return Byte.class;
                }
            }
            return cast;
        }

        @Override
        public boolean hasJavaClass() {
            return this.thenExpr.hasJavaClass() && this.elseExpr.hasJavaClass() && (this.thenExpr.getJavaClass() == this.elseExpr.getJavaClass() || this.thenExpr.getJavaClass() == RECUR_CLASS || this.elseExpr.getJavaClass() == RECUR_CLASS || this.thenExpr.getJavaClass() == null && !this.elseExpr.getJavaClass().isPrimitive() || this.elseExpr.getJavaClass() == null && !this.thenExpr.getJavaClass().isPrimitive());
        }

        @Override
        public boolean canEmitPrimitive() {
            try {
                return this.thenExpr instanceof MaybePrimitiveExpr && this.elseExpr instanceof MaybePrimitiveExpr && (this.thenExpr.getJavaClass() == this.elseExpr.getJavaClass() || this.thenExpr.getJavaClass() == RECUR_CLASS || this.elseExpr.getJavaClass() == RECUR_CLASS) && ((MaybePrimitiveExpr)this.thenExpr).canEmitPrimitive() && ((MaybePrimitiveExpr)this.elseExpr).canEmitPrimitive();
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public Class getJavaClass() {
            Class thenClass = this.thenExpr.getJavaClass();
            if (thenClass != null && thenClass != RECUR_CLASS) {
                return thenClass;
            }
            return this.elseExpr.getJavaClass();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object frm) {
                Expr elseexpr;
                Expr thenexpr;
                ISeq form = (ISeq)frm;
                if (form.count() > 4) {
                    throw Util.runtimeException("Too many arguments to if");
                }
                if (form.count() < 3) {
                    throw Util.runtimeException("Too few arguments to if");
                }
                PathNode branch = new PathNode(PATHTYPE.BRANCH, (PathNode)CLEAR_PATH.get());
                Expr testexpr = Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, RT.second(form));
                try {
                    Var.pushThreadBindings(RT.map(CLEAR_PATH, new PathNode(PATHTYPE.PATH, branch)));
                    thenexpr = Compiler.analyze(context, RT.third(form));
                }
                finally {
                    Var.popThreadBindings();
                }
                try {
                    Var.pushThreadBindings(RT.map(CLEAR_PATH, new PathNode(PATHTYPE.PATH, branch)));
                    elseexpr = Compiler.analyze(context, RT.fourth(form));
                }
                finally {
                    Var.popThreadBindings();
                }
                return new IfExpr(Compiler.lineDeref(), Compiler.columnDeref(), testexpr, thenexpr, elseexpr);
            }
        }
    }

    public static class ImportExpr
    implements Expr {
        public final String c;
        static final clojure.asm.commons.Method forNameMethod = clojure.asm.commons.Method.getMethod("Class forName(String)");
        static final clojure.asm.commons.Method importClassMethod = clojure.asm.commons.Method.getMethod("Class importClass(Class)");
        static final clojure.asm.commons.Method derefMethod = clojure.asm.commons.Method.getMethod("Object deref()");

        public ImportExpr(String c) {
            this.c = c;
        }

        @Override
        public Object eval() {
            Namespace ns = (Namespace)RT.CURRENT_NS.deref();
            ns.importClass(RT.classForName(this.c));
            return null;
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.getStatic(RT_TYPE, "CURRENT_NS", VAR_TYPE);
            gen.invokeVirtual(VAR_TYPE, derefMethod);
            gen.checkCast(NS_TYPE);
            gen.push(this.c);
            gen.invokeStatic(CLASS_TYPE, forNameMethod);
            gen.invokeVirtual(NS_TYPE, importClassMethod);
            String className = this.c;
            try {
                Class<?> cl = Class.forName(className);
                if (cl.getEnclosingClass() != null) {
                    className = className.replaceAll("\\$", ".");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Compiler.emitSource("((Namespace)RT.CURRENT_NS.deref()).importClass(" + Compiler.printClass(className) + ".class);");
            if (context == C.STATEMENT) {
                gen.pop();
                return "";
            }
            return Compiler.wrap(context, "null");
        }

        @Override
        public boolean hasJavaClass() {
            return false;
        }

        @Override
        public Class getJavaClass() {
            throw new IllegalArgumentException("ImportExpr has no Java class");
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object form) {
                return new ImportExpr((String)RT.second(form));
            }
        }
    }

    static class InstanceFieldExpr
    extends FieldExpr
    implements AssignableExpr {
        public final Expr target;
        public final Class targetClass;
        public final Field field;
        public final String fieldName;
        public final int line;
        public final int column;
        public final Symbol tag;
        static final clojure.asm.commons.Method invokeNoArgInstanceMember = clojure.asm.commons.Method.getMethod("Object invokeNoArgInstanceMember(Object,String)");
        static final clojure.asm.commons.Method setInstanceFieldMethod = clojure.asm.commons.Method.getMethod("Object setInstanceField(Object,String,Object)");

        public InstanceFieldExpr(int line, int column, Expr target, String fieldName, Symbol tag) {
            this.target = target;
            this.targetClass = target.hasJavaClass() ? target.getJavaClass() : null;
            this.field = this.targetClass != null ? Reflector.getField(this.targetClass, fieldName, false) : null;
            this.fieldName = fieldName;
            this.line = line;
            this.column = column;
            this.tag = tag;
            if (this.field == null && RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                RT.errPrintWriter().format("Reflection warning, %s:%d:%d - reference to field %s can't be resolved.\n", SOURCE_PATH.deref(), line, column, fieldName);
            }
        }

        @Override
        public Object eval() {
            return Reflector.invokeNoArgInstanceMember(this.target.eval(), this.fieldName);
        }

        @Override
        public boolean canEmitPrimitive() {
            return this.targetClass != null && this.field != null && Util.isPrimitive(this.field.getType());
        }

        @Override
        public String emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.targetClass != null && this.field != null) {
                String value = this.target.emit(C.EXPRESSION, objx, gen);
                gen.checkCast(Compiler.getType(this.targetClass));
                gen.getField(Compiler.getType(this.targetClass), this.fieldName, Type.getType(this.field.getType()));
                return Compiler.wrap(context, "((" + Compiler.printClass(this.targetClass) + ")" + value + ")." + this.fieldName);
            }
            throw new UnsupportedOperationException("Unboxed emit of unknown member");
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.targetClass != null && this.field != null) {
                String value = this.target.emit(C.EXPRESSION, objx, gen);
                gen.checkCast(Compiler.getType(this.targetClass));
                gen.getField(Compiler.getType(this.targetClass), this.fieldName, Type.getType(this.field.getType()));
                String v = "((" + Compiler.printClass(this.targetClass) + ")" + value + ")." + this.fieldName;
                v = HostExpr.emitBoxReturn(objx, gen, this.field.getType(), v);
                if (context == C.STATEMENT) {
                    gen.pop();
                    return "";
                }
                return Compiler.wrap(context, v);
            }
            String t = this.target.emit(C.EXPRESSION, objx, gen);
            gen.push(this.fieldName);
            gen.invokeStatic(REFLECTOR_TYPE, invokeNoArgInstanceMember);
            if (context == C.STATEMENT) {
                gen.pop();
            }
            return Compiler.wrap(context, "Reflector.invokeNoArgInstanceMember(" + t + ", \"" + this.fieldName + "\")");
        }

        @Override
        public boolean hasJavaClass() {
            return this.field != null || this.tag != null;
        }

        @Override
        public Class getJavaClass() {
            return this.tag != null ? HostExpr.tagToClass(this.tag) : this.field.getType();
        }

        @Override
        public Object evalAssign(Expr val) {
            return Reflector.setInstanceField(this.target.eval(), this.fieldName, val.eval());
        }

        @Override
        public String emitAssign(C context, ObjExpr objx, GeneratorAdapter gen, Expr val) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.targetClass == null || this.field == null) {
                this.target.emit(C.EXPRESSION, objx, gen);
                gen.push(this.fieldName);
                val.emit(C.EXPRESSION, objx, gen);
                gen.invokeStatic(REFLECTOR_TYPE, setInstanceFieldMethod);
                throw new RuntimeException("Reflection not allowed");
            }
            String t = this.target.emit(C.EXPRESSION, objx, gen);
            gen.checkCast(Type.getType(this.targetClass));
            String value = val.emit(C.EXPRESSION, objx, gen);
            gen.dupX1();
            Compiler.emitSource("((" + Compiler.printClass(this.targetClass) + ")" + t + ")." + this.fieldName + " = (" + Compiler.printClass(this.field.getType()) + ")" + value + ";");
            String v = HostExpr.emitUnboxArg(objx, gen, this.field.getType(), String.valueOf(t) + "." + this.fieldName);
            gen.putField(Type.getType(this.targetClass), this.fieldName, Type.getType(this.field.getType()));
            String ret = Compiler.wrap(context, v);
            if (context == C.STATEMENT) {
                gen.pop();
                return "";
            }
            return ret;
        }
    }

    static class InstanceMethodExpr
    extends MethodExpr {
        public final Expr target;
        public final String methodName;
        public final IPersistentVector args;
        public final String source;
        public final int line;
        public final int column;
        public final Symbol tag;
        public final Method method;
        static final clojure.asm.commons.Method invokeInstanceMethodMethod = clojure.asm.commons.Method.getMethod("Object invokeInstanceMethod(Object,String,Object[])");

        public InstanceMethodExpr(String source, int line, int column, Symbol tag, Expr target, String methodName, IPersistentVector args) {
            this.source = source;
            this.line = line;
            this.column = column;
            this.args = args;
            this.methodName = methodName;
            this.target = target;
            this.tag = tag;
            if (target.hasJavaClass() && target.getJavaClass() != null) {
                List methods = Reflector.getMethods(target.getJavaClass(), args.count(), methodName, false);
                if (methods.isEmpty()) {
                    this.method = null;
                } else {
                    ObjMethod objm;
                    Method m;
                    int methodidx = 0;
                    if (methods.size() > 1) {
                        ArrayList<Class[]> params = new ArrayList<Class[]>();
                        ArrayList<Class> rets = new ArrayList<Class>();
                        int i = 0;
                        while (i < methods.size()) {
                            Method m2 = (Method)methods.get(i);
                            params.add(m2.getParameterTypes());
                            rets.add(m2.getReturnType());
                            ++i;
                        }
                        methodidx = Compiler.getMatchingParams(methodName, params, args, rets);
                    }
                    if ((m = (Method)(methodidx >= 0 ? methods.get(methodidx) : null)) != null && (objm = (ObjMethod)METHOD.get()) != null && !objm.hasException) {
                        Class<?>[] classArray = m.getExceptionTypes();
                        int n = classArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Class<?> ex = classArray[n2];
                            if (!RuntimeException.class.isAssignableFrom(ex)) {
                                objm.hasException = true;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (m != null && !Modifier.isPublic(m.getDeclaringClass().getModifiers())) {
                        m = Reflector.getAsMethodOfPublicBase(m.getDeclaringClass(), m);
                    }
                    this.method = m;
                }
            } else {
                this.method = null;
            }
            if (this.method == null && RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                RT.errPrintWriter().format("Reflection warning, %s:%d:%d - call to %s can't be resolved.\n", SOURCE_PATH.deref(), line, column, methodName);
            }
        }

        @Override
        public Object eval() {
            try {
                Object targetval = this.target.eval();
                Object[] argvals = new Object[this.args.count()];
                int i = 0;
                while (i < this.args.count()) {
                    argvals[i] = ((Expr)this.args.nth(i)).eval();
                    ++i;
                }
                if (this.method != null) {
                    LinkedList<Method> ms = new LinkedList<Method>();
                    ms.add(this.method);
                    return Reflector.invokeMatchingMethod(this.methodName, ms, targetval, argvals);
                }
                return Reflector.invokeInstanceMethod(targetval, this.methodName, argvals);
            }
            catch (Throwable e) {
                if (!(e instanceof CompilerException)) {
                    throw new CompilerException(this.source, this.line, this.column, e);
                }
                throw (CompilerException)e;
            }
        }

        @Override
        public boolean canEmitPrimitive() {
            return this.method != null && Util.isPrimitive(this.method.getReturnType());
        }

        @Override
        public String emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.method != null) {
                Type type = Type.getType(this.method.getDeclaringClass());
                String first = this.target.emit(C.EXPRESSION, objx, gen);
                gen.checkCast(type);
                String argsList = MethodExpr.emitTypedArgs(objx, gen, this.method.getParameterTypes(), this.args);
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.methodName, Type.getReturnType(this.method), Type.getArgumentTypes(this.method));
                if (this.method.getDeclaringClass().isInterface()) {
                    gen.invokeInterface(type, m);
                } else {
                    gen.invokeVirtual(type, m);
                }
                return Compiler.wrap(context, "((" + Compiler.printClass(this.method.getDeclaringClass()) + ")" + first + ")." + this.method.getName() + "(" + argsList + ")");
            }
            throw new UnsupportedOperationException("Unboxed emit of unknown member");
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            String ret = null;
            gen.visitLineNumber(this.line, gen.mark());
            if (this.method != null) {
                Type type = Type.getType(this.method.getDeclaringClass());
                String val = this.target.emit(C.EXPRESSION, objx, gen);
                gen.checkCast(type);
                String argsList = MethodExpr.emitTypedArgs(objx, gen, this.method.getParameterTypes(), this.args);
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.methodName, Type.getReturnType(this.method), Type.getArgumentTypes(this.method));
                if (this.method.getDeclaringClass().isInterface()) {
                    gen.invokeInterface(type, m);
                } else {
                    gen.invokeVirtual(type, m);
                }
                ret = "((" + Compiler.printClass(this.method.getDeclaringClass()) + ")" + val + ")." + this.methodName + "(" + argsList + ")";
                String ret1 = HostExpr.emitBoxReturn(objx, gen, this.method.getReturnType(), ret);
                if (context != C.STATEMENT) {
                    ret = ret1;
                }
                if (context == C.STATEMENT && ret1.equals("null")) {
                    ret = "";
                }
            } else {
                String t = this.target.emit(C.EXPRESSION, objx, gen);
                gen.push(this.methodName);
                String argsList = InstanceMethodExpr.emitArgsAsArray(this.args, objx, gen);
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                gen.invokeStatic(REFLECTOR_TYPE, invokeInstanceMethodMethod);
                ret = "Reflector.invokeInstanceMethod(" + t + ", \"" + this.methodName + "\", new Object[]{" + argsList + "})";
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
            if (ret.isEmpty()) {
                return "";
            }
            return Compiler.wrap(context, ret);
        }

        @Override
        public boolean hasJavaClass() {
            return this.method != null || this.tag != null;
        }

        @Override
        public Class getJavaClass() {
            return this.tag != null ? HostExpr.tagToClass(this.tag) : this.method.getReturnType();
        }
    }

    public static class InstanceOfExpr
    implements Expr,
    MaybePrimitiveExpr {
        Expr expr;
        Class c;

        public InstanceOfExpr(Class c, Expr expr) {
            this.expr = expr;
            this.c = c;
        }

        @Override
        public Object eval() {
            if (this.c.isInstance(this.expr.eval())) {
                return RT.T;
            }
            return RT.F;
        }

        @Override
        public boolean canEmitPrimitive() {
            return true;
        }

        @Override
        public String emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            String val = this.expr.emit(C.EXPRESSION, objx, gen);
            gen.instanceOf(Compiler.getType(this.c));
            return "(" + val + " instanceof " + Compiler.printClass(this.c) + ")";
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            String val = this.emitUnboxed(context, objx, gen);
            val = HostExpr.emitBoxReturn(objx, gen, Boolean.TYPE, val);
            if (context == C.STATEMENT) {
                gen.pop();
            }
            return Compiler.wrap(context, val);
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return Boolean.TYPE;
        }
    }

    static class InvokeExpr
    implements Expr {
        public final Expr fexpr;
        public final Object tag;
        public final IPersistentVector args;
        public final int line;
        public final int column;
        public final String source;
        public boolean isProtocol = false;
        public boolean isDirect = false;
        public int siteIndex = -1;
        public Class protocolOn;
        public Method onMethod;
        static Keyword onKey = Keyword.intern("on");
        static Keyword methodMapKey = Keyword.intern("method-map");

        public InvokeExpr(String source, int line, int column, Symbol tag, Expr fexpr, IPersistentVector args) {
            Var fvar;
            Var pvar;
            this.source = source;
            this.fexpr = fexpr;
            this.args = args;
            this.line = line;
            this.column = column;
            if (fexpr instanceof VarExpr && (pvar = (Var)RT.get((fvar = ((VarExpr)fexpr).var).meta(), protocolKey)) != null && PROTOCOL_CALLSITES.isBound()) {
                this.isProtocol = true;
                this.siteIndex = Compiler.registerProtocolCallsite(((VarExpr)fexpr).var);
                Object pon = RT.get(pvar.get(), onKey);
                this.protocolOn = HostExpr.maybeClass(pon, false);
                if (this.protocolOn != null) {
                    IPersistentMap mmap = (IPersistentMap)RT.get(pvar.get(), methodMapKey);
                    Keyword mmapVal = (Keyword)mmap.valAt(Keyword.intern(fvar.sym));
                    if (mmapVal == null) {
                        throw new IllegalArgumentException("No method of interface: " + this.protocolOn.getName() + " found for function: " + fvar.sym + " of protocol: " + pvar.sym + " (The protocol method may have been defined before and removed.)");
                    }
                    String mname = Compiler.munge(mmapVal.sym.toString());
                    List methods = Reflector.getMethods(this.protocolOn, args.count() - 1, mname, false);
                    if (methods.size() != 1) {
                        throw new IllegalArgumentException("No single method: " + mname + " of interface: " + this.protocolOn.getName() + " found for function: " + fvar.sym + " of protocol: " + pvar.sym);
                    }
                    this.onMethod = (Method)methods.get(0);
                }
            }
            if (tag != null) {
                this.tag = tag;
            } else if (fexpr instanceof VarExpr) {
                Object arglists = RT.get(RT.meta(((VarExpr)fexpr).var), arglistsKey);
                Object sigTag = null;
                ISeq s = RT.seq(arglists);
                while (s != null) {
                    APersistentVector sig = (APersistentVector)s.first();
                    int restOffset = sig.indexOf(_AMP_);
                    if (args.count() == sig.count() || restOffset > -1 && args.count() >= restOffset) {
                        sigTag = Compiler.tagOf(sig);
                        break;
                    }
                    s = s.next();
                }
                this.tag = sigTag == null ? ((VarExpr)fexpr).tag : sigTag;
            } else {
                this.tag = null;
            }
        }

        @Override
        public Object eval() {
            try {
                IFn fn = (IFn)this.fexpr.eval();
                PersistentVector argvs = PersistentVector.EMPTY;
                int i = 0;
                while (i < this.args.count()) {
                    argvs = argvs.cons(((Expr)this.args.nth(i)).eval());
                    ++i;
                }
                PersistentVector persistentVector = argvs;
                argvs = null;
                return fn.applyTo(RT.seq(Util.ret1(persistentVector, null)));
            }
            catch (Throwable e) {
                if (!(e instanceof CompilerException)) {
                    throw new CompilerException(this.source, this.line, this.column, e);
                }
                throw (CompilerException)e;
            }
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            String ret;
            gen.visitLineNumber(this.line, gen.mark());
            if (this.isProtocol) {
                ret = this.emitProto(context, objx, gen);
            } else {
                String val = this.fexpr.emit(C.EXPRESSION, objx, gen);
                gen.checkCast(IFN_TYPE);
                ret = Compiler.wrap(context, "((IFn)" + val + ").invoke(" + this.emitArgsAndCall(0, context, objx, gen) + ")");
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
            return ret;
        }

        public String emitProto(C context, ObjExpr objx, GeneratorAdapter gen) {
            Label onLabel = gen.newLabel();
            Label callLabel = gen.newLabel();
            Label endLabel = gen.newLabel();
            Var v = ((VarExpr)this.fexpr).var;
            Expr e = (Expr)this.args.nth(0);
            String eetemp = Compiler.registerTemp();
            Compiler.emitSource("Object " + eetemp + " = " + e.emit(C.EXPRESSION, objx, gen) + ";");
            String ee = eetemp;
            gen.dup();
            gen.invokeStatic(UTIL_TYPE, clojure.asm.commons.Method.getMethod("Class classOf(Object)"));
            gen.getStatic(objx.objtype, objx.cachedClassName(this.siteIndex), CLASS_TYPE);
            gen.visitJumpInsn(165, callLabel);
            if (this.protocolOn != null) {
                gen.dup();
                gen.instanceOf(Type.getType(this.protocolOn));
                gen.ifZCmp(154, onLabel);
                Compiler.emitSource("if (!(" + ee + " instanceof " + Compiler.printClass(this.protocolOn) + ")) {");
                Compiler.tab();
            }
            gen.dup();
            gen.invokeStatic(UTIL_TYPE, clojure.asm.commons.Method.getMethod("Class classOf(Object)"));
            gen.putStatic(objx.objtype, objx.cachedClassName(this.siteIndex), CLASS_TYPE);
            gen.mark(callLabel);
            String vare = objx.emitVar(gen, v);
            gen.invokeVirtual(VAR_TYPE, clojure.asm.commons.Method.getMethod("Object getRawRoot()"));
            gen.swap();
            String argse = this.emitArgsAndCall(1, context, objx, gen);
            gen.goTo(endLabel);
            String body = "((IFn)" + vare + ".getRawRoot()).invoke(" + ee + (argse.length() > 0 ? ", " + argse : "") + ")";
            body = Compiler.wrap(context, body);
            if (context == C.EXPRESSION) {
                Compiler.emitAssigRet(context, eetemp, body);
            } else {
                Compiler.emitSource(body);
            }
            Compiler.untab();
            Compiler.emitSource("} else {");
            Compiler.tab();
            gen.mark(onLabel);
            if (this.protocolOn != null) {
                String argList = MethodExpr.emitTypedArgs(objx, gen, this.onMethod.getParameterTypes(), RT.subvec(this.args, 1, this.args.count()));
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.onMethod.getName(), Type.getReturnType(this.onMethod), Type.getArgumentTypes(this.onMethod));
                gen.invokeInterface(Type.getType(this.protocolOn), m);
                String b = "((" + Compiler.printClass(this.protocolOn) + ") " + ee + ")." + this.onMethod.getName() + "(" + argList + ")";
                String boxed = HostExpr.emitBoxReturn(objx, gen, this.onMethod.getReturnType(), b);
                if (context == C.EXPRESSION) {
                    Compiler.emitAssigRet(context, eetemp, Compiler.wrap(context, boxed));
                } else {
                    Compiler.emitSource(Compiler.wrap(context, b));
                }
                Compiler.untab();
                Compiler.emitSource("}");
            }
            gen.mark(endLabel);
            return context != C.EXPRESSION ? "" : eetemp;
        }

        String emitArgsAndCall(int firstArgToEmit, C context, ObjExpr objx, GeneratorAdapter gen) {
            StringBuilder sb = new StringBuilder();
            int i = firstArgToEmit;
            while (i < Math.min(20, this.args.count())) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                Expr e = (Expr)this.args.nth(i);
                sb.append(e.emit(C.EXPRESSION, objx, gen));
                ++i;
            }
            if (this.args.count() > 20) {
                PersistentVector restArgs = PersistentVector.EMPTY;
                int i2 = 20;
                while (i2 < this.args.count()) {
                    restArgs = restArgs.cons(this.args.nth(i2));
                    ++i2;
                }
                sb.append(", " + MethodExpr.emitArgsAsArray(restArgs, objx, gen));
            }
            if (context == C.RETURN) {
                ObjMethod method = (ObjMethod)METHOD.deref();
                method.emitClearLocals(gen);
            }
            gen.invokeInterface(IFN_TYPE, new clojure.asm.commons.Method("invoke", OBJECT_TYPE, ARG_TYPES[Math.min(21, this.args.count())]));
            return sb.toString();
        }

        @Override
        public boolean hasJavaClass() {
            return this.tag != null;
        }

        @Override
        public Class getJavaClass() {
            return HostExpr.tagToClass(this.tag);
        }

        public static Expr parse(C context, ISeq form) {
            Object val;
            Expr sexpr;
            Expr fexpr;
            if (context != C.EVAL) {
                context = C.EXPRESSION;
            }
            if ((fexpr = Compiler.analyze(context, form.first())) instanceof VarExpr && ((VarExpr)fexpr).var.equals(INSTANCE) && RT.count(form) == 3 && (sexpr = Compiler.analyze(C.EXPRESSION, RT.second(form))) instanceof ConstantExpr && (val = ((ConstantExpr)sexpr).val()) instanceof Class) {
                return new InstanceOfExpr((Class)val, Compiler.analyze(context, RT.third(form)));
            }
            if (fexpr instanceof VarExpr && context != C.EVAL) {
                Var v = ((VarExpr)fexpr).var;
                Object arglists = RT.get(RT.meta(v), arglistsKey);
                int arity = RT.count(form.next());
                ISeq s = RT.seq(arglists);
                while (s != null) {
                    IPersistentVector args = (IPersistentVector)s.first();
                    if (args.count() == arity) {
                        String primc = FnMethod.primInterface(args);
                        if (primc == null) break;
                        return Compiler.analyze(context, RT.listStar(Symbol.intern(".invokePrim"), ((Symbol)form.first()).withMeta(RT.map(RT.TAG_KEY, Symbol.intern(primc))), form.next()));
                    }
                    s = s.next();
                }
            }
            if (fexpr instanceof KeywordExpr && RT.count(form) == 2 && KEYWORD_CALLSITES.isBound()) {
                Expr target = Compiler.analyze(context, RT.second(form));
                return new KeywordInvokeExpr((String)SOURCE.deref(), Compiler.lineDeref(), Compiler.columnDeref(), Compiler.tagOf(form), (KeywordExpr)fexpr, target);
            }
            PersistentVector args = PersistentVector.EMPTY;
            ISeq s = RT.seq(form.next());
            while (s != null) {
                args = args.cons(Compiler.analyze(context, s.first()));
                s = s.next();
            }
            return new InvokeExpr((String)SOURCE.deref(), Compiler.lineDeref(), Compiler.columnDeref(), Compiler.tagOf(form), fexpr, args);
        }
    }

    public static class KeywordExpr
    extends LiteralExpr {
        public final Keyword k;

        public KeywordExpr(Keyword k) {
            this.k = k;
        }

        @Override
        Object val() {
            return this.k;
        }

        @Override
        public Object eval() {
            return this.k;
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            String val = objx.emitKeyword(gen, this.k);
            if (context == C.STATEMENT) {
                gen.pop();
                return "";
            }
            return Compiler.wrap(context, val);
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return Keyword.class;
        }
    }

    static class KeywordInvokeExpr
    implements Expr {
        public final KeywordExpr kw;
        public final Object tag;
        public final Expr target;
        public final int line;
        public final int column;
        public final int siteIndex;
        public final String source;
        static Type ILOOKUP_TYPE = Type.getType(ILookup.class);

        public KeywordInvokeExpr(String source, int line, int column, Symbol tag, KeywordExpr kw, Expr target) {
            this.source = source;
            this.kw = kw;
            this.target = target;
            this.line = line;
            this.column = column;
            this.tag = tag;
            this.siteIndex = Compiler.registerKeywordCallsite(kw.k);
        }

        @Override
        public Object eval() {
            try {
                return this.kw.k.invoke(this.target.eval());
            }
            catch (Throwable e) {
                if (!(e instanceof CompilerException)) {
                    throw new CompilerException(this.source, this.line, this.column, e);
                }
                throw (CompilerException)e;
            }
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            Label endLabel = gen.newLabel();
            Label faultLabel = gen.newLabel();
            gen.visitLineNumber(this.line, gen.mark());
            gen.getStatic(objx.objtype, objx.thunkNameStatic(this.siteIndex), ObjExpr.ILOOKUP_THUNK_TYPE);
            gen.dup();
            String tar = this.target.emit(C.EXPRESSION, objx, gen);
            gen.dupX2();
            gen.invokeInterface(ObjExpr.ILOOKUP_THUNK_TYPE, clojure.asm.commons.Method.getMethod("Object get(Object)"));
            gen.dupX2();
            gen.visitJumpInsn(165, faultLabel);
            gen.pop();
            gen.goTo(endLabel);
            gen.mark(faultLabel);
            gen.swap();
            gen.pop();
            gen.dup();
            gen.getStatic(objx.objtype, objx.siteNameStatic(this.siteIndex), ObjExpr.KEYWORD_LOOKUPSITE_TYPE);
            gen.swap();
            gen.invokeInterface(ObjExpr.ILOOKUP_SITE_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.ILookupThunk fault(Object)"));
            gen.dup();
            gen.putStatic(objx.objtype, objx.thunkNameStatic(this.siteIndex), ObjExpr.ILOOKUP_THUNK_TYPE);
            gen.swap();
            gen.invokeInterface(ObjExpr.ILOOKUP_THUNK_TYPE, clojure.asm.commons.Method.getMethod("Object get(Object)"));
            gen.mark(endLabel);
            if (context == C.STATEMENT) {
                gen.pop();
            }
            return Compiler.wrap(context, "RT.get(" + tar + ", Keyword.intern(" + (this.kw.k.getNamespace() == null ? "null" : "\"" + this.kw.k.getNamespace() + "\"") + ", \"" + this.kw.k.getName() + "\"))");
        }

        @Override
        public boolean hasJavaClass() {
            return this.tag != null;
        }

        @Override
        public Class getJavaClass() {
            return HostExpr.tagToClass(this.tag);
        }
    }

    public static class LetExpr
    implements Expr,
    MaybePrimitiveExpr {
        public final PersistentVector bindingInits;
        public final Expr body;
        public final boolean isLoop;

        public LetExpr(PersistentVector bindingInits, Expr body, boolean isLoop) {
            this.bindingInits = bindingInits;
            this.body = body;
            this.isLoop = isLoop;
        }

        @Override
        public Object eval() {
            throw new UnsupportedOperationException("Can't eval let/loop");
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            return this.doEmit(context, objx, gen, false);
        }

        @Override
        public String emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            return this.doEmit(context, objx, gen, true);
        }

        public String doEmit(C context, ObjExpr objx, GeneratorAdapter gen, boolean emitUnboxed) {
            String v;
            String r = null;
            if (context == C.EXPRESSION) {
                r = Compiler.registerTemp();
                Compiler.emitSource("Object " + r + " = null;");
            }
            if (!emitUnboxed) {
                Compiler.emitSource("{");
                Compiler.tab();
            }
            HashMap<BindingInit, Label> bindingLabels = new HashMap<BindingInit, Label>();
            int i = 0;
            while (i < this.bindingInits.count()) {
                String val;
                BindingInit bi = (BindingInit)this.bindingInits.nth(i);
                Class primc = Compiler.maybePrimitiveType(bi.init);
                boolean typed = true;
                if (primc != null) {
                    val = ((MaybePrimitiveExpr)bi.init).emitUnboxed(C.EXPRESSION, objx, gen);
                    gen.visitVarInsn(Type.getType(primc).getOpcode(54), bi.binding.idx);
                    Compiler.emitSource(String.valueOf(typed ? String.valueOf(Compiler.printClass(primc)) + " " : "") + bi.binding.print() + " = " + val + ";");
                } else {
                    val = bi.init.emit(C.EXPRESSION, objx, gen);
                    gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), bi.binding.idx);
                    Compiler.emitSource(String.valueOf(typed ? "Object " : "") + bi.binding.print() + " = " + val + ";");
                }
                bindingLabels.put(bi, gen.mark());
                ++i;
            }
            if (this.isLoop) {
                Compiler.emitSource("while(true) {");
                Compiler.tab();
            }
            Label loopLabel = gen.mark();
            if (this.isLoop) {
                try {
                    Var.pushThreadBindings(RT.map(LOOP_LABEL, loopLabel));
                    if (emitUnboxed) {
                        v = ((MaybePrimitiveExpr)this.body).emitUnboxed(context, objx, gen);
                    }
                    v = this.body.emit(context, objx, gen);
                }
                finally {
                    Var.popThreadBindings();
                }
            } else {
                v = emitUnboxed ? ((MaybePrimitiveExpr)this.body).emitUnboxed(context, objx, gen) : this.body.emit(context, objx, gen);
            }
            if (v != null) {
                if (emitUnboxed) {
                    r = v;
                } else {
                    Compiler.emitAssigRet(context, r, v);
                }
            } else if (emitUnboxed) {
                r = "null";
            }
            Label end = gen.mark();
            ISeq bis = this.bindingInits.seq();
            while (bis != null) {
                Class primc;
                BindingInit bi = (BindingInit)bis.first();
                String lname = bi.binding.name;
                if (lname.endsWith("__auto__")) {
                    lname = String.valueOf(lname) + RT.nextID();
                }
                if ((primc = Compiler.maybePrimitiveType(bi.init)) != null) {
                    gen.visitLocalVariable(lname, Type.getDescriptor(primc), null, (Label)bindingLabels.get(bi), end, bi.binding.idx);
                } else {
                    gen.visitLocalVariable(lname, "Ljava/lang/Object;", null, (Label)bindingLabels.get(bi), end, bi.binding.idx);
                }
                bis = bis.next();
            }
            if (this.isLoop) {
                if (C.RETURN != context) {
                    Compiler.emitSource("break;");
                }
                Compiler.untab();
                Compiler.emitSource("}");
            }
            if (!emitUnboxed) {
                Compiler.untab();
                Compiler.emitSource("}");
            }
            return context == C.EXPRESSION || emitUnboxed ? r : (v == null ? null : "");
        }

        @Override
        public boolean hasJavaClass() {
            return this.body.hasJavaClass();
        }

        @Override
        public Class getJavaClass() {
            return this.body.getJavaClass();
        }

        @Override
        public boolean canEmitPrimitive() {
            return this.body instanceof MaybePrimitiveExpr && ((MaybePrimitiveExpr)this.body).canEmitPrimitive();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public Expr parse(C context, Object frm) {
                form = (ISeq)frm;
                isLoop = RT.first(form).equals(Compiler.LOOP);
                if (!(RT.second(form) instanceof IPersistentVector)) {
                    throw new IllegalArgumentException("Bad binding form, expected vector");
                }
                bindings = (IPersistentVector)RT.second(form);
                if (bindings.count() % 2 != 0) {
                    throw new IllegalArgumentException("Bad binding form, expected matched symbol expression pairs");
                }
                body = RT.next(RT.next(form));
                if (context == C.EVAL || context == C.EXPRESSION && isLoop) {
                    return Compiler.analyze(context, RT.list(RT.list(Compiler.FNONCE, PersistentVector.EMPTY, form)));
                }
                method = (ObjMethod)Compiler.METHOD.deref();
                methodHasRecur = method.hasRecur;
                backupMethodLocals = method.locals;
                backupMethodIndexLocals = method.indexlocals;
                recurMismatches = PersistentVector.EMPTY;
                i = 0;
                while (i < bindings.count() / 2) {
                    recurMismatches = recurMismatches.cons(RT.F);
                    ++i;
                }
                while (true) {
                    dynamicBindings = RT.map(new Object[]{Compiler.LOCAL_ENV, Compiler.LOCAL_ENV.deref()});
                    method.locals = backupMethodLocals;
                    method.indexlocals = backupMethodIndexLocals;
                    if (isLoop) {
                        dynamicBindings = dynamicBindings.assoc(Compiler.LOOP_LOCALS, null);
                    }
                    try {
                        block28: {
                            Var.pushThreadBindings(dynamicBindings);
                            bindingInits = PersistentVector.EMPTY;
                            loopLocals = PersistentVector.EMPTY;
                            i = 0;
                            while (i < bindings.count()) {
                                if (!(bindings.nth(i) instanceof Symbol)) {
                                    throw new IllegalArgumentException("Bad binding form, expected symbol, got: " + bindings.nth(i));
                                }
                                sym = (Symbol)bindings.nth(i);
                                if (sym.getNamespace() != null) {
                                    throw Util.runtimeException("Can't let qualified name: " + sym);
                                }
                                init = Compiler.access$0(C.EXPRESSION, bindings.nth(i + 1), sym.name);
                                if (isLoop) {
                                    if (recurMismatches != null && RT.booleanCast(recurMismatches.nth(i / 2))) {
                                        init = new StaticMethodExpr("", 0, 0, null, RT.class, "box", RT.vector(new Object[]{init}));
                                        if (RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                                            RT.errPrintWriter().println("Auto-boxing loop arg: " + sym);
                                        }
                                    } else if (Compiler.maybePrimitiveType(init) == Integer.TYPE) {
                                        init = new StaticMethodExpr("", 0, 0, null, RT.class, "longCast", RT.vector(new Object[]{init}));
                                    } else if (Compiler.maybePrimitiveType(init) == Float.TYPE) {
                                        init = new StaticMethodExpr("", 0, 0, null, RT.class, "doubleCast", RT.vector(new Object[]{init}));
                                    }
                                }
                                lb = Compiler.access$9(sym, Compiler.access$4(sym), init, false);
                                bi = new BindingInit(lb, init);
                                bindingInits = bindingInits.cons(bi);
                                if (isLoop) {
                                    loopLocals = loopLocals.cons(lb);
                                }
                                i += 2;
                            }
                            if (isLoop) {
                                Compiler.LOOP_LOCALS.set(loopLocals);
                            }
                            moreMismatches = false;
                            try {
                                if (isLoop) {
                                    root = new PathNode(PATHTYPE.PATH, (PathNode)Compiler.CLEAR_PATH.get());
                                    Var.pushThreadBindings(RT.map(new Object[]{Compiler.CLEAR_PATH, new PathNode(PATHTYPE.PATH, root), Compiler.CLEAR_ROOT, new PathNode(PATHTYPE.PATH, root), Compiler.NO_RECUR, null}));
                                }
                                bodyExpr = new BodyExpr.Parser().parse(isLoop != false ? C.RETURN : context, body);
                            }
                            finally {
                                if (!isLoop) break block28;
                                Var.popThreadBindings();
                                i = 0;
                                ** while (i < loopLocals.count())
                            }
lbl-1000:
                            // 1 sources

                            {
                                lb = (LocalBinding)loopLocals.nth(i);
                                if (lb.recurMistmatch) {
                                    recurMismatches = (IPersistentVector)recurMismatches.assoc(i, RT.T);
                                    moreMismatches = true;
                                }
                                ++i;
                                continue;
                            }
                        }
                        if (moreMismatches) continue;
                        var22_27 = new LetExpr(bindingInits, bodyExpr, isLoop);
                        return var22_27;
                    }
                    finally {
                        if (isLoop) {
                            method.hasRecur = methodHasRecur;
                        }
                        Var.popThreadBindings();
                        continue;
                    }
                    break;
                }
            }
        }
    }

    public static class LetFnExpr
    implements Expr {
        public final PersistentVector bindingInits;
        public final Expr body;

        public LetFnExpr(PersistentVector bindingInits, Expr body) {
            this.bindingInits = bindingInits;
            this.body = body;
        }

        @Override
        public Object eval() {
            throw new UnsupportedOperationException("Can't eval letfns");
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            BindingInit bi;
            int i = 0;
            while (i < this.bindingInits.count()) {
                BindingInit bi2 = (BindingInit)this.bindingInits.nth(i);
                gen.visitInsn(1);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), bi2.binding.idx);
                ++i;
            }
            String r = Compiler.registerTemp();
            if (context == C.EXPRESSION) {
                Compiler.emitSource("Object " + r + ";");
            }
            IPersistentSet lbset = PersistentHashSet.EMPTY;
            int i2 = 0;
            while (i2 < this.bindingInits.count()) {
                bi = (BindingInit)this.bindingInits.nth(i2);
                lbset = (IPersistentSet)lbset.cons(bi.binding);
                String val = bi.init.emit(C.EXPRESSION, objx, gen);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), bi.binding.idx);
                Compiler.emitSource("IFn " + bi.binding.print() + " = " + val + ";");
                ++i2;
            }
            i2 = 0;
            while (i2 < this.bindingInits.count()) {
                bi = (BindingInit)this.bindingInits.nth(i2);
                ObjExpr fe = (ObjExpr)bi.init;
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(21), bi.binding.idx);
                fe.emitLetFnInits(gen, objx, lbset);
                ++i2;
            }
            Label loopLabel = gen.mark();
            Compiler.emitAssigRet(context, r, this.body.emit(context, objx, gen));
            Label end = gen.mark();
            ISeq bis = this.bindingInits.seq();
            while (bis != null) {
                Class primc;
                BindingInit bi3 = (BindingInit)bis.first();
                String lname = bi3.binding.name;
                if (lname.endsWith("__auto__")) {
                    lname = String.valueOf(lname) + RT.nextID();
                }
                if ((primc = Compiler.maybePrimitiveType(bi3.init)) != null) {
                    gen.visitLocalVariable(lname, Type.getDescriptor(primc), null, loopLabel, end, bi3.binding.idx);
                } else {
                    gen.visitLocalVariable(lname, "Ljava/lang/Object;", null, loopLabel, end, bi3.binding.idx);
                }
                bis = bis.next();
            }
            return C.EXPRESSION == context ? r : "";
        }

        @Override
        public boolean hasJavaClass() {
            return this.body.hasJavaClass();
        }

        @Override
        public Class getJavaClass() {
            return this.body.getJavaClass();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object frm) {
                ISeq form = (ISeq)frm;
                if (!(RT.second(form) instanceof IPersistentVector)) {
                    throw new IllegalArgumentException("Bad binding form, expected vector");
                }
                IPersistentVector bindings = (IPersistentVector)RT.second(form);
                if (bindings.count() % 2 != 0) {
                    throw new IllegalArgumentException("Bad binding form, expected matched symbol expression pairs");
                }
                ISeq body = RT.next(RT.next(form));
                if (context == C.EVAL) {
                    return Compiler.analyze(context, RT.list(RT.list(FNONCE, PersistentVector.EMPTY, form)));
                }
                IPersistentMap dynamicBindings = RT.map(LOCAL_ENV, LOCAL_ENV.deref());
                try {
                    Var.pushThreadBindings(dynamicBindings);
                    PersistentVector lbs = PersistentVector.EMPTY;
                    int i = 0;
                    while (i < bindings.count()) {
                        if (!(bindings.nth(i) instanceof Symbol)) {
                            throw new IllegalArgumentException("Bad binding form, expected symbol, got: " + bindings.nth(i));
                        }
                        Symbol sym = (Symbol)bindings.nth(i);
                        if (sym.getNamespace() != null) {
                            throw Util.runtimeException("Can't let qualified name: " + sym);
                        }
                        LocalBinding lb = Compiler.registerLocal(sym, Compiler.tagOf(sym), null, false);
                        lb.canBeCleared = false;
                        lbs = lbs.cons(lb);
                        i += 2;
                    }
                    PersistentVector bindingInits = PersistentVector.EMPTY;
                    int i2 = 0;
                    while (i2 < bindings.count()) {
                        Symbol sym = (Symbol)bindings.nth(i2);
                        Expr init = Compiler.analyze(C.EXPRESSION, bindings.nth(i2 + 1), sym.name);
                        LocalBinding lb = (LocalBinding)lbs.nth(i2 / 2);
                        lb.init = init;
                        BindingInit bi = new BindingInit(lb, init);
                        bindingInits = bindingInits.cons(bi);
                        i2 += 2;
                    }
                    LetFnExpr letFnExpr = new LetFnExpr(bindingInits, new BodyExpr.Parser().parse(context, body));
                    return letFnExpr;
                }
                finally {
                    Var.popThreadBindings();
                }
            }
        }
    }

    public static class ListExpr
    implements Expr {
        public final IPersistentVector args;
        static final clojure.asm.commons.Method arrayToListMethod = clojure.asm.commons.Method.getMethod("clojure.lang.ISeq arrayToList(Object[])");

        public ListExpr(IPersistentVector args) {
            this.args = args;
        }

        @Override
        public Object eval() {
            IPersistentVector ret = PersistentVector.EMPTY;
            int i = 0;
            while (i < this.args.count()) {
                ret = ret.cons(((Expr)this.args.nth(i)).eval());
                ++i;
            }
            return ret.seq();
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            String argsList = MethodExpr.emitArgsAsArray(this.args, objx, gen);
            gen.invokeStatic(RT_TYPE, arrayToListMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
            return Compiler.wrap(context, "RT.arrayToList(" + argsList + ")");
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return IPersistentList.class;
        }
    }

    public static abstract class LiteralExpr
    implements Expr {
        abstract Object val();

        @Override
        public Object eval() {
            return this.val();
        }
    }

    public static class LocalBinding {
        public final Symbol sym;
        public final Symbol tag;
        public Expr init;
        public final int idx;
        public final String name;
        public final boolean isArg;
        public final PathNode clearPathRoot;
        public boolean canBeCleared = !RT.booleanCast(Compiler.getCompilerOption(disableLocalsClearingKey));
        public boolean recurMistmatch = false;

        public LocalBinding(int num, Symbol sym, Symbol tag, Expr init, boolean isArg, PathNode clearPathRoot) {
            if (Compiler.maybePrimitiveType(init) != null && tag != null) {
                throw new UnsupportedOperationException("Can't type hint a local with a primitive initializer");
            }
            this.idx = num;
            this.sym = sym;
            this.tag = tag;
            this.init = init;
            this.isArg = isArg;
            this.clearPathRoot = clearPathRoot;
            this.name = Compiler.munge(sym.name);
        }

        public boolean hasJavaClass() {
            if (this.init != null && this.init.hasJavaClass() && Util.isPrimitive(this.init.getJavaClass()) && !(this.init instanceof MaybePrimitiveExpr)) {
                return false;
            }
            return this.tag != null || this.init != null && this.init.hasJavaClass();
        }

        public Class getJavaClass() {
            return this.tag != null ? HostExpr.tagToClass(this.tag) : this.init.getJavaClass();
        }

        public Class getPrimitiveType() {
            return Compiler.maybePrimitiveType(this.init);
        }

        public String print() {
            if (this.idx == -1) {
                return this.name;
            }
            return String.valueOf(this.name) + this.idx;
        }
    }

    public static class LocalBindingExpr
    implements Expr,
    MaybePrimitiveExpr,
    AssignableExpr {
        public final LocalBinding b;
        public final Symbol tag;
        public final PathNode clearPath;
        public final PathNode clearRoot;
        public boolean shouldClear = false;

        public LocalBindingExpr(LocalBinding b, Symbol tag) {
            if (b.getPrimitiveType() != null && tag != null) {
                throw new UnsupportedOperationException("Can't type hint a primitive local");
            }
            this.b = b;
            this.tag = tag;
            this.clearPath = (PathNode)CLEAR_PATH.get();
            this.clearRoot = (PathNode)CLEAR_ROOT.get();
            IPersistentCollection sites = (IPersistentCollection)RT.get(CLEAR_SITES.get(), b);
            if (b.idx > 0) {
                if (sites != null) {
                    ISeq s = sites.seq();
                    while (s != null) {
                        LocalBindingExpr o = (LocalBindingExpr)s.first();
                        PathNode common = Compiler.commonPath(this.clearPath, o.clearPath);
                        if (common != null && common.type == PATHTYPE.PATH) {
                            o.shouldClear = false;
                        }
                        s = s.next();
                    }
                }
                if (this.clearRoot == b.clearPathRoot) {
                    this.shouldClear = true;
                    sites = RT.conj(sites, this);
                    CLEAR_SITES.set(RT.assoc(CLEAR_SITES.get(), b, sites));
                }
            }
        }

        @Override
        public Object eval() {
            throw new UnsupportedOperationException("Can't eval locals");
        }

        @Override
        public boolean canEmitPrimitive() {
            return this.b.getPrimitiveType() != null;
        }

        @Override
        public String emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            return Compiler.wrap(context, objx.emitUnboxedLocal(gen, this.b));
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (context != C.STATEMENT) {
                return Compiler.wrap(context, objx.emitLocal(gen, this.b, this.shouldClear));
            }
            return "";
        }

        @Override
        public Object evalAssign(Expr val) {
            throw new UnsupportedOperationException("Can't eval locals");
        }

        @Override
        public String emitAssign(C context, ObjExpr objx, GeneratorAdapter gen, Expr val) {
            objx.emitAssignLocal(gen, this.b, val);
            if (context != C.STATEMENT) {
                return objx.emitLocal(gen, this.b, false);
            }
            return "";
        }

        @Override
        public boolean hasJavaClass() {
            return this.tag != null || this.b.hasJavaClass();
        }

        @Override
        public Class getJavaClass() {
            if (this.tag != null) {
                return HostExpr.tagToClass(this.tag);
            }
            return this.b.getJavaClass();
        }
    }

    public static class MapExpr
    implements Expr {
        public final IPersistentVector keyvals;
        static final clojure.asm.commons.Method mapMethod = clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentMap map(Object[])");
        static final clojure.asm.commons.Method mapUniqueKeysMethod = clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentMap mapUniqueKeys(Object[])");

        public MapExpr(IPersistentVector keyvals) {
            this.keyvals = keyvals;
        }

        @Override
        public Object eval() {
            Object[] ret = new Object[this.keyvals.count()];
            int i = 0;
            while (i < this.keyvals.count()) {
                ret[i] = ((Expr)this.keyvals.nth(i)).eval();
                ++i;
            }
            return RT.map(ret);
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            boolean allKeysConstant = true;
            boolean allConstantKeysUnique = true;
            IPersistentSet constantKeys = PersistentHashSet.EMPTY;
            int i = 0;
            while (i < this.keyvals.count()) {
                Expr k = (Expr)this.keyvals.nth(i);
                if (k instanceof LiteralExpr) {
                    Object kval = k.eval();
                    if (constantKeys.contains(kval)) {
                        allConstantKeysUnique = false;
                    } else {
                        constantKeys = (IPersistentSet)constantKeys.cons(kval);
                    }
                } else {
                    allKeysConstant = false;
                }
                i += 2;
            }
            String val = MethodExpr.emitArgsAsArray(this.keyvals, objx, gen);
            if (allKeysConstant && allConstantKeysUnique || this.keyvals.count() <= 2) {
                gen.invokeStatic(RT_TYPE, mapUniqueKeysMethod);
                val = "RT.mapUniqueKeys(" + val + ")";
            } else {
                gen.invokeStatic(RT_TYPE, mapMethod);
                val = "RT.map(" + val + ")";
            }
            if (context == C.STATEMENT) {
                gen.pop();
                return "";
            }
            return Compiler.wrap(context, val);
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return IPersistentMap.class;
        }

        public static Expr parse(C context, IPersistentMap form) {
            IPersistentVector keyvals = PersistentVector.EMPTY;
            boolean keysConstant = true;
            boolean valsConstant = true;
            boolean allConstantKeysUnique = true;
            IPersistentSet constantKeys = PersistentHashSet.EMPTY;
            ISeq s = RT.seq(form);
            while (s != null) {
                IMapEntry e = (IMapEntry)s.first();
                Expr k = Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, e.key());
                Expr v = Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, e.val());
                keyvals = keyvals.cons(k);
                keyvals = keyvals.cons(v);
                if (k instanceof LiteralExpr) {
                    Object kval = k.eval();
                    if (constantKeys.contains(kval)) {
                        allConstantKeysUnique = false;
                    } else {
                        constantKeys = (IPersistentSet)constantKeys.cons(kval);
                    }
                } else {
                    keysConstant = false;
                }
                if (!(v instanceof LiteralExpr)) {
                    valsConstant = false;
                }
                s = s.next();
            }
            MapExpr ret = new MapExpr(keyvals);
            if (form instanceof IObj && ((IObj)((Object)form)).meta() != null) {
                return new MetaExpr(ret, MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)((Object)form)).meta()));
            }
            if (keysConstant) {
                if (!allConstantKeysUnique) {
                    throw new IllegalArgumentException("Duplicate constant keys in map");
                }
                if (valsConstant) {
                    IPersistentMap m = PersistentHashMap.EMPTY;
                    int i = 0;
                    while (i < keyvals.length()) {
                        m = m.assoc(((LiteralExpr)keyvals.nth(i)).val(), ((LiteralExpr)keyvals.nth(i + 1)).val());
                        i += 2;
                    }
                    return new ConstantExpr(m);
                }
                return ret;
            }
            return ret;
        }
    }

    public static interface MaybePrimitiveExpr
    extends Expr {
        public boolean canEmitPrimitive();

        public String emitUnboxed(C var1, ObjExpr var2, GeneratorAdapter var3);
    }

    public static class MetaExpr
    implements Expr {
        public final Expr expr;
        public final Expr meta;
        static final Type IOBJ_TYPE = Type.getType(IObj.class);
        static final clojure.asm.commons.Method withMetaMethod = clojure.asm.commons.Method.getMethod("clojure.lang.IObj withMeta(clojure.lang.IPersistentMap)");

        public MetaExpr(Expr expr, Expr meta) {
            this.expr = expr;
            this.meta = meta;
        }

        @Override
        public Object eval() {
            return ((IObj)this.expr.eval()).withMeta((IPersistentMap)this.meta.eval());
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            String val = this.expr.emit(C.EXPRESSION, objx, gen);
            gen.checkCast(IOBJ_TYPE);
            String m = this.meta.emit(C.EXPRESSION, objx, gen);
            gen.checkCast(IPERSISTENTMAP_TYPE);
            gen.invokeInterface(IOBJ_TYPE, withMetaMethod);
            if (context == C.STATEMENT) {
                gen.pop();
                return "";
            }
            return Compiler.wrap(context, "((IObj)" + val + ").withMeta(" + m + ")");
        }

        @Override
        public boolean hasJavaClass() {
            return this.expr.hasJavaClass();
        }

        @Override
        public Class getJavaClass() {
            return this.expr.getJavaClass();
        }
    }

    static abstract class MethodExpr
    extends HostExpr {
        MethodExpr() {
        }

        static String emitArgsAsArray(IPersistentVector args, ObjExpr objx, GeneratorAdapter gen) {
            gen.push(args.count());
            gen.newArray(OBJECT_TYPE);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < args.count()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                gen.dup();
                gen.push(i);
                sb.append(((Expr)args.nth(i)).emit(C.EXPRESSION, objx, gen));
                gen.arrayStore(OBJECT_TYPE);
                ++i;
            }
            return sb.toString();
        }

        public static String emitTypedArgs(ObjExpr objx, GeneratorAdapter gen, Class[] parameterTypes, IPersistentVector args) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < parameterTypes.length) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                Expr e = (Expr)args.nth(i);
                try {
                    MaybePrimitiveExpr pe;
                    Class primc = Compiler.maybePrimitiveType(e);
                    String canonicalName = Compiler.printClass(parameterTypes[i]);
                    if (!canonicalName.equals("java.lang.Object")) {
                        sb.append("(" + canonicalName + ")");
                    }
                    if (primc == parameterTypes[i]) {
                        pe = (MaybePrimitiveExpr)e;
                        sb.append(pe.emitUnboxed(C.EXPRESSION, objx, gen));
                    } else if (primc == Integer.TYPE && parameterTypes[i] == Long.TYPE) {
                        pe = (MaybePrimitiveExpr)e;
                        sb.append(pe.emitUnboxed(C.EXPRESSION, objx, gen));
                        gen.visitInsn(133);
                    } else if (primc == Long.TYPE && parameterTypes[i] == Integer.TYPE) {
                        pe = (MaybePrimitiveExpr)e;
                        String val = pe.emitUnboxed(C.EXPRESSION, objx, gen);
                        if (RT.booleanCast(RT.UNCHECKED_MATH.deref())) {
                            gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("int uncheckedIntCast(long)"));
                            sb.append("RT.uncheckedIntCast(" + val + ")");
                        } else {
                            gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("int intCast(long)"));
                            sb.append("RT.intCast(" + val + ")");
                        }
                    } else if (primc == Float.TYPE && parameterTypes[i] == Double.TYPE) {
                        pe = (MaybePrimitiveExpr)e;
                        sb.append(pe.emitUnboxed(C.EXPRESSION, objx, gen));
                        gen.visitInsn(141);
                    } else if (primc == Double.TYPE && parameterTypes[i] == Float.TYPE) {
                        pe = (MaybePrimitiveExpr)e;
                        sb.append(pe.emitUnboxed(C.EXPRESSION, objx, gen));
                        gen.visitInsn(144);
                    } else {
                        String v = e.emit(C.EXPRESSION, objx, gen);
                        v = HostExpr.emitUnboxArg(objx, gen, parameterTypes[i], v);
                        sb.append(v);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace(RT.errPrintWriter());
                }
                ++i;
            }
            return sb.toString();
        }
    }

    public static class MethodParamExpr
    implements Expr,
    MaybePrimitiveExpr {
        final Class c;

        public MethodParamExpr(Class c) {
            this.c = c;
        }

        @Override
        public Object eval() {
            throw Util.runtimeException("Can't eval");
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            throw Util.runtimeException("Can't emit");
        }

        @Override
        public boolean hasJavaClass() {
            return this.c != null;
        }

        @Override
        public Class getJavaClass() {
            return this.c;
        }

        @Override
        public boolean canEmitPrimitive() {
            return Util.isPrimitive(this.c);
        }

        @Override
        public String emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            throw Util.runtimeException("Can't emit");
        }
    }

    static class MonitorEnterExpr
    extends UntypedExpr {
        final Expr target;

        public MonitorEnterExpr(Expr target) {
            this.target = target;
        }

        @Override
        public Object eval() {
            throw new UnsupportedOperationException("Can't eval monitor-enter");
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.target.emit(C.EXPRESSION, objx, gen);
            gen.monitorEnter();
            NIL_EXPR.emit(context, objx, gen);
            return "";
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object form) {
                return new MonitorEnterExpr(Compiler.analyze(C.EXPRESSION, RT.second(form)));
            }
        }
    }

    static class MonitorExitExpr
    extends UntypedExpr {
        final Expr target;

        public MonitorExitExpr(Expr target) {
            this.target = target;
        }

        @Override
        public Object eval() {
            throw new UnsupportedOperationException("Can't eval monitor-exit");
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.target.emit(C.EXPRESSION, objx, gen);
            gen.monitorExit();
            NIL_EXPR.emit(context, objx, gen);
            return "";
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object form) {
                return new MonitorExitExpr(Compiler.analyze(C.EXPRESSION, RT.second(form)));
            }
        }
    }

    public static class NewExpr
    implements Expr {
        public final IPersistentVector args;
        public final Constructor ctor;
        public final Class c;
        static final clojure.asm.commons.Method invokeConstructorMethod = clojure.asm.commons.Method.getMethod("Object invokeConstructor(Class,Object[])");
        static final clojure.asm.commons.Method forNameMethod = clojure.asm.commons.Method.getMethod("Class forName(String)");

        public NewExpr(Class c, IPersistentVector args, int line, int column) {
            ObjMethod objm;
            this.args = args;
            this.c = c;
            Constructor<?>[] allctors = c.getConstructors();
            ArrayList ctors = new ArrayList();
            ArrayList<Class[]> params = new ArrayList<Class[]>();
            ArrayList<Class> rets = new ArrayList<Class>();
            int i = 0;
            while (i < allctors.length) {
                Constructor<?> ctor = allctors[i];
                if (ctor.getParameterTypes().length == args.count()) {
                    ctors.add(ctor);
                    params.add(ctor.getParameterTypes());
                    rets.add(c);
                }
                ++i;
            }
            if (ctors.isEmpty()) {
                throw new IllegalArgumentException("No matching ctor found for " + c);
            }
            int ctoridx = 0;
            if (ctors.size() > 1) {
                ctoridx = Compiler.getMatchingParams(c.getName(), params, args, rets);
            }
            Constructor constructor = this.ctor = ctoridx >= 0 ? (Constructor)ctors.get(ctoridx) : null;
            if (this.ctor != null && (objm = (ObjMethod)METHOD.get()) != null && !objm.hasException) {
                Class<?>[] classArray = this.ctor.getExceptionTypes();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> ex = classArray[n2];
                    if (!RuntimeException.class.isAssignableFrom(ex)) {
                        objm.hasException = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (this.ctor == null && RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                RT.errPrintWriter().format("Reflection warning, %s:%d:%d - call to %s ctor can't be resolved.\n", SOURCE_PATH.deref(), line, column, c.getName());
            }
        }

        @Override
        public Object eval() {
            Object[] argvals = new Object[this.args.count()];
            int i = 0;
            while (i < this.args.count()) {
                argvals[i] = ((Expr)this.args.nth(i)).eval();
                ++i;
            }
            if (this.ctor != null) {
                try {
                    return this.ctor.newInstance(Reflector.boxArgs(this.ctor.getParameterTypes(), argvals));
                }
                catch (Exception e) {
                    throw Util.sneakyThrow(e);
                }
            }
            return Reflector.invokeConstructor(this.c, argvals);
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            String val;
            String canonicalName = Compiler.printClass(this.c);
            if (this.ctor != null) {
                Type type = Compiler.getType(this.c);
                gen.newInstance(type);
                gen.dup();
                String argsList = MethodExpr.emitTypedArgs(objx, gen, this.ctor.getParameterTypes(), this.args);
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                gen.invokeConstructor(type, new clojure.asm.commons.Method("<init>", Type.getConstructorDescriptor(this.ctor)));
                val = "new " + canonicalName + "(" + argsList + ")";
            } else {
                gen.push(Compiler.destubClassName(this.c.getName()));
                gen.invokeStatic(CLASS_TYPE, forNameMethod);
                String argsList = MethodExpr.emitArgsAsArray(this.args, objx, gen);
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                gen.invokeStatic(REFLECTOR_TYPE, invokeConstructorMethod);
                val = "Reflector.invokeConstructor(" + canonicalName + ".class, new Object[]{" + argsList + "})";
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
            return Compiler.wrap(context, val);
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return this.c;
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object frm) {
                int line = Compiler.lineDeref();
                int column = Compiler.columnDeref();
                ISeq form = (ISeq)frm;
                if (form.count() < 2) {
                    throw Util.runtimeException("wrong number of arguments, expecting: (new Classname args...)");
                }
                Class c = HostExpr.maybeClass(RT.second(form), false);
                if (c == null) {
                    throw new IllegalArgumentException("Unable to resolve classname: " + RT.second(form));
                }
                PersistentVector args = PersistentVector.EMPTY;
                ISeq s = RT.next(RT.next(form));
                while (s != null) {
                    args = args.cons(Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, s.first()));
                    s = s.next();
                }
                return new NewExpr(c, args, line, column);
            }
        }
    }

    public static class NewInstanceExpr
    extends ObjExpr {
        IPersistentCollection methods;
        Map<IPersistentVector, Method> mmap;
        Map<IPersistentVector, Set<Class>> covariants;
        private IPersistentVector overrideMethods;

        public NewInstanceExpr(Object tag) {
            super(tag);
        }

        static ObjExpr build(IPersistentVector interfaceSyms, IPersistentVector fieldSyms, Symbol thisSym, String tagName, Symbol className, Symbol typeTag, ISeq methodForms, Object frm) {
            NewInstanceExpr ret = new NewInstanceExpr(null);
            ret.src = frm;
            ret.name = className.toString();
            ret.classMeta = RT.meta(className);
            ret.internalName = ret.name.replace('.', '/');
            ret.objtype = Type.getObjectType(ret.internalName);
            if (thisSym != null) {
                ret.thisName = thisSym.name;
            }
            if (fieldSyms != null) {
                IPersistentMap fmap = PersistentHashMap.EMPTY;
                Object[] closesvec = new Object[2 * fieldSyms.count()];
                int i = 0;
                while (i < fieldSyms.count()) {
                    Symbol sym = (Symbol)fieldSyms.nth(i);
                    if (sym.name.equals("this")) {
                        throw new RuntimeException("A deftype/defrecord field cannot be named 'this'");
                    }
                    LocalBinding lb = new LocalBinding(-1, sym, null, new MethodParamExpr(Compiler.tagClass(Compiler.tagOf(sym))), false, null);
                    fmap = fmap.assoc(sym, lb);
                    closesvec[i * 2] = lb;
                    closesvec[i * 2 + 1] = lb;
                    ++i;
                }
                ret.closes = new PersistentArrayMap(closesvec);
                ret.fields = fmap;
                i = fieldSyms.count() - 1;
                while (i >= 0 && (((Symbol)fieldSyms.nth((int)i)).name.equals("__meta") || ((Symbol)fieldSyms.nth((int)i)).name.equals("__extmap"))) {
                    ret.altCtorDrops = ret.altCtorDrops + 1;
                    --i;
                }
            }
            PersistentVector interfaces = PersistentVector.EMPTY;
            ISeq s = RT.seq(interfaceSyms);
            while (s != null) {
                Class c = (Class)Compiler.resolve((Symbol)s.first());
                if (!c.isInterface()) {
                    throw new IllegalArgumentException("only interfaces are supported, had: " + c.getName());
                }
                interfaces = interfaces.cons(c);
                s = s.next();
            }
            Class<Object> superClass = Object.class;
            Map[] mc = NewInstanceExpr.gatherMethods(superClass, RT.seq(interfaces));
            Map overrideables = mc[0];
            Map covariants = mc[1];
            ret.mmap = overrideables;
            ret.covariants = covariants;
            HashMap allmethods = new HashMap(overrideables);
            String[] inames = NewInstanceExpr.interfaceNames(interfaces);
            Class stub = NewInstanceExpr.compileStub(NewInstanceExpr.slashname(superClass), ret, inames, frm);
            Symbol thistag = Symbol.intern(null, stub.getName());
            try {
                Var.pushThreadBindings(RT.mapUniqueKeys(CONSTANTS, PersistentVector.EMPTY, CONSTANT_IDS, new IdentityHashMap(), KEYWORDS, PersistentHashMap.EMPTY, VARS, PersistentHashMap.EMPTY, KEYWORD_CALLSITES, PersistentVector.EMPTY, PROTOCOL_CALLSITES, PersistentVector.EMPTY, VAR_CALLSITES, Compiler.emptyVarCallSites(), NO_RECUR, null));
                if (ret.isDeftype()) {
                    Var.pushThreadBindings(RT.mapUniqueKeys(METHOD, null, LOCAL_ENV, ret.fields, COMPILE_STUB_SYM, Symbol.intern(null, tagName), COMPILE_STUB_CLASS, stub));
                    ret.hintedFields = RT.subvec(fieldSyms, 0, fieldSyms.count() - ret.altCtorDrops);
                }
                ret.line = Compiler.lineDeref();
                ret.column = Compiler.columnDeref();
                IPersistentCollection methods = null;
                ISeq s2 = methodForms;
                while (s2 != null) {
                    NewInstanceMethod m = NewInstanceMethod.parse(ret, (ISeq)RT.first(s2), thistag, overrideables);
                    methods = RT.conj(methods, m);
                    allmethods.remove(m.mk);
                    s2 = RT.next(s2);
                }
                IPersistentVector overrideMethods = RT.vector(new Object[0]);
                for (Map.Entry ee : allmethods.entrySet()) {
                    Map.Entry e = ee;
                    Method method = (Method)e.getValue();
                    Class<?> dc = method.getDeclaringClass();
                    if (dc.equals(IMeta.class) || dc.equals(IObj.class) || !Modifier.isAbstract(method.getModifiers())) continue;
                    overrideMethods = overrideMethods.cons(method);
                }
                ret.overrideMethods = overrideMethods;
                ret.methods = methods;
                ret.keywords = (IPersistentMap)KEYWORDS.deref();
                ret.vars = (IPersistentMap)VARS.deref();
                ret.constants = (PersistentVector)CONSTANTS.deref();
                ret.constantsID = RT.nextID();
                ret.keywordCallsites = (IPersistentVector)KEYWORD_CALLSITES.deref();
                ret.protocolCallsites = (IPersistentVector)PROTOCOL_CALLSITES.deref();
                ret.varCallsites = (IPersistentSet)VAR_CALLSITES.deref();
            }
            finally {
                if (ret.isDeftype()) {
                    Var.popThreadBindings();
                }
                Var.popThreadBindings();
            }
            try {
                ret.compile(NewInstanceExpr.slashname(superClass), inames, false);
            }
            catch (IOException e) {
                throw Util.sneakyThrow(e);
            }
            ret.getCompiledClass();
            return ret;
        }

        static Class compileStub(String superName, NewInstanceExpr ret, String[] interfaceNames, Object frm) {
            String packageName;
            String className;
            ClassWriter cw;
            ClassWriter cv = cw = new ClassWriter(1);
            Var.pushThreadBindings(RT.mapUniqueKeys(SOURCE_WRITER, cw.getSc()));
            cv.visit(49, 33, "compile__stub/" + ret.internalName, null, superName, interfaceNames);
            int lastSlash = ret.internalName.lastIndexOf(47);
            if (lastSlash != -1) {
                className = ret.internalName.substring(lastSlash + 1);
                packageName = ret.internalName.substring(0, lastSlash).replaceAll("/", ".");
            } else {
                packageName = "";
                className = ret.internalName;
            }
            packageName = "compile__stub." + packageName;
            Compiler.emitSource("package " + packageName + ";");
            Compiler.emitSource();
            Compiler.emitSource("import clojure.lang.*;");
            Compiler.emitSource();
            StringBuilder sb = new StringBuilder();
            String[] stringArray = interfaceNames;
            int n = interfaceNames.length;
            int n2 = 0;
            while (n2 < n) {
                String i = stringArray[n2];
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(i.replaceAll("/", "."));
                ++n2;
            }
            Compiler.emitSource("public class " + className + " extends " + superName.replaceAll("/", ".") + (sb.length() > 0 ? " implements " + sb.toString() : "") + " {");
            Compiler.tab();
            ISeq s = RT.keys(ret.closes);
            while (s != null) {
                String modif;
                LocalBinding lb = (LocalBinding)s.first();
                int access = 1 + (ret.isVolatile(lb) ? 64 : (ret.isMutable(lb) ? 0 : 16));
                String string = ret.isVolatile(lb) ? "volatile " : (modif = ret.isMutable(lb) ? "" : "final ");
                if (lb.getPrimitiveType() != null) {
                    cv.visitField(access, lb.name, Type.getType(lb.getPrimitiveType()).getDescriptor(), null, null);
                    Compiler.emitSource(String.valueOf(modif) + Compiler.printClass(lb.getPrimitiveType()) + " " + lb.print() + ";");
                } else {
                    cv.visitField(access, lb.name, OBJECT_TYPE.getDescriptor(), null, null);
                    Compiler.emitSource(String.valueOf(modif) + "Object " + lb.print() + ";");
                }
                s = s.next();
            }
            clojure.asm.commons.Method m = new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, ret.ctorTypes());
            GeneratorAdapter ctorgen = new GeneratorAdapter(1, m, null, null, cv);
            StringBuilder cparams = new StringBuilder();
            StringBuilder sparams = new StringBuilder();
            int n3 = 0;
            Type[] typeArray = ret.ctorTypes();
            int n4 = typeArray.length;
            int n5 = 0;
            while (n5 < n4) {
                Type t = typeArray[n5];
                if (cparams.length() > 0) {
                    cparams.append(", ");
                    sparams.append(", ");
                }
                cparams.append(String.valueOf(Compiler.printClass(t)) + " p" + n3);
                sparams.append("p" + n3);
                ++n3;
                ++n5;
            }
            Compiler.emitSource("public " + className + "(" + cparams + ") {");
            Compiler.tab();
            ctorgen.visitCode();
            ctorgen.loadThis();
            ctorgen.invokeConstructor(Type.getObjectType(superName), voidctor);
            Compiler.emitSource("super(" + sparams + ");");
            ctorgen.returnValue();
            ctorgen.endMethod();
            Compiler.untab();
            Compiler.emitSource("}");
            if (ret.altCtorDrops > 0) {
                Type[] ctorTypes = ret.ctorTypes();
                Type[] altCtorTypes = new Type[ctorTypes.length - ret.altCtorDrops];
                int i = 0;
                while (i < altCtorTypes.length) {
                    altCtorTypes[i] = ctorTypes[i];
                    ++i;
                }
                clojure.asm.commons.Method alt = new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, altCtorTypes);
                cparams = new StringBuilder();
                sparams = new StringBuilder();
                n3 = 0;
                Type[] typeArray2 = altCtorTypes;
                int n6 = altCtorTypes.length;
                int n7 = 0;
                while (n7 < n6) {
                    Type t = typeArray2[n7];
                    if (cparams.length() > 0) {
                        cparams.append(", ");
                        sparams.append(", ");
                    }
                    cparams.append(String.valueOf(Compiler.printClass(t)) + " p" + n3);
                    sparams.append("p" + n3);
                    ++n3;
                    ++n7;
                }
                Compiler.emitSource("public " + className + "(" + cparams + ") {");
                Compiler.tab();
                Compiler.emitSource("super(" + sparams + ");");
                Compiler.untab();
                Compiler.emitSource("}");
                ctorgen = new GeneratorAdapter(1, alt, null, null, cv);
                ctorgen.visitCode();
                ctorgen.loadThis();
                ctorgen.loadArgs();
                int i2 = 0;
                while (i2 < ret.altCtorDrops) {
                    ctorgen.visitInsn(1);
                    ++i2;
                }
                ctorgen.invokeConstructor(Type.getObjectType("compile__stub/" + ret.internalName), new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, ctorTypes));
                ctorgen.returnValue();
                ctorgen.endMethod();
            }
            cv.visitEnd();
            byte[] bytecode = cw.toByteArray();
            DynamicClassLoader loader = (DynamicClassLoader)LOADER.deref();
            Compiler.untab();
            Compiler.emitSource("}");
            Var.popThreadBindings();
            return loader.defineClass("compile__stub." + ret.name, bytecode, frm);
        }

        static String[] interfaceNames(IPersistentVector interfaces) {
            int icnt = interfaces.count();
            String[] inames = icnt > 0 ? new String[icnt] : null;
            int i = 0;
            while (i < icnt) {
                inames[i] = NewInstanceExpr.slashname((Class)interfaces.nth(i));
                ++i;
            }
            return inames;
        }

        static String slashname(Class c) {
            return c.getName().replace('.', '/');
        }

        @Override
        protected void emitStatics(ClassVisitor cv) {
            if (this.isDeftype()) {
                clojure.asm.commons.Method meth = clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentVector getBasis()");
                GeneratorAdapter gen = new GeneratorAdapter(9, meth, null, null, cv);
                Compiler.emitSource("public static clojure.lang.IPersistentVector getBasis() {");
                Compiler.tab();
                Compiler.emitSource("return " + this.emitValue(this.hintedFields, gen) + ";");
                Compiler.untab();
                Compiler.emitSource("}");
                gen.returnValue();
                gen.endMethod();
                if (this.fields.count() > this.hintedFields.count()) {
                    String className = this.name.replace('.', '/');
                    int i = 1;
                    int fieldCount = this.hintedFields.count();
                    MethodVisitor mv = cv.visitMethod(9, "create", "(Lclojure/lang/IPersistentMap;)L" + className + ";", null, null);
                    mv.visitCode();
                    Compiler.emitSource("public static " + Compiler.printClass(this.name) + " create(IPersistentMap map) {");
                    Compiler.tab();
                    StringBuilder sb = new StringBuilder();
                    StringBuilder others = new StringBuilder();
                    ISeq s = RT.seq(this.hintedFields);
                    while (s != null) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        String bName = ((Symbol)s.first()).name;
                        Class k = Compiler.tagClass(Compiler.tagOf(s.first()));
                        others.append(".without(Keyword.intern(\"" + bName + "\"))");
                        String val = "map.valAt(Keyword.intern(\"" + bName + "\"), null)";
                        if (k.isPrimitive()) {
                            sb.append("(" + Compiler.printClass(Compiler.boxClass(k)) + ")" + val);
                        } else {
                            sb.append(val);
                        }
                        mv.visitVarInsn(25, 0);
                        mv.visitLdcInsn(bName);
                        mv.visitMethodInsn(184, "clojure/lang/Keyword", "intern", "(Ljava/lang/String;)Lclojure/lang/Keyword;");
                        mv.visitInsn(1);
                        mv.visitMethodInsn(185, "clojure/lang/IPersistentMap", "valAt", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        if (k.isPrimitive()) {
                            mv.visitTypeInsn(192, Type.getType(Compiler.boxClass(k)).getInternalName());
                        }
                        mv.visitVarInsn(58, i);
                        mv.visitVarInsn(25, 0);
                        mv.visitLdcInsn(bName);
                        mv.visitMethodInsn(184, "clojure/lang/Keyword", "intern", "(Ljava/lang/String;)Lclojure/lang/Keyword;");
                        mv.visitMethodInsn(185, "clojure/lang/IPersistentMap", "without", "(Ljava/lang/Object;)Lclojure/lang/IPersistentMap;");
                        mv.visitVarInsn(58, 0);
                        s = s.next();
                        ++i;
                    }
                    mv.visitTypeInsn(187, className);
                    mv.visitInsn(89);
                    clojure.asm.commons.Method ctor = new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, this.ctorTypes());
                    if (this.hintedFields.count() > 0) {
                        i = 1;
                        while (i <= fieldCount) {
                            mv.visitVarInsn(25, i);
                            Class k = Compiler.tagClass(Compiler.tagOf(this.hintedFields.nth(i - 1)));
                            if (k.isPrimitive()) {
                                String b = Type.getType(Compiler.boxClass(k)).getInternalName();
                                String p = Type.getType(k).getDescriptor();
                                String n = k.getName();
                                mv.visitMethodInsn(182, b, String.valueOf(n) + "Value", "()" + p);
                            }
                            ++i;
                        }
                    }
                    Compiler.emitSource("return new " + Compiler.printClass(this.name) + "(" + sb + (sb.length() > 0 ? ", " : "") + "null, RT.seqOrElse(map" + others + "));");
                    mv.visitInsn(1);
                    mv.visitVarInsn(25, 0);
                    mv.visitMethodInsn(184, "clojure/lang/RT", "seqOrElse", "(Ljava/lang/Object;)Ljava/lang/Object;");
                    mv.visitMethodInsn(183, className, "<init>", ctor.getDescriptor());
                    mv.visitInsn(176);
                    mv.visitMaxs(4 + fieldCount, 1 + fieldCount);
                    mv.visitEnd();
                    Compiler.untab();
                    Compiler.emitSource("}");
                }
            }
        }

        @Override
        protected void emitMethods(ClassVisitor cv) {
            ISeq s = RT.seq(this.methods);
            while (s != null) {
                ObjMethod method = (ObjMethod)s.first();
                method.emit(this, cv);
                s = s.next();
            }
            ISeq i = this.overrideMethods.seq();
            while (i != null) {
                Method m = (Method)i.first();
                StringBuilder sb = new StringBuilder();
                int n = 0;
                Class<?>[] classArray = m.getParameterTypes();
                int n2 = classArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Class<?> p = classArray[n3];
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(String.valueOf(Compiler.printClass(p)) + " p" + n);
                    ++n;
                    ++n3;
                }
                StringBuilder exs = new StringBuilder();
                Class<?>[] classArray2 = m.getExceptionTypes();
                int n4 = classArray2.length;
                n2 = 0;
                while (n2 < n4) {
                    Class<?> e = classArray2[n2];
                    if (exs.length() > 0) {
                        exs.append(", ");
                    }
                    exs.append(Compiler.printClass(e));
                    ++n2;
                }
                Compiler.emitSource("public " + Compiler.printClass(m.getReturnType()) + " " + m.getName() + "(" + sb + ") " + (exs.length() > 0 ? "throws " : "") + exs + " {");
                Compiler.tab();
                Compiler.emitSource("throw new RuntimeException(\"Reify non implemented method\");");
                Compiler.untab();
                Compiler.emitSource("}");
                i = i.next();
            }
            for (Map.Entry<IPersistentVector, Set<Class>> e : this.covariants.entrySet()) {
                Method m = this.mmap.get(e.getKey());
                Class<?>[] params = m.getParameterTypes();
                Type[] argTypes = new Type[params.length];
                int i2 = 0;
                while (i2 < params.length) {
                    argTypes[i2] = Type.getType(params[i2]);
                    ++i2;
                }
                clojure.asm.commons.Method target = new clojure.asm.commons.Method(m.getName(), Type.getType(m.getReturnType()), argTypes);
                for (Class retType : e.getValue()) {
                    clojure.asm.commons.Method meth = new clojure.asm.commons.Method(m.getName(), Type.getType(retType), argTypes);
                    GeneratorAdapter gen = new GeneratorAdapter(65, meth, null, EXCEPTION_TYPES, cv);
                    gen.visitCode();
                    gen.loadThis();
                    gen.loadArgs();
                    gen.invokeInterface(Type.getType(m.getDeclaringClass()), target);
                    gen.returnValue();
                    gen.endMethod();
                }
            }
        }

        public static IPersistentVector msig(Method m) {
            return RT.vector(m.getName(), RT.seq(m.getParameterTypes()), m.getReturnType());
        }

        static void considerMethod(Method m, Map mm) {
            IPersistentVector mk = NewInstanceExpr.msig(m);
            int mods = m.getModifiers();
            if (!(mm.containsKey(mk) || !Modifier.isPublic(mods) && !Modifier.isProtected(mods) || Modifier.isStatic(mods) || Modifier.isFinal(mods))) {
                mm.put(mk, m);
            }
        }

        static void gatherMethods(Class c, Map mm) {
            while (c != null) {
                Method m;
                Method[] methodArray = c.getDeclaredMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    m = methodArray[n2];
                    NewInstanceExpr.considerMethod(m, mm);
                    ++n2;
                }
                methodArray = c.getMethods();
                n = methodArray.length;
                n2 = 0;
                while (n2 < n) {
                    m = methodArray[n2];
                    NewInstanceExpr.considerMethod(m, mm);
                    ++n2;
                }
                c = c.getSuperclass();
            }
        }

        public static Map[] gatherMethods(Class sc, ISeq interfaces) {
            HashMap allm = new HashMap();
            NewInstanceExpr.gatherMethods(sc, allm);
            while (interfaces != null) {
                NewInstanceExpr.gatherMethods((Class)interfaces.first(), allm);
                interfaces = interfaces.next();
            }
            HashMap<IPersistentVector, Method> mm = new HashMap<IPersistentVector, Method>();
            HashMap covariants = new HashMap();
            Iterator iterator = allm.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry e = o = iterator.next();
                IPersistentVector mk = (IPersistentVector)e.getKey();
                mk = (IPersistentVector)mk.pop();
                Method m = (Method)e.getValue();
                if (mm.containsKey(mk)) {
                    Method om;
                    HashSet cvs = (HashSet)covariants.get(mk);
                    if (cvs == null) {
                        cvs = new HashSet();
                        covariants.put(mk, cvs);
                    }
                    if ((om = (Method)mm.get(mk)).getReturnType().isAssignableFrom(m.getReturnType())) {
                        cvs.add(om.getReturnType());
                        mm.put(mk, m);
                        continue;
                    }
                    cvs.add(m.getReturnType());
                    continue;
                }
                mm.put(mk, m);
            }
            return new Map[]{mm, covariants};
        }

        static class DeftypeParser
        implements IParser {
            DeftypeParser() {
            }

            @Override
            public Expr parse(C context, Object frm) {
                ISeq rform = (ISeq)frm;
                rform = RT.next(rform);
                String tagname = ((Symbol)rform.first()).toString();
                rform = rform.next();
                Symbol classname = (Symbol)rform.first();
                rform = rform.next();
                IPersistentVector fields = (IPersistentVector)rform.first();
                rform = rform.next();
                IPersistentMap opts = PersistentHashMap.EMPTY;
                while (rform != null && rform.first() instanceof Keyword) {
                    opts = opts.assoc(rform.first(), RT.second(rform));
                    rform = rform.next().next();
                }
                ObjExpr ret = NewInstanceExpr.build((IPersistentVector)RT.get(opts, implementsKey, PersistentVector.EMPTY), fields, null, tagname, classname, (Symbol)RT.get(opts, RT.TAG_KEY), rform, frm);
                return ret;
            }
        }

        static class ReifyParser
        implements IParser {
            ReifyParser() {
            }

            @Override
            public Expr parse(C context, Object frm) {
                ISeq form = (ISeq)frm;
                ObjMethod enclosingMethod = (ObjMethod)METHOD.deref();
                String basename = enclosingMethod != null ? String.valueOf(NewInstanceExpr.trimGenID(enclosingMethod.objx.name)) + Compiler.DOLLAR : String.valueOf(Compiler.munge(Compiler.currentNS().name.name)) + Compiler.DOLLAR;
                String simpleName = "reify__" + RT.nextID();
                String classname = String.valueOf(basename) + simpleName;
                ISeq rform = RT.next(form);
                IPersistentVector interfaces = ((IPersistentVector)RT.first(rform)).cons(Symbol.intern("clojure.lang.IObj"));
                rform = RT.next(rform);
                ObjExpr ret = NewInstanceExpr.build(interfaces, null, null, classname, Symbol.intern(classname), null, rform, frm);
                if (frm instanceof IObj && ((IObj)frm).meta() != null) {
                    return new MetaExpr(ret, MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)frm).meta()));
                }
                return ret;
            }
        }
    }

    public static class NewInstanceMethod
    extends ObjMethod {
        String name;
        Type[] argTypes;
        Type retType;
        Class retClass;
        Class[] exclasses;
        static Symbol dummyThis = Symbol.intern(null, "dummy_this_dlskjsdfower");
        private IPersistentVector parms;
        private Symbol thisName;
        private Object mk;

        public NewInstanceMethod(ObjExpr objx, ObjMethod parent) {
            super(objx, parent);
        }

        @Override
        int numParams() {
            return this.argLocals.count();
        }

        @Override
        String getMethodName() {
            return this.name;
        }

        @Override
        Type getReturnType() {
            return this.retType;
        }

        @Override
        Type[] getArgTypes() {
            return this.argTypes;
        }

        public static IPersistentVector msig(String name, Class[] paramTypes) {
            return RT.vector(name, RT.seq(paramTypes));
        }

        static NewInstanceMethod parse(ObjExpr objx, ISeq form, Symbol thistag, Map overrideables) {
            NewInstanceMethod method = new NewInstanceMethod(objx, (ObjMethod)METHOD.deref());
            Symbol dotname = (Symbol)RT.first(form);
            Symbol name = (Symbol)Symbol.intern(null, Compiler.munge(dotname.name)).withMeta(RT.meta(dotname));
            IPersistentVector parms = (IPersistentVector)RT.second(form);
            if (parms.count() == 0) {
                throw new IllegalArgumentException("Must supply at least one argument for 'this' in: " + dotname);
            }
            Symbol thisName = (Symbol)parms.nth(0);
            parms = RT.subvec(parms, 1, parms.count());
            ISeq body = RT.next(RT.next(form));
            try {
                method.line = Compiler.lineDeref();
                method.column = Compiler.columnDeref();
                PathNode pnode = new PathNode(PATHTYPE.PATH, (PathNode)CLEAR_PATH.get());
                Var.pushThreadBindings(RT.mapUniqueKeys(METHOD, method, LOCAL_ENV, LOCAL_ENV.deref(), LOOP_LOCALS, null, NEXT_LOCAL_NUM, 0, CLEAR_PATH, pnode, CLEAR_ROOT, pnode, CLEAR_SITES, PersistentHashMap.EMPTY));
                if (thisName != null) {
                    Compiler.registerLocal(thisName == null ? NewInstanceMethod.dummyThis : thisName, thistag, null, false);
                } else {
                    Compiler.getAndIncLocalNum();
                }
                PersistentVector argLocals = PersistentVector.EMPTY;
                method.thisName = thisName;
                method.retClass = Compiler.tagClass(Compiler.tagOf(name));
                method.argTypes = new Type[parms.count()];
                boolean hinted = Compiler.tagOf(name) != null;
                Class[] pclasses = new Class[parms.count()];
                Symbol[] psyms = new Symbol[parms.count()];
                int i = 0;
                while (i < parms.count()) {
                    Class pclass;
                    if (!(parms.nth(i) instanceof Symbol)) {
                        throw new IllegalArgumentException("params must be Symbols");
                    }
                    Symbol p = (Symbol)parms.nth(i);
                    Symbol tag = Compiler.tagOf(p);
                    if (tag != null) {
                        hinted = true;
                    }
                    if (p.getNamespace() != null) {
                        p = Symbol.intern(p.name);
                    }
                    pclasses[i] = pclass = Compiler.tagClass(tag);
                    psyms[i] = p;
                    ++i;
                }
                Map matches = NewInstanceMethod.findMethodsWithNameAndArity(name.name, parms.count(), overrideables);
                IPersistentVector mk = NewInstanceMethod.msig(name.name, pclasses);
                Method m = null;
                if (matches.size() > 0) {
                    if (matches.size() > 1) {
                        if (!hinted) {
                            throw new IllegalArgumentException("Must hint overloaded method: " + name.name);
                        }
                        m = (Method)matches.get(mk);
                        if (m == null) {
                            throw new IllegalArgumentException("Can't find matching overloaded method: " + name.name);
                        }
                        if (m.getReturnType() != method.retClass) {
                            throw new IllegalArgumentException("Mismatched return type: " + name.name + ", expected: " + m.getReturnType().getName() + ", had: " + method.retClass.getName());
                        }
                    } else if (hinted) {
                        m = (Method)matches.get(mk);
                        if (m == null) {
                            throw new IllegalArgumentException("Can't find matching method: " + name.name + ", leave off hints for auto match.");
                        }
                        if (m.getReturnType() != method.retClass) {
                            throw new IllegalArgumentException("Mismatched return type: " + name.name + ", expected: " + m.getReturnType().getName() + ", had: " + method.retClass.getName());
                        }
                    } else {
                        m = (Method)matches.values().iterator().next();
                        method.retClass = m.getReturnType();
                        pclasses = m.getParameterTypes();
                    }
                } else {
                    throw new IllegalArgumentException("Can't define method not in interfaces: " + name.name);
                }
                IPersistentVector types = RT.vector(new Object[0]);
                Class<?>[] classArray = m.getParameterTypes();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> t = classArray[n2];
                    types = types.cons(t);
                    ++n2;
                }
                method.mk = RT.vector(m.getName(), types.seq());
                method.retType = Type.getType(method.retClass);
                method.exclasses = m.getExceptionTypes();
                int i2 = 0;
                while (i2 < parms.count()) {
                    LocalBinding lb = Compiler.registerLocal(psyms[i2], null, new MethodParamExpr(pclasses[i2]), true);
                    argLocals = argLocals.assocN(i2, lb);
                    method.argTypes[i2] = Type.getType(pclasses[i2]);
                    ++i2;
                }
                i2 = 0;
                while (i2 < parms.count()) {
                    if (pclasses[i2] == Long.TYPE || pclasses[i2] == Double.TYPE) {
                        Compiler.getAndIncLocalNum();
                    }
                    ++i2;
                }
                LOOP_LOCALS.set(argLocals);
                method.name = name.name;
                method.methodMeta = RT.meta(name);
                method.parms = parms;
                method.argLocals = argLocals;
                method.body = new BodyExpr.Parser().parse(C.RETURN, body);
                NewInstanceMethod newInstanceMethod = method;
                return newInstanceMethod;
            }
            finally {
                Var.popThreadBindings();
            }
        }

        private static Map findMethodsWithNameAndArity(String name, int arity, Map mm) {
            HashMap ret = new HashMap();
            for (Map.Entry o : mm.entrySet()) {
                Map.Entry e = o;
                Method m = (Method)e.getValue();
                if (!name.equals(m.getName()) || m.getParameterTypes().length != arity) continue;
                ret.put(e.getKey(), e.getValue());
            }
            return ret;
        }

        @Override
        public void emit(ObjExpr obj, ClassVisitor cv) {
            clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.getMethodName(), this.getReturnType(), this.getArgTypes());
            StringBuilder params = new StringBuilder();
            int pos = 0;
            ISeq lbs = this.argLocals.seq();
            while (lbs != null) {
                LocalBinding lb = (LocalBinding)lbs.first();
                if (params.length() > 0) {
                    params.append(", ");
                }
                params.append(String.valueOf(Compiler.printClass(this.getArgTypes()[pos])) + " " + lb.print());
                ++pos;
                lbs = lbs.next();
            }
            Type[] extypes = null;
            StringBuilder exs = null;
            if (this.exclasses.length > 0) {
                exs = new StringBuilder();
                extypes = new Type[this.exclasses.length];
                int i = 0;
                while (i < this.exclasses.length) {
                    if (exs.length() > 0) {
                        exs.append(", ");
                    }
                    extypes[i] = Type.getType(this.exclasses[i]);
                    exs.append(Compiler.printClass(this.exclasses[i]));
                    ++i;
                }
            }
            GeneratorAdapter gen = new GeneratorAdapter(1, m, null, extypes, cv);
            Compiler.addAnnotation(gen, this.methodMeta);
            Compiler.emitSource("public " + Compiler.printClass(this.getReturnType()) + " " + this.getMethodName() + "(" + params + ") " + (this.exclasses.length > 0 ? "throws " + exs.toString() : "") + " {");
            Compiler.tab();
            if (this.hasException) {
                Compiler.emitSource("try {");
                Compiler.tab();
            }
            if (this.hasRecur) {
                Compiler.emitSource("while(true) {");
                Compiler.tab();
            }
            int i = 0;
            while (i < this.parms.count()) {
                IPersistentMap meta = RT.meta(this.parms.nth(i));
                Compiler.addParameterAnnotation(gen, meta, i);
                ++i;
            }
            gen.visitCode();
            Label loopLabel = gen.mark();
            gen.visitLineNumber(this.line, loopLabel);
            try {
                try {
                    Var.pushThreadBindings(RT.map(LOOP_LABEL, loopLabel, METHOD, this));
                    String b = NewInstanceMethod.emitBody(this.objx, gen, this.retClass, this.body);
                    if (b != null) {
                        Compiler.emitSource(b);
                    }
                    Label end = gen.mark();
                    gen.visitLocalVariable("this", obj.objtype.getDescriptor(), null, loopLabel, end, 0);
                    ISeq lbs2 = this.argLocals.seq();
                    while (lbs2 != null) {
                        LocalBinding lb = (LocalBinding)lbs2.first();
                        gen.visitLocalVariable(lb.name, this.argTypes[lb.idx - 1].getDescriptor(), null, loopLabel, end, lb.idx);
                        lbs2 = lbs2.next();
                    }
                }
                catch (Exception e) {
                    throw Util.sneakyThrow(e);
                }
            }
            finally {
                Var.popThreadBindings();
            }
            gen.returnValue();
            gen.endMethod();
            if (this.hasRecur) {
                Compiler.untab();
                Compiler.emitSource("}");
            }
            if (this.hasException) {
                Compiler.untab();
                Compiler.emitSource("} catch (Exception ___e) {");
                Compiler.tab();
                Compiler.emitSource("throw Util.sneakyThrow(___e);");
                Compiler.untab();
                Compiler.emitSource("}");
            }
            Compiler.untab();
            Compiler.emitSource("}");
        }
    }

    static class NilExpr
    extends LiteralExpr {
        NilExpr() {
        }

        @Override
        Object val() {
            return null;
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitInsn(1);
            if (context == C.STATEMENT) {
                gen.pop();
                return "";
            }
            return Compiler.wrap(context, "null");
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return null;
        }
    }

    static class NumberExpr
    extends LiteralExpr
    implements MaybePrimitiveExpr {
        final Number n;
        public final int id;

        public NumberExpr(Number n) {
            this.n = n;
            this.id = Compiler.registerConstant(n);
        }

        @Override
        Object val() {
            return this.n;
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (context != C.STATEMENT) {
                return Compiler.wrap(context, objx.emitConstant(gen, this.id));
            }
            return "";
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            if (this.n instanceof Integer) {
                return Long.TYPE;
            }
            if (this.n instanceof Double) {
                return Double.TYPE;
            }
            if (this.n instanceof Long) {
                return Long.TYPE;
            }
            throw new IllegalStateException("Unsupported Number type: " + this.n.getClass().getName());
        }

        @Override
        public boolean canEmitPrimitive() {
            return true;
        }

        @Override
        public String emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (this.n instanceof Integer) {
                gen.push(this.n.longValue());
                return Compiler.wrap(context, String.valueOf(this.n.longValue()));
            }
            if (this.n instanceof Double) {
                gen.push(this.n.doubleValue());
                return Compiler.wrap(context, String.valueOf(this.n.doubleValue()));
            }
            if (this.n instanceof Long) {
                gen.push(this.n.longValue());
                return Compiler.wrap(context, String.valueOf(String.valueOf(this.n.longValue())) + "L");
            }
            throw new RuntimeException();
        }

        public static Expr parse(Number form) {
            if (form instanceof Integer || form instanceof Double || form instanceof Long) {
                return new NumberExpr(form);
            }
            return new ConstantExpr(form);
        }
    }

    public static class ObjExpr
    implements Expr {
        static final String CONST_PREFIX = "const__";
        String name;
        String internalName;
        String thisName;
        Type objtype;
        public final Object tag;
        IPersistentMap closes = PersistentHashMap.EMPTY;
        IPersistentVector closesExprs = PersistentVector.EMPTY;
        IPersistentSet volatiles = PersistentHashSet.EMPTY;
        IPersistentMap fields = null;
        IPersistentVector hintedFields = PersistentVector.EMPTY;
        IPersistentMap keywords = PersistentHashMap.EMPTY;
        IPersistentMap vars = PersistentHashMap.EMPTY;
        Class compiledClass;
        int line;
        int column;
        PersistentVector constants;
        int constantsID;
        int altCtorDrops = 0;
        IPersistentVector keywordCallsites;
        IPersistentVector protocolCallsites;
        IPersistentSet varCallsites;
        boolean onceOnly = false;
        Object src;
        static final clojure.asm.commons.Method voidctor = clojure.asm.commons.Method.getMethod("void <init>()");
        protected IPersistentMap classMeta;
        protected boolean isStatic;
        static final clojure.asm.commons.Method kwintern = clojure.asm.commons.Method.getMethod("clojure.lang.Keyword intern(String, String)");
        static final clojure.asm.commons.Method symintern = clojure.asm.commons.Method.getMethod("clojure.lang.Symbol intern(String)");
        static final clojure.asm.commons.Method varintern = clojure.asm.commons.Method.getMethod("clojure.lang.Var intern(clojure.lang.Symbol, clojure.lang.Symbol)");
        static final Type DYNAMIC_CLASSLOADER_TYPE = Type.getType(DynamicClassLoader.class);
        static final clojure.asm.commons.Method getClassMethod = clojure.asm.commons.Method.getMethod("Class getClass()");
        static final clojure.asm.commons.Method getClassLoaderMethod = clojure.asm.commons.Method.getMethod("ClassLoader getClassLoader()");
        static final clojure.asm.commons.Method getConstantsMethod = clojure.asm.commons.Method.getMethod("Object[] getConstants(int)");
        static final clojure.asm.commons.Method readStringMethod = clojure.asm.commons.Method.getMethod("Object readString(String)");
        static final Type ILOOKUP_SITE_TYPE = Type.getType(ILookupSite.class);
        static final Type ILOOKUP_THUNK_TYPE = Type.getType(ILookupThunk.class);
        static final Type KEYWORD_LOOKUPSITE_TYPE = Type.getType(KeywordLookupSite.class);
        private DynamicClassLoader loader;
        private byte[] bytecode;
        static final clojure.asm.commons.Method varGetMethod = clojure.asm.commons.Method.getMethod("Object get()");
        static final clojure.asm.commons.Method varGetRawMethod = clojure.asm.commons.Method.getMethod("Object getRawRoot()");

        public final String name() {
            return this.name;
        }

        public final String internalName() {
            return this.internalName;
        }

        public final String thisName() {
            return this.thisName;
        }

        public final Type objtype() {
            return this.objtype;
        }

        public final IPersistentMap closes() {
            return this.closes;
        }

        public final IPersistentMap keywords() {
            return this.keywords;
        }

        public final IPersistentMap vars() {
            return this.vars;
        }

        public final Class compiledClass() {
            return this.compiledClass;
        }

        public final int line() {
            return this.line;
        }

        public final int column() {
            return this.column;
        }

        public final PersistentVector constants() {
            return this.constants;
        }

        public final int constantsID() {
            return this.constantsID;
        }

        public ObjExpr(Object tag) {
            this.tag = tag;
        }

        static String trimGenID(String name) {
            int i = name.lastIndexOf("__");
            return i == -1 ? name : name.substring(0, i);
        }

        Type[] ctorTypes() {
            IPersistentVector tv = !this.supportsMeta() ? PersistentVector.EMPTY : RT.vector(IPERSISTENTMAP_TYPE);
            ISeq s = RT.keys(this.closes);
            while (s != null) {
                LocalBinding lb = (LocalBinding)s.first();
                tv = lb.getPrimitiveType() != null ? tv.cons(Type.getType(lb.getPrimitiveType())) : tv.cons(OBJECT_TYPE);
                s = s.next();
            }
            Type[] ret = new Type[tv.count()];
            int i = 0;
            while (i < tv.count()) {
                ret[i] = (Type)tv.nth(i);
                ++i;
            }
            return ret;
        }

        void compile(String superName, String[] interfaceNames, boolean oneTimeUse) throws IOException {
            clojure.asm.commons.Method alt;
            StringBuilder params;
            Type[] ctorTypes;
            String packageName;
            String className;
            ClassWriter cw;
            ClassWriter cv = cw = new ClassWriter(1);
            Var.pushThreadBindings(RT.mapUniqueKeys(SOURCE_WRITER, cw.getSc()));
            int lastSlash = this.internalName.lastIndexOf(47);
            if (lastSlash != -1) {
                className = this.internalName.substring(lastSlash + 1);
                packageName = this.internalName.substring(0, lastSlash).replaceAll("/", ".");
            } else {
                packageName = "";
                className = this.internalName;
            }
            className = className.replaceAll("-", Compiler.DOLLAR);
            Compiler.emitSource("package " + packageName + ";");
            Compiler.emitSource();
            Compiler.emitSource("import clojure.lang.*;");
            Compiler.emitSource();
            StringBuilder interfaces = new StringBuilder();
            if (interfaceNames != null) {
                String[] stringArray = interfaceNames;
                int n = interfaceNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String in = stringArray[n2];
                    if (interfaces.length() > 0) {
                        interfaces.append(", ");
                    }
                    interfaces.append(in.replaceAll("/", ".").replaceAll("\\$", "."));
                    ++n2;
                }
            }
            cv.visit(49, 49, this.internalName, null, superName, interfaceNames);
            String source = (String)SOURCE.deref();
            int lineBefore = (Integer)LINE_BEFORE.deref();
            int lineAfter = (Integer)LINE_AFTER.deref() + 1;
            int columnBefore = (Integer)COLUMN_BEFORE.deref();
            int columnAfter = (Integer)COLUMN_AFTER.deref() + 1;
            if (source != null && SOURCE_PATH.deref() != null) {
                String smap = "SMAP\n" + (source.lastIndexOf(46) > 0 ? source.substring(0, source.lastIndexOf(46)) : source) + ".java\n" + "Clojure\n" + "*S Clojure\n" + "*F\n" + "+ 1 " + source + "\n" + (String)SOURCE_PATH.deref() + "\n" + "*L\n" + String.format("%d#1,%d:%d\n", lineBefore, lineAfter - lineBefore, lineBefore) + "*E";
                cv.visitSource(source, smap);
            }
            Compiler.addAnnotation(cv, this.classMeta);
            Compiler.emitSource("public final class " + className + " extends " + superName.replaceAll("/", ".") + (interfaces.length() > 0 ? " implements " : "") + interfaces + " {");
            Compiler.tab();
            int i = 0;
            while (i < this.constants.count()) {
                Compiler.emitSource("public static final " + Compiler.printClass(this.constantType(i)) + " " + this.constantName(i) + ";");
                cv.visitField(25, this.constantName(i), this.constantType(i).getDescriptor(), null, null);
                ++i;
            }
            i = 0;
            while (i < this.keywordCallsites.count()) {
                cv.visitField(24, this.siteNameStatic(i), KEYWORD_LOOKUPSITE_TYPE.getDescriptor(), null, null);
                cv.visitField(8, this.thunkNameStatic(i), ILOOKUP_THUNK_TYPE.getDescriptor(), null, null);
                ++i;
            }
            Compiler.emitSource("static {");
            Compiler.tab();
            GeneratorAdapter clinitgen = new GeneratorAdapter(9, clojure.asm.commons.Method.getMethod("void <clinit> ()"), null, null, cv);
            clinitgen.visitCode();
            clinitgen.visitLineNumber(this.line, clinitgen.mark());
            if (this.constants.count() > 0) {
                this.emitConstants(clinitgen);
            }
            if (this.keywordCallsites.count() > 0) {
                this.emitKeywordCallsites(clinitgen);
            }
            clinitgen.returnValue();
            clinitgen.endMethod();
            Compiler.untab();
            Compiler.emitSource("}");
            StringBuilder sb = new StringBuilder();
            if (this.supportsMeta()) {
                Compiler.emitSource("final " + IPERSISTENTMAP_TYPE.getClassName() + " __meta;");
                cv.visitField(16, "__meta", IPERSISTENTMAP_TYPE.getDescriptor(), null, null);
                sb.append("final " + IPERSISTENTMAP_TYPE.getClassName() + " __meta");
            }
            ISeq s = RT.keys(this.closes);
            while (s != null) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                LocalBinding lb = (LocalBinding)s.first();
                if (this.isDeftype()) {
                    int access = this.isVolatile(lb) ? 64 : (this.isMutable(lb) ? 0 : 17);
                    FieldVisitor fv = lb.getPrimitiveType() != null ? cv.visitField(access, lb.name, Type.getType(lb.getPrimitiveType()).getDescriptor(), null, null) : cv.visitField(access, lb.name, OBJECT_TYPE.getDescriptor(), null, null);
                    String type = lb.getPrimitiveType() != null ? Compiler.printClass(lb.getPrimitiveType()) : "Object";
                    sb.append("final ").append(type).append(" ").append(lb.print());
                    Compiler.addAnnotation(fv, RT.meta(lb.sym));
                    Compiler.emitSource("public " + (this.isVolatile(lb) ? "volatile" : "") + " " + (this.isMutable(lb) ? "" : "final") + " " + type + " " + lb.print() + ";");
                } else if (lb.getPrimitiveType() != null) {
                    cv.visitField(0 + (this.isVolatile(lb) ? 64 : 0), lb.name, Type.getType(lb.getPrimitiveType()).getDescriptor(), null, null);
                    Compiler.emitSource(String.valueOf(this.isVolatile(lb) ? "volatile " : "") + Compiler.printClass(lb.getPrimitiveType()) + " " + lb.print() + ";");
                    sb.append("final " + Compiler.printClass(lb.getPrimitiveType()) + " " + lb.print());
                } else {
                    cv.visitField(0, lb.name, OBJECT_TYPE.getDescriptor(), null, null);
                    Compiler.emitSource("Object " + lb.print() + ";");
                    sb.append("final Object " + lb.print());
                }
                s = s.next();
            }
            int i2 = 0;
            while (i2 < this.protocolCallsites.count()) {
                cv.visitField(10, this.cachedClassName(i2), CLASS_TYPE.getDescriptor(), null, null);
                ++i2;
            }
            clojure.asm.commons.Method m = new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, this.ctorTypes());
            Compiler.emitSource("public " + className + "(" + sb.toString() + ") {");
            Compiler.tab();
            GeneratorAdapter ctorgen = new GeneratorAdapter(1, m, null, null, cv);
            Label start = ctorgen.newLabel();
            Label end = ctorgen.newLabel();
            ctorgen.visitCode();
            ctorgen.visitLineNumber(this.line, ctorgen.mark());
            ctorgen.visitLabel(start);
            ctorgen.loadThis();
            ctorgen.invokeConstructor(Type.getObjectType(superName), voidctor);
            Compiler.emitSource("super();");
            if (this.supportsMeta()) {
                ctorgen.loadThis();
                ctorgen.visitVarInsn(IPERSISTENTMAP_TYPE.getOpcode(21), 1);
                ctorgen.putField(this.objtype, "__meta", IPERSISTENTMAP_TYPE);
                Compiler.emitSource("this.__meta = __meta;");
            }
            int a = this.supportsMeta() ? 2 : 1;
            ISeq s2 = RT.keys(this.closes);
            while (s2 != null) {
                LocalBinding lb = (LocalBinding)s2.first();
                Compiler.emitSource("this." + lb.print() + " = " + lb.print() + ";");
                ctorgen.loadThis();
                Class primc = lb.getPrimitiveType();
                if (primc != null) {
                    ctorgen.visitVarInsn(Type.getType(primc).getOpcode(21), a);
                    ctorgen.putField(this.objtype, lb.name, Type.getType(primc));
                    if (primc == Long.TYPE || primc == Double.TYPE) {
                        ++a;
                    }
                } else {
                    ctorgen.visitVarInsn(OBJECT_TYPE.getOpcode(21), a);
                    ctorgen.putField(this.objtype, lb.name, OBJECT_TYPE);
                }
                this.closesExprs = this.closesExprs.cons(new LocalBindingExpr(lb, null));
                s2 = s2.next();
                ++a;
            }
            ctorgen.visitLabel(end);
            ctorgen.returnValue();
            ctorgen.endMethod();
            Compiler.untab();
            Compiler.emitSource("}");
            if (this.altCtorDrops > 0) {
                ctorTypes = this.ctorTypes();
                Type[] altCtorTypes = new Type[ctorTypes.length - this.altCtorDrops];
                params = new StringBuilder();
                StringBuilder args = new StringBuilder();
                int i3 = 0;
                while (i3 < altCtorTypes.length) {
                    if (params.length() > 0) {
                        params.append(", ");
                        args.append(", ");
                    }
                    params.append("o" + i3);
                    args.append(String.valueOf(Compiler.printClass(ctorTypes[i3])) + " o" + i3);
                    altCtorTypes[i3] = ctorTypes[i3];
                    ++i3;
                }
                alt = new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, altCtorTypes);
                ctorgen = new GeneratorAdapter(1, alt, null, null, cv);
                ctorgen.visitCode();
                ctorgen.loadThis();
                ctorgen.loadArgs();
                int i4 = 0;
                while (i4 < this.altCtorDrops) {
                    if (params.length() > 0) {
                        params.append(", ");
                    }
                    params.append("null");
                    ctorgen.visitInsn(1);
                    ++i4;
                }
                ctorgen.invokeConstructor(this.objtype, new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, ctorTypes));
                Compiler.emitSource("public " + className + "(" + args + ") {");
                Compiler.tab();
                Compiler.emitSource("this(" + params + ");");
                Compiler.untab();
                Compiler.emitSource("}");
                ctorgen.returnValue();
                ctorgen.endMethod();
            }
            if (this.supportsMeta()) {
                ctorTypes = this.ctorTypes();
                Type[] noMetaCtorTypes = new Type[ctorTypes.length - 1];
                params = new StringBuilder();
                StringBuilder paramNames = new StringBuilder();
                int i5 = 1;
                while (i5 < ctorTypes.length) {
                    if (params.length() > 0) {
                        params.append(", ");
                    }
                    paramNames.append(", ");
                    String t = Compiler.registerTemp();
                    noMetaCtorTypes[i5 - 1] = ctorTypes[i5];
                    params.append(String.valueOf(Compiler.printClass(ctorTypes[i5])) + " " + t);
                    paramNames.append(t);
                    ++i5;
                }
                alt = new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, noMetaCtorTypes);
                ctorgen = new GeneratorAdapter(1, alt, null, null, cv);
                ctorgen.visitCode();
                ctorgen.loadThis();
                ctorgen.visitInsn(1);
                ctorgen.loadArgs();
                ctorgen.invokeConstructor(this.objtype, new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, ctorTypes));
                Compiler.emitSource("public " + className + "(" + params + ") {");
                Compiler.tab();
                Compiler.emitSource("this(null" + paramNames + ");");
                Compiler.untab();
                Compiler.emitSource("}");
                ctorgen.returnValue();
                ctorgen.endMethod();
                clojure.asm.commons.Method meth = clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentMap meta()");
                GeneratorAdapter gen = new GeneratorAdapter(1, meth, null, null, cv);
                gen.visitCode();
                gen.loadThis();
                gen.getField(this.objtype, "__meta", IPERSISTENTMAP_TYPE);
                Compiler.emitSource("public clojure.lang.IPersistentMap meta() { return this.__meta; }");
                gen.returnValue();
                gen.endMethod();
                meth = clojure.asm.commons.Method.getMethod("clojure.lang.IObj withMeta(clojure.lang.IPersistentMap)");
                Compiler.emitSource("public clojure.lang.IObj withMeta(clojure.lang.IPersistentMap __meta) {");
                Compiler.tab();
                gen = new GeneratorAdapter(1, meth, null, null, cv);
                gen.visitCode();
                gen.newInstance(this.objtype);
                gen.dup();
                gen.loadArg(0);
                StringBuilder ctorParams = new StringBuilder();
                ISeq s3 = RT.keys(this.closes);
                while (s3 != null) {
                    ctorParams.append(", ");
                    LocalBinding lb = (LocalBinding)s3.first();
                    gen.loadThis();
                    Class primc = lb.getPrimitiveType();
                    if (primc != null) {
                        gen.getField(this.objtype, lb.name, Type.getType(primc));
                        ctorParams.append("(" + Compiler.printClass(primc) + ")" + lb.print());
                    } else {
                        gen.getField(this.objtype, lb.name, OBJECT_TYPE);
                        ctorParams.append("(Object)" + lb.print());
                    }
                    s3 = s3.next();
                    ++a;
                }
                Compiler.emitSource("return new " + className + "(__meta" + ctorParams + ");");
                gen.invokeConstructor(this.objtype, new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, ctorTypes));
                Compiler.untab();
                Compiler.emitSource("}");
                gen.returnValue();
                gen.endMethod();
            }
            this.emitStatics(cv);
            this.emitMethods(cv);
            if (this.keywordCallsites.count() > 0) {
                clojure.asm.commons.Method meth = clojure.asm.commons.Method.getMethod("void swapThunk(int,clojure.lang.ILookupThunk)");
                GeneratorAdapter gen = new GeneratorAdapter(1, meth, null, null, cv);
                gen.visitCode();
                Label endLabel = gen.newLabel();
                Label[] labels = new Label[this.keywordCallsites.count()];
                int i6 = 0;
                while (i6 < this.keywordCallsites.count()) {
                    labels[i6] = gen.newLabel();
                    ++i6;
                }
                gen.loadArg(0);
                gen.visitTableSwitchInsn(0, this.keywordCallsites.count() - 1, endLabel, labels);
                i6 = 0;
                while (i6 < this.keywordCallsites.count()) {
                    gen.mark(labels[i6]);
                    gen.loadArg(1);
                    gen.putStatic(this.objtype, this.thunkNameStatic(i6), ILOOKUP_THUNK_TYPE);
                    gen.goTo(endLabel);
                    ++i6;
                }
                gen.mark(endLabel);
                gen.returnValue();
                gen.endMethod();
            }
            cv.visitEnd();
            Compiler.untab();
            Compiler.emitSource("}");
            this.bytecode = cw.toByteArray();
            if (RT.booleanCast(COMPILE_FILES.deref())) {
                Compiler.writeClassFile(this.internalName, this.bytecode);
                Compiler.writeSourceFile(this.internalName, SOURCE_WRITER.deref().toString());
            }
            Var.popThreadBindings();
        }

        private void emitKeywordCallsites(GeneratorAdapter clinitgen) {
            int i = 0;
            while (i < this.keywordCallsites.count()) {
                Keyword k = (Keyword)this.keywordCallsites.nth(i);
                clinitgen.newInstance(KEYWORD_LOOKUPSITE_TYPE);
                clinitgen.dup();
                String val = this.emitValue(k, clinitgen);
                clinitgen.invokeConstructor(KEYWORD_LOOKUPSITE_TYPE, clojure.asm.commons.Method.getMethod("void <init>(clojure.lang.Keyword)"));
                clinitgen.dup();
                clinitgen.putStatic(this.objtype, this.siteNameStatic(i), KEYWORD_LOOKUPSITE_TYPE);
                clinitgen.putStatic(this.objtype, this.thunkNameStatic(i), ILOOKUP_THUNK_TYPE);
                ++i;
            }
        }

        protected void emitStatics(ClassVisitor gen) {
        }

        protected void emitMethods(ClassVisitor gen) {
        }

        String emitListAsObjectArray(Object value, GeneratorAdapter gen) {
            StringBuilder sb = new StringBuilder();
            gen.push(((List)value).size());
            gen.newArray(OBJECT_TYPE);
            int i = 0;
            Iterator it = ((List)value).iterator();
            while (it.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                gen.dup();
                gen.push(i);
                sb.append(this.emitValue(it.next(), gen));
                gen.arrayStore(OBJECT_TYPE);
                ++i;
            }
            return sb.toString();
        }

        String emitValue(Object value, GeneratorAdapter gen) {
            String str;
            boolean partial = true;
            if (value == null) {
                gen.visitInsn(1);
                str = "null";
            } else if (value instanceof String) {
                gen.push((String)value);
                str = "\"" + Compiler.escapeString((String)value) + "\"";
            } else if (value instanceof Boolean) {
                if (((Boolean)value).booleanValue()) {
                    gen.getStatic(BOOLEAN_OBJECT_TYPE, "TRUE", BOOLEAN_OBJECT_TYPE);
                    str = "Boolean.TRUE";
                } else {
                    gen.getStatic(BOOLEAN_OBJECT_TYPE, "FALSE", BOOLEAN_OBJECT_TYPE);
                    str = "Boolean.FALSE";
                }
            } else {
                String valueStr = value instanceof Number ? String.valueOf(value) : "";
                boolean isNeg = valueStr.startsWith("-");
                if (value instanceof Integer) {
                    gen.push((Integer)value);
                    gen.invokeStatic(Type.getType(Integer.class), clojure.asm.commons.Method.getMethod("Integer valueOf(int)"));
                    str = isNeg ? "(" + valueStr + ")" : valueStr;
                } else if (value instanceof Long) {
                    gen.push((Long)value);
                    gen.invokeStatic(Type.getType(Long.class), clojure.asm.commons.Method.getMethod("Long valueOf(long)"));
                    str = isNeg ? "(" + value + "L)" : value + "L";
                } else if (value instanceof Double) {
                    gen.push((Double)value);
                    gen.invokeStatic(Type.getType(Double.class), clojure.asm.commons.Method.getMethod("Double valueOf(double)"));
                    str = isNeg ? "(" + valueStr + ")" : valueStr;
                } else if (value instanceof Float) {
                    gen.push(((Float)value).floatValue());
                    gen.invokeStatic(Type.getType(Float.class), clojure.asm.commons.Method.getMethod("Float valueOf(float)"));
                    str = isNeg ? "(" + valueStr + ")" : valueStr;
                } else if (value instanceof Character) {
                    gen.push(((Character)value).charValue());
                    gen.invokeStatic(Type.getType(Character.class), clojure.asm.commons.Method.getMethod("Character valueOf(char)"));
                    str = "Character.valueOf((char)" + ((Character)value).charValue() + ")";
                } else if (value instanceof Class) {
                    Class cc = (Class)value;
                    if (cc.isPrimitive()) {
                        Type bt;
                        if (cc == Boolean.TYPE) {
                            bt = Type.getType(Boolean.class);
                        } else if (cc == Byte.TYPE) {
                            bt = Type.getType(Byte.class);
                        } else if (cc == Character.TYPE) {
                            bt = Type.getType(Character.class);
                        } else if (cc == Double.TYPE) {
                            bt = Type.getType(Double.class);
                        } else if (cc == Float.TYPE) {
                            bt = Type.getType(Float.class);
                        } else if (cc == Integer.TYPE) {
                            bt = Type.getType(Integer.class);
                        } else if (cc == Long.TYPE) {
                            bt = Type.getType(Long.class);
                        } else if (cc == Short.TYPE) {
                            bt = Type.getType(Short.class);
                        } else {
                            throw Util.runtimeException("Can't embed unknown primitive in code: " + value);
                        }
                        gen.getStatic(bt, "TYPE", Type.getType(Class.class));
                    } else {
                        gen.push(Compiler.destubClassName(cc.getName()));
                        gen.invokeStatic(Type.getType(Class.class), clojure.asm.commons.Method.getMethod("Class forName(String)"));
                    }
                    str = String.valueOf(Compiler.printClass(cc)) + ".class";
                } else if (value instanceof Symbol) {
                    String ns_ = ((Symbol)value).ns;
                    gen.push(ns_);
                    String name_ = ((Symbol)value).name;
                    gen.push(name_);
                    gen.invokeStatic(Type.getType(Symbol.class), clojure.asm.commons.Method.getMethod("clojure.lang.Symbol intern(String,String)"));
                    str = "Symbol.intern(" + (ns_ == null ? "null" : "\"" + ns_ + "\"") + ", " + (name_ == null ? "null" : "\"" + name_ + "\"") + ")";
                } else if (value instanceof Keyword) {
                    String ns_ = ((Keyword)value).sym.ns;
                    gen.push(ns_);
                    String name_ = ((Keyword)value).sym.name;
                    gen.push(name_);
                    gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.Keyword keyword(String,String)"));
                    str = "Keyword.intern(" + (ns_ == null ? "null" : "\"" + ns_ + "\"") + ", " + (name_ == null ? "null" : "\"" + name_ + "\"") + ")";
                } else if (value instanceof Var) {
                    Var var = (Var)value;
                    String ns_ = var.ns.name.toString();
                    gen.push(ns_);
                    String name_ = var.sym.toString();
                    gen.push(name_);
                    gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.Var var(String,String)"));
                    str = "RT.var(" + (ns_ == null ? "null" : "\"" + ns_ + "\"") + ", " + (name_ == null ? "null" : "\"" + name_ + "\"") + ")";
                } else {
                    if (value instanceof IType) {
                        clojure.asm.commons.Method ctor = new clojure.asm.commons.Method("<init>", Type.getConstructorDescriptor(value.getClass().getConstructors()[0]));
                        gen.newInstance(Type.getType(value.getClass()));
                        gen.dup();
                        IPersistentVector fields = (IPersistentVector)Reflector.invokeStaticMethod(value.getClass(), "getBasis", new Object[0]);
                        StringBuilder sb = new StringBuilder();
                        ISeq s = RT.seq(fields);
                        while (s != null) {
                            Symbol field = (Symbol)s.first();
                            Class k = Compiler.tagClass(Compiler.tagOf(field));
                            Object val = Reflector.getInstanceField(value, field.name);
                            String f = this.emitValue(val, gen);
                            if (k.isPrimitive()) {
                                Type b = Type.getType(Compiler.boxClass(k));
                                String p = Type.getType(k).getDescriptor();
                                String n = k.getName();
                                gen.invokeVirtual(b, new clojure.asm.commons.Method(String.valueOf(n) + "Value", "()" + p));
                                f = String.valueOf(f) + "." + n + "Value()";
                            }
                            if (sb.length() > 0) {
                                sb.append(", ");
                            }
                            sb.append(f);
                            s = s.next();
                        }
                        gen.invokeConstructor(Type.getType(value.getClass()), ctor);
                        return "new " + Compiler.printClass(value.getClass()) + "(" + sb.toString() + ")";
                    }
                    if (value instanceof IRecord) {
                        clojure.asm.commons.Method createMethod = clojure.asm.commons.Method.getMethod(String.valueOf(value.getClass().getName()) + " create(clojure.lang.IPersistentMap)");
                        String val = this.emitValue(PersistentArrayMap.create((Map)value), gen);
                        gen.invokeStatic(Compiler.getType(value.getClass()), createMethod);
                        str = String.valueOf(Compiler.printClass(value.getClass())) + ".create(" + val + ")";
                    } else if (value instanceof IPersistentMap) {
                        ArrayList<Object> entries = new ArrayList<Object>();
                        for (Map.Entry entry : ((Map)value).entrySet()) {
                            entries.add(entry.getKey());
                            entries.add(entry.getValue());
                        }
                        String val = this.emitListAsObjectArray(entries, gen);
                        gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentMap map(Object[])"));
                        str = "RT.map(" + val + ")";
                    } else if (value instanceof IPersistentVector) {
                        String val = this.emitListAsObjectArray(value, gen);
                        gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentVector vector(Object[])"));
                        str = val.equals("null") ? "RT.vector().cons(null)" : "RT.vector(" + val + ")";
                    } else if (value instanceof PersistentHashSet) {
                        ISeq vs = RT.seq(value);
                        if (vs == null) {
                            gen.getStatic(Type.getType(PersistentHashSet.class), "EMPTY", Type.getType(PersistentHashSet.class));
                            str = "PersistentHashSet.EMPTY";
                        } else {
                            String val = this.emitListAsObjectArray(vs, gen);
                            gen.invokeStatic(Type.getType(PersistentHashSet.class), clojure.asm.commons.Method.getMethod("clojure.lang.PersistentHashSet create(Object[])"));
                            str = val.equals("null") ? "PersistentHashSet.create().cons(null)" : "PersistentHashSet.create(" + val + ")";
                        }
                    } else if (value instanceof ISeq || value instanceof IPersistentList) {
                        String val = this.emitListAsObjectArray(value, gen);
                        gen.invokeStatic(Type.getType(Arrays.class), clojure.asm.commons.Method.getMethod("java.util.List asList(Object[])"));
                        gen.invokeStatic(Type.getType(PersistentList.class), clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentList create(java.util.List)"));
                        str = val.equals("null") ? "PersistentList.EMPTY.cons(null)" : "PersistentList.create(java.util.Arrays.asList(" + val + "))";
                    } else if (value instanceof Pattern) {
                        String v = this.emitValue(value.toString(), gen);
                        gen.invokeStatic(Type.getType(Pattern.class), clojure.asm.commons.Method.getMethod("java.util.regex.Pattern compile(String)"));
                        str = "java.util.regex.Pattern.compile(" + v + ")";
                    } else {
                        String cs = null;
                        try {
                            cs = RT.printString(value);
                        }
                        catch (Exception e) {
                            throw Util.runtimeException("Can't embed object in code, maybe print-dup not defined: " + value);
                        }
                        if (cs.length() == 0) {
                            throw Util.runtimeException("Can't embed unreadable object in code: " + value);
                        }
                        if (cs.startsWith("#<")) {
                            throw Util.runtimeException("Can't embed unreadable object in code: " + cs);
                        }
                        gen.push(cs);
                        gen.invokeStatic(RT_TYPE, readStringMethod);
                        partial = false;
                        str = "RT.readString(\"" + Compiler.escapeString(cs) + "\")";
                    }
                }
            }
            if (partial && value instanceof IObj && RT.count(((IObj)value).meta()) > 0) {
                gen.checkCast(IOBJ_TYPE);
                IPersistentMap m = ((IObj)value).meta();
                String val = this.emitValue(Compiler.elideMeta(m), gen);
                gen.checkCast(IPERSISTENTMAP_TYPE);
                gen.invokeInterface(IOBJ_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.IObj withMeta(clojure.lang.IPersistentMap)"));
                return "((clojure.lang.IObj)" + str + ").withMeta((IPersistentMap)" + val + ")";
            }
            return str;
        }

        void emitConstants(GeneratorAdapter clinitgen) {
            try {
                Var.pushThreadBindings(RT.map(RT.PRINT_DUP, RT.T));
                int i = 0;
                while (i < this.constants.count()) {
                    String val = this.emitValue(this.constants.nth(i), clinitgen);
                    clinitgen.checkCast(this.constantType(i));
                    clinitgen.putStatic(this.objtype, this.constantName(i), this.constantType(i));
                    Compiler.emitSource(String.valueOf(this.constantName(i)) + " = (" + Compiler.printClass(this.constantType(i)) + ")" + val + ";");
                    ++i;
                }
            }
            finally {
                Var.popThreadBindings();
            }
        }

        boolean isMutable(LocalBinding lb) {
            return this.isVolatile(lb) || RT.booleanCast(RT.contains(this.fields, lb.sym)) && RT.booleanCast(RT.get(lb.sym.meta(), Keyword.intern("unsynchronized-mutable")));
        }

        boolean isVolatile(LocalBinding lb) {
            return RT.booleanCast(RT.contains(this.fields, lb.sym)) && RT.booleanCast(RT.get(lb.sym.meta(), Keyword.intern("volatile-mutable")));
        }

        boolean isDeftype() {
            return this.fields != null;
        }

        boolean supportsMeta() {
            return !this.isDeftype();
        }

        void emitClearCloses(GeneratorAdapter gen) {
        }

        synchronized Class getCompiledClass() {
            if (this.compiledClass == null) {
                try {
                    this.loader = (DynamicClassLoader)LOADER.deref();
                    this.compiledClass = this.loader.defineClass(this.name, this.bytecode, this.src);
                }
                catch (Exception e) {
                    throw Util.sneakyThrow(e);
                }
            }
            return this.compiledClass;
        }

        @Override
        public Object eval() {
            if (this.isDeftype()) {
                return null;
            }
            try {
                return this.getCompiledClass().newInstance();
            }
            catch (Exception e) {
                throw Util.sneakyThrow(e);
            }
        }

        public void emitLetFnInits(GeneratorAdapter gen, ObjExpr objx, IPersistentSet letFnLocals) {
            gen.checkCast(this.objtype);
            ISeq s = RT.keys(this.closes);
            while (s != null) {
                LocalBinding lb = (LocalBinding)s.first();
                if (letFnLocals.contains(lb)) {
                    Class primc = lb.getPrimitiveType();
                    gen.dup();
                    if (primc != null) {
                        objx.emitUnboxedLocal(gen, lb);
                        gen.putField(this.objtype, lb.name, Type.getType(primc));
                    } else {
                        objx.emitLocal(gen, lb, false);
                        gen.putField(this.objtype, lb.name, OBJECT_TYPE);
                    }
                }
                s = s.next();
            }
            gen.pop();
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            String val;
            if (this.isDeftype()) {
                gen.visitInsn(1);
                val = "";
            } else {
                gen.newInstance(this.objtype);
                gen.dup();
                if (this.supportsMeta()) {
                    gen.visitInsn(1);
                }
                StringBuilder argsList = new StringBuilder();
                ISeq s = RT.seq(this.closesExprs);
                while (s != null) {
                    if (argsList.length() > 0) {
                        argsList.append(", ");
                    }
                    LocalBindingExpr lbe = (LocalBindingExpr)s.first();
                    LocalBinding lb = lbe.b;
                    if (lb.getPrimitiveType() != null) {
                        argsList.append(objx.emitUnboxedLocal(gen, lb));
                    } else {
                        argsList.append(objx.emitLocal(gen, lb, lbe.shouldClear));
                    }
                    s = s.next();
                }
                gen.invokeConstructor(this.objtype, new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, this.ctorTypes()));
                val = "new " + Compiler.printClass(this.objtype) + "(" + argsList + ")";
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
            if (!val.isEmpty()) {
                return Compiler.wrap(context, val);
            }
            return "";
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return this.compiledClass != null ? this.compiledClass : (this.tag != null ? HostExpr.tagToClass(this.tag) : IFn.class);
        }

        public void emitAssignLocal(GeneratorAdapter gen, LocalBinding lb, Expr val) {
            if (!this.isMutable(lb)) {
                throw new IllegalArgumentException("Cannot assign to non-mutable: " + lb.name);
            }
            Class primc = lb.getPrimitiveType();
            gen.loadThis();
            if (primc != null) {
                if (!(val instanceof MaybePrimitiveExpr) || !((MaybePrimitiveExpr)val).canEmitPrimitive()) {
                    throw new IllegalArgumentException("Must assign primitive to primitive mutable: " + lb.name);
                }
                MaybePrimitiveExpr me = (MaybePrimitiveExpr)val;
                String t = me.emitUnboxed(C.EXPRESSION, this, gen);
                gen.putField(this.objtype, lb.name, Type.getType(primc));
                Compiler.emitSource("this." + lb.print() + " = " + t + ";");
            } else {
                String t = val.emit(C.EXPRESSION, this, gen);
                gen.putField(this.objtype, lb.name, OBJECT_TYPE);
                Compiler.emitSource("this." + lb.print() + " = " + t + ";");
            }
        }

        private String emitLocal(GeneratorAdapter gen, LocalBinding lb, boolean clear) {
            ObjMethod m;
            if (this.closes.containsKey(lb)) {
                Class primc = lb.getPrimitiveType();
                gen.loadThis();
                if (primc != null) {
                    gen.getField(this.objtype, lb.name, Type.getType(primc));
                    return HostExpr.emitBoxReturn(this, gen, primc, "this." + lb.print());
                }
                gen.getField(this.objtype, lb.name, OBJECT_TYPE);
                if (this.onceOnly && clear && lb.canBeCleared) {
                    gen.loadThis();
                    gen.visitInsn(1);
                    gen.putField(this.objtype, lb.name, OBJECT_TYPE);
                }
                return "this." + lb.print();
            }
            int argoff = this.isStatic ? 0 : 1;
            Class primc = lb.getPrimitiveType();
            if (lb.isArg) {
                gen.loadArg(lb.idx - argoff);
                if (primc != null) {
                    return HostExpr.emitBoxReturn(this, gen, primc, lb.print());
                }
                if (clear && lb.canBeCleared) {
                    gen.visitInsn(1);
                    gen.storeArg(lb.idx - argoff);
                }
                return lb.print();
            }
            if (primc != null) {
                gen.visitVarInsn(Type.getType(primc).getOpcode(21), lb.idx);
                return HostExpr.emitBoxReturn(this, gen, primc, lb.print());
            }
            gen.visitVarInsn(OBJECT_TYPE.getOpcode(21), lb.idx);
            if (clear && lb.canBeCleared) {
                gen.visitInsn(1);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), lb.idx);
            }
            if (METHOD.deref() instanceof FnMethod && ((FnMethod)(m = (FnMethod)METHOD.deref())).thisName != null && lb.name.equals(Compiler.munge(((FnMethod)m).thisName))) {
                return "this";
            }
            if (METHOD.deref() instanceof NewInstanceMethod) {
                m = (NewInstanceMethod)METHOD.deref();
                if (((NewInstanceMethod)m).thisName.name != null && lb.name.equals(Compiler.munge(((NewInstanceMethod)m).thisName.name))) {
                    return "this";
                }
            }
            if (this.thisName != null && lb.name.equals(Compiler.munge(this.thisName))) {
                return "this";
            }
            return lb.print();
        }

        private String emitUnboxedLocal(GeneratorAdapter gen, LocalBinding lb) {
            int argoff = this.isStatic ? 0 : 1;
            Class primc = lb.getPrimitiveType();
            if (this.closes.containsKey(lb)) {
                gen.loadThis();
                gen.getField(this.objtype, lb.name, Type.getType(primc));
            } else if (lb.isArg) {
                gen.loadArg(lb.idx - argoff);
            } else {
                gen.visitVarInsn(Type.getType(primc).getOpcode(21), lb.idx);
            }
            return lb.print();
        }

        public String emitVar(GeneratorAdapter gen, Var var) {
            Integer i = (Integer)this.vars.valAt(var);
            return this.emitConstant(gen, i);
        }

        public String emitVarValue(GeneratorAdapter gen, Var v) {
            Integer i = (Integer)this.vars.valAt(v);
            if (!v.isDynamic()) {
                String val = this.emitConstant(gen, i);
                gen.invokeVirtual(VAR_TYPE, varGetRawMethod);
                return String.valueOf(val) + ".getRawRoot()";
            }
            String val = this.emitConstant(gen, i);
            gen.invokeVirtual(VAR_TYPE, varGetMethod);
            return String.valueOf(val) + ".get()";
        }

        public String emitKeyword(GeneratorAdapter gen, Keyword k) {
            Integer i = (Integer)this.keywords.valAt(k);
            return this.emitConstant(gen, i);
        }

        public String emitConstant(GeneratorAdapter gen, int id) {
            String constantName = this.constantName(id);
            Type constantType = this.constantType(id);
            gen.getStatic(this.objtype, constantName, constantType);
            return constantName;
        }

        String constantName(int id) {
            return CONST_PREFIX + id;
        }

        String siteName(int n) {
            return "__site__" + n;
        }

        String siteNameStatic(int n) {
            return String.valueOf(this.siteName(n)) + "__";
        }

        String thunkName(int n) {
            return "__thunk__" + n;
        }

        String cachedClassName(int n) {
            return "__cached_class__" + n;
        }

        String cachedVarName(int n) {
            return "__cached_var__" + n;
        }

        String varCallsiteName(int n) {
            return "__var__callsite__" + n;
        }

        String thunkNameStatic(int n) {
            return String.valueOf(this.thunkName(n)) + "__";
        }

        Class constantRealType(int id) {
            Object o = this.constants.nth(id);
            Class c = Util.classOf(o);
            if (o != null) {
                if (o instanceof ISeq || o instanceof IPersistentList) {
                    return IPersistentList.class;
                }
                if (o instanceof IPersistentMap) {
                    return IPersistentMap.class;
                }
            }
            return c;
        }

        Type constantType(int id) {
            Object o = this.constants.nth(id);
            Class c = Util.classOf(o);
            if (c != null && Modifier.isPublic(c.getModifiers())) {
                if (LazySeq.class.isAssignableFrom(c)) {
                    return Type.getType(ISeq.class);
                }
                if (c == Keyword.class) {
                    return Type.getType(Keyword.class);
                }
                if (RestFn.class.isAssignableFrom(c)) {
                    return Type.getType(RestFn.class);
                }
                if (IPersistentMap.class.isAssignableFrom(c)) {
                    return Type.getType(IPersistentMap.class);
                }
                if (IPersistentSet.class.isAssignableFrom(c)) {
                    return Type.getType(IPersistentSet.class);
                }
                if (IPersistentStack.class.isAssignableFrom(c)) {
                    return Type.getType(IPersistentStack.class);
                }
                if (IPersistentVector.class.isAssignableFrom(c)) {
                    return Type.getType(IPersistentVector.class);
                }
                if (IPersistentList.class.isAssignableFrom(c)) {
                    return Type.getType(IPersistentList.class);
                }
                if (Symbol.class.isAssignableFrom(c)) {
                    return Type.getType(Symbol.class);
                }
                if (AFn.class.isAssignableFrom(c)) {
                    return Type.getType(AFn.class);
                }
                if (c == Var.class) {
                    return Type.getType(Var.class);
                }
                if (c == String.class) {
                    return Type.getType(String.class);
                }
            }
            return OBJECT_TYPE;
        }
    }

    public static abstract class ObjMethod {
        public final ObjMethod parent;
        boolean hasRecur;
        boolean hasException;
        IPersistentMap locals = null;
        IPersistentMap indexlocals = null;
        Expr body = null;
        ObjExpr objx;
        PersistentVector argLocals;
        int maxLocal = 0;
        int line;
        int column;
        PersistentHashSet localsUsedInCatchFinally = PersistentHashSet.EMPTY;
        protected IPersistentMap methodMeta;

        public final IPersistentMap locals() {
            return this.locals;
        }

        public final Expr body() {
            return this.body;
        }

        public final ObjExpr objx() {
            return this.objx;
        }

        public final PersistentVector argLocals() {
            return this.argLocals;
        }

        public final int maxLocal() {
            return this.maxLocal;
        }

        public final int line() {
            return this.line;
        }

        public final int column() {
            return this.column;
        }

        public ObjMethod(ObjExpr objx, ObjMethod parent) {
            this.parent = parent;
            this.objx = objx;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static String emitBody(ObjExpr objx, GeneratorAdapter gen, Class retClass, Expr body) {
            String ret;
            MaybePrimitiveExpr be = (MaybePrimitiveExpr)body;
            if (Util.isPrimitive(retClass) && be.canEmitPrimitive()) {
                Class bc = Compiler.maybePrimitiveType(be);
                if (bc == retClass) {
                    return be.emitUnboxed(C.RETURN, objx, gen);
                }
                if (retClass == Long.TYPE && bc == Integer.TYPE) {
                    ret = be.emitUnboxed(C.RETURN, objx, gen);
                    gen.visitInsn(133);
                    return ret;
                } else if (retClass == Double.TYPE && bc == Float.TYPE) {
                    ret = be.emitUnboxed(C.RETURN, objx, gen);
                    gen.visitInsn(141);
                    return ret;
                } else if (retClass == Integer.TYPE && bc == Long.TYPE) {
                    Var.pushThreadBindings(RT.map(RETURN_TYPE, Integer.TYPE));
                    ret = be.emitUnboxed(C.RETURN, objx, gen);
                    Var.popThreadBindings();
                    gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("int intCast(long)"));
                    return ret;
                } else {
                    if (retClass != Float.TYPE) throw new IllegalArgumentException("Mismatched primitive return, expected: " + retClass + ", had: " + be.getJavaClass());
                    if (bc != Double.TYPE) throw new IllegalArgumentException("Mismatched primitive return, expected: " + retClass + ", had: " + be.getJavaClass());
                    ret = be.emitUnboxed(C.RETURN, objx, gen);
                    gen.visitInsn(144);
                }
                return ret;
            } else {
                Var.pushThreadBindings(RT.map(RETURN_TYPE, retClass));
                ret = body.emit(C.RETURN, objx, gen);
                Var.popThreadBindings();
                if (retClass == Void.TYPE) {
                    gen.pop();
                    return ret;
                } else {
                    gen.unbox(Type.getType(retClass));
                }
            }
            return ret;
        }

        abstract int numParams();

        abstract String getMethodName();

        abstract Type getReturnType();

        abstract Type[] getArgTypes();

        public void emit(ObjExpr fn, ClassVisitor cv) {
            clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.getMethodName(), this.getReturnType(), this.getArgTypes());
            StringBuilder params = new StringBuilder();
            int pos = 0;
            ISeq lbs = this.argLocals.seq();
            while (lbs != null) {
                LocalBinding lb = (LocalBinding)lbs.first();
                if (params.length() > 0) {
                    params.append(", ");
                }
                params.append(String.valueOf(Compiler.printClass(this.getArgTypes()[pos])) + " " + lb.name + lb.idx);
                ++pos;
                lbs = lbs.next();
            }
            Compiler.emitSource("public " + Compiler.printClass(this.getReturnType()) + " " + this.getMethodName() + "(" + params + ") {");
            Compiler.tab();
            if (this.hasException) {
                Compiler.emitSource("try {");
                Compiler.tab();
            }
            if (this.hasRecur) {
                Compiler.emitSource("while(true) {");
                Compiler.tab();
            }
            GeneratorAdapter gen = new GeneratorAdapter(1, m, null, EXCEPTION_TYPES, cv);
            gen.visitCode();
            Label loopLabel = gen.mark();
            gen.visitLineNumber(this.line, loopLabel);
            try {
                Var.pushThreadBindings(RT.map(LOOP_LABEL, loopLabel, METHOD, this));
                Compiler.emitSource(this.body.emit(C.RETURN, fn, gen));
                Label end = gen.mark();
                gen.visitLocalVariable("this", "Ljava/lang/Object;", null, loopLabel, end, 0);
                ISeq lbs2 = this.argLocals.seq();
                while (lbs2 != null) {
                    LocalBinding lb = (LocalBinding)lbs2.first();
                    gen.visitLocalVariable(lb.name, "Ljava/lang/Object;", null, loopLabel, end, lb.idx);
                    lbs2 = lbs2.next();
                }
            }
            finally {
                Var.popThreadBindings();
            }
            gen.returnValue();
            gen.endMethod();
            if (this.hasRecur) {
                Compiler.untab();
                Compiler.emitSource("}");
            }
            if (this.hasException) {
                Compiler.untab();
                Compiler.emitSource("} catch (Exception ___e) {");
                Compiler.tab();
                Compiler.emitSource("throw Util.sneakyThrow(___e);");
                Compiler.untab();
                Compiler.emitSource("}");
            }
            Compiler.untab();
            Compiler.emitSource("}");
        }

        void emitClearLocals(GeneratorAdapter gen) {
        }

        void emitClearLocalsOld(GeneratorAdapter gen) {
            int i = 0;
            while (i < this.argLocals.count()) {
                LocalBinding lb = (LocalBinding)this.argLocals.nth(i);
                if (!this.localsUsedInCatchFinally.contains(lb.idx) && lb.getPrimitiveType() == null) {
                    gen.visitInsn(1);
                    gen.storeArg(lb.idx - 1);
                }
                ++i;
            }
            i = this.numParams() + 1;
            while (i < this.maxLocal + 1) {
                LocalBinding b;
                if (!(this.localsUsedInCatchFinally.contains(i) || (b = (LocalBinding)RT.get(this.indexlocals, i)) != null && Compiler.maybePrimitiveType(b.init) != null)) {
                    gen.visitInsn(1);
                    gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), i);
                }
                ++i;
            }
        }
    }

    static enum PATHTYPE {
        PATH,
        BRANCH;

    }

    static enum PSTATE {
        REQ,
        REST,
        DONE;

    }

    static class PathNode {
        final PATHTYPE type;
        final PathNode parent;

        PathNode(PATHTYPE type, PathNode parent) {
            this.type = type;
            this.parent = parent;
        }
    }

    private class Recur {
        private Recur() {
        }
    }

    public static class RecurExpr
    implements Expr,
    MaybePrimitiveExpr {
        public final IPersistentVector args;
        public final IPersistentVector loopLocals;
        final int line;
        final int column;
        final String source;

        public RecurExpr(IPersistentVector loopLocals, IPersistentVector args, int line, int column, String source) {
            this.loopLocals = loopLocals;
            this.args = args;
            this.line = line;
            this.column = column;
            this.source = source;
        }

        @Override
        public Object eval() {
            throw new UnsupportedOperationException("Can't eval recur");
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            Object lb;
            Label loopLabel = (Label)LOOP_LABEL.deref();
            String val = null;
            if (loopLabel == null) {
                throw new IllegalStateException();
            }
            Expr last = null;
            ArrayList<String> auxs = new ArrayList<String>();
            int i = 0;
            while (i < this.loopLocals.count()) {
                block17: {
                    Expr arg;
                    lb = (LocalBinding)this.loopLocals.nth(i);
                    last = arg = (Expr)this.args.nth(i);
                    if (((LocalBinding)lb).getPrimitiveType() != null) {
                        Class primc = ((LocalBinding)lb).getPrimitiveType();
                        try {
                            Class pc = Compiler.maybePrimitiveType(arg);
                            if (pc == primc) {
                                val = ((MaybePrimitiveExpr)arg).emitUnboxed(C.EXPRESSION, objx, gen);
                                break block17;
                            }
                            if (primc == Long.TYPE && pc == Integer.TYPE) {
                                val = ((MaybePrimitiveExpr)arg).emitUnboxed(C.EXPRESSION, objx, gen);
                                gen.visitInsn(133);
                                break block17;
                            }
                            if (primc == Double.TYPE && pc == Float.TYPE) {
                                val = ((MaybePrimitiveExpr)arg).emitUnboxed(C.EXPRESSION, objx, gen);
                                gen.visitInsn(141);
                                break block17;
                            }
                            if (primc == Integer.TYPE && pc == Long.TYPE) {
                                val = ((MaybePrimitiveExpr)arg).emitUnboxed(C.EXPRESSION, objx, gen);
                                gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("int intCast(long)"));
                                val = "RT.intCast(" + val + ")";
                                break block17;
                            }
                            if (primc == Float.TYPE && pc == Double.TYPE) {
                                val = ((MaybePrimitiveExpr)arg).emitUnboxed(C.EXPRESSION, objx, gen);
                                gen.visitInsn(144);
                                break block17;
                            }
                            throw new IllegalArgumentException(" recur arg for primitive local: " + ((LocalBinding)lb).name + " is not matching primitive, had: " + (arg.hasJavaClass() ? arg.getJavaClass().getName() : "Object") + ", needed: " + primc.getName());
                        }
                        catch (Exception e) {
                            throw Util.sneakyThrow(e);
                        }
                    }
                    val = arg.emit(C.EXPRESSION, objx, gen);
                }
                if (!((LocalBinding)lb).print().equals(val)) {
                    Class type = ((LocalBinding)lb).getPrimitiveType();
                    Compiler.emitSource(String.valueOf(Compiler.printClass(type == null ? Object.class : type)) + " " + ((LocalBinding)lb).print() + "___aux = " + val + ";");
                    auxs.add(((LocalBinding)lb).print());
                }
                ++i;
            }
            for (String a : auxs) {
                Compiler.emitSource(String.valueOf(a) + " = " + a + "___aux;");
            }
            i = this.loopLocals.count() - 1;
            while (i >= 0) {
                lb = (LocalBinding)this.loopLocals.nth(i);
                Class primc = ((LocalBinding)lb).getPrimitiveType();
                if (((LocalBinding)lb).isArg) {
                    gen.storeArg(((LocalBinding)lb).idx - (objx.isStatic ? 0 : 1));
                } else if (primc != null) {
                    gen.visitVarInsn(Type.getType(primc).getOpcode(54), ((LocalBinding)lb).idx);
                } else {
                    gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), ((LocalBinding)lb).idx);
                }
                --i;
            }
            gen.goTo(loopLabel);
            return "continue;";
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return RECUR_CLASS;
        }

        @Override
        public boolean canEmitPrimitive() {
            return true;
        }

        @Override
        public String emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            return this.emit(context, objx, gen);
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object frm) {
                int line = Compiler.lineDeref();
                int column = Compiler.columnDeref();
                String source = (String)SOURCE.deref();
                ISeq form = (ISeq)frm;
                IPersistentVector loopLocals = (IPersistentVector)LOOP_LOCALS.deref();
                if (context != C.RETURN || loopLocals == null) {
                    throw new UnsupportedOperationException("Can only recur from tail position");
                }
                if (NO_RECUR.deref() != null) {
                    throw new UnsupportedOperationException("Cannot recur across try");
                }
                ObjMethod objmethod = (ObjMethod)METHOD.deref();
                objmethod.hasRecur = true;
                PersistentVector args = PersistentVector.EMPTY;
                ISeq s = RT.seq(form.next());
                while (s != null) {
                    args = args.cons(Compiler.analyze(C.EXPRESSION, s.first()));
                    s = s.next();
                }
                if (args.count() != loopLocals.count()) {
                    throw new IllegalArgumentException(String.format("Mismatched argument count to recur, expected: %d args, got: %d", loopLocals.count(), args.count()));
                }
                int i = 0;
                while (i < loopLocals.count()) {
                    LocalBinding lb = (LocalBinding)loopLocals.nth(i);
                    Class primc = lb.getPrimitiveType();
                    if (primc != null) {
                        boolean mismatch = false;
                        Class pc = Compiler.maybePrimitiveType((Expr)args.nth(i));
                        if (primc == Long.TYPE) {
                            if (pc != Long.TYPE && pc != Integer.TYPE && pc != Short.TYPE && pc != Character.TYPE && pc != Byte.TYPE) {
                                mismatch = true;
                            }
                        } else if (primc == Double.TYPE && pc != Double.TYPE && pc != Float.TYPE) {
                            mismatch = true;
                        }
                        if (mismatch) {
                            lb.recurMistmatch = true;
                            if (RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                                RT.errPrintWriter().println(String.valueOf(source) + ":" + line + " recur arg for primitive local: " + lb.name + " is not matching primitive, had: " + (pc != null ? pc.getName() : "Object") + ", needed: " + primc.getName());
                            }
                        }
                    }
                    ++i;
                }
                return new RecurExpr(loopLocals, args, line, column, source);
            }
        }
    }

    public static class SetExpr
    implements Expr {
        public final IPersistentVector keys;
        static final clojure.asm.commons.Method setMethod = clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentSet set(Object[])");

        public SetExpr(IPersistentVector keys) {
            this.keys = keys;
        }

        @Override
        public Object eval() {
            Object[] ret = new Object[this.keys.count()];
            int i = 0;
            while (i < this.keys.count()) {
                ret[i] = ((Expr)this.keys.nth(i)).eval();
                ++i;
            }
            return RT.set(ret);
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            String argsList = MethodExpr.emitArgsAsArray(this.keys, objx, gen);
            gen.invokeStatic(RT_TYPE, setMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
            return Compiler.wrap(context, "RT.set(" + argsList + ")");
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return IPersistentSet.class;
        }

        public static Expr parse(C context, IPersistentSet form) {
            IPersistentVector keys = PersistentVector.EMPTY;
            boolean constant = true;
            ISeq s = RT.seq(form);
            while (s != null) {
                Object e = s.first();
                Expr expr = Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, e);
                keys = keys.cons(expr);
                if (!(expr instanceof LiteralExpr)) {
                    constant = false;
                }
                s = s.next();
            }
            SetExpr ret = new SetExpr(keys);
            if (form instanceof IObj && ((IObj)((Object)form)).meta() != null) {
                return new MetaExpr(ret, MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)((Object)form)).meta()));
            }
            if (constant) {
                IPersistentSet set = PersistentHashSet.EMPTY;
                int i = 0;
                while (i < keys.count()) {
                    LiteralExpr ve = (LiteralExpr)keys.nth(i);
                    set = (IPersistentSet)set.cons(ve.val());
                    ++i;
                }
                return new ConstantExpr(set);
            }
            return ret;
        }
    }

    static class SourceDebugExtensionAttribute
    extends Attribute {
        public SourceDebugExtensionAttribute() {
            super("SourceDebugExtension");
        }

        void writeSMAP(ClassWriter cw, String smap) {
            ByteVector bv = this.write(cw, null, -1, -1, -1);
            bv.putUTF8(smap);
        }
    }

    static class StaticFieldExpr
    extends FieldExpr
    implements AssignableExpr {
        public final String fieldName;
        public final Class c;
        public final Field field;
        public final Symbol tag;
        final int line;
        final int column;

        public StaticFieldExpr(int line, int column, Class c, String fieldName, Symbol tag) {
            this.fieldName = fieldName;
            this.line = line;
            this.column = column;
            this.c = c;
            try {
                this.field = c.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                throw Util.sneakyThrow(e);
            }
            this.tag = tag;
        }

        @Override
        public Object eval() {
            return Reflector.getStaticField(this.c, this.fieldName);
        }

        @Override
        public boolean canEmitPrimitive() {
            return Util.isPrimitive(this.field.getType());
        }

        @Override
        public String emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            gen.getStatic(Type.getType(this.c), this.fieldName, Type.getType(this.field.getType()));
            return String.valueOf(Compiler.printClass(this.c)) + "." + this.fieldName;
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            gen.getStatic(Type.getType(this.c), this.fieldName, Type.getType(this.field.getType()));
            String v = String.valueOf(Compiler.printClass(this.c)) + "." + this.fieldName;
            v = HostExpr.emitBoxReturn(objx, gen, this.field.getType(), v);
            if (context == C.STATEMENT) {
                gen.pop();
                return "";
            }
            return Compiler.wrap(context, v);
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return this.tag != null ? HostExpr.tagToClass(this.tag) : this.field.getType();
        }

        @Override
        public Object evalAssign(Expr val) {
            return Reflector.setStaticField(this.c, this.fieldName, val.eval());
        }

        @Override
        public String emitAssign(C context, ObjExpr objx, GeneratorAdapter gen, Expr val) {
            gen.visitLineNumber(this.line, gen.mark());
            String value = val.emit(C.EXPRESSION, objx, gen);
            gen.dup();
            Compiler.emitSource(String.valueOf(Compiler.printClass(this.c)) + "." + this.fieldName + " = (" + Compiler.printClass(this.field.getType()) + ")" + value + ";");
            String v = HostExpr.emitUnboxArg(objx, gen, this.field.getType(), String.valueOf(Compiler.printClass(this.c)) + "." + this.fieldName);
            gen.putStatic(Type.getType(this.c), this.fieldName, Type.getType(this.field.getType()));
            if (context == C.STATEMENT) {
                gen.pop();
                return "";
            }
            return Compiler.wrap(context, v);
        }
    }

    static class StaticInvokeExpr
    implements Expr,
    MaybePrimitiveExpr {
        public final Type target;
        public final Class retClass;
        public final Class[] paramclasses;
        public final Type[] paramtypes;
        public final IPersistentVector args;
        public final boolean variadic;
        public final Symbol tag;

        StaticInvokeExpr(Type target, Class retClass, Class[] paramclasses, Type[] paramtypes, boolean variadic, IPersistentVector args, Symbol tag) {
            this.target = target;
            this.retClass = retClass;
            this.paramclasses = paramclasses;
            this.paramtypes = paramtypes;
            this.args = args;
            this.variadic = variadic;
            this.tag = tag;
        }

        @Override
        public Object eval() {
            throw new UnsupportedOperationException("Can't eval StaticInvokeExpr");
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            String val = this.emitUnboxed(context, objx, gen);
            if (context != C.STATEMENT) {
                val = HostExpr.emitBoxReturn(objx, gen, this.retClass, val);
            }
            if (context == C.STATEMENT) {
                if (this.retClass == Long.TYPE || this.retClass == Double.TYPE) {
                    gen.pop2();
                } else {
                    gen.pop();
                }
            }
            return Compiler.wrap(context, val);
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return this.tag != null ? HostExpr.tagToClass(this.tag) : this.retClass;
        }

        @Override
        public boolean canEmitPrimitive() {
            return this.retClass.isPrimitive();
        }

        @Override
        public String emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            clojure.asm.commons.Method ms = new clojure.asm.commons.Method("invokeStatic", this.getReturnType(), this.paramtypes);
            if (this.variadic) {
                int i = 0;
                while (i < this.paramclasses.length - 1) {
                    Expr e = (Expr)this.args.nth(i);
                    try {
                        if (Compiler.maybePrimitiveType(e) == this.paramclasses[i]) {
                            ((MaybePrimitiveExpr)e).emitUnboxed(C.EXPRESSION, objx, gen);
                        } else {
                            String v = e.emit(C.EXPRESSION, objx, gen);
                            v = HostExpr.emitUnboxArg(objx, gen, this.paramclasses[i], v);
                        }
                    }
                    catch (Exception ex) {
                        throw Util.sneakyThrow(ex);
                    }
                    ++i;
                }
                IPersistentVector restArgs = RT.subvec(this.args, this.paramclasses.length - 1, this.args.count());
                MethodExpr.emitArgsAsArray(restArgs, objx, gen);
                gen.invokeStatic(Type.getType(ArraySeq.class), clojure.asm.commons.Method.getMethod("clojure.lang.ArraySeq create(Object[])"));
            } else {
                MethodExpr.emitTypedArgs(objx, gen, this.paramclasses, this.args);
            }
            gen.invokeStatic(this.target, ms);
            throw new RuntimeException("NOT IMPLEMENTED; TODO FIX");
        }

        private Type getReturnType() {
            return Type.getType(this.retClass);
        }

        public static Expr parse(Var v, ISeq args, Symbol tag) {
            Class pc;
            int i;
            IPersistentCollection paramlists = (IPersistentCollection)RT.get(v.meta(), arglistsKey);
            if (paramlists == null) {
                throw new IllegalStateException("Can't call static fn with no arglists: " + v);
            }
            IPersistentVector paramlist = null;
            int argcount = RT.count(args);
            boolean variadic = false;
            ISeq aseq = RT.seq(paramlists);
            while (aseq != null) {
                if (!(aseq.first() instanceof IPersistentVector)) {
                    throw new IllegalStateException("Expected vector arglist, had: " + aseq.first());
                }
                IPersistentVector alist = (IPersistentVector)aseq.first();
                if (alist.count() > 1 && alist.nth(alist.count() - 2).equals(_AMP_)) {
                    if (argcount >= alist.count() - 2) {
                        paramlist = alist;
                        variadic = true;
                    }
                } else if (alist.count() == argcount) {
                    paramlist = alist;
                    variadic = false;
                    break;
                }
                aseq = aseq.next();
            }
            if (paramlist == null) {
                throw new IllegalArgumentException("Invalid arity - can't call: " + v + " with " + argcount + " args");
            }
            Class retClass = Compiler.tagClass(Compiler.tagOf(paramlist));
            ArrayList<Class> paramClasses = new ArrayList<Class>();
            ArrayList<Type> paramTypes = new ArrayList<Type>();
            if (variadic) {
                i = 0;
                while (i < paramlist.count() - 2) {
                    pc = Compiler.tagClass(Compiler.tagOf(paramlist.nth(i)));
                    paramClasses.add(pc);
                    paramTypes.add(Type.getType(pc));
                    ++i;
                }
                paramClasses.add(ISeq.class);
                paramTypes.add(Type.getType(ISeq.class));
            } else {
                i = 0;
                while (i < argcount) {
                    pc = Compiler.tagClass(Compiler.tagOf(paramlist.nth(i)));
                    paramClasses.add(pc);
                    paramTypes.add(Type.getType(pc));
                    ++i;
                }
            }
            String cname = String.valueOf(v.ns.name.name.replace('.', '/').replace('-', '_')) + Compiler.DOLLAR + Compiler.munge(v.sym.name);
            Type target = Type.getObjectType(cname);
            PersistentVector argv = PersistentVector.EMPTY;
            ISeq s = RT.seq(args);
            while (s != null) {
                argv = argv.cons(Compiler.analyze(C.EXPRESSION, s.first()));
                s = s.next();
            }
            return new StaticInvokeExpr(target, retClass, paramClasses.toArray(new Class[paramClasses.size()]), paramTypes.toArray(new Type[paramTypes.size()]), variadic, argv, tag);
        }
    }

    static class StaticMethodExpr
    extends MethodExpr {
        public final Class c;
        public final String methodName;
        public final IPersistentVector args;
        public final String source;
        public final int line;
        public final int column;
        public final Method method;
        public final Symbol tag;
        static final clojure.asm.commons.Method forNameMethod = clojure.asm.commons.Method.getMethod("Class forName(String)");
        static final clojure.asm.commons.Method invokeStaticMethodMethod = clojure.asm.commons.Method.getMethod("Object invokeStaticMethod(Class,String,Object[])");

        public StaticMethodExpr(String source, int line, int column, Symbol tag, Class c, String methodName, IPersistentVector args) {
            ObjMethod m;
            this.c = c;
            this.methodName = methodName;
            this.args = args;
            this.source = source;
            this.line = line;
            this.column = column;
            this.tag = tag;
            List methods = Reflector.getMethods(c, args.count(), methodName, true);
            if (methods.isEmpty()) {
                throw new IllegalArgumentException("No matching method: " + Compiler.printClass(c) + "." + methodName);
            }
            int methodidx = 0;
            if (methods.size() > 1) {
                ArrayList<Class[]> params = new ArrayList<Class[]>();
                ArrayList<Class> rets = new ArrayList<Class>();
                int i = 0;
                while (i < methods.size()) {
                    Method m2 = (Method)methods.get(i);
                    params.add(m2.getParameterTypes());
                    rets.add(m2.getReturnType());
                    ++i;
                }
                methodidx = Compiler.getMatchingParams(methodName, params, args, rets);
            }
            this.method = methodidx >= 0 ? methods.get(methodidx) : null;
            if (this.method != null && (m = (ObjMethod)METHOD.get()) != null && !m.hasException) {
                Class<?>[] classArray = this.method.getExceptionTypes();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> ex = classArray[n2];
                    if (!RuntimeException.class.isAssignableFrom(ex)) {
                        m.hasException = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (this.method == null && RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                RT.errPrintWriter().format("Reflection warning, %s:%d:%d - call to %s can't be resolved.\n", SOURCE_PATH.deref(), line, column, methodName);
            }
        }

        @Override
        public Object eval() {
            try {
                Object[] argvals = new Object[this.args.count()];
                int i = 0;
                while (i < this.args.count()) {
                    argvals[i] = ((Expr)this.args.nth(i)).eval();
                    ++i;
                }
                if (this.method != null) {
                    LinkedList<Method> ms = new LinkedList<Method>();
                    ms.add(this.method);
                    return Reflector.invokeMatchingMethod(this.methodName, ms, null, argvals);
                }
                return Reflector.invokeStaticMethod(this.c, this.methodName, argvals);
            }
            catch (Throwable e) {
                if (!(e instanceof CompilerException)) {
                    throw new CompilerException(this.source, this.line, this.column, e);
                }
                throw (CompilerException)e;
            }
        }

        @Override
        public boolean canEmitPrimitive() {
            return this.method != null && Util.isPrimitive(this.method.getReturnType());
        }

        public boolean canEmitIntrinsicPredicate() {
            return this.method != null && RT.get(Intrinsics.preds, this.method.toString()) != null;
        }

        public String emitIntrinsicPredicate(C context, ObjExpr objx, GeneratorAdapter gen, Label falseLabel) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.method != null) {
                String argsList = MethodExpr.emitTypedArgs(objx, gen, this.method.getParameterTypes(), this.args);
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                Object[] predOps = (Object[])RT.get(Intrinsics.preds, this.method.toString());
                int i = 0;
                while (i < predOps.length - 1) {
                    gen.visitInsn((Integer)predOps[i]);
                    ++i;
                }
                gen.visitJumpInsn((Integer)predOps[predOps.length - 1], falseLabel);
                return Compiler.wrap(context, String.valueOf(Compiler.printClass(this.c)) + "." + this.method.getName() + "(" + argsList + ")");
            }
            throw new UnsupportedOperationException("Unboxed emit of unknown member");
        }

        @Override
        public String emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.method != null) {
                Object ops;
                String argsList = MethodExpr.emitTypedArgs(objx, gen, this.method.getParameterTypes(), this.args);
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                if ((ops = RT.get(Intrinsics.ops, this.method.toString())) != null) {
                    if (ops instanceof Object[]) {
                        Object[] objectArray = (Object[])ops;
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object op = objectArray[n2];
                            gen.visitInsn((Integer)op);
                            ++n2;
                        }
                    } else {
                        gen.visitInsn((Integer)ops);
                    }
                    return Compiler.wrap(context, String.valueOf(Compiler.printClass(this.method.getDeclaringClass())) + "." + this.method.getName() + "(" + argsList + ")");
                }
                Type type = Type.getType(this.c);
                clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.methodName, Type.getReturnType(this.method), Type.getArgumentTypes(this.method));
                gen.invokeStatic(type, m);
                return Compiler.wrap(context, String.valueOf(Compiler.printClass(this.c)) + "." + m.getName() + "(" + argsList + ")");
            }
            throw new UnsupportedOperationException("Unboxed emit of unknown member");
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.method != null) {
                String argsList = MethodExpr.emitTypedArgs(objx, gen, this.method.getParameterTypes(), this.args);
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                Type type = Type.getType(this.c);
                clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.methodName, Type.getReturnType(this.method), Type.getArgumentTypes(this.method));
                gen.invokeStatic(type, m);
                Class<?> retClass = this.method.getReturnType();
                String v = String.valueOf(Compiler.printClass(this.c)) + "." + this.method.getName() + "(" + argsList + ")";
                if (context == C.STATEMENT) {
                    if (retClass == Long.TYPE || retClass == Double.TYPE) {
                        gen.pop2();
                    } else if (retClass != Void.TYPE) {
                        gen.pop();
                    }
                } else {
                    v = HostExpr.emitBoxReturn(objx, gen, this.method.getReturnType(), v);
                }
                return Compiler.wrap(context, v);
            }
            gen.push(this.c.getName());
            gen.invokeStatic(CLASS_TYPE, forNameMethod);
            gen.push(this.methodName);
            String argsList = StaticMethodExpr.emitArgsAsArray(this.args, objx, gen);
            if (context == C.RETURN) {
                ObjMethod method = (ObjMethod)METHOD.deref();
                method.emitClearLocals(gen);
            }
            gen.invokeStatic(REFLECTOR_TYPE, invokeStaticMethodMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
            return Compiler.wrap(context, "Reflector.invokeStaticMethod(" + Compiler.printClass(this.c) + ".class, \"" + this.methodName + "\", new Object[]{" + argsList + "})");
        }

        @Override
        public boolean hasJavaClass() {
            return this.method != null || this.tag != null;
        }

        @Override
        public Class getJavaClass() {
            return this.tag != null ? HostExpr.tagToClass(this.tag) : this.method.getReturnType();
        }
    }

    static class StringExpr
    extends LiteralExpr {
        public final String str;

        public StringExpr(String str) {
            this.str = str;
        }

        @Override
        Object val() {
            return this.str;
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (context != C.STATEMENT) {
                gen.push(this.str);
                return Compiler.wrap(context, "\"" + Compiler.escapeString(this.str) + "\"");
            }
            return "";
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return String.class;
        }
    }

    public static class TheVarExpr
    implements Expr {
        public final Var var;

        public TheVarExpr(Var var) {
            this.var = var;
        }

        @Override
        public Object eval() {
            return this.var;
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            String val = objx.emitVar(gen, this.var);
            if (context == C.STATEMENT) {
                gen.pop();
                return "";
            }
            return Compiler.wrap(context, val);
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return Var.class;
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object form) {
                Symbol sym = (Symbol)RT.second(form);
                Var v = Compiler.lookupVar(sym, false);
                if (v != null) {
                    return new TheVarExpr(v);
                }
                throw Util.runtimeException("Unable to resolve var: " + sym + " in this context");
            }
        }
    }

    static class ThrowExpr
    extends UntypedExpr {
        public final Expr excExpr;

        public ThrowExpr(Expr excExpr) {
            this.excExpr = excExpr;
        }

        @Override
        public Object eval() {
            throw Util.runtimeException("Can't eval throw");
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            String val = this.excExpr.emit(C.EXPRESSION, objx, gen);
            gen.checkCast(THROWABLE_TYPE);
            gen.throwException();
            Compiler.emitSource("Util.trow((Throwable)" + val + ");");
            return Compiler.wrap(context, "null");
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object form) {
                if (context == C.EVAL) {
                    return Compiler.analyze(context, RT.list(RT.list(FNONCE, PersistentVector.EMPTY, form)));
                }
                return new ThrowExpr(Compiler.analyze(C.EXPRESSION, RT.second(form)));
            }
        }
    }

    public static class TryExpr
    implements Expr {
        public final Expr tryExpr;
        public final Expr finallyExpr;
        public final PersistentVector catchExprs;
        public final int retLocal;
        public final int finallyLocal;

        public TryExpr(Expr tryExpr, PersistentVector catchExprs, Expr finallyExpr, int retLocal, int finallyLocal) {
            this.tryExpr = tryExpr;
            this.catchExprs = catchExprs;
            this.finallyExpr = finallyExpr;
            this.retLocal = retLocal;
            this.finallyLocal = finallyLocal;
        }

        @Override
        public Object eval() {
            throw new UnsupportedOperationException("Can't eval try");
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            CatchClause clause;
            String e;
            Label startTry = gen.newLabel();
            Label endTry = gen.newLabel();
            Label end = gen.newLabel();
            Label ret = gen.newLabel();
            Label finallyLabel = gen.newLabel();
            int i = 0;
            while (i < this.catchExprs.count()) {
                CatchClause clause2 = (CatchClause)this.catchExprs.nth(i);
                clause2.label = gen.newLabel();
                clause2.endLabel = gen.newLabel();
                ++i;
            }
            String r = null;
            if (context == C.EXPRESSION) {
                r = Compiler.registerTemp();
                Compiler.emitSource("Object " + r + " = null;");
            }
            gen.mark(startTry);
            Compiler.emitSource("try {");
            Compiler.tab();
            if (this.catchExprs.count() > 0 && this.finallyExpr != null) {
                Compiler.emitSource("try {");
                Compiler.tab();
            }
            if ((e = this.tryExpr.emit(context, objx, gen)) != null) {
                Compiler.emitAssigRet(context, r, e);
            }
            if (context != C.STATEMENT) {
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), this.retLocal);
            }
            gen.mark(endTry);
            if (this.catchExprs.count() == 0) {
                Compiler.untab();
                Compiler.emitSource("} finally {");
                Compiler.tab();
            }
            if (this.finallyExpr != null) {
                String f;
                if (this.catchExprs.count() > 0) {
                    Compiler.untab();
                    Compiler.emitSource("} finally {");
                    Compiler.tab();
                }
                if ((f = this.finallyExpr.emit(C.STATEMENT, objx, gen)) != null) {
                    Compiler.emitAssigRet(context, r, f);
                }
                if (this.catchExprs.count() > 0) {
                    Compiler.untab();
                    Compiler.emitSource("}");
                }
            }
            Compiler.untab();
            Compiler.emitSource("}");
            gen.goTo(ret);
            if (this.catchExprs.count() > 0) {
                Compiler.emitSource("catch (Throwable ex___) {");
                Compiler.tab();
                int i2 = 0;
                while (i2 < this.catchExprs.count()) {
                    clause = (CatchClause)this.catchExprs.nth(i2);
                    gen.mark(clause.label);
                    String clazz = Compiler.printClass(clause.c);
                    Compiler.emitSource(String.valueOf(i2 > 0 ? "else " : "") + "if (ex___ instanceof " + clazz + ") {");
                    Compiler.tab();
                    Compiler.emitSource(String.valueOf(clazz) + " " + clause.lb.print() + " = (" + clazz + ") ex___;");
                    if (this.finallyExpr != null) {
                        Compiler.emitSource("try {");
                        Compiler.tab();
                    }
                    gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), clause.lb.idx);
                    String h = clause.handler.emit(context, objx, gen);
                    if (h != null) {
                        Compiler.emitAssigRet(context, r, h);
                    }
                    if (context != C.STATEMENT) {
                        gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), this.retLocal);
                    }
                    gen.mark(clause.endLabel);
                    if (this.finallyExpr != null) {
                        Compiler.untab();
                        Compiler.emitSource("} finally {");
                        Compiler.tab();
                        Compiler.emitSource(this.finallyExpr.emit(C.STATEMENT, objx, gen));
                        Compiler.untab();
                        Compiler.emitSource("}");
                    }
                    Compiler.untab();
                    Compiler.emitSource("}");
                    gen.goTo(ret);
                    ++i2;
                }
                Compiler.emitSource("else {");
                Compiler.tab();
                Compiler.emitSource("throw Util.sneakyThrow(ex___);");
                Compiler.untab();
                Compiler.emitSource("}");
                Compiler.untab();
                Compiler.emitSource("}");
            }
            if (this.finallyExpr != null) {
                gen.mark(finallyLabel);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), this.finallyLocal);
                Var.pushThreadBindings(RT.map(STOP_EMIT_SOURCE, true));
                this.finallyExpr.emit(C.STATEMENT, objx, gen);
                Var.popThreadBindings();
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(21), this.finallyLocal);
                gen.throwException();
            }
            gen.mark(ret);
            if (context != C.STATEMENT) {
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(21), this.retLocal);
            }
            gen.mark(end);
            int i3 = 0;
            while (i3 < this.catchExprs.count()) {
                clause = (CatchClause)this.catchExprs.nth(i3);
                gen.visitTryCatchBlock(startTry, endTry, clause.label, clause.c.getName().replace('.', '/'));
                ++i3;
            }
            if (this.finallyExpr != null) {
                gen.visitTryCatchBlock(startTry, endTry, finallyLabel, null);
                i3 = 0;
                while (i3 < this.catchExprs.count()) {
                    clause = (CatchClause)this.catchExprs.nth(i3);
                    gen.visitTryCatchBlock(clause.label, clause.endLabel, finallyLabel, null);
                    ++i3;
                }
            }
            i3 = 0;
            while (i3 < this.catchExprs.count()) {
                clause = (CatchClause)this.catchExprs.nth(i3);
                gen.visitLocalVariable(clause.lb.name, "Ljava/lang/Object;", null, clause.label, clause.endLabel, clause.lb.idx);
                ++i3;
            }
            return context == C.EXPRESSION ? r : "";
        }

        @Override
        public boolean hasJavaClass() {
            return this.tryExpr.hasJavaClass();
        }

        @Override
        public Class getJavaClass() {
            return this.tryExpr.getJavaClass();
        }

        public static class CatchClause {
            public final Class c;
            public final LocalBinding lb;
            public final Expr handler;
            Label label;
            Label endLabel;

            public CatchClause(Class c, LocalBinding lb, Expr handler) {
                this.c = c;
                this.lb = lb;
                this.handler = handler;
            }
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object frm) {
                ISeq form = (ISeq)frm;
                if (context != C.RETURN) {
                    return Compiler.analyze(context, RT.list(RT.list(FNONCE, PersistentVector.EMPTY, form)));
                }
                PersistentVector body = PersistentVector.EMPTY;
                PersistentVector catches = PersistentVector.EMPTY;
                Expr bodyExpr = null;
                Expr finallyExpr = null;
                boolean caught = false;
                int retLocal = Compiler.getAndIncLocalNum();
                int finallyLocal = Compiler.getAndIncLocalNum();
                ISeq fs = form.next();
                while (fs != null) {
                    Object op;
                    Object f = fs.first();
                    Object object = op = f instanceof ISeq ? ((ISeq)f).first() : null;
                    if (!Util.equals(op, CATCH) && !Util.equals(op, FINALLY)) {
                        if (caught) {
                            throw Util.runtimeException("Only catch or finally clause can follow catch in try expression");
                        }
                        body = body.cons(f);
                    } else {
                        if (bodyExpr == null) {
                            try {
                                Var.pushThreadBindings(RT.map(NO_RECUR, true));
                                bodyExpr = new BodyExpr.Parser().parse(context, RT.seq(body));
                            }
                            finally {
                                Var.popThreadBindings();
                            }
                        }
                        if (Util.equals(op, CATCH)) {
                            Class c = HostExpr.maybeClass(RT.second(f), false);
                            if (c == null) {
                                throw new IllegalArgumentException("Unable to resolve classname: " + RT.second(f));
                            }
                            if (!(RT.third(f) instanceof Symbol)) {
                                throw new IllegalArgumentException("Bad binding form, expected symbol, got: " + RT.third(f));
                            }
                            Symbol sym = (Symbol)RT.third(f);
                            if (sym.getNamespace() != null) {
                                throw Util.runtimeException("Can't bind qualified name:" + sym);
                            }
                            IPersistentMap dynamicBindings = RT.map(LOCAL_ENV, LOCAL_ENV.deref(), IN_CATCH_FINALLY, RT.T);
                            try {
                                Var.pushThreadBindings(dynamicBindings);
                                LocalBinding lb = Compiler.registerLocal(sym, (Symbol)(RT.second(f) instanceof Symbol ? RT.second(f) : null), null, false);
                                Expr handler = new BodyExpr.Parser().parse(C.EXPRESSION, RT.next(RT.next(RT.next(f))));
                                catches = catches.cons(new CatchClause(c, lb, handler));
                            }
                            finally {
                                Var.popThreadBindings();
                            }
                            caught = true;
                        } else {
                            if (fs.next() != null) {
                                throw Util.runtimeException("finally clause must be last in try expression");
                            }
                            try {
                                Var.pushThreadBindings(RT.map(IN_CATCH_FINALLY, RT.T));
                                finallyExpr = new BodyExpr.Parser().parse(C.STATEMENT, RT.next(f));
                            }
                            finally {
                                Var.popThreadBindings();
                            }
                        }
                    }
                    fs = fs.next();
                }
                if (bodyExpr == null) {
                    try {
                        Var.pushThreadBindings(RT.map(NO_RECUR, true));
                        bodyExpr = new BodyExpr.Parser().parse(C.EXPRESSION, RT.seq(body));
                    }
                    finally {
                        Var.popThreadBindings();
                    }
                }
                return new TryExpr(bodyExpr, catches, finallyExpr, retLocal, finallyLocal);
            }
        }
    }

    static class UnresolvedVarExpr
    implements Expr {
        public final Symbol symbol;

        public UnresolvedVarExpr(Symbol symbol) {
            this.symbol = symbol;
        }

        @Override
        public boolean hasJavaClass() {
            return false;
        }

        @Override
        public Class getJavaClass() {
            throw new IllegalArgumentException("UnresolvedVarExpr has no Java class");
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            throw new RuntimeException();
        }

        @Override
        public Object eval() {
            throw new IllegalArgumentException("UnresolvedVarExpr cannot be evalled");
        }
    }

    public static abstract class UntypedExpr
    implements Expr {
        @Override
        public Class getJavaClass() {
            throw new IllegalArgumentException("Has no Java class");
        }

        @Override
        public boolean hasJavaClass() {
            return false;
        }
    }

    public static class VarExpr
    implements Expr,
    AssignableExpr {
        public final Var var;
        public final Object tag;
        static final clojure.asm.commons.Method getMethod = clojure.asm.commons.Method.getMethod("Object get()");
        static final clojure.asm.commons.Method setMethod = clojure.asm.commons.Method.getMethod("Object set(Object)");

        public VarExpr(Var var, Symbol tag) {
            this.var = var;
            this.tag = tag != null ? tag : var.getTag();
        }

        @Override
        public Object eval() {
            return this.var.deref();
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            String val = objx.emitVarValue(gen, this.var);
            if (context == C.STATEMENT) {
                gen.pop();
                return "";
            }
            return Compiler.wrap(context, val);
        }

        @Override
        public boolean hasJavaClass() {
            return this.tag != null;
        }

        @Override
        public Class getJavaClass() {
            return HostExpr.tagToClass(this.tag);
        }

        @Override
        public Object evalAssign(Expr val) {
            return this.var.set(val.eval());
        }

        @Override
        public String emitAssign(C context, ObjExpr objx, GeneratorAdapter gen, Expr val) {
            String to = objx.emitVar(gen, this.var);
            String value = val.emit(C.EXPRESSION, objx, gen);
            gen.invokeVirtual(VAR_TYPE, setMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
            return Compiler.wrap(context, String.valueOf(to) + ".set(" + value + ")");
        }
    }

    public static class VectorExpr
    implements Expr {
        public final IPersistentVector args;
        static final clojure.asm.commons.Method vectorMethod = clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentVector vector(Object[])");

        public VectorExpr(IPersistentVector args) {
            this.args = args;
        }

        @Override
        public Object eval() {
            IPersistentVector ret = PersistentVector.EMPTY;
            int i = 0;
            while (i < this.args.count()) {
                ret = ret.cons(((Expr)this.args.nth(i)).eval());
                ++i;
            }
            return ret;
        }

        @Override
        public String emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            String val = MethodExpr.emitArgsAsArray(this.args, objx, gen);
            gen.invokeStatic(RT_TYPE, vectorMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
            if (val.equals("null")) {
                return Compiler.wrap(context, "RT.vector().cons(null)");
            }
            return Compiler.wrap(context, "RT.vector(" + val + ")");
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return IPersistentVector.class;
        }

        public static Expr parse(C context, IPersistentVector form) {
            boolean constant = true;
            IPersistentVector args = PersistentVector.EMPTY;
            int i = 0;
            while (i < form.count()) {
                Expr v = Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, form.nth(i));
                args = args.cons(v);
                if (!(v instanceof LiteralExpr)) {
                    constant = false;
                }
                ++i;
            }
            VectorExpr ret = new VectorExpr(args);
            if (form instanceof IObj && ((IObj)((Object)form)).meta() != null) {
                return new MetaExpr(ret, MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)((Object)form)).meta()));
            }
            if (constant) {
                PersistentVector rv = PersistentVector.EMPTY;
                int i2 = 0;
                while (i2 < args.count()) {
                    LiteralExpr ve = (LiteralExpr)args.nth(i2);
                    rv = rv.cons(ve.val());
                    ++i2;
                }
                return new ConstantExpr(rv);
            }
            return ret;
        }
    }
}

