// Compiled by ClojureScript 1.9.521 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs_time.internal.parse');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs_time.internal.core');
goog.require('clojure.string');
goog.require('goog.date.Date');
goog.require('goog.date.DateTime');
goog.require('goog.date.UtcDateTime');
goog.require('goog.date.Interval');
cljs_time.internal.parse.replace = (function cljs_time$internal$parse$replace(s,match,replacement){
return clojure.string.replace(((typeof s === 'string')?s:clojure.string.join.cljs$core$IFn$_invoke$arity$1(s)),match,replacement);
});
cljs_time.internal.parse.token = (function cljs_time$internal$parse$token(s){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$token,s], null);
});
cljs_time.internal.parse.quoted = (function cljs_time$internal$parse$quoted(s){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$quoted,s], null);
});
cljs_time.internal.parse.read_while = (function cljs_time$internal$parse$read_while(pred,s){
var G__16781 = s;
var vec__16782 = G__16781;
var seq__16783 = cljs.core.seq(vec__16782);
var first__16784 = cljs.core.first(seq__16783);
var seq__16783__$1 = cljs.core.next(seq__16783);
var h = first__16784;
var more = seq__16783__$1;
var s__$1 = vec__16782;
var out = cljs.core.PersistentVector.EMPTY;
var G__16781__$1 = G__16781;
var out__$1 = out;
while(true){
var vec__16785 = G__16781__$1;
var seq__16786 = cljs.core.seq(vec__16785);
var first__16787 = cljs.core.first(seq__16786);
var seq__16786__$1 = cljs.core.next(seq__16786);
var h__$1 = first__16787;
var more__$1 = seq__16786__$1;
var s__$2 = vec__16785;
var out__$2 = out__$1;
if(cljs.core.truth_((function (){var and__7717__auto__ = h__$1;
if(cljs.core.truth_(and__7717__auto__)){
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(h__$1) : pred.call(null,h__$1));
} else {
return and__7717__auto__;
}
})())){
var G__16788 = more__$1;
var G__16789 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out__$2,h__$1);
G__16781__$1 = G__16788;
out__$1 = G__16789;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [out__$2,s__$2], null);
}
break;
}
});
cljs_time.internal.parse.read_token = (function cljs_time$internal$parse$read_token(ch,s){
var vec__16793 = cljs_time.internal.parse.read_while(cljs.core.PersistentHashSet.createAsIfByAssoc([ch], true),s);
var end = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16793,(0),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16793,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs_time.internal.parse.token(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.str,ch,end)),s__$1], null);
});
cljs_time.internal.parse.read_quoted = (function cljs_time$internal$parse$read_quoted(_,p__16796){
var vec__16803 = p__16796;
var seq__16804 = cljs.core.seq(vec__16803);
var first__16805 = cljs.core.first(seq__16804);
var seq__16804__$1 = cljs.core.next(seq__16804);
var h = first__16805;
var more = seq__16804__$1;
var s = vec__16803;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(h,"'")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs_time.internal.parse.quoted("'"),more], null);
} else {
var vec__16806 = cljs_time.internal.parse.read_while(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["'",null], null), null)),s);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16806,(0),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16806,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs_time.internal.parse.quoted(q),cljs.core.rest(s__$1)], null);
}
});
cljs_time.internal.parse.read_punctuation = (function cljs_time$internal$parse$read_punctuation(ch,s){
var vec__16813 = cljs_time.internal.parse.read_while((function (p1__16809_SHARP_){
return cljs.core.not(cljs.core.re_find(/[a-zA-Z']/,p1__16809_SHARP_));
}),s);
var end = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16813,(0),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16813,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs_time.internal.parse.quoted(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.str,ch,end)),s__$1], null);
});
cljs_time.internal.parse.read_match = (function cljs_time$internal$parse$read_match(match,ch,s){
var c = (cljs.core.count(match) - (1));
var sub = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),c))].join('');
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(match,sub)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sub,cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,c,cljs.core.count(s))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join('')], null);
}
});
cljs_time.internal.parse.alpha_QMARK_ = (function cljs_time$internal$parse$alpha_QMARK_(ch){
return cljs.core.re_find(/[a-zA-Z]/,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch)].join(''));
});
cljs_time.internal.parse.read = (function cljs_time$internal$parse$read(s){
var vec__16819 = s;
var seq__16820 = cljs.core.seq(vec__16819);
var first__16821 = cljs.core.first(seq__16820);
var seq__16820__$1 = cljs.core.next(seq__16820);
var h = first__16821;
var more = seq__16820__$1;
var f = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(h,"'"))?cljs_time.internal.parse.read_quoted:(cljs.core.truth_(cljs_time.internal.parse.alpha_QMARK_(h))?cljs_time.internal.parse.read_token:cljs_time.internal.parse.read_punctuation
));
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(h,more) : f.call(null,h,more));
});
cljs_time.internal.parse.read_pattern = (function cljs_time$internal$parse$read_pattern(s){
var s__$1 = s;
var out = cljs.core.PersistentVector.EMPTY;
while(true){
var vec__16825 = cljs_time.internal.parse.read(s__$1);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16825,(0),null);
var s__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16825,(1),null);
var out__$1 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,h);
if(cljs.core.seq(s__$2)){
var G__16828 = s__$2;
var G__16829 = out__$1;
s__$1 = G__16828;
out = G__16829;
continue;
} else {
return out__$1;
}
break;
}
});
cljs_time.internal.parse.parse_match = (function cljs_time$internal$parse$parse_match(s,key,match){
var vec__16833 = cljs_time.internal.parse.read_match(match,cljs.core.first(s),clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.rest(s)));
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16833,(0),null);
var s_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16833,(1),null);
if(cljs.core.truth_(m)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,m], null),s_SINGLEQUOTE_], null);
} else {
return null;
}
});
cljs_time.internal.parse.parse_number = (function cljs_time$internal$parse$parse_number(var_args){
var args16837 = [];
var len__8950__auto___16845 = arguments.length;
var i__8951__auto___16846 = (0);
while(true){
if((i__8951__auto___16846 < len__8950__auto___16845)){
args16837.push((arguments[i__8951__auto___16846]));

var G__16847 = (i__8951__auto___16846 + (1));
i__8951__auto___16846 = G__16847;
continue;
} else {
}
break;
}

var G__16839 = args16837.length;
switch (G__16839) {
case 2:
return cljs_time.internal.parse.parse_number.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs_time.internal.parse.parse_number.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args16837.length)].join('')));

}
});

cljs_time.internal.parse.parse_number.cljs$core$IFn$_invoke$arity$2 = (function (s,limit){
return cljs_time.internal.parse.parse_number.cljs$core$IFn$_invoke$arity$3(s,(1),limit);
});

cljs_time.internal.parse.parse_number.cljs$core$IFn$_invoke$arity$3 = (function (s,lower,upper){
var vec__16840 = cljs_time.internal.parse.read_while((function (p1__16836_SHARP_){
return cljs.core.re_find(/\d/,p1__16836_SHARP_);
}),s);
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16840,(0),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16840,(1),null);
if((cljs.core.count(n) >= lower)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__16843 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take.cljs$core$IFn$_invoke$arity$2(upper,n));
return parseInt(G__16843);
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(upper,n),s__$1)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__16844 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,n);
return parseInt(G__16844);
})(),s__$1], null);
}
});

cljs_time.internal.parse.parse_number.cljs$lang$maxFixedArity = 3;

cljs_time.internal.parse.parse_period = (function cljs_time$internal$parse$parse_period(var_args){
var args16849 = [];
var len__8950__auto___16855 = arguments.length;
var i__8951__auto___16856 = (0);
while(true){
if((i__8951__auto___16856 < len__8950__auto___16855)){
args16849.push((arguments[i__8951__auto___16856]));

var G__16857 = (i__8951__auto___16856 + (1));
i__8951__auto___16856 = G__16857;
continue;
} else {
}
break;
}

var G__16851 = args16849.length;
switch (G__16851) {
case 3:
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args16849.length)].join('')));

}
});

cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$3 = (function (s,period,limit){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,period,(1),limit);
});

cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4 = (function (s,period,lower,upper){
var vec__16852 = cljs_time.internal.parse.parse_number.cljs$core$IFn$_invoke$arity$3(s,lower,upper);
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16852,(0),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16852,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [period,n], null),s__$1], null);
});

cljs_time.internal.parse.parse_period.cljs$lang$maxFixedArity = 4;

cljs_time.internal.parse.parse_year = (function cljs_time$internal$parse$parse_year(var_args){
var args16859 = [];
var len__8950__auto___16862 = arguments.length;
var i__8951__auto___16863 = (0);
while(true){
if((i__8951__auto___16863 < len__8950__auto___16862)){
args16859.push((arguments[i__8951__auto___16863]));

var G__16864 = (i__8951__auto___16863 + (1));
i__8951__auto___16863 = G__16864;
continue;
} else {
}
break;
}

var G__16861 = args16859.length;
switch (G__16861) {
case 1:
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args16859.length)].join('')));

}
});

cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$years,lower,upper);
});
});

cljs_time.internal.parse.parse_year.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_weekyear = (function cljs_time$internal$parse$parse_weekyear(var_args){
var args16866 = [];
var len__8950__auto___16869 = arguments.length;
var i__8951__auto___16870 = (0);
while(true){
if((i__8951__auto___16870 < len__8950__auto___16869)){
args16866.push((arguments[i__8951__auto___16870]));

var G__16871 = (i__8951__auto___16870 + (1));
i__8951__auto___16870 = G__16871;
continue;
} else {
}
break;
}

var G__16868 = args16866.length;
switch (G__16868) {
case 1:
return cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args16866.length)].join('')));

}
});

cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$weekyear,lower,upper);
});
});

cljs_time.internal.parse.parse_weekyear.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_weekyear_week = (function cljs_time$internal$parse$parse_weekyear_week(var_args){
var args16873 = [];
var len__8950__auto___16876 = arguments.length;
var i__8951__auto___16877 = (0);
while(true){
if((i__8951__auto___16877 < len__8950__auto___16876)){
args16873.push((arguments[i__8951__auto___16877]));

var G__16878 = (i__8951__auto___16877 + (1));
i__8951__auto___16877 = G__16878;
continue;
} else {
}
break;
}

var G__16875 = args16873.length;
switch (G__16875) {
case 1:
return cljs_time.internal.parse.parse_weekyear_week.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_weekyear_week.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args16873.length)].join('')));

}
});

cljs_time.internal.parse.parse_weekyear_week.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_weekyear_week.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$weekyear_DASH_week,lower,upper);
});
});

cljs_time.internal.parse.parse_weekyear_week.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_month = (function cljs_time$internal$parse$parse_month(var_args){
var args16880 = [];
var len__8950__auto___16883 = arguments.length;
var i__8951__auto___16884 = (0);
while(true){
if((i__8951__auto___16884 < len__8950__auto___16883)){
args16880.push((arguments[i__8951__auto___16884]));

var G__16885 = (i__8951__auto___16884 + (1));
i__8951__auto___16884 = G__16885;
continue;
} else {
}
break;
}

var G__16882 = args16880.length;
switch (G__16882) {
case 1:
return cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args16880.length)].join('')));

}
});

cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$months,lower,upper);
});
});

cljs_time.internal.parse.parse_month.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_day = (function cljs_time$internal$parse$parse_day(var_args){
var args16887 = [];
var len__8950__auto___16890 = arguments.length;
var i__8951__auto___16891 = (0);
while(true){
if((i__8951__auto___16891 < len__8950__auto___16890)){
args16887.push((arguments[i__8951__auto___16891]));

var G__16892 = (i__8951__auto___16891 + (1));
i__8951__auto___16891 = G__16892;
continue;
} else {
}
break;
}

var G__16889 = args16887.length;
switch (G__16889) {
case 1:
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args16887.length)].join('')));

}
});

cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$days,lower,upper);
});
});

cljs_time.internal.parse.parse_day.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_hours = (function cljs_time$internal$parse$parse_hours(var_args){
var args16894 = [];
var len__8950__auto___16897 = arguments.length;
var i__8951__auto___16898 = (0);
while(true){
if((i__8951__auto___16898 < len__8950__auto___16897)){
args16894.push((arguments[i__8951__auto___16898]));

var G__16899 = (i__8951__auto___16898 + (1));
i__8951__auto___16898 = G__16899;
continue;
} else {
}
break;
}

var G__16896 = args16894.length;
switch (G__16896) {
case 1:
return cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args16894.length)].join('')));

}
});

cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$hours,lower,upper);
});
});

cljs_time.internal.parse.parse_hours.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_HOURS = (function cljs_time$internal$parse$parse_HOURS(var_args){
var args16901 = [];
var len__8950__auto___16904 = arguments.length;
var i__8951__auto___16905 = (0);
while(true){
if((i__8951__auto___16905 < len__8950__auto___16904)){
args16901.push((arguments[i__8951__auto___16905]));

var G__16906 = (i__8951__auto___16905 + (1));
i__8951__auto___16905 = G__16906;
continue;
} else {
}
break;
}

var G__16903 = args16901.length;
switch (G__16903) {
case 1:
return cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args16901.length)].join('')));

}
});

cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$HOURS,lower,upper);
});
});

cljs_time.internal.parse.parse_HOURS.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_minutes = (function cljs_time$internal$parse$parse_minutes(var_args){
var args16908 = [];
var len__8950__auto___16911 = arguments.length;
var i__8951__auto___16912 = (0);
while(true){
if((i__8951__auto___16912 < len__8950__auto___16911)){
args16908.push((arguments[i__8951__auto___16912]));

var G__16913 = (i__8951__auto___16912 + (1));
i__8951__auto___16912 = G__16913;
continue;
} else {
}
break;
}

var G__16910 = args16908.length;
switch (G__16910) {
case 1:
return cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args16908.length)].join('')));

}
});

cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$minutes,lower,upper);
});
});

cljs_time.internal.parse.parse_minutes.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_seconds = (function cljs_time$internal$parse$parse_seconds(var_args){
var args16915 = [];
var len__8950__auto___16918 = arguments.length;
var i__8951__auto___16919 = (0);
while(true){
if((i__8951__auto___16919 < len__8950__auto___16918)){
args16915.push((arguments[i__8951__auto___16919]));

var G__16920 = (i__8951__auto___16919 + (1));
i__8951__auto___16919 = G__16920;
continue;
} else {
}
break;
}

var G__16917 = args16915.length;
switch (G__16917) {
case 1:
return cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args16915.length)].join('')));

}
});

cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$seconds,lower,upper);
});
});

cljs_time.internal.parse.parse_seconds.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_millis = (function cljs_time$internal$parse$parse_millis(var_args){
var args16922 = [];
var len__8950__auto___16925 = arguments.length;
var i__8951__auto___16926 = (0);
while(true){
if((i__8951__auto___16926 < len__8950__auto___16925)){
args16922.push((arguments[i__8951__auto___16926]));

var G__16927 = (i__8951__auto___16926 + (1));
i__8951__auto___16926 = G__16927;
continue;
} else {
}
break;
}

var G__16924 = args16922.length;
switch (G__16924) {
case 1:
return cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args16922.length)].join('')));

}
});

cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$millis,lower,upper);
});
});

cljs_time.internal.parse.parse_millis.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.timezone_adj = (function cljs_time$internal$parse$timezone_adj(sign,hh,mm){
var hh__$1 = parseInt(hh,(10));
var mm__$1 = parseInt(mm,(10));
var mins = ((hh__$1 * (60)) + mm__$1);
var adj_fn = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sign,"+"))?cljs.core._:cljs.core._PLUS_);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$timezone,(new goog.date.Interval(goog.date.Interval.MINUTES,(adj_fn.cljs$core$IFn$_invoke$arity$1 ? adj_fn.cljs$core$IFn$_invoke$arity$1(mins) : adj_fn.call(null,mins))))], null);
});
cljs_time.internal.parse.parse_timezone = (function cljs_time$internal$parse$parse_timezone(fmt){
return (function (s){
var vec__16946 = s;
var seq__16947 = cljs.core.seq(vec__16946);
var first__16948 = cljs.core.first(seq__16947);
var seq__16947__$1 = cljs.core.next(seq__16947);
var h = first__16948;
var more = seq__16947__$1;
var err = ((function (vec__16946,seq__16947,first__16948,seq__16947__$1,h,more){
return (function (){
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid timezone format: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,cljs.core.cst$kw$parse_DASH_error], null));
});})(vec__16946,seq__16947,first__16948,seq__16947__$1,h,more))
;
var dddd = ((function (vec__16946,seq__16947,first__16948,seq__16947__$1,h,more,err){
return (function (p1__16929_SHARP_){
var tz_QMARK_ = clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.take.cljs$core$IFn$_invoke$arity$2((4),more));
var temp__6738__auto__ = cljs.core.re_find(/^(\d{2})(\d{2})/,tz_QMARK_);
if(cljs.core.truth_(temp__6738__auto__)){
var vec__16949 = temp__6738__auto__;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16949,(0),null);
var hh = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16949,(1),null);
var mm = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16949,(2),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs_time.internal.parse.timezone_adj(p1__16929_SHARP_,hh,mm),cljs.core.drop.cljs$core$IFn$_invoke$arity$2((4),more)], null);
} else {
return null;
}
});})(vec__16946,seq__16947,first__16948,seq__16947__$1,h,more,err))
;
var long$ = ((function (vec__16946,seq__16947,first__16948,seq__16947__$1,h,more,err,dddd){
return (function (p1__16930_SHARP_){
var tz_QMARK_ = clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.take.cljs$core$IFn$_invoke$arity$2((5),more));
var temp__6738__auto__ = cljs.core.re_find(/^(\d{2}):(\d{2})/,tz_QMARK_);
if(cljs.core.truth_(temp__6738__auto__)){
var vec__16952 = temp__6738__auto__;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16952,(0),null);
var hh = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16952,(1),null);
var mm = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16952,(2),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs_time.internal.parse.timezone_adj(p1__16930_SHARP_,hh,mm),cljs.core.drop.cljs$core$IFn$_invoke$arity$2((5),more)], null);
} else {
return null;
}
});})(vec__16946,seq__16947,first__16948,seq__16947__$1,h,more,err,dddd))
;
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["+",null,"-",null], null), null).call(null,h))){
var G__16955 = (((fmt instanceof cljs.core.Keyword))?fmt.fqn:null);
switch (G__16955) {
case "dddd":
var or__7729__auto__ = dddd(h);
if(cljs.core.truth_(or__7729__auto__)){
return or__7729__auto__;
} else {
var or__7729__auto____$1 = long$(h);
if(cljs.core.truth_(or__7729__auto____$1)){
return or__7729__auto____$1;
} else {
throw err();
}
}

break;
case "long":
var or__7729__auto__ = dddd(h);
if(cljs.core.truth_(or__7729__auto__)){
return or__7729__auto__;
} else {
var or__7729__auto____$1 = long$(h);
if(cljs.core.truth_(or__7729__auto____$1)){
return or__7729__auto____$1;
} else {
throw err();
}
}

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fmt)].join('')));

}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(h,"Z")){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$timezone,cljs_time.internal.parse.timezone_adj(cljs.core._PLUS_,"0","0")], null)], null);
} else {
var G__16956 = (((fmt instanceof cljs.core.Keyword))?fmt.fqn:null);
switch (G__16956) {
case "abbr":
var tz_QMARK_ = cljs.core.take.cljs$core$IFn$_invoke$arity$2((3),s);
var vec__16957 = cljs_time.internal.parse.read_while(((function (tz_QMARK_,G__16956,vec__16946,seq__16947,first__16948,seq__16947__$1,h,more,err,dddd,long$){
return (function (p1__16931_SHARP_){
return cljs.core.re_find(/[A-Z]/,p1__16931_SHARP_);
});})(tz_QMARK_,G__16956,vec__16946,seq__16947,first__16948,seq__16947__$1,h,more,err,dddd,long$))
,tz_QMARK_);
var tz = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16957,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16957,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(tz),(3))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$timezone,clojure.string.join.cljs$core$IFn$_invoke$arity$1(tz)], null),cljs.core.drop.cljs$core$IFn$_invoke$arity$2((3),s)], null);
} else {
throw err();
}

break;
case "full":
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Cannot parse long form timezone:"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,cljs.core.cst$kw$parse_DASH_error], null));

break;
default:
throw err();

}

}
}
});
});
cljs_time.internal.parse.parse_meridiem = (function cljs_time$internal$parse$parse_meridiem(){
return (function (s){
var vec__16971 = cljs.core.split_at((2),s);
var vec__16974 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16971,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16974,(0),null);
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16974,(1),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16971,(1),null);
var meridiem = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(m),cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join('');
var vec__16977 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, ["AM",null,"am",null,"pm",null,"PM",null], null), null).call(null,meridiem))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [meridiem,s__$1], null):(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["a",null,"p",null], null), null).call(null,m))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, ["a","am","p","pm"], null).call(null,m),cljs.core.cons(n,s__$1)], null):(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["A",null,"P",null], null), null).call(null,m))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, ["A","am","P","pm"], null).call(null,m),cljs.core.cons(n,s__$1)], null):null)));
var meridiem__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16977,(0),null);
var s__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16977,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$meridiem,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(meridiem__$1)], null),clojure.string.join.cljs$core$IFn$_invoke$arity$1(s__$2)], null);
});
});
cljs_time.internal.parse.parse_period_name = (function cljs_time$internal$parse$parse_period_name(s,period,periods,short_QMARK_){
var periods__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(periods,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__16980_SHARP_){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(p1__16980_SHARP_,(0),(3));
}),periods));
var vec__16985 = cljs.core.first(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,s),cljs.core.second),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (periods__$1){
return (function (p1__16981_SHARP_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16981_SHARP_,cljs_time.internal.parse.replace(s,cljs.core.re_pattern([cljs.core.str.cljs$core$IFn$_invoke$arity$1("^"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16981_SHARP_)].join('')),"")], null);
});})(periods__$1))
,periods__$1)));
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16985,(0),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16985,(1),null);
if(cljs.core.truth_(m)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [period,cljs.core.mod(cljs_time.internal.core.index_of(periods__$1,m),(12))], null),s__$1], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Could not parse "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(period)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" name")].join(''),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$parse_DASH_error,cljs.core.cst$kw$sub_DASH_type,cljs.core.cst$kw$period_DASH_match_DASH_erroro,cljs.core.cst$kw$period,period,cljs.core.cst$kw$in,s__$1], null));
}
});
cljs_time.internal.parse.parse_month_name = (function cljs_time$internal$parse$parse_month_name(short_QMARK_){
return (function (s){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs_time.internal.parse.parse_period_name(s,cljs.core.cst$kw$months,cljs_time.internal.core.months,short_QMARK_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null),cljs.core.inc);
});
});
cljs_time.internal.parse.parse_day_name = (function cljs_time$internal$parse$parse_day_name(short_QMARK_){
return (function (s){
return cljs_time.internal.parse.parse_period_name(s,cljs.core.cst$kw$days,cljs_time.internal.core.days,short_QMARK_);
});
});
cljs_time.internal.parse.parse_quoted = (function cljs_time$internal$parse$parse_quoted(quoted){
return (function (s){
var s_SINGLEQUOTE_ = cljs_time.internal.parse.replace(s,cljs.core.re_pattern([cljs.core.str.cljs$core$IFn$_invoke$arity$1("^"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(quoted)].join('')),"");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(s,s_SINGLEQUOTE_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Quoted text not found",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,cljs.core.cst$kw$parse_DASH_error,cljs.core.cst$kw$where,cljs.core.cst$kw$parse_DASH_quoted], null));
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$quoted,quoted], null),s_SINGLEQUOTE_], null);
}
});
});
cljs_time.internal.parse.parse_ordinal_suffix = (function cljs_time$internal$parse$parse_ordinal_suffix(){
return (function (s){
var or__7729__auto__ = cljs_time.internal.parse.parse_match(s,cljs.core.cst$kw$ordinal_DASH_suffix,"st");
if(cljs.core.truth_(or__7729__auto__)){
return or__7729__auto__;
} else {
var or__7729__auto____$1 = cljs_time.internal.parse.parse_match(s,cljs.core.cst$kw$ordinal_DASH_suffix,"nd");
if(cljs.core.truth_(or__7729__auto____$1)){
return or__7729__auto____$1;
} else {
var or__7729__auto____$2 = cljs_time.internal.parse.parse_match(s,cljs.core.cst$kw$ordinal_DASH_suffix,"rd");
if(cljs.core.truth_(or__7729__auto____$2)){
return or__7729__auto____$2;
} else {
return cljs_time.internal.parse.parse_match(s,cljs.core.cst$kw$ordinal_DASH_suffix,"th");
}
}
}
});
});
cljs_time.internal.parse.lookup = (function cljs_time$internal$parse$lookup(p__16988){
var vec__16993 = p__16988;
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16993,(0),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16993,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.cst$kw$token)){
var G__16996 = pattern;
switch (G__16996) {
case "S":
return cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "SSS":
return cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$2((3),(3));

break;
case "s":
return cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "ss":
return cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "m":
return cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "mm":
return cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "h":
return cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "hh":
return cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "H":
return cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "HH":
return cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "d":
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "dd":
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "D":
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((1),(3));

break;
case "DD":
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((2),(3));

break;
case "DDD":
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((3),(3));

break;
case "M":
return cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "MM":
return cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "MMM":
return cljs_time.internal.parse.parse_month_name(true);

break;
case "MMMM":
return cljs_time.internal.parse.parse_month_name(false);

break;
case "y":
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((1),(4));

break;
case "yy":
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "yyyy":
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((4),(4));

break;
case "Y":
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((1),(4));

break;
case "YY":
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "YYYY":
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((4),(4));

break;
case "x":
return cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$2((1),(4));

break;
case "xx":
return cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "xxxx":
return cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$2((4),(4));

break;
case "w":
return cljs_time.internal.parse.parse_weekyear_week.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "ww":
return cljs_time.internal.parse.parse_weekyear_week.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "E":
return cljs_time.internal.parse.parse_day_name(true);

break;
case "EEE":
return cljs_time.internal.parse.parse_day_name(true);

break;
case "EEEE":
return cljs_time.internal.parse.parse_day_name(false);

break;
case "a":
return cljs_time.internal.parse.parse_meridiem();

break;
case "A":
return cljs_time.internal.parse.parse_meridiem();

break;
case "Z":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$dddd);

break;
case "ZZ":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$long);

break;
case "ZZZ":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$abbr);

break;
case "ZZZZ":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$abbr);

break;
case "z":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$abbr);

break;
case "zz":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$abbr);

break;
case "zzz":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$abbr);

break;
case "zzzz":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$full);

break;
case "o":
return cljs_time.internal.parse.parse_ordinal_suffix();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Illegal pattern component: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(pattern)].join(''),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,cljs.core.cst$kw$illegal_DASH_pattern], null));

}
} else {
return cljs_time.internal.parse.parse_quoted(pattern);
}
});
cljs_time.internal.parse.parse = (function cljs_time$internal$parse$parse(pattern,value){
var s = value;
var G__17014 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_time.internal.parse.lookup,cljs_time.internal.parse.read_pattern(pattern));
var vec__17015 = G__17014;
var seq__17016 = cljs.core.seq(vec__17015);
var first__17017 = cljs.core.first(seq__17016);
var seq__17016__$1 = cljs.core.next(seq__17016);
var parser = first__17017;
var more = seq__17016__$1;
var out = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
var G__17014__$1 = G__17014;
var out__$1 = out;
while(true){
var s__$2 = s__$1;
var vec__17018 = G__17014__$1;
var seq__17019 = cljs.core.seq(vec__17018);
var first__17020 = cljs.core.first(seq__17019);
var seq__17019__$1 = cljs.core.next(seq__17019);
var parser__$1 = first__17020;
var more__$1 = seq__17019__$1;
var out__$2 = out__$1;
var err = ((function (s__$1,G__17014__$1,out__$1,s__$2,vec__17018,seq__17019,first__17020,seq__17019__$1,parser__$1,more__$1,out__$2,s,G__17014,vec__17015,seq__17016,first__17017,seq__17016__$1,parser,more,out){
return (function (){
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid format: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" is malformed at "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([s__$2], 0)))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,cljs.core.cst$kw$parse_DASH_error,cljs.core.cst$kw$sub_DASH_type,cljs.core.cst$kw$invalid_DASH_format], null));
});})(s__$1,G__17014__$1,out__$1,s__$2,vec__17018,seq__17019,first__17020,seq__17019__$1,parser__$1,more__$1,out__$2,s,G__17014,vec__17015,seq__17016,first__17017,seq__17016__$1,parser,more,out))
;
if(cljs.core.seq(s__$2)){
if((parser__$1 == null)){
throw err();
} else {
var vec__17021 = (parser__$1.cljs$core$IFn$_invoke$arity$1 ? parser__$1.cljs$core$IFn$_invoke$arity$1(s__$2) : parser__$1.call(null,s__$2));
var value__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17021,(0),null);
var s__$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17021,(1),null);
var G__17024 = s__$3;
var G__17025 = more__$1;
var G__17026 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out__$2,value__$1);
s__$1 = G__17024;
G__17014__$1 = G__17025;
out__$1 = G__17026;
continue;
}
} else {
if(cljs.core.truth_(parser__$1)){
throw err();
} else {
return out__$2;
}
}
break;
}
});
cljs_time.internal.parse.compile = (function cljs_time$internal$parse$compile(class$,p__17027,values){
var map__17034 = p__17027;
var map__17034__$1 = ((((!((map__17034 == null)))?((((map__17034.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17034.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17034):map__17034);
var fmt = map__17034__$1;
var default_year = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17034__$1,cljs.core.cst$kw$default_DASH_year);
var map__17036 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$quoted,null], null), null),cljs.core.first),values));
var map__17036__$1 = ((((!((map__17036 == null)))?((((map__17036.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17036.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17036):map__17036);
var date_map = map__17036__$1;
var minutes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17036__$1,cljs.core.cst$kw$minutes);
var HOURS = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17036__$1,cljs.core.cst$kw$HOURS);
var millis = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17036__$1,cljs.core.cst$kw$millis);
var timezone = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17036__$1,cljs.core.cst$kw$timezone);
var meridiem = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17036__$1,cljs.core.cst$kw$meridiem);
var months = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17036__$1,cljs.core.cst$kw$months);
var days = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17036__$1,cljs.core.cst$kw$days);
var seconds = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17036__$1,cljs.core.cst$kw$seconds);
var hours = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17036__$1,cljs.core.cst$kw$hours);
var years = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17036__$1,cljs.core.cst$kw$years);
var years__$1 = (function (){var or__7729__auto__ = years;
if(cljs.core.truth_(or__7729__auto__)){
return or__7729__auto__;
} else {
var or__7729__auto____$1 = default_year;
if(cljs.core.truth_(or__7729__auto____$1)){
return or__7729__auto____$1;
} else {
return (0);
}
}
})();
var months__$1 = (cljs.core.truth_(months)?(months - (1)):null);
var hours__$1 = (cljs.core.truth_(meridiem)?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$PM,null,cljs.core.cst$kw$pm,null], null), null).call(null,meridiem))?(function (){var hours__$1 = (hours + (12));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hours__$1,(24))){
return (12);
} else {
return hours__$1;
}
})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hours,(12)))?(0):hours)):HOURS);
var date_map__$1 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(date_map,cljs.core.cst$kw$hours,hours__$1),cljs.core.cst$kw$HOURS,cljs.core.array_seq([cljs.core.cst$kw$meridiem], 0));
var timezone__$1 = (((timezone instanceof goog.date.Interval))?timezone:(new goog.date.Interval(goog.date.Interval.SECONDS,(0))));
cljs_time.internal.core.valid_date_QMARK_(date_map__$1);

var G__17038 = (function (){var G__17039 = (((class$ instanceof cljs.core.Keyword))?class$.fqn:null);
switch (G__17039) {
case "goog.date.Date":
return (new goog.date.Date(years__$1,months__$1,days));

break;
case "goog.date.DateTime":
return (new goog.date.DateTime(years__$1,months__$1,days,hours__$1,minutes,seconds,millis));

break;
case "goog.date.UtcDateTime":
return (new goog.date.UtcDateTime(years__$1,months__$1,days,hours__$1,minutes,seconds,millis));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)].join('')));

}
})();
G__17038.add(timezone__$1);

return G__17038;
});
