// Compiled by ClojureScript 1.9.521 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs_time.coerce');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs_time.core');
goog.require('cljs_time.format');
goog.require('goog.date.UtcDateTime');

/**
 * @interface
 */
cljs_time.coerce.ICoerce = function(){};

/**
 * Convert `obj` to a goog.date.DateTime instance.
 */
cljs_time.coerce.to_date_time = (function cljs_time$coerce$to_date_time(obj){
if((!((obj == null))) && (!((obj.cljs_time$coerce$ICoerce$to_date_time$arity$1 == null)))){
return obj.cljs_time$coerce$ICoerce$to_date_time$arity$1(obj);
} else {
var x__8447__auto__ = (((obj == null))?null:obj);
var m__8448__auto__ = (cljs_time.coerce.to_date_time[goog.typeOf(x__8447__auto__)]);
if(!((m__8448__auto__ == null))){
return (m__8448__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8448__auto__.cljs$core$IFn$_invoke$arity$1(obj) : m__8448__auto__.call(null,obj));
} else {
var m__8448__auto____$1 = (cljs_time.coerce.to_date_time["_"]);
if(!((m__8448__auto____$1 == null))){
return (m__8448__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8448__auto____$1.cljs$core$IFn$_invoke$arity$1(obj) : m__8448__auto____$1.call(null,obj));
} else {
throw cljs.core.missing_protocol("ICoerce.to-date-time",obj);
}
}
}
});

/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.from_long = (function cljs_time$coerce$from_long(millis){
var G__17401 = millis;
if((G__17401 == null)){
return null;
} else {
return (goog.date.UtcDateTime.fromTimestamp.cljs$core$IFn$_invoke$arity$1 ? goog.date.UtcDateTime.fromTimestamp.cljs$core$IFn$_invoke$arity$1(G__17401) : goog.date.UtcDateTime.fromTimestamp.call(null,G__17401));
}
});
/**
 * Returns DateTime instance from string using formatters in cljs-time.format,
 *   returning first which parses
 */
cljs_time.coerce.from_string = (function cljs_time$coerce$from_string(s){
if(cljs.core.truth_(s)){
return cljs.core.first((function (){var iter__8591__auto__ = (function cljs_time$coerce$from_string_$_iter__17412(s__17413){
return (new cljs.core.LazySeq(null,(function (){
var s__17413__$1 = s__17413;
while(true){
var temp__6738__auto__ = cljs.core.seq(s__17413__$1);
if(temp__6738__auto__){
var s__17413__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_(s__17413__$2)){
var c__8589__auto__ = cljs.core.chunk_first(s__17413__$2);
var size__8590__auto__ = cljs.core.count(c__8589__auto__);
var b__17415 = cljs.core.chunk_buffer(size__8590__auto__);
if((function (){var i__17414 = (0);
while(true){
if((i__17414 < size__8590__auto__)){
var f = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__8589__auto__,i__17414);
var d = (function (){try{return cljs_time.format.parse.cljs$core$IFn$_invoke$arity$2(f,s);
}catch (e17420){if((e17420 instanceof Error)){
var _ = e17420;
return null;
} else {
throw e17420;

}
}})();
if(cljs.core.truth_(d)){
cljs.core.chunk_append(b__17415,d);

var G__17422 = (i__17414 + (1));
i__17414 = G__17422;
continue;
} else {
var G__17423 = (i__17414 + (1));
i__17414 = G__17423;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__17415),cljs_time$coerce$from_string_$_iter__17412(cljs.core.chunk_rest(s__17413__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__17415),null);
}
} else {
var f = cljs.core.first(s__17413__$2);
var d = (function (){try{return cljs_time.format.parse.cljs$core$IFn$_invoke$arity$2(f,s);
}catch (e17421){if((e17421 instanceof Error)){
var _ = e17421;
return null;
} else {
throw e17421;

}
}})();
if(cljs.core.truth_(d)){
return cljs.core.cons(d,cljs_time$coerce$from_string_$_iter__17412(cljs.core.rest(s__17413__$2)));
} else {
var G__17424 = cljs.core.rest(s__17413__$2);
s__17413__$1 = G__17424;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8591__auto__(cljs.core.vals(cljs_time.format.formatters));
})());
} else {
return null;
}
});
/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   js Date object.
 */
cljs_time.coerce.from_date = (function cljs_time$coerce$from_date(date){
var G__17426 = date;
var G__17426__$1 = (((G__17426 == null))?null:G__17426.getTime());
if((G__17426__$1 == null)){
return null;
} else {
return cljs_time.coerce.from_long(G__17426__$1);
}
});
/**
 * Convert `obj` to the number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.to_long = (function cljs_time$coerce$to_long(obj){
var G__17428 = obj;
var G__17428__$1 = (((G__17428 == null))?null:cljs_time.coerce.to_date_time(G__17428));
if((G__17428__$1 == null)){
return null;
} else {
return G__17428__$1.getTime();
}
});
/**
 * Convert `obj` to Unix epoch.
 */
cljs_time.coerce.to_epoch = (function cljs_time$coerce$to_epoch(obj){
var millis = cljs_time.coerce.to_long(obj);
var and__7717__auto__ = millis;
if(cljs.core.truth_(and__7717__auto__)){
return cljs.core.quot(millis,(1000));
} else {
return and__7717__auto__;
}
});
/**
 * Convert `obj` to a JavaScript Date instance.
 */
cljs_time.coerce.to_date = (function cljs_time$coerce$to_date(obj){
var G__17430 = obj;
var G__17430__$1 = (((G__17430 == null))?null:cljs_time.coerce.to_date_time(G__17430));
var G__17430__$2 = (((G__17430__$1 == null))?null:G__17430__$1.getTime());
if((G__17430__$2 == null)){
return null;
} else {
return (new Date(G__17430__$2));
}
});
/**
 * Returns a string representation of obj in UTC time-zone
 *   using "yyyy-MM-dd'T'HH:mm:ss.SSSZZ" date-time representation.
 */
cljs_time.coerce.to_string = (function cljs_time$coerce$to_string(obj){
var G__17432 = obj;
var G__17432__$1 = (((G__17432 == null))?null:cljs_time.coerce.to_date_time(G__17432));
if((G__17432__$1 == null)){
return null;
} else {
return cljs_time.format.unparse(cljs.core.cst$kw$date_DASH_time.cljs$core$IFn$_invoke$arity$1(cljs_time.format.formatters),G__17432__$1);
}
});
/**
 * Convert `obj` to a goog.date.Date instance
 */
cljs_time.coerce.to_local_date = (function cljs_time$coerce$to_local_date(obj){
if(cljs.core.truth_(obj)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(goog.date.Date,cljs.core.type(obj))){
return obj;
} else {
var temp__6736__auto__ = cljs_time.coerce.to_date_time(obj);
if(cljs.core.truth_(temp__6736__auto__)){
var dt = temp__6736__auto__;
return (new goog.date.Date(dt.getYear(),dt.getMonth(),dt.getDate()));
} else {
return null;
}
}
} else {
return null;
}
});
/**
 * Convert `obj` to a goog.date.DateTime instance
 */
cljs_time.coerce.to_local_date_time = (function cljs_time$coerce$to_local_date_time(obj){
if(cljs.core.truth_(obj)){
var temp__6736__auto__ = cljs_time.coerce.to_date_time(obj);
if(cljs.core.truth_(temp__6736__auto__)){
var dt = temp__6736__auto__;
var G__17434 = (new goog.date.DateTime(dt.getYear(),dt.getMonth(),dt.getDate()));
G__17434.setHours(dt.getHours());

G__17434.setMinutes(dt.getMinutes());

G__17434.setSeconds(dt.getSeconds());

G__17434.setMilliseconds(dt.getMilliseconds());

return G__17434;
} else {
return null;
}
} else {
return null;
}
});
(cljs_time.coerce.ICoerce["null"] = true);

(cljs_time.coerce.to_date_time["null"] = (function (_){
return null;
}));

Date.prototype.cljs_time$coerce$ICoerce$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date){
var date__$1 = this;
return cljs_time.coerce.from_date(date__$1);
});

goog.date.Date.prototype.cljs_time$coerce$ICoerce$ = cljs.core.PROTOCOL_SENTINEL;

goog.date.Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date){
var local_date__$1 = this;
if(cljs.core.truth_(local_date__$1)){
return cljs_time.core.to_utc_time_zone(local_date__$1);
} else {
return null;
}
});

goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$ = cljs.core.PROTOCOL_SENTINEL;

goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date_time){
var local_date_time__$1 = this;
if(cljs.core.truth_(local_date_time__$1)){
return cljs_time.core.to_utc_time_zone(local_date_time__$1);
} else {
return null;
}
});

goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$ = cljs.core.PROTOCOL_SENTINEL;

goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date_time){
var date_time__$1 = this;
return date_time__$1;
});

(cljs_time.coerce.ICoerce["number"] = true);

(cljs_time.coerce.to_date_time["number"] = (function (long$){
return cljs_time.coerce.from_long(long$);
}));

(cljs_time.coerce.ICoerce["string"] = true);

(cljs_time.coerce.to_date_time["string"] = (function (string){
return cljs_time.coerce.from_string(string);
}));
