(ns api.s3-test
  (:require [cljs.test :refer-macros [deftest is]]
            [api.s3 :as s3]
            [cljs-lambda.local :refer [invoke channel]]
            [cljs.core.async :as async :refer [<!]])
  (:require-macros [cljs.core.async.macros :refer [go]]
                   [api.util :refer [def-async-test]]))

(def sample "data:image/png;base64,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")

(deftest base64
  (is (= "image/png" (s3/base64-format sample))))

#_(def-async-test test-s3
  (println (<! (s3/upload "dynamic.tu.delivery" "test.png" sample))))
