(ns api.cookies
  (:require [clojure.string :as str]
            [goog.string :as gstring]))

(def set-cookie-attrs
  {:domain "Domain", :max-age "Max-Age", :path "Path"
   :secure "Secure", :expires "Expires", :http-only "HttpOnly"})

(defn- parse-cookie-header [header]
  (into {} (map #(let [[a b] (str/split % #"[=]" 2)]
                   [a b])
                (map str/trim (str/split header #"[;]")))))

(defn- strip-quotes [value] (if value (str/replace value #"^\"|\"$" "") ""))

(defn- decode-values [cookies decoder]
  (for [[name value] cookies]
    (if-let [value (decoder (strip-quotes value))]
      [name {:value value}])))

(defn- parse-cookies [request encoder]
  (if-let [cookie (get-in request [:headers :cookie])]
    (->> cookie
         parse-cookie-header
         ((fn [c] (decode-values c encoder)))
         (remove nil?)
         (into {}))
    {}))

(defn form-decode-str [^String encoded]
  #_(gstring/urlDecode) encoded)

(defn cookies-request [request]
  (assoc request :cookies (parse-cookies request form-decode-str)))
