(ns api.util)

(defmacro def-async-test [name & body]
  `(cljs.test/deftest ~name
     (cljs.test/async
      done#
      (cljs.core.async.macros/go
        ~@body
        (done#)))))

(defmacro is+
  ([expr]
   `(let [t# ~expr] (cljs.test/is t#)))
  ([desc expr]
   `(let [t# ~expr]
      (cljs.test/testing ~desc (cljs.test/is t#)))))
