(ns api.jwt-test
  (:require [cljs.test :refer-macros [deftest is]]
            [api.jwt :as jwt]
            [clojure.test.check :as tc]
            [clojure.test.check.generators :as gen]
            [clojure.test.check.properties :as prop :include-macros true]))

(def jwt-prop
  (prop/for-all
   [v (gen/map gen/keyword (gen/one-of [gen/string gen/int]))]
   (is (= v (dissoc (jwt/verify (jwt/sign v)) :iat)))))

(deftest test-jwt
  (tc/quick-check 20 jwt-prop))

(deftest test-jwt-expire
  (let [data {:iat (.floor js/Math (- (/ (.now js/Date) 1000) 30))}]
    (is (= data (dissoc (jwt/verify (jwt/sign data {:expiresIn "31s"})) :exp))))
  (let [data {:iat (.floor js/Math (- (/ (.now js/Date) 1000) 30))}]
    (is (nil? (jwt/verify (jwt/sign data {:expiresIn "30s"}))))))
