(ns api.remote
  (:require
   [api.util :as util]
   [api.http :as http]
   [reagent.core :as reagent]
   [api.crypto :as crypto]
   [cognitect.transit :as t]
   [re-frame.core :refer [reg-event-db path reg-sub dispatch dispatch-sync subscribe]]
   [cljs.core.async :as async :refer [chan close! put! <! timeout]]
   [cljs.spec.gen.alpha])
  (:require-macros [cljs.core.async.macros :refer [go alt!]]
                   [cljs.spec.gen.alpha :refer [dynaload]]))

(def api-caller (dynaload 'api.server/api-caller))

(defn GET [url]
  (go (let [{:keys [status data error]} (<! (http/GET-PLAIN url))]
        (if (= status :ok)
          data
          (js/Error. error)))))

(defn api-background
  ([path] (api-background path nil))
  ([path & params]
   (dispatch-sync [:loading])
   (go
     (let [r (@api-caller path (t/write (t/writer :json) (vec params)))
           {:keys [status body] :as all} (if (util/chan? r) (<! r) r)
           r (if (= status 200)
               (t/read (t/reader :json) (.toString (crypto/unzip body) "utf-8"))
               (let [body (t/read (t/reader :json) body)]
                 (when (= "Invalid token" body)
                   (dispatch-sync [:logout]))
                 nil))]
       (dispatch [:unloading])
       r))))

(defn api
  ([path] (api path nil))
  ([path & params]
   (go (<! (apply api-background path params)))))
