(ns api.athena
  (:require [cljs.nodejs :as nodejs]
            [api.util :as util]
            [api.aws :refer [AWS]]
            [cljs.core.async :as async])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(def lambda (let [l (.-Lambda AWS)] (new l)))

(defn query [q & [retries]]
  (let [ch (async/chan 1)]
    (.invoke lambda (clj->js {:FunctionName "athena"
                              :InvocationType "RequestResponse"
                              :LogType "Tail"
                              :Payload (pr-str q)})
             (fn [err data]
               (let [r (or err (js->clj
                                (.parse js/JSON (aget data "Payload"))
                                :keywordize-keys true))]
                 (if (and retries (pos? retries) (:error r))
                   (do
                     (println "RETRYING" retries q)
                     (go
                       (async/<! (async/timeout 250))
                       (async/>! ch (<! (query q (dec retries))))))
                   (async/put! ch r)))))
    ch))

(defn query-many [queries]
  (go
    (loop [[q & other] queries r []]
      (if q
        (recur other (conj r (async/<! (query q 10))))
        r))))
