(ns api.jwt
  (:require [eulalie.util :refer [env!]]
            [cljs.nodejs :as nodejs]))

(extend-type Keyword IEncodeJS
             (-clj->js [s]
               (let [n (namespace s)]
                 (str n (when n "/") (name s)))))

(def jwt (nodejs/require "jsonwebtoken"))

;; TODO check if this works
(def secret (or (env! "JWT_SECRET") "!!LOCALAPI!!"))

(def signer (when jwt (aget jwt "sign")))

(def verifier (when jwt (aget jwt "verify")))

(defn sign
  ([data] (sign data nil))
  ([data options]
   (signer (clj->js data) secret (clj->js options))))

(defn verify [token]
  (when token
    (try
      (js->clj (verifier token secret) :keywordize-keys true)
      (catch js/Error e
        nil))))
