(ns api.crypto-test
  (:require [api.crypto :as encr]
            [cljs.test :refer-macros [deftest is testing]]))

(def rsa-key (encr/gen-keys))

(deftest test-encrypt-decrypt
  (let [t "hello world"
        t (if (> (count t) 50) (subs t 0 50) t)]
    (is (= t (.toString (encr/decrypt
                         (:public rsa-key)
                         (encr/prencrypt (:private rsa-key) t))
                        "utf-8")))
    (is (= t (.toString (encr/prdecrypt
                         (:private rsa-key)
                         (encr/encrypt (:public rsa-key) t))
                        "utf-8")))))

(deftest test-aes
  (let [t "Hello world"
        k (encr/random-aes-key)]
    (is (= t (encr/aes-decrypt k (encr/aes-encrypt k t))))))

(deftest test-hcrypt
  (let [t "test"]
    (is (= t (encr/prhdecrypt
              (:private rsa-key)
              (encr/hencrypt (:public rsa-key) t))))
    (is (= t (encr/hdecrypt
              (:public rsa-key)
              (encr/prhencrypt (:private rsa-key) t))))))
