(ns api.cloudwatch
  (:require [cljs.nodejs :as nodejs]
            [cljs.core.async :as async]
            [api.aws :refer [AWS]]
            [api.util :as util])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(def CloudWatch (let [o (aget AWS "CloudWatch")] (new o #js {:region "us-east-1"})))

(defn put-metric [namespace & kv]
  (let [ch (async/chan 1)]
    (apply println "METRIC:" kv)
    (if (util/local?)
      (async/put! ch true)
      (.putMetricData
       CloudWatch
       (clj->js {:Namespace namespace
                 :MetricData (mapv (fn [[k v]] {:MetricName (name k)
                                                :Unit "Count"
                                                :Value v}) (partition 2 kv))})
       (fn [err data] (async/put! ch (or err data)))))
    ch))
