(defproject galdolber/api-common-server "0.1.12"
  :plugins [[lein-cljsbuild "1.1.7"]
            [lein-figwheel "0.5.13"]
            [lein-npm "0.6.2"]
            [lein-doo "0.1.7"]
            [io.nervous/cljs-nodejs-externs "0.2.0"]
            [io.nervous/lein-cljs-lambda "0.6.4"]]
  :jvm-opts ["-Xss16m" "-Xmx1024m"]
  :target-path "../target"
  :clean-targets ^{:protect false} ["../target"]
  :npm {:dependencies
        [[source-map-support "0.4.2"]
         [ws "1.1.1"]
         [aws-xray-sdk-core "1.1.2"]
         [libphonenumber-js "0.4.5"]
         [googleapis "14.2.0"]
         [node-rsa "0.4.2"]
         [redis "2.6.3"]
         [request "2.74.0"]
         [stacktrace-js "1.3.1"]
         [jsonwebtoken "7.1.9"]
         [deasync "0.1.9"]
         [react "15.6.1"]
         [react-dom "15.6.1"]
         [create-react-class "15.6.1"]
         [mime "1.3.4"]]}
  :source-paths ["." "../shared" "../test"]
  :cljsbuild
  {:builds
   [{:id "test"
     :incremental true
     :source-paths ["." "../shared" "../test"]
     :compiler {:output-to "../target/test/server-test.js"
                :output-dir "../target/test"
                :target :nodejs
                :warnings {:fn-deprecated false}
                :language-in :ecmascript5
                :parallel-build true
                :optimizations :none
                :main api.test-runner}}]}
  :dependencies
  [[org.clojure/clojure "1.9.0-alpha17"]
   [org.clojure/clojurescript "1.9.908"]
   [org.clojure/core.async "0.3.443"]
   [org.clojure/data.codec "0.1.0"]
   [org.clojure/test.check "0.10.0-alpha2"]
   [com.rpl/specter "1.0.3"]
   [com.cognitect/transit-cljs "0.8.239"]
   [com.cemerick/url "0.1.1"]
   [figwheel "0.5.13"]
   [bidi "2.1.2"]
   [reagent "0.7.0" :exclusions [cljsjs/react-dom cljsjs/react-dom-server]]
   [re-frame "0.10.1"]
   [hiccups "0.3.0"]
   [com.andrewmcveigh/cljs-time "0.5.1"]
   ;;[galdolber/cljs-time "0.5.0-SNAPSHOT2"]
   [thi.ng/color "1.2.0"]
   [honeysql "0.9.0"]
   [cljsjs/react-input-mask "0.8.0-0" :exclusions [cljsjs/react]]
   [cljsjs/facebook "v20150729-0"]
   [cljsjs/react-input-mask "0.8.0-0"]
   [cljsjs/google-maps "3.18-1"]
   [hiccups "0.3.0"]

   ;; TODO replace with manual implementation?
   [io.nervous/glossop "0.2.1"]
   [io.nervous/cljs-lambda "0.3.4" :exclusions [funcool/promesa]]
   [funcool/promesa "1.9.0"]
   [prismatic/schema "1.1.6"]
   [galdolber/hildebrand "0.4.4-1" :exclusions [prismatic/schema]]])
