;; RENAME FILE
(ns api.spec-macros
  (:require [cljs.spec.alpha :as s]
            [re-frame.core :refer
             [reg-event-db reg-event-fx path reg-sub reg-fx
              dispatch subscribe clear-event
              clear-sub clear-fx]]))

(def events (atom #{}))

#?(:clj
   (defn add-spec? []
     (= :none
        (:optimizations (:options @cljs.env/*compiler*)))))

(defmacro only-keys [& {:keys [req req-un opt opt-un] :as args}]
  `(cljs.spec.alpha/and
    (cljs.spec.alpha/keys ~@(apply concat (vec args)))
    (cljs.spec.alpha/map-of
     ~(set (concat req
                   (map (comp keyword name) req-un)
                   opt
                   (map (comp keyword name) opt-un)))
     any?)))

(defmacro def-keys [n & {:keys [req req-un opt opt-un] :as args}]
  (let [n-opt (keyword (namespace n) (str (name n) "-opt"))
        all-keys (set (concat req
                              (map (comp keyword name) req-un)
                              opt
                              (map (comp keyword name) opt-un)))]
    `(do (s/def ~n
           (cljs.spec.alpha/and
            (cljs.spec.alpha/keys ~@(apply concat (vec args)))
            (cljs.spec.alpha/map-of ~all-keys any?)))
         (s/def ~n-opt
           (cljs.spec.alpha/and
            (cljs.spec.alpha/keys :opt ~(into (or req []) opt)
                            :opt-un ~(into (or req-un []) opt-un))
            (cljs.spec.alpha/map-of ~all-keys any?))))))

(defmacro def-fx [n args & body]
  (let [kn (keyword (namespace n) (name n))
        nf (symbol (str (name n) "-fx"))]
    `(do
       (defn ~nf ~args ~@body)
       (reg-fx ~kn ~nf))))

#?(:clj
   (defmacro def-sub [n args & body]
     (let [kn (keyword (namespace n) (name n))
           nf (symbol (str (name n) "-sub"))
           {sret :ret sfn :fn sargs :args :as spec} (:spec (meta args))
           spec
           (when (add-spec?)
             [`(s/fdef
                ~nf
                :fn ~sfn
                :ret ~sret
                :args
                (s/cat :state :api.spec/state
                       :event (s/spec (s/cat :method #{~kn} ~@sargs))))])]
       `(do
          (defn ~nf ~args ~@body)
          (reg-sub ~kn ~nf)
          ;;~@spec
          ))))

#?(:clj
   (defmacro def-event-spec
     ([f] `(def-event-spec ~f {}))
     ([f {:keys [event ret db args-gen]
          :or {ret :api.spec/state
               event []
               db :api.spec/state}}]
      (let [method (keyword (namespace f) (name f))
            args-spec `(s/cat :method #{~method} ~@event)
            event `(s/cat :state ~db :event
                          (s/spec ~args-spec))
            args (if args-gen
                   `(s/with-gen ~event ~args-gen)
                   event)
            event-name (keyword "event" (name f))]
        (swap! events conj event-name)
        `(do
           (s/def ~event-name ~args-spec)
           (s/fdef ~f
                   :args ~args
                   :ret ~ret))))))

(defmacro def-event [n args & body]
  (let [kn (keyword (namespace n) (name n))
        nf (symbol (name n))
        spec (or (:spec (meta args)) {})
        db-sym (first args)
        other-args (next args)
        ignore-sym '_
        args `[~db-sym [~ignore-sym ~@other-args]]]
    `(do
       (defn ~nf ~args ~@body)
       (reg-event-db ~kn ~nf)
       ;;(def-event-spec ~nf ~spec)
       )))

#?(:clj
   (defmacro def-effect-spec
     ([f] `(def-effect-spec ~f {}))
     ([f {:keys [ret db]
           :or {ret :api.spec/effect
                db :api.spec/effect}
          :as m}]
      (let [m (assoc m :db db :ret ret)]
        `(def-event-spec ~f ~m)))))

(defmacro def-effect [n args & body]
  (let [kn (keyword (namespace n) (name n))
        nf (symbol (name n))
        spec (or (:spec (meta args)) {})
        fx-sym (first args)
        other-args (next args)
        ignore-sym '_
        args `[~fx-sym [~ignore-sym ~@other-args]]]
    `(do
       (defn ~nf ~args ~@body)
       (reg-event-fx ~kn ~nf)
       ;;(def-effect-spec ~nf ~spec)
       )))

(defmacro defentity [k & {:keys [req req-un opt opt-un] :as args}]
  (let [kp (keyword (str (subs (pr-str k) 1) "-base"))]
    `(do
       (cljs.spec.alpha/def ~kp
         (cljs.spec.alpha/keys ~@(apply concat (vec args))))
       (cljs.spec.alpha/def ~k
         (cljs.spec.alpha/and
          (cljs.spec.alpha/keys ~@(apply concat (vec args)))
          (cljs.spec.alpha/map-of
           ~(set (concat req
                         (map (comp keyword name) req-un)
                         opt
                         (map (comp keyword name) opt-un)))
           any?))))))

#?(:clj
   (defmacro get-events []
     (let [e @events]
       `~e)))


#?(:clj
   (defmacro event-spec []
     (let [e (reduce into [] (map (fn [e] [e e]) @events))]
       `(s/or ~@e))))

(defn find-symbol [s]
  (if (vector? s)
    (let [s (first s)]
      (if (map? s) (:as s) s))
    (if (map? s) (:as s) s)))

#?(:clj
   (defmacro defui [n args & body]
     (let [index (.indexOf args '|)
           _ (when (= index -1) (throw (Exception. "Missing |")))
           [fix-syms subs-syms] (split-at index args)
           subs-syms (next subs-syms)
           subs
           (->> subs-syms
                (map (fn [s]
                       (let [sym (find-symbol s)
                             k (keyword (namespace sym) (name sym))
                             v (if (vector? s) (assoc s 0 k) `[~k])]
                         (when-not sym
                           (throw (Exception. (str "Missing :as in map "
                                                   (pr-str s)))))
                         `[~sym (re-frame.core/subscribe ~v)])))
                (reduce into []))
           derefs (reduce into []
                          (map (fn [s]
                                 (let [sym (find-symbol s)
                                       s (if (vector? s) (first s) s)]
                                   `[~s (deref ~sym)]))
                               subs-syms))]
       `(defn ~n [_#]
          (let [~@subs]
            (fn [~@fix-syms]
              (let [~@derefs]
                ~@body)))))))
