(ns api.ses
  (:require [eulalie.core :as eulalie]
            [eulalie.ses]
            [eulalie.sns]
            [eulalie.creds :as creds]
            [eulalie.util :refer [env!]]
            [api.util :refer [local?]]
            [cljs.nodejs :as nodejs]
            [cljs.core.async :as async :refer [<!]])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(def libphonenumber (nodejs/require "libphonenumber-js"))
(def format-phone (aget libphonenumber "format"))

(defn creds [] (creds/env))

(defn send-email! [to html subject source]
  (go (when-not (local?)
        (:body (<! (eulalie/issue-request!
                    {:service :ses
                     :target  :send-email
                     :creds (creds)
                     :body {:to to
                            :html html
                            :subject subject
                            :source source}}))))))

;; TODO! Country from merchant
(defn send-sms! [phone msg subject]
  (let [phone (if (= "+" (first phone))
                phone
                (.call format-phone libphonenumber phone "US" "International_plaintext"))]
    (go
      (when-not (local?)
        (:body (<! (eulalie/issue-request!
                    {:service :sns
                     :target  :publish
                     :creds (creds)
                     :body {:Message msg
                            :PhoneNumber phone
                            :Subject subject}})))))))
