(ns api.icons
  (:require [clojure.data.codec.base64 :as b64]
            [clojure.java.io :as io]))

(defn icons []
  (let [curr (.getCanonicalPath (java.io.File. "."))
        path (if (.endsWith curr "/api")
               "../web/static/icons/"
               "./static/icons/")]
    (into {}
          (filter identity
                  (mapv #(let [n (.getName %)
                               f (java.io.File. (str path n))]
                           (when (.endsWith n ".svg")
                             (try
                               [n (slurp f)]
                               (catch Exception e
                                 nil))))
                        (file-seq (java.io.File. path)))))))

(defn slurp-bytes
  "Slurp the bytes from a slurpable thing"
  [x]
  (with-open [out (java.io.ByteArrayOutputStream.)]
    (clojure.java.io/copy (clojure.java.io/input-stream x) out)
    (.toByteArray out)))

;; delete?
(defn micros-icons []
  (let [curr (.getCanonicalPath (java.io.File. "."))
        path "../resources/icons-png/"]
    (into
     {}
     (filter
      identity
      (mapv #(let [n (.getName %)
                   f (java.io.File. (str path n))]
               (when (.endsWith n ".png")
                 (try
                   [(subs n 0 (- (count n) 4)) (String. (b64/encode (slurp-bytes f)) "UTF-8")]
                   (catch Exception e nil))))
            (file-seq (java.io.File. path)))))))

(defmacro def-icons [n]
  (let [i (icons)]
    `(def ~n ~i)))

(defmacro def-micros-icons [n]
  (let [i (micros-icons)]
    `(def ~n ~i)))
