(ns api.color-thief
  (:require
   [cljsjs.color-thief]
   [cljs.core.async :as async])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defn get-palette [img]
  (assert img)
  (let [ch (async/chan 1)]
    (let [e (.createElement js/document "img")]
      (set! (.-width e) "100")
      (set! (.-height e) "100")
      (set! (.-src e) (str "/proxy?" img))
      (set! (.-style e) "position:absolute; top: 100000px; left: 100000px")
      (set! (.-onload e)
            #(async/put!
              ch
              (vec (set (js->clj ((aget (js/ColorThief.) "getPalette") e 25)
                                 :keywordize-keys true))))))
    ch))
