(ns api.specter-macros
  (:require
   [com.rpl.specter :as specter :include-macros true
    :refer [ALL FIRST transform select filterer srange keypath
            setval LAST END if-path STOP must pred select-one]]))

(defn vec-remove [coll pos]
  (if (and pos (< -1 pos (count coll)))
    (vec (concat (subvec coll 0 pos) (subvec coll (inc pos))))
    coll))

(defn NTH [index]
  (if-path
   (pred #(< -1 index (count %)))
   [(srange index (inc index)) FIRST]
   STOP))

(defn NTH-ALL [index]
  (if-path
   (pred #(< -1 index (count %)))
   [(srange index (inc index))]
   STOP))

(defn INSERT [pos val]
  (fn [coll]
    (if (zero? pos)
      (vec (cons val coll))
      (if (<= 0 pos (count coll))
        (vec (concat (subvec coll 0 pos) [val] (subvec coll pos)))
        coll))))

(defn DISSOC [k]
  (fn [m]
    (if (vector? m)
      (vec-remove m k)
      (dissoc m k))))

(defn ->DISSOC [f]
  (fn [m]
    (if-let [i (select-one [f] m)]
      (vec (remove #(= i %) m))
      m)))

(defn index-of [coll k id]
  (let [coll (vec coll)]
    (first (filter identity (map #(when (= (k (nth coll %)) id) %) (range (count coll)))))))
