(ns api.icons
  (:require [clojure.data.codec.base64 :as b64]
            [clojure.java.io :as io]))

(defn icons []
  (let [curr (.getCanonicalPath (java.io.File. "."))
        path "static/icons/"]
    (into {}
          (filter identity
                  (mapv #(let [n (.getName %)
                               f (java.io.File. (str path n))]
                           (when (.endsWith n ".svg")
                             (try
                               [n (slurp f)]
                               (catch Exception e
                                 nil))))
                        (file-seq (java.io.File. path)))))))

(defmacro def-icons [n]
  (let [i (icons)]
    `(def ~n ~i)))
