;  Copyright (C) 2020 Gabriel Ash

; This program and the accompanying materials are made available under
; the terms of the Eclipse Public License 2.0 which is available at
; http://www.eclipse.org/legal/epl-2.0 .

; This code is provided as is, without any guarantee whatsoever.

  (ns gabrielash.libmisc.debug
    "helper functions for tracing, debuging, etc."
    (:require 
     [clojure.string :as str]
     ))



(defn log
  "logs with println or js/console as necessary"
  [& strs]
  (let [o (apply str strs)]
    #?(:cljs
       (.log js/console o)
       :clj 
       (println o))))


(defn  !>p
   "ignores all but first argument  
    use to turn [[>p]] into a no-op
    "
   [& args] (first args))
   
   
(defn  !p>
  "ignores all but last argument  
    use to turn [[p>]] into a no-op
    "

  [& args] (last args))


(defn >p
  ">p evaluates to its first `arg` and logs as messages all postfixed forms  
   example :   
   `(map odd? (>p [ 1 2 3] \"this prints\" \"[1 2 3]\"))`
   "
  [v & msgs]
  (log (apply str msgs))
  v)


(defn p> 
  "p> evaluates to its last `arg` and logs as messages all prefixed forms  
   example  
   `(map odd? (p> \"this prints\" \"[1 2 3]\" [ 1 2 3] ))`"
  [& args]
  (let [v (last args)
        msgs (butlast args)]
    (log (apply str msgs))
    v))

