;  Copyright (C) 2020 Gabriel Ash

; This program and the accompanying materials are made available under
; the terms of the Eclipse Public License 2.0 which is available at
; http://www.eclipse.org/legal/epl-2.0 .

; This code is provided as is, without any guarantee whatsoever.

  (ns gabrielash.libmisc.debug
    (:require 
     [clojure.string :as str]
     ))



(defn log
  "logs with println or js/console as necessary"
  [& strs]
  (let [o (apply str strs)]
    #?(:cljs
       (.log js/console o)
       :clj 
       (println o))))


(defn  !>p
   "!>p = first (no-op)"
   [& args] (first args))
   
   
(defn  !p>
   "!p> = last (no op) " 
   [& args] (last args))


(defn >p 
    ">p evaluates first form; logs as messages all post-fixed forms"
  [v & msgs]
  (log (apply str msgs))
  v)


(defn p> 
  "p> evaluates last form; logs as messages all pre-fixed forms"
  [& args]
  (let [v (last args)
        msgs (butlast args)]
    (log (apply str msgs))
    v))

