;  Copyright (C) 2020 Gabriel Ash

; This program and the accompanying materials are made available under
; the terms of the Eclipse Public License 2.0 which is available at
; http://www.eclipse.org/legal/epl-2.0 .

; This code is provided as is, without any guarantee whatsoever.

(ns gabrielash.libmisc.core
  
  )



(defn some*
  [pred coll] 
  (some #(and (pred %) %) coll))

(defn atom?
  [ a ] 
  (instance? clojure.lang.Atom a))

(def != #'not=)

(def ! #'not)

(defmacro !! [f & args] 
  `(apply (complement ~f) [~@args]))


(defn assoc-not-nil
  "assoc but ignore nil value"
  ([col k v]
   (if-not (nil? v)
     (assoc col k v)
     col)))


(defn assoc-if
  "assoc conditional on first argument"
  ([col test k v]
   (if test (assoc col k v) col)))
 
(defn is=? [v] #(= v %))




(defn ^:forward no-nils-? [col])

(defn- no-nils--?
  [col]
  
   (and (cond (sequential? col) (!! seq (filter nil? col)) 
              (set? col)        (= (count col) (count (disj col nil)))
              (map? col)       (!! seq (keep #(when (nil? (val %))
                                              (key %)) col)))
        
        (every? no-nils-? 
                (if (map? col) (vals col) col))))


(defn- no-nils-? 
"true only if arg includes no nil values at any depth, nil -> false"
  [v]
  (if (coll? v) 
    (no-nils--? v) 
    (!! nil? v)))

(defn no-nils?
  [col]
  "true only if arg includes no nil values at any depth, nil -> nil
   intended for testing and sanity checks"
  {:pre [((some-fn seq? nil?) col)]} 
  (if (nil? col)
    nil
    (no-nils-? col)))
  

(defn strip-nils
  "remove nil values from map"
  [col]
  (apply dissoc col
         (keep #(when (nil? (val %))
                  (key %)) col)))



(defn flatten-any 
  "flatten any collection"
  [x] 
  {:pre [((some-fn coll? nil?) x)]}
  (if (nil? x)
    nil
    (remove coll?
            (rest (tree-seq coll? seq x)))))

(defn flatten*
  "flatten any sequence, nil -> nil"
  [x]
  {:pre [((some-fn seq? nil?) x)]}
  (if (nil? x)
    nil
    (remove seq?
            (rest (tree-seq sequential? seq x)))))


(defn detect-nils 
  [col] 
  (some nil? (flatten-any col)))

